/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.expression.variables;

import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.expression.variables.AbstractAttributeVariable;
import com.ibm.team.workitem.common.expression.variables.IEvaluationContext;
import com.ibm.team.workitem.common.expression.variables.Messages;
import com.ibm.team.workitem.common.model.IState;
import com.ibm.team.workitem.common.model.Identifier;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatusVariable
extends AbstractAttributeVariable<String> {
    public static final String VARIABLE_ID = "state";
    public static final int OPEN_AND_IN_PROGRESS_STATES = 5;
    private Group fGroup;

    public StatusVariable() {
    }

    public StatusVariable(int group) {
        this.fGroup = StatusVariable.mapToGroup(group);
    }

    public StatusVariable(String group) {
        this.fGroup = StatusVariable.mapToGroup(group);
    }

    public static boolean isValidGroup(String groupIdentifier) {
        Group group = StatusVariable.getGroup(groupIdentifier);
        return group != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> evaluate(IEvaluationContext context, IProgressMonitor monitor) throws TeamRepositoryException {
        Class<StatusVariable> clazz = StatusVariable.class;
        synchronized (StatusVariable.class) {
            IWorkItemCommon workItemCommon = context.getAuditableCommon().getPeer(IWorkItemCommon.class);
            Identifier<IState>[] states = workItemCommon.findCombinedWorkflowInfos(context.getProjectArea(), monitor).getStateIds(this.fGroup.getStateGroup());
            // ** MonitorExit[var4_3] (shouldn't be in output)
            ArrayList<String> stateList = new ArrayList<String>(states.length);
            Identifier<IState>[] identifierArray = states;
            int n = states.length;
            int n2 = 0;
            while (n2 < n) {
                Identifier<IState> state = identifierArray[n2];
                stateList.add(state.getStringIdentifier());
                ++n2;
            }
            return stateList;
        }
    }

    @Override
    public String getDisplayName() {
        switch (this.fGroup) {
            case GROUP_OPEN: {
                return Messages.getString("StatusVariable.OPEN");
            }
            case GROUP_OPEN_OR_PROGRESS: 
            case GROUP_OPEN_OR_PROGRESS2: {
                return Messages.getString("StatusVariable.INCOMPLETE");
            }
            case GROUP_CLOSED: {
                return Messages.getString("StatusVariable.COMPLETE");
            }
            case GROUP_PROGRESS: {
                return Messages.getString("StatusVariable.IN_PROGRESS");
            }
        }
        return this.fGroup.getIdentifier();
    }

    @Override
    public String getId() {
        return VARIABLE_ID;
    }

    @Override
    public void setArguments(String arguments) {
        this.fGroup = StatusVariable.mapToGroup(arguments);
    }

    @Override
    public String getArguments() {
        return this.fGroup.getIdentifier();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof StatusVariable)) {
            return false;
        }
        return this.fGroup == ((StatusVariable)obj).fGroup;
    }

    public int hashCode() {
        return this.getId().hashCode() ^ this.fGroup.getStateGroup();
    }

    private static Group mapToGroup(String groupIdentifier) {
        Group group = StatusVariable.getGroup(groupIdentifier);
        if (group != null) {
            return group;
        }
        String error = NLS.bind((String)Messages.getString("StatusVariable.UNKNOWN_GROUP"), (Object[])new Object[]{groupIdentifier});
        throw new IllegalArgumentException(error);
    }

    private static Group getGroup(String groupIdentifier) {
        Group[] groupArray = Group.values();
        int n = groupArray.length;
        int n2 = 0;
        while (n2 < n) {
            Group group = groupArray[n2];
            if (group.getIdentifier().equals(groupIdentifier)) {
                return group;
            }
            ++n2;
        }
        return null;
    }

    private static Group mapToGroup(int stateGroup) {
        Group[] groupArray = Group.values();
        int n = groupArray.length;
        int n2 = 0;
        while (n2 < n) {
            Group group = groupArray[n2];
            if (group.getStateGroup() == stateGroup) {
                return group;
            }
            ++n2;
        }
        String error = NLS.bind((String)Messages.getString("StatusVariable.UNKNOWN_GROUP"), (Object[])new Object[]{stateGroup});
        throw new IllegalArgumentException(error);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Group {
        GROUP_OPEN("open", 1),
        GROUP_OPEN_OR_PROGRESS("open or in progress", 5),
        GROUP_OPEN_OR_PROGRESS2("incomplete", 5),
        GROUP_CLOSED("closed", 2),
        GROUP_PROGRESS("progress", 4);

        private String fIdentifier;
        private int fStateGroup;

        private Group(String id, int stateGroup) {
            this.fIdentifier = id;
            this.fStateGroup = stateGroup;
        }

        public String getIdentifier() {
            return this.fIdentifier;
        }

        public int getStateGroup() {
            return this.fStateGroup;
        }
    }
}

