/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.utils;

import com.ibm.team.repository.common.utils.HashCode;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.Checksum;

public class HashComputingInputStream
extends FilterInputStream {
    private final Checksum hashCode = HashCode.newChecksum();
    private long contentSize = 0L;

    public int read() throws IOException {
        int n = super.read();
        if (n != -1) {
            this.hashCode.update(n);
            ++this.contentSize;
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = super.read(byArray, n, n2);
        if (n3 != -1) {
            this.hashCode.update(byArray, n, n3);
            this.contentSize += (long)n3;
        }
        return n3;
    }

    public boolean markSupported() {
        return false;
    }

    public synchronized void reset() throws IOException {
        super.reset();
        this.hashCode.reset();
        this.contentSize = 0L;
    }

    public HashComputingInputStream(InputStream inputStream) {
        super(inputStream);
    }

    public long getHash() {
        return this.hashCode.getValue();
    }

    public Checksum getChecksum() {
        return this.hashCode;
    }

    public long getContentSize() {
        return this.contentSize;
    }
}

