/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.util;

import com.ibm.team.repository.common.internal.nls.Messages;
import com.ibm.team.repository.common.internal.util.InternalTeamPlatform;
import com.ibm.team.repository.common.transport.internal.Activator;
import com.ibm.team.repository.common.util.ExtensionRegistryReader$$Cold;
import com.ibm.team.repository.common.util.ExtensionRegistryReader$1;
import com.ibm.team.repository.common.util.ExtensionRegistryReader$2;
import com.ibm.team.repository.common.util.ExtensionRegistryReader$3;
import com.ibm.team.repository.common.util.ExtensionRegistryReader$IExtensionRegistryProvider;
import com.ibm.team.repository.common.util.ExtensionRegistryReaderListener;
import com.ibm.team.repository.common.util.IExtensionRegistryReader;
import com.ibm.team.repository.common.util.NLS;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;

public abstract class ExtensionRegistryReader
implements IExtensionRegistryReader {
    private static ExtensionRegistryReader$IExtensionRegistryProvider EXTENSION_REGISTRY_PROVIDER;
    private static final Log LOGGER;
    private static final List NO_CONFIGURATION_ELEMENTS;
    private String pluginId;
    private String extensionPointId;
    private Map descriptorByConfigurationElement;
    private Map configurationElementByBundleSymbolicName;
    private Map orphanMap;
    private List extensionRegistryReaderListeners;
    private IRegistryChangeListener registryChangeListener;
    private BundleListener bundleListener;
    private boolean started;
    private final Object startLock = new Object();
    private final Object eventLock = new Object();
    private final ReadWriteLock listenerLock = new ReentrantReadWriteLock();

    static {
        LOGGER = LogFactory.getLog(ExtensionRegistryReader.class);
        NO_CONFIGURATION_ELEMENTS = Collections.unmodifiableList(new ArrayList(0));
    }

    public static void setExtensionRegistryProvider(ExtensionRegistryReader$IExtensionRegistryProvider extensionRegistryReader$IExtensionRegistryProvider) {
        EXTENSION_REGISTRY_PROVIDER = extensionRegistryReader$IExtensionRegistryProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ExtensionRegistryReader$IExtensionRegistryProvider getExtensionRegistryProvider() {
        Class<ExtensionRegistryReader> clazz = ExtensionRegistryReader.class;
        synchronized (ExtensionRegistryReader.class) {
            if (EXTENSION_REGISTRY_PROVIDER == null) {
                EXTENSION_REGISTRY_PROVIDER = ExtensionRegistryReader.createDefaultExtensionRegistryProvider();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return EXTENSION_REGISTRY_PROVIDER;
        }
    }

    private static ExtensionRegistryReader$IExtensionRegistryProvider createDefaultExtensionRegistryProvider() {
        return new ExtensionRegistryReader$1();
    }

    protected ExtensionRegistryReader(String string, String string2) {
        this.setPluginId(string);
        this.setExtensionPointId(string2);
        this.setDescriptorByConfigurationElement(this.createDescriptorByConfigurationElementMap());
        this.setConfigurationElementByBundleSymbolicName(this.createConfigurationElementByBundleSymbolicNameMap());
        this.setOrphanMap(this.createOrphanMap());
        this.setExtensionRegistryReaderListeners(this.createExtensionRegistryReaderListenersList());
        this.setRegistryChangeListener(this.createRegistryChangeListener());
        this.setBundleListener(this.createBundleListener());
        this.setStarted(false);
        this.initialize();
        this.earlyStart();
    }

    private ArrayList createExtensionRegistryReaderListenersList() {
        return new ArrayList(3);
    }

    private Map createOrphanMap() {
        int n = this.estimateHashedCollectionSize(5);
        HashMap hashMap = new HashMap(n);
        return hashMap;
    }

    private Map createConfigurationElementByBundleSymbolicNameMap() {
        int n = this.estimateHashedCollectionSize(75);
        HashMap hashMap = new HashMap(n);
        return hashMap;
    }

    private Map createDescriptorByConfigurationElementMap() {
        int n = this.estimateHashedCollectionSize(75);
        HashMap hashMap = new HashMap(n);
        return hashMap;
    }

    private void addContributedExtensions() {
        List list = this.getRegisteredConfigurationElements();
        for (IConfigurationElement iConfigurationElement : list) {
            this.handleExtensionAddedToRegistry(iConfigurationElement);
        }
    }

    private final void addRegistryChangeListener(IRegistryChangeListener iRegistryChangeListener, String string) {
        IExtensionRegistry iExtensionRegistry = this.getRegistry();
        if (iExtensionRegistry == null) {
            return;
        }
        iExtensionRegistry.addRegistryChangeListener(iRegistryChangeListener, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void basicHandleExtensionAdded(IConfigurationElement iConfigurationElement) {
        Object object;
        Object object2 = object = this.getEventLock();
        synchronized (object2) {
            this.storeConfigurationElementByBundleSymbolicName(iConfigurationElement);
            try {
                Object object3 = this.handleExtensionAdded(iConfigurationElement);
                this.storeDescriptorByConfigurationElement(iConfigurationElement, object3);
                this.notifyListenersOfExtensionAdded(iConfigurationElement, object3);
            }
            catch (Throwable throwable) {
                this.logFailedToHandleExtensionAddedToRegistry(iConfigurationElement, throwable);
            }
        }
    }

    private void bundleChanged(BundleEvent bundleEvent) {
        int n = bundleEvent.getType();
        if (n != 2 && n != 256) {
            return;
        }
        Bundle bundle = bundleEvent.getBundle();
        List list = this.getConfigurationElements(bundle, true);
        if (list == null) {
            return;
        }
        String string = bundle.getSymbolicName();
        List list2 = this.getDescriptors(list);
        switch (n) {
            case 2: {
                this.handleBundleWithExtensionsStarted(string, list, list2);
                break;
            }
            case 256: {
                this.handleBundleWithExtensionsStopped(string, list, list2);
                break;
            }
            default: {
                this.logError(NLS.bind("Unhandled BundleEvent type: {0}", n));
            }
        }
    }

    protected void checkStarted() {
    }

    private BundleListener createBundleListener() {
        return (BundleListener)new ExtensionRegistryReader$2(this);
    }

    private IRegistryChangeListener createRegistryChangeListener() {
        return new ExtensionRegistryReader$3(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteConfigurationElementByBundleSymbolicName(IConfigurationElement iConfigurationElement) {
        Map map;
        String string = this.getBundleSymbolicName(iConfigurationElement);
        Map map2 = map = this.getConfigurationElementByBundleSymbolicName();
        synchronized (map2) {
            List list = this.getConfigurationElements(string);
            if (list == null) {
                return;
            }
            list.remove(iConfigurationElement);
            boolean bl = list.isEmpty();
            if (!bl) {
                return;
            }
            map.remove(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteDescriptorByConfigurationElement(IConfigurationElement iConfigurationElement) {
        Map map;
        Map map2 = map = this.getDescriptorByConfigurationElement();
        synchronized (map2) {
            map.remove(iConfigurationElement);
        }
    }

    private final void earlyStart() {
        if (!InternalTeamPlatform.getDefault().asBundle()) {
            this.start();
        }
    }

    protected final int estimateHashedCollectionSize(int n) {
        if (n <= 0) {
            return 0;
        }
        int n2 = n * 4 / 3 + 1;
        return n2;
    }

    private BundleContext getBundleContext() {
        return Activator.getBundleContext();
    }

    private BundleListener getBundleListener() {
        return this.bundleListener;
    }

    private String getBundleSymbolicName(IConfigurationElement iConfigurationElement) {
        String string = iConfigurationElement.getNamespaceIdentifier();
        return string;
    }

    private Map getConfigurationElementByBundleSymbolicName() {
        return this.configurationElementByBundleSymbolicName;
    }

    private List getConfigurationElements(Bundle bundle, boolean bl) {
        String string = bundle.getSymbolicName();
        List list = this.getConfigurationElements(string, bl);
        return list;
    }

    private List getConfigurationElements(String string) {
        List list = this.getConfigurationElements(string, false);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getConfigurationElements(String string, boolean bl) {
        List list;
        Map map;
        Map map2 = map = this.getConfigurationElementByBundleSymbolicName();
        synchronized (map2) {
            list = (List)map.get(string);
            if (bl) {
                list = list != null ? new ArrayList(list) : null;
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Object getDescriptor(IConfigurationElement iConfigurationElement) {
        Object v;
        Map map;
        this.checkStarted();
        if (iConfigurationElement == null) {
            throw (Throwable)new IllegalArgumentException("element must not be null");
        }
        Map map2 = map = this.getDescriptorByConfigurationElement();
        synchronized (map2) {
            v = map.get(iConfigurationElement);
        }
        return v;
    }

    private Map getDescriptorByConfigurationElement() {
        return this.descriptorByConfigurationElement;
    }

    private List getDescriptors(List list) {
        int n = list.size();
        ArrayList<Object> arrayList = new ArrayList<Object>(n);
        for (IConfigurationElement iConfigurationElement : list) {
            Object object = this.getDescriptor(iConfigurationElement);
            if (object == null) continue;
            arrayList.add(object);
        }
        arrayList.trimToSize();
        return arrayList;
    }

    private Object getEventLock() {
        return this.eventLock;
    }

    private String getExtensionPointId() {
        return this.extensionPointId;
    }

    private List getExtensionRegistryReaderListeners() {
        return this.extensionRegistryReaderListeners;
    }

    protected Object getOrphanKey(IConfigurationElement iConfigurationElement) {
        throw (Throwable)new RuntimeException("Subclass responsibility");
    }

    private Map getOrphanMap() {
        return this.orphanMap;
    }

    private String getPluginId() {
        return this.pluginId;
    }

    private List getRegisteredConfigurationElements() {
        IExtensionRegistry iExtensionRegistry = this.getRegistry();
        if (iExtensionRegistry == null) {
            return NO_CONFIGURATION_ELEMENTS;
        }
        String string = this.getPluginId();
        String string2 = this.getExtensionPointId();
        IExtensionPoint iExtensionPoint = iExtensionRegistry.getExtensionPoint(string, string2);
        List list = this.getRegisteredConfigurationElements(iExtensionPoint);
        return list;
    }

    private List getRegisteredConfigurationElements(IExtensionPoint iExtensionPoint) {
        if (iExtensionPoint == null) {
            return NO_CONFIGURATION_ELEMENTS;
        }
        IConfigurationElement[] iConfigurationElementArray = iExtensionPoint.getConfigurationElements();
        if (iConfigurationElementArray == null) {
            return NO_CONFIGURATION_ELEMENTS;
        }
        List<IConfigurationElement> list = Arrays.asList(iConfigurationElementArray);
        return list;
    }

    private IExtensionRegistry getRegistry() {
        ExtensionRegistryReader$IExtensionRegistryProvider extensionRegistryReader$IExtensionRegistryProvider = ExtensionRegistryReader.getExtensionRegistryProvider();
        IExtensionRegistry iExtensionRegistry = extensionRegistryReader$IExtensionRegistryProvider.getRegistry();
        return iExtensionRegistry;
    }

    private IRegistryChangeListener getRegistryChangeListener() {
        return this.registryChangeListener;
    }

    private Object getStartLock() {
        return this.startLock;
    }

    protected void handleBundleStarted(String string, List list, List list2) throws Exception {
    }

    protected void handleBundleStopped(String string, List list, List list2) throws Exception {
    }

    private void handleBundleWithExtensionsStarted(String string, List list, List list2) {
        try {
            try {
                this.handleBundleStarted(string, list, list2);
            }
            catch (Throwable throwable) {
                this.logException(throwable);
                this.notifyListenersOfBundleStarted(string, list, list2);
            }
        }
        finally {
            this.notifyListenersOfBundleStarted(string, list, list2);
        }
    }

    private void handleBundleWithExtensionsStopped(String string, List list, List list2) {
        try {
            try {
                this.handleBundleStopped(string, list, list2);
            }
            catch (Throwable throwable) {
                this.logException(throwable);
                this.notifyListenersOfBundleStopped(string, list, list2);
            }
        }
        finally {
            this.notifyListenersOfBundleStopped(string, list, list2);
        }
    }

    protected Object handleExtensionAdded(IConfigurationElement iConfigurationElement) throws Exception {
        return null;
    }

    private void handleExtensionAddedToRegistry(IConfigurationElement iConfigurationElement) {
        boolean bl = this.isOrphan(iConfigurationElement);
        if (bl) {
            this.addOrphan(iConfigurationElement);
            return;
        }
        this.basicHandleExtensionAdded(iConfigurationElement);
    }

    protected void handleExtensionRemoved(IConfigurationElement iConfigurationElement, Object object) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleExtensionRemovedFromRegistry(IConfigurationElement iConfigurationElement) {
        Object object;
        Object object2 = object = this.getEventLock();
        synchronized (object2) {
            block8: {
                Object object3 = this.getDescriptor(iConfigurationElement);
                try {
                    try {
                        this.handleExtensionRemoved(iConfigurationElement, object3);
                        this.notifyListenersOfExtensionRemoved(iConfigurationElement, object3);
                    }
                    catch (Throwable throwable) {
                        this.logFailedToHandleExtensionRemovedFromRegistry(iConfigurationElement, throwable);
                        this.deleteConfigurationElementByBundleSymbolicName(iConfigurationElement);
                        this.deleteDescriptorByConfigurationElement(iConfigurationElement);
                        break block8;
                    }
                }
                catch (Throwable throwable) {
                    this.deleteConfigurationElementByBundleSymbolicName(iConfigurationElement);
                    this.deleteDescriptorByConfigurationElement(iConfigurationElement);
                    throw throwable;
                }
                this.deleteConfigurationElementByBundleSymbolicName(iConfigurationElement);
                this.deleteDescriptorByConfigurationElement(iConfigurationElement);
            }
        }
    }

    protected void handleStarted() {
    }

    protected void handleStopped() {
    }

    private void hookupBundleListener() {
        BundleContext bundleContext = this.getBundleContext();
        if (bundleContext == null) {
            return;
        }
        BundleListener bundleListener = this.getBundleListener();
        bundleContext.addBundleListener(bundleListener);
    }

    protected void initialize() {
    }

    protected boolean isOrphan(IConfigurationElement iConfigurationElement) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean isStarted() {
        Object object;
        Object object2 = object = this.getStartLock();
        synchronized (object2) {
            return this.started;
        }
    }

    public Iterator iterator() {
        List list = this.getDescriptors();
        Iterator iterator = list.iterator();
        return iterator;
    }

    protected final void logError(String string) {
        this.logError(string, null);
    }

    protected final void logException(Throwable throwable) {
        this.logError(null, throwable);
    }

    private void logFailedToHandleRegistryChange(int n, IConfigurationElement iConfigurationElement) {
        this.logFailedToHandleRegistryChange(n, iConfigurationElement, null);
    }

    private void notifyListenersOfBundleStarted(String string, List list, List list2) {
        List list3 = this.getExtensionRegistryReaderListeners();
        Lock lock = this.listenerLock.readLock();
        lock.lock();
        try {
            for (ExtensionRegistryReaderListener extensionRegistryReaderListener : list3) {
                try {
                    extensionRegistryReaderListener.handleBundleStarted(string, list, list2);
                }
                catch (Throwable throwable) {
                    this.logException(throwable);
                }
            }
        }
        finally {
            lock.unlock();
        }
    }

    private void notifyListenersOfBundleStopped(String string, List list, List list2) {
        List list3 = this.getExtensionRegistryReaderListeners();
        Lock lock = this.listenerLock.readLock();
        lock.lock();
        try {
            for (ExtensionRegistryReaderListener extensionRegistryReaderListener : list3) {
                try {
                    extensionRegistryReaderListener.handleBundleStopped(string, list, list2);
                }
                catch (Throwable throwable) {
                    this.logException(throwable);
                }
            }
        }
        finally {
            lock.unlock();
        }
    }

    private void notifyListenersOfExtensionAdded(IConfigurationElement iConfigurationElement, Object object) {
        List list = this.getExtensionRegistryReaderListeners();
        Lock lock = this.listenerLock.readLock();
        lock.lock();
        try {
            for (ExtensionRegistryReaderListener extensionRegistryReaderListener : list) {
                try {
                    extensionRegistryReaderListener.handleExtensionAdded(iConfigurationElement, object);
                }
                catch (Throwable throwable) {
                    this.logException(throwable);
                }
            }
        }
        finally {
            lock.unlock();
        }
    }

    private void notifyListenersOfExtensionRemoved(IConfigurationElement iConfigurationElement, Object object) {
        List list = this.getExtensionRegistryReaderListeners();
        Lock lock = this.listenerLock.readLock();
        lock.lock();
        try {
            for (ExtensionRegistryReaderListener extensionRegistryReaderListener : list) {
                try {
                    extensionRegistryReaderListener.handleExtensionRemoved(iConfigurationElement, object);
                }
                catch (Throwable throwable) {
                    this.logException(throwable);
                }
            }
        }
        finally {
            lock.unlock();
        }
    }

    private void printExtensionPointIdOn(StringBuffer stringBuffer) {
        String string = this.getExtensionPointId();
        this.printOn(stringBuffer, "extensionPointId", string);
    }

    private void printPluginIdOn(StringBuffer stringBuffer) {
        String string = this.getPluginId();
        this.printOn(stringBuffer, "pluginId", string);
    }

    private void printStartedOn(StringBuffer stringBuffer) {
        boolean bl = this.isStarted();
        this.printOn(stringBuffer, "started", bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeContributedExtensions() {
        HashMap hashMap;
        HashMap hashMap2;
        HashMap hashMap3 = (HashMap)this.getDescriptorByConfigurationElement();
        Object object = hashMap3;
        synchronized (object) {
            hashMap2 = hashMap3 != null ? new HashMap(hashMap3) : null;
        }
        object = hashMap2.keySet();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            hashMap = (IConfigurationElement)iterator.next();
            this.handleExtensionRemovedFromRegistry((IConfigurationElement)hashMap);
        }
        hashMap = hashMap3;
        synchronized (hashMap) {
            hashMap3.clear();
        }
    }

    private void removeRegistryChangeListener(IRegistryChangeListener iRegistryChangeListener) {
        IExtensionRegistry iExtensionRegistry = this.getRegistry();
        if (iExtensionRegistry == null) {
            return;
        }
        iExtensionRegistry.removeRegistryChangeListener(iRegistryChangeListener);
    }

    private void setBundleListener(BundleListener bundleListener) {
        this.bundleListener = bundleListener;
    }

    private void setConfigurationElementByBundleSymbolicName(Map map) {
        this.configurationElementByBundleSymbolicName = map;
    }

    private void setDescriptorByConfigurationElement(Map map) {
        this.descriptorByConfigurationElement = map;
    }

    private void setExtensionPointId(String string) {
        if (string == null) {
            throw (Throwable)new IllegalArgumentException("extensionPointId must not be null");
        }
        this.extensionPointId = string;
    }

    private void setExtensionRegistryReaderListeners(List list) {
        this.extensionRegistryReaderListeners = list;
    }

    private void setOrphanMap(Map map) {
        this.orphanMap = map;
    }

    private void setPluginId(String string) {
        if (string == null) {
            throw (Throwable)new IllegalArgumentException("pluginId must not be null");
        }
        this.pluginId = string;
    }

    private void setRegistryChangeListener(IRegistryChangeListener iRegistryChangeListener) {
        this.registryChangeListener = iRegistryChangeListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setStarted(boolean bl) {
        Object object;
        Object object2 = object = this.getStartLock();
        synchronized (object2) {
            this.started = bl;
        }
    }

    public int size() {
        Map map = this.getDescriptorByConfigurationElement();
        int n = map.size();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() {
        Object object = this.getStartLock();
        IRegistryChangeListener iRegistryChangeListener = this.getRegistryChangeListener();
        String string = this.getPluginId();
        Object object2 = object;
        synchronized (object2) {
            boolean bl = this.isStarted();
            if (bl) {
                return;
            }
            this.setStarted(true);
            this.addRegistryChangeListener(iRegistryChangeListener, string);
            this.addContributedExtensions();
            this.hookupBundleListener();
            this.handleStarted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() {
        Object object = this.getStartLock();
        IRegistryChangeListener iRegistryChangeListener = this.getRegistryChangeListener();
        Object object2 = object;
        synchronized (object2) {
            boolean bl = this.isStarted();
            if (!bl) {
                return;
            }
            this.unhookBundleListener();
            this.removeContributedExtensions();
            this.removeRegistryChangeListener(iRegistryChangeListener);
            this.setStarted(false);
            this.handleStopped();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeConfigurationElementByBundleSymbolicName(IConfigurationElement iConfigurationElement) {
        Map map;
        String string = this.getBundleSymbolicName(iConfigurationElement);
        Map map2 = map = this.getConfigurationElementByBundleSymbolicName();
        synchronized (map2) {
            boolean bl;
            ArrayList<IConfigurationElement> arrayList = this.getConfigurationElements(string);
            if (arrayList == null) {
                arrayList = new ArrayList<IConfigurationElement>(10);
                map.put(string, arrayList);
            }
            if (bl = arrayList.contains(iConfigurationElement)) {
                return;
            }
            arrayList.add(iConfigurationElement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeDescriptorByConfigurationElement(IConfigurationElement iConfigurationElement, Object object) {
        Map map;
        if (object == null) {
            return;
        }
        Map map2 = map = this.getDescriptorByConfigurationElement();
        synchronized (map2) {
            map.put(iConfigurationElement, object);
        }
    }

    private void unhookBundleListener() {
        BundleContext bundleContext = this.getBundleContext();
        if (bundleContext == null) {
            return;
        }
        BundleListener bundleListener = this.getBundleListener();
        bundleContext.removeBundleListener(bundleListener);
    }

    static /* synthetic */ void access$0(ExtensionRegistryReader extensionRegistryReader, BundleEvent bundleEvent) {
        extensionRegistryReader.bundleChanged(bundleEvent);
    }

    static /* synthetic */ void access$1(ExtensionRegistryReader extensionRegistryReader, IRegistryChangeEvent iRegistryChangeEvent) {
        extensionRegistryReader.handleRegistryChanged(iRegistryChangeEvent);
    }

    public final void addListener(ExtensionRegistryReaderListener extensionRegistryReaderListener) {
        if (extensionRegistryReaderListener == null) {
            throw (Throwable)new IllegalArgumentException("listener must not be null");
        }
        List list = this.getExtensionRegistryReaderListeners();
        Lock lock = this.listenerLock.writeLock();
        lock.lock();
        try {
            boolean bl = list.contains(extensionRegistryReaderListener);
            if (bl) {
                return;
            }
            list.add(extensionRegistryReaderListener);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addOrphan(IConfigurationElement iConfigurationElement) {
        Map map = this.getOrphanMap();
        Object object = this.getOrphanKey(iConfigurationElement);
        Map map2 = map;
        synchronized (map2) {
            HashSet<IConfigurationElement> hashSet = this.getOrphans(object);
            if (hashSet == null) {
                int n = this.estimateHashedCollectionSize(5);
                hashSet = new HashSet<IConfigurationElement>(n);
                map.put(object, hashSet);
            }
            hashSet.add(iConfigurationElement);
        }
    }

    protected final void basicPrintOn(StringBuffer stringBuffer) {
        String string = super.toString();
        int n = string.lastIndexOf(46);
        string = string.substring(n + 1);
        stringBuffer.append(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final List getConfigurationElements() {
        ArrayList arrayList;
        Map map;
        this.checkStarted();
        Map map2 = map = this.getDescriptorByConfigurationElement();
        synchronized (map2) {
            Set set = map.keySet();
            arrayList = new ArrayList(set);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getDescriptors() {
        ArrayList arrayList;
        Map map;
        this.checkStarted();
        Map map2 = map = this.getDescriptorByConfigurationElement();
        synchronized (map2) {
            Collection collection = map.values();
            arrayList = new ArrayList(collection);
        }
        return arrayList;
    }

    private IExtensionDelta[] getExtensionDeltas(IRegistryChangeEvent iRegistryChangeEvent) {
        String string = this.getPluginId();
        String string2 = this.getExtensionPointId();
        IExtensionDelta[] iExtensionDeltaArray = iRegistryChangeEvent.getExtensionDeltas(string, string2);
        return iExtensionDeltaArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set getOrphans(Object object) {
        Set set;
        Map map;
        if (object == null) {
            throw (Throwable)new IllegalArgumentException("key must not be null");
        }
        Map map2 = map = this.getOrphanMap();
        synchronized (map2) {
            set = (Set)map.get(object);
        }
        return set;
    }

    private void handleRegistryChanged(int n, IConfigurationElement iConfigurationElement) {
        switch (n) {
            case 1: {
                this.handleExtensionAddedToRegistry(iConfigurationElement);
                break;
            }
            case 2: {
                this.handleExtensionRemovedFromRegistry(iConfigurationElement);
                break;
            }
            default: {
                this.logFailedToHandleRegistryChange(n, iConfigurationElement);
            }
        }
    }

    private void handleRegistryChanged(IRegistryChangeEvent iRegistryChangeEvent) {
        IExtensionDelta[] iExtensionDeltaArray;
        IExtensionDelta[] iExtensionDeltaArray2 = iExtensionDeltaArray = this.getExtensionDeltas(iRegistryChangeEvent);
        int n = iExtensionDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] iConfigurationElementArray;
            IExtensionDelta iExtensionDelta = iExtensionDeltaArray2[n2];
            int n3 = iExtensionDelta.getKind();
            IExtension iExtension = iExtensionDelta.getExtension();
            IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElementArray = iExtension.getConfigurationElements();
            int n4 = iConfigurationElementArray.length;
            int n5 = 0;
            while (n5 < n4) {
                IConfigurationElement iConfigurationElement = iConfigurationElementArray2[n5];
                try {
                    this.handleRegistryChanged(n3, iConfigurationElement);
                }
                catch (Throwable throwable) {
                    this.logFailedToHandleRegistryChange(n3, iConfigurationElement, throwable);
                }
                ++n5;
            }
            ++n2;
        }
    }

    protected final void logError(String string, Throwable throwable) {
        if (string == null && throwable != null) {
            string = throwable.getMessage();
        }
        if (string == null) {
            throw (Throwable)new IllegalArgumentException("message must not be null");
        }
        if (throwable == null) {
            LOGGER.error((Object)string);
        } else {
            LOGGER.error((Object)string, throwable);
        }
    }

    private void logFailedToHandleExtensionAddedToRegistry(IConfigurationElement iConfigurationElement, Throwable throwable) {
        String string = this.getPluginId();
        String string2 = this.getExtensionPointId();
        IExtension iExtension = iConfigurationElement.getDeclaringExtension();
        String string3 = iExtension.getExtensionPointUniqueIdentifier();
        String string4 = Messages.getServerString("ExtensionRegistryReader.ErrorExtensionAdd");
        String string5 = NLS.bind(string4, this, string, string2, string3);
        this.logError(string5, throwable);
    }

    private void logFailedToHandleExtensionRemovedFromRegistry(IConfigurationElement iConfigurationElement, Throwable throwable) {
        String string = this.getPluginId();
        String string2 = this.getExtensionPointId();
        IExtension iExtension = iConfigurationElement.getDeclaringExtension();
        String string3 = iExtension.getExtensionPointUniqueIdentifier();
        String string4 = Messages.getServerString("ExtensionRegistryReader.ErrorExtensionRemove");
        String string5 = NLS.bind(string4, this, string, string2, string3);
        this.logError(string5, throwable);
    }

    private void logFailedToHandleRegistryChange(int n, IConfigurationElement iConfigurationElement, Throwable throwable) {
        String string = this.patternForKind(n);
        String string2 = this.getPluginId();
        String string3 = this.getExtensionPointId();
        IExtension iExtension = iConfigurationElement.getDeclaringExtension();
        String string4 = iExtension.getExtensionPointUniqueIdentifier();
        String string5 = NLS.bind(string, this, string2, string3, string4);
        this.logError(string5, throwable);
    }

    private void printNullOn(StringBuffer stringBuffer, String string) throws  {
        ExtensionRegistryReader$$Cold.printNullOn(this, stringBuffer, string);
    }

    private void printObjectOn(StringBuffer stringBuffer, String string, Object object) throws  {
        ExtensionRegistryReader$$Cold.printObjectOn(this, stringBuffer, string, object);
    }

    protected void printOn(StringBuffer stringBuffer) {
        this.basicPrintOn(stringBuffer);
        this.printPluginIdOn(stringBuffer);
        this.printExtensionPointIdOn(stringBuffer);
        this.printStartedOn(stringBuffer);
    }

    protected final void printOn(StringBuffer stringBuffer, String string, boolean bl) throws  {
        ExtensionRegistryReader$$Cold.printOn(this, stringBuffer, string, bl);
    }

    protected final void printOn(StringBuffer stringBuffer, String string, Object object) {
        if (object == null) {
            this.printNullOn(stringBuffer, string);
        } else {
            this.printObjectOn(stringBuffer, string, object);
        }
    }

    protected final void printOn(StringBuffer stringBuffer, String string, String string2) {
        if (string2 == null) {
            this.printNullOn(stringBuffer, string);
        } else {
            this.printStringOnBuffer(stringBuffer, string, string2);
        }
    }

    private void printStringOnBuffer(StringBuffer stringBuffer, String string, String string2) throws  {
        ExtensionRegistryReader$$Cold.printStringOnBuffer(this, stringBuffer, string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void processOrphans(Object object) {
        Map map;
        Map map2 = map = this.getOrphanMap();
        synchronized (map2) {
            Set set = this.getOrphans(object);
            if (set == null) {
                return;
            }
            for (IConfigurationElement iConfigurationElement : set) {
                this.basicHandleExtensionAdded(iConfigurationElement);
            }
            map.remove(object);
        }
    }

    public final void removeListener(ExtensionRegistryReaderListener extensionRegistryReaderListener) {
        if (extensionRegistryReaderListener == null) {
            throw (Throwable)new IllegalArgumentException("listener must not be null");
        }
        List list = this.getExtensionRegistryReaderListeners();
        Lock lock = this.listenerLock.writeLock();
        lock.lock();
        try {
            list.remove(extensionRegistryReaderListener);
        }
        finally {
            lock.unlock();
        }
    }

    private String patternForKind(int n) throws  {
        return ExtensionRegistryReader$$Cold.patternForKind(this, n);
    }

    public final String toString() {
        String string;
        StringBuffer stringBuffer = new StringBuffer(100);
        try {
            this.printOn(stringBuffer);
            string = stringBuffer.toString();
        }
        catch (Throwable throwable) {
            this.logException(throwable);
            string = super.toString();
        }
        return string;
    }
}

