/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.transport;

import com.ibm.team.repository.common.transport.ICancelableRunnable;
import com.ibm.team.repository.common.transport.TeamServiceCallContextImpl;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.ProgressMonitorWrapper;

public class CancelableCaller {
    public static void call(IProgressMonitor progressMonitor, ICancelableRunnable runnable) {
        boolean real = CancelableCaller.isReal(progressMonitor);
        if (real) {
            TeamServiceCallContextImpl.pushCallContext(progressMonitor);
        }
        try {
            runnable.run(progressMonitor);
        }
        finally {
            if (real) {
                TeamServiceCallContextImpl.popCallContext();
            }
        }
    }

    private static boolean isReal(IProgressMonitor progressMonitor) {
        if (progressMonitor == null) {
            return false;
        }
        boolean real = true;
        Object outer = progressMonitor;
        while (outer != null) {
            if (outer instanceof NullProgressMonitor) {
                real = false;
                outer = null;
                continue;
            }
            outer = outer instanceof ProgressMonitorWrapper ? ((ProgressMonitorWrapper)outer).getWrappedProgressMonitor() : null;
        }
        return real;
    }

    private CancelableCaller() {
    }
}

