/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.transport;

import com.ibm.team.repository.common.transport.AbstractElementDescriptor$$Cold;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

public abstract class AbstractElementDescriptor {
    private static final String ATTRIBUTE_IS_MISSING_ERROR = "The %s bundle's plugin.xml file contains a <%s> element that has a missing '%s' attribute value.";
    private static final String ATTRIBUTE_IS_ILLEGAL_ERROR = "The %s bundle's plugin.xml file contains a <%s> element that has an illegal '%s' attribute value '%s'.";
    private static final String ATTRIBUTE_IS_DEPRECATED_ERROR = "The %s bundle's plugin.xml file contains a <%s> element that is using the deprecated '%s' attribute value. Use the '%s' attribute instead.";
    private static final String ELEMENT_DOES_HAVE_NESTED_ELEMENTS = "The %s bundle's plugin.xml file contains a <%s> element that does not contain at least one nested element.";
    private static final Log LOGGER = LogFactory.getLog(AbstractElementDescriptor.class);
    private static final String REPOSITORY_SERVICE_BUNDLE = "com.ibm.team.repository.service";
    private IConfigurationElement element;
    private String bundleSymbolicName;

    protected AbstractElementDescriptor(IConfigurationElement iConfigurationElement, String string) {
        this.basicInitialize(iConfigurationElement, string);
        this.initialize();
        this.processChildren();
        this.checkElement();
    }

    private void basicInitialize(IConfigurationElement iConfigurationElement, String string) {
        this.setElement(iConfigurationElement);
        this.checkElementName(string);
        String string2 = iConfigurationElement.getNamespaceIdentifier();
        this.setBundleSymbolicName(string2);
    }

    protected final boolean checkAttributeIsLegal(String string, String string2, boolean bl, String ... stringArray) throws IllegalArgumentException {
        String string3;
        this.checkAttributeIsSet(string, string2, bl);
        if (stringArray == null || stringArray.length == 0) {
            throw (Throwable)new IllegalArgumentException("legalValues must not be null or empty");
        }
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            string3 = stringArray2[n2];
            boolean bl2 = string3.equals(string);
            if (bl2) {
                return true;
            }
            ++n2;
        }
        string3 = this.getBundleSymbolicName();
        String string4 = this.getElementName();
        String string5 = String.format(ATTRIBUTE_IS_ILLEGAL_ERROR, string3, string4, string2, string);
        if (bl) {
            throw (Throwable)new IllegalArgumentException(string5);
        }
        LOGGER.warn((Object)string5);
        return false;
    }

    protected final void checkAttributeIsLegal(String string, String string2, String ... stringArray) throws IllegalArgumentException {
        this.checkAttributeIsLegal(string, string2, true, stringArray);
    }

    protected final void checkAttributeIsSet(String string, String string2) throws IllegalArgumentException {
        this.checkAttributeIsSet(string, string2, true);
    }

    protected final boolean checkAttributeIsSet(String string, String string2, boolean bl) throws IllegalArgumentException {
        boolean bl2;
        boolean bl3 = bl2 = string != null && string.length() != 0;
        if (bl2) {
            return true;
        }
        if (string2 == null) {
            throw (Throwable)new IllegalArgumentException("attributeName must not be null");
        }
        String string3 = this.getBundleSymbolicName();
        String string4 = this.getElementName();
        String string5 = String.format(ATTRIBUTE_IS_MISSING_ERROR, string3, string4, string2);
        if (bl) {
            throw (Throwable)new IllegalArgumentException(string5);
        }
        LOGGER.warn((Object)string5);
        return false;
    }

    protected void checkElement() {
    }

    private void checkElementName(String string) {
        if (string == null) {
            throw (Throwable)new IllegalArgumentException("name must not be null");
        }
        String string2 = this.getElementName();
        boolean bl = string2.equalsIgnoreCase(string);
        if (bl) {
            return;
        }
        String string3 = String.format("Illegal element name: %s", string2);
        throw (Throwable)new IllegalArgumentException(string3);
    }

    private String safeGetName(IConfigurationElement iConfigurationElement) {
        int n = 0;
        while (true) {
            try {
                return iConfigurationElement.getName();
            }
            catch (InvalidRegistryObjectException invalidRegistryObjectException) {
                LOGGER.error((Object)(this + ":  Failed to get IConfigurationElement's name"));
                if (n >= 15) {
                    throw (Throwable)invalidRegistryObjectException;
                }
                ++n;
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
            }
            break;
        }
    }

    protected final String getAttribute(String string) {
        String string2 = this.getAttribute(string, null);
        return string2;
    }

    protected final String getAttribute(String string, String string2) {
        IConfigurationElement iConfigurationElement = this.getElement();
        String string3 = iConfigurationElement.getAttribute(string);
        if (string3 == null) {
            string3 = string2;
        }
        return string3;
    }

    protected final Bundle getBundle() {
        String string = this.getBundleSymbolicName();
        Bundle bundle = this.getBundle(string);
        return bundle;
    }

    public final String getBundleSymbolicName() {
        return this.bundleSymbolicName;
    }

    private IConfigurationElement[] getChildren() {
        IConfigurationElement iConfigurationElement = this.getElement();
        IConfigurationElement[] iConfigurationElementArray = iConfigurationElement.getChildren();
        return iConfigurationElementArray;
    }

    protected final IConfigurationElement getElement() {
        return this.element;
    }

    protected final String getElementName() {
        IConfigurationElement iConfigurationElement = this.getElement();
        String string = this.safeGetName(iConfigurationElement);
        return string;
    }

    protected final int getNumberOfChildren() {
        IConfigurationElement[] iConfigurationElementArray = this.getChildren();
        int n = iConfigurationElementArray.length;
        return n;
    }

    protected final String getValue() {
        IConfigurationElement iConfigurationElement = this.getElement();
        String string = iConfigurationElement.getValue();
        return string;
    }

    protected void initialize() {
    }

    protected final void logError(String string, Throwable throwable) {
        LOGGER.error((Object)string, throwable);
    }

    protected final void logWarning(String string) {
        LOGGER.warn((Object)string);
    }

    protected void processChild(IConfigurationElement iConfigurationElement) {
        this.logFailedToProcessChildError(iConfigurationElement);
    }

    private void processChildren() {
        IConfigurationElement[] iConfigurationElementArray;
        IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElementArray = this.getChildren();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray2[n2];
            try {
                this.processChild(iConfigurationElement);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                String string = throwable.getMessage();
                LOGGER.error((Object)string, throwable);
            }
            ++n2;
        }
    }

    private void setBundleSymbolicName(String string) {
        this.bundleSymbolicName = string;
    }

    private void setElement(IConfigurationElement iConfigurationElement) {
        if (iConfigurationElement == null) {
            throw (Throwable)new IllegalArgumentException("element must not be null");
        }
        this.element = iConfigurationElement;
    }

    private Class basicLoadClass(String string) throws ClassNotFoundException {
        return AbstractElementDescriptor$$Cold.basicLoadClass(this, string);
    }

    protected final void basicPrintOn(StringBuffer stringBuffer) {
        if (stringBuffer == null) {
            throw (Throwable)new IllegalArgumentException("buffer must not be null");
        }
        String string = super.toString();
        int n = string.lastIndexOf(46);
        string = string.substring(n + 1);
        stringBuffer.append(string);
    }

    protected final void checkHasChildren() throws  {
        AbstractElementDescriptor$$Cold.checkHasChildren(this);
    }

    protected final Object createInstance(String string) throws CoreException {
        return AbstractElementDescriptor$$Cold.createInstance(this, string);
    }

    protected final int estimateHashedCollectionSize(int n) throws  {
        return AbstractElementDescriptor$$Cold.estimateHashedCollectionSize(this, n);
    }

    private IConfigurationElement getAncestor(IConfigurationElement iConfigurationElement, String string) {
        IConfigurationElement iConfigurationElement2 = null;
        Object object = iConfigurationElement.getParent();
        if (object instanceof IConfigurationElement) {
            IConfigurationElement iConfigurationElement3 = (IConfigurationElement)object;
            String string2 = this.safeGetName(iConfigurationElement3);
            boolean bl = string2.equals(string);
            iConfigurationElement2 = bl ? iConfigurationElement3 : this.getAncestor(iConfigurationElement3, string);
        }
        return iConfigurationElement2;
    }

    protected final IConfigurationElement getAncestor(String string) {
        if (string == null) {
            throw (Throwable)new IllegalArgumentException("name must not be null");
        }
        IConfigurationElement iConfigurationElement = this.getElement();
        IConfigurationElement iConfigurationElement2 = this.getAncestor(iConfigurationElement, string);
        return iConfigurationElement2;
    }

    protected final Bundle getBundle(String string) throws  {
        return AbstractElementDescriptor$$Cold.getBundle(this, string);
    }

    public final BundleContext getBundleContext() {
        boolean bl;
        Bundle bundle = this.getBundle();
        BundleContext bundleContext = bundle.getBundleContext();
        if (bundleContext != null) {
            return bundleContext;
        }
        int n = bundle.getState();
        boolean bl2 = bl = (n & 4) != 0;
        if (bl) {
            try {
                bundle.start();
                bundleContext = bundle.getBundleContext();
                if (bundleContext != null) {
                    return bundleContext;
                }
            }
            catch (BundleException bundleException) {
                String string = bundleException.getMessage();
                LOGGER.error((Object)string, (Throwable)bundleException);
            }
        }
        bundle = Platform.getBundle((String)REPOSITORY_SERVICE_BUNDLE);
        bundleContext = bundle.getBundleContext();
        return bundleContext;
    }

    protected final boolean hasChildren() throws  {
        return AbstractElementDescriptor$$Cold.hasChildren(this);
    }

    protected final Class loadClass(String string) throws ClassNotFoundException {
        if (string == null) {
            throw (Throwable)new IllegalArgumentException("name must not be null");
        }
        Class clazz = this.basicLoadClass(string);
        boolean bl = clazz.isInterface();
        if (bl) {
            String string2 = String.format("The value \"%s\" is not the name of a class", string);
            throw (Throwable)new IllegalArgumentException(string2);
        }
        return clazz;
    }

    protected final Class loadInterface(String string) throws ClassNotFoundException {
        if (string == null) {
            throw (Throwable)new IllegalArgumentException("name must not be null");
        }
        Class clazz = this.basicLoadClass(string);
        boolean bl = clazz.isInterface();
        if (!bl) {
            String string2 = String.format("The value \"%s\" is not the name of an interface", string);
            throw (Throwable)new IllegalArgumentException(string2);
        }
        return clazz;
    }

    protected final void logAttributeIsDeprecated(String string, String string2) {
        if (string == null) {
            throw (Throwable)new IllegalArgumentException("oldAttribute must not be null");
        }
        if (string2 == null) {
            throw (Throwable)new IllegalArgumentException("newAttribute must not be null");
        }
        String string3 = this.getBundleSymbolicName();
        String string4 = this.getElementName();
        String string5 = String.format(ATTRIBUTE_IS_DEPRECATED_ERROR, string3, string4, string, string2);
        LOGGER.warn((Object)string5);
    }

    protected final void logFailedToProcessChildError(IConfigurationElement iConfigurationElement) {
        if (iConfigurationElement == null) {
            throw (Throwable)new IllegalArgumentException("child must not be null");
        }
        String string = this.getElementName();
        String string2 = this.safeGetName(iConfigurationElement);
        String string3 = String.format("Failed to process '%s' child named '%s'", string, string2);
        LOGGER.error((Object)string3);
    }

    protected final void printBundleSymbolicNameOn(StringBuffer stringBuffer) throws  {
        AbstractElementDescriptor$$Cold.printBundleSymbolicNameOn(this, stringBuffer);
    }

    private void printNullOn(StringBuffer stringBuffer, String string) throws  {
        AbstractElementDescriptor$$Cold.printNullOn(this, stringBuffer, string);
    }

    private void printObjectOn(StringBuffer stringBuffer, String string, Object object) throws  {
        AbstractElementDescriptor$$Cold.printObjectOn(this, stringBuffer, string, object);
    }

    protected void printOn(StringBuffer stringBuffer) throws  {
        AbstractElementDescriptor$$Cold.printOn(this, stringBuffer);
    }

    protected final void printOn(StringBuffer stringBuffer, String string, Object object) {
        if (object == null) {
            this.printNullOn(stringBuffer, string);
        } else {
            this.printObjectOn(stringBuffer, string, object);
        }
    }

    protected final void printOn(StringBuffer stringBuffer, String string, String string2) {
        if (string2 == null) {
            this.printNullOn(stringBuffer, string);
        } else {
            this.printStringOnBuffer(stringBuffer, string, string2);
        }
    }

    private void printStringOnBuffer(StringBuffer stringBuffer, String string, String string2) throws  {
        AbstractElementDescriptor$$Cold.printStringOnBuffer(this, stringBuffer, string, string2);
    }

    public final String toString() {
        String string;
        StringBuffer stringBuffer = new StringBuffer(256);
        try {
            this.printOn(stringBuffer);
            string = stringBuffer.toString();
        }
        catch (Throwable throwable) {
            String string2 = throwable.getMessage();
            LOGGER.error((Object)string2);
            string = super.toString();
        }
        return string;
    }
}

