/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.internal.util;

import com.ibm.team.repository.common.internal.util.StandaloneUtil;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class StandaloneFileLocator {
    private static final Log logger = LogFactory.getLog(StandaloneFileLocator.class);
    private final Map bundleNameToURLsMap = new HashMap();
    public static final String PROP_NL = "osgi.nl";
    public static final String PROP_OS = "osgi.os";
    public static final String PROP_WS = "osgi.ws";
    public static final String PROP_ARCH = "osgi.arch";
    private static String[] NL_VARIANTS = StandaloneFileLocator.buildNLVariants(System.getProperty("osgi.nl"));
    private static String OS = System.getProperty("osgi.os");
    private static String WS = System.getProperty("osgi.ws");
    private static String ARCH = System.getProperty("osgi.arch");

    protected StandaloneFileLocator() {
        try {
            Enumeration<URL> enumeration = StandaloneFileLocator.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
            int n = 0;
            while (enumeration.hasMoreElements()) {
                LinkedList<URL> linkedList;
                URL uRL = enumeration.nextElement();
                String string = uRL.getPath();
                String string2 = StandaloneUtil.getParentPath(string);
                String string3 = StandaloneUtil.getParentPath(string2);
                URL uRL2 = new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), string3);
                String string4 = StandaloneUtil.getBundleNameForManifest(uRL);
                String string5 = StandaloneUtil.getFragmentHostForManifest(uRL);
                if (string5 != null) {
                    string4 = string5;
                }
                if (string4 == null) {
                    string4 = Integer.toString(n);
                    ++n;
                }
                if ((linkedList = (LinkedList<URL>)this.bundleNameToURLsMap.get(string4)) == null) {
                    linkedList = new LinkedList<URL>();
                    this.bundleNameToURLsMap.put(string4, linkedList);
                }
                if (string5 == null) {
                    linkedList.addFirst(uRL2);
                    continue;
                }
                linkedList.addLast(uRL2);
            }
        }
        catch (IOException iOException) {
            logger.error((Object)iOException);
        }
    }

    public URL find(String string, IPath iPath, Map map, List list) {
        if (string == null || iPath == null) {
            return null;
        }
        String string2 = iPath.segment(0);
        if (!string2.startsWith("$")) {
            return this.find(string, iPath, list);
        }
        IPath iPath2 = iPath.removeFirstSegments(1);
        if (string2.equalsIgnoreCase("$nl$")) {
            return this.findNL(string, iPath2, map, list);
        }
        if (string2.equalsIgnoreCase("$os$")) {
            return this.findOS(string, iPath2, map, list);
        }
        if (string2.equalsIgnoreCase("$ws$")) {
            return this.findWS(string, iPath2, map, list);
        }
        if (string2.equalsIgnoreCase("$files$")) {
            return null;
        }
        return null;
    }

    private URL findNL(String string, IPath iPath, Map map, List list) {
        String[] stringArray;
        String string2 = null;
        if (map != null) {
            try {
                string2 = (String)map.get("$nl$");
            }
            catch (ClassCastException classCastException) {}
        }
        String[] stringArray2 = stringArray = string2 == null || string2.length() == 0 ? NL_VARIANTS : StandaloneFileLocator.buildNLVariants(string2);
        if (stringArray == null) {
            return null;
        }
        URL uRL = null;
        int n = 0;
        while (n < stringArray.length) {
            IPath iPath2 = new Path(stringArray[n]).append(iPath);
            uRL = this.find(string, iPath2, list);
            if (uRL != null && list == null) {
                return uRL;
            }
            ++n;
        }
        return this.find(string, iPath, list);
    }

    private URL findOS(String string, IPath iPath, Map map, List list) {
        String string2 = null;
        if (map != null) {
            try {
                string2 = (String)map.get("$os$");
            }
            catch (ClassCastException classCastException) {}
        }
        if (string2 == null) {
            string2 = OS;
        }
        if (string2 == null || string2.length() == 0) {
            return null;
        }
        String string3 = null;
        if (map != null) {
            try {
                string3 = (String)map.get("$arch$");
            }
            catch (ClassCastException classCastException) {}
        }
        if (string3 == null) {
            string3 = ARCH;
        }
        if (string3 == null || string3.length() == 0) {
            return null;
        }
        URL uRL = null;
        IPath iPath2 = new Path("os").append(string2).append(string3);
        while (iPath2.segmentCount() != 1) {
            IPath iPath3 = iPath2.append(iPath);
            uRL = this.find(string, iPath3, list);
            if (uRL != null && list == null) {
                return uRL;
            }
            iPath2 = iPath2.removeLastSegments(1);
        }
        return this.find(string, iPath, list);
    }

    private URL findWS(String string, IPath iPath, Map map, List list) {
        String string2 = null;
        if (map != null) {
            try {
                string2 = (String)map.get("$ws$");
            }
            catch (ClassCastException classCastException) {}
        }
        if (string2 == null) {
            string2 = WS;
        }
        if (string2 == null || string2.length() == 0) {
            return null;
        }
        IPath iPath2 = new Path("ws").append(string2).append(iPath);
        URL uRL = this.find(string, iPath2, list);
        if (uRL != null && list == null) {
            return uRL;
        }
        return this.find(string, iPath, list);
    }

    private URL find(String string, IPath iPath, List list) {
        List list2 = (List)this.bundleNameToURLsMap.get(string);
        if (list2 == null || list2.isEmpty()) {
            return null;
        }
        URL uRL = null;
        for (URL uRL2 : list2) {
            URL uRL3 = this.find(uRL2, iPath);
            if (uRL3 == null) continue;
            if (uRL == null) {
                uRL = uRL3;
            }
            if (list == null) break;
            list.add(uRL3);
        }
        return uRL;
    }

    private URL find(URL uRL, IPath iPath) {
        URL uRL2 = null;
        if (iPath.isEmpty() || iPath.isRoot()) {
            uRL2 = uRL;
        } else {
            try {
                uRL2 = new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), String.valueOf(uRL.getPath()) + iPath.toString());
            }
            catch (MalformedURLException malformedURLException) {}
        }
        if (uRL2 != null) {
            try {
                uRL2.openStream().close();
            }
            catch (IOException iOException) {
                uRL2 = null;
            }
        }
        return uRL2;
    }

    private static String[] buildNLVariants(String string) {
        if (string == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Path path = new Path("nl");
        Path path2 = new Path(string.replace('_', '/'));
        while (path2.segmentCount() > 0) {
            arrayList.add(path.append((IPath)path2).toString());
            if (path2.segmentCount() > 1) {
                arrayList.add(path.append(path2.toString().replace('/', '_')).toString());
            }
            path2 = path2.removeLastSegments(1);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }
}

