/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.internal.util;

import com.ibm.team.repository.common.internal.util.StandaloneExtensionRegistry$1;
import com.ibm.team.repository.common.internal.util.StandaloneExtensionRegistry$ResourceBundleClassLoader;
import com.ibm.team.repository.common.internal.util.StandaloneFileLocator;
import com.ibm.team.repository.common.internal.util.StandaloneUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.core.runtime.spi.IRegistryProvider;
import org.eclipse.core.runtime.spi.RegistryContributor;
import org.eclipse.core.runtime.spi.RegistryStrategy;

public class StandaloneExtensionRegistry
implements IRegistryProvider {
    private static final Log logger = LogFactory.getLog(StandaloneFileLocator.class);
    private Object masterRegistryKey = new Object();
    private Map pluginIdToBundlePropertiesLoader;
    private IExtensionRegistry registry;

    protected StandaloneExtensionRegistry() {
        Enumeration<URL> enumeration;
        StandaloneExtensionRegistry$1 standaloneExtensionRegistry$1 = new StandaloneExtensionRegistry$1(this, null, null);
        this.registry = RegistryFactory.createRegistry((RegistryStrategy)standaloneExtensionRegistry$1, (Object)this.masterRegistryKey, null);
        this.pluginIdToBundlePropertiesLoader = new HashMap(64);
        try {
            enumeration = StandaloneExtensionRegistry.class.getClassLoader().getResources("plugin.xml");
        }
        catch (IOException iOException) {
            throw (Throwable)new RuntimeException(iOException);
        }
        int n = 0;
        while (enumeration.hasMoreElements()) {
            URL uRL = enumeration.nextElement();
            this.processPlugin(this.registry, uRL, n);
            ++n;
        }
    }

    private void processPlugin(IExtensionRegistry iExtensionRegistry, URL uRL, int n) {
        InputStream inputStream = null;
        ResourceBundle resourceBundle = null;
        try {
            try {
                String string;
                inputStream = uRL.openStream();
                String string2 = StandaloneUtil.getBundleNameForPluginXml(uRL);
                String string3 = Integer.toString(n);
                if (string2 == null) {
                    string2 = string3;
                }
                if ((string = this.getBundleLocalization(uRL)) != null) {
                    try {
                        StandaloneExtensionRegistry$ResourceBundleClassLoader standaloneExtensionRegistry$ResourceBundleClassLoader = new StandaloneExtensionRegistry$ResourceBundleClassLoader(this, StandaloneExtensionRegistry.class.getClassLoader(), string2, uRL, string);
                        resourceBundle = standaloneExtensionRegistry$ResourceBundleClassLoader.getResourceBundle(Locale.getDefault());
                        this.pluginIdToBundlePropertiesLoader.put(string2, standaloneExtensionRegistry$ResourceBundleClassLoader);
                    }
                    catch (MissingResourceException missingResourceException) {}
                }
                try {
                    iExtensionRegistry.addContribution(inputStream, (IContributor)new RegistryContributor(string3, string2, null, null), false, null, resourceBundle, this.masterRegistryKey);
                }
                catch (MissingResourceException missingResourceException) {
                    String string4 = "Exception parsing manifest for plugin \"{0}\" due to a missing key in properties file \"{1}\"";
                    string4 = MessageFormat.format(string4, string2, string);
                    throw (Throwable)new IllegalStateException(string4, missingResourceException);
                }
            }
            catch (IOException iOException) {
                logger.error((Object)iOException);
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException2) {
                    logger.error((Object)iOException2);
                }
            }
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                logger.error((Object)iOException);
            }
        }
    }

    private String getBundleLocalization(URL uRL) {
        Attributes attributes;
        InputStream inputStream;
        block16: {
            block17: {
                URL uRL2 = this.computeRelativeResource(uRL, "META-INF/MANIFEST.MF");
                inputStream = null;
                try {
                    inputStream = uRL2.openStream();
                }
                catch (IOException iOException) {
                    logger.warn((Object)("Could not open META-INF/MANIFEST.MF for bundle: " + uRL));
                    return null;
                }
                try {
                    Manifest manifest;
                    try {
                        manifest = new Manifest(inputStream);
                    }
                    catch (IOException iOException) {
                        throw (Throwable)new IllegalStateException("Error parsing manifest: " + uRL2, iOException);
                    }
                    attributes = manifest.getMainAttributes();
                    if (attributes != null) break block16;
                    if (inputStream == null) break block17;
                }
                catch (Throwable throwable) {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            return null;
        }
        String string = attributes.getValue("Bundle-Localization");
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        if (string == null) {
            string = "OSGI-INF/l10n/bundle";
        }
        return string;
    }

    private URL computeRelativeResource(URL uRL, String string) {
        try {
            return new URL(uRL, string);
        }
        catch (MalformedURLException malformedURLException) {
            logger.error((Object)malformedURLException);
            return null;
        }
    }

    public IExtensionRegistry getRegistry() {
        return this.registry;
    }

    public ResourceBundle getResourceBundle(String string, Locale locale) {
        StandaloneExtensionRegistry$ResourceBundleClassLoader standaloneExtensionRegistry$ResourceBundleClassLoader = (StandaloneExtensionRegistry$ResourceBundleClassLoader)this.pluginIdToBundlePropertiesLoader.get(string);
        if (standaloneExtensionRegistry$ResourceBundleClassLoader != null) {
            return standaloneExtensionRegistry$ResourceBundleClassLoader.getResourceBundle(locale);
        }
        return null;
    }

    static /* synthetic */ URL access$0(StandaloneExtensionRegistry standaloneExtensionRegistry, URL uRL, String string) {
        return standaloneExtensionRegistry.computeRelativeResource(uRL, string);
    }
}

