/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.internal.util;

import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.internal.util.ObjectSizer$Sizeable;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.common.util.AbstractEnumerator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class ObjectSizer {
    private static Log logger = LogFactory.getLog(ObjectSizer.class);
    private static List unsizeableObjectList = new ArrayList(10);
    private final Map visited = new IdentityHashMap();

    public static long getSize(Object object) {
        if (object == null) {
            return 0L;
        }
        ObjectSizer objectSizer = new ObjectSizer();
        long l = objectSizer.getSize(object, 0L);
        return l;
    }

    private ObjectSizer() {
    }

    private long getSize(Collection collection) {
        if (collection == null) {
            return 0L;
        }
        long l = 8L;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            l += this.getSize(iterator.next(), 4L);
        }
        return l;
    }

    private long getSize(Map map) {
        if (map == null) {
            return 0L;
        }
        long l = 32L;
        for (Map.Entry entry : map.entrySet()) {
            l += 4L;
            l += this.getSize(entry.getKey(), 4L);
            l += this.getSize(entry.getValue(), 4L);
        }
        return l;
    }

    private long getSize(Object[] objectArray) {
        if (objectArray == null) {
            return 0L;
        }
        long l = 8L;
        int n = 0;
        while (n < objectArray.length) {
            l = objectArray[n] != null ? (l += this.getSize(objectArray[n], 4L)) : (l += 4L);
            ++n;
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSize(Object object, long l) {
        if (object == null) {
            return 0L;
        }
        if (this.visited.containsKey(object)) {
            return 0L;
        }
        this.visited.put(object, null);
        if (object instanceof Integer) {
            return 4L;
        }
        if (object instanceof Float) {
            return 4L;
        }
        if (object instanceof Double) {
            return 8L;
        }
        if (object instanceof Long) {
            return 8L;
        }
        if (object instanceof Short) {
            return 2L;
        }
        if (object instanceof Byte) {
            return 1L;
        }
        if (object instanceof Boolean) {
            return 1L;
        }
        if (object instanceof Character) {
            return 2L;
        }
        if (object instanceof String) {
            return l + 8L + 24L + (long)(((String)object).length() * 2);
        }
        if (object instanceof UUID) {
            return l + 8L + 16L;
        }
        if (object instanceof Collection) {
            return l + 8L + this.getSize((Collection)object);
        }
        if (object instanceof Map) {
            return l + 8L + this.getSize((Map)object);
        }
        if (object instanceof Object[]) {
            return l + 8L + this.getSize((Object[])object);
        }
        if (object instanceof EObject) {
            EObject eObject = (EObject)object;
            long l2 = l + 8L + 20L;
            for (EStructuralFeature eStructuralFeature : eObject.eClass().getEAllStructuralFeatures()) {
                if (eObject.eIsSet(eStructuralFeature)) {
                    Object object2 = eObject.eGet(eStructuralFeature);
                    l2 += this.getSize(object2, 4L);
                    continue;
                }
                l2 += 4L;
            }
            return l2;
        }
        if (object instanceof Timestamp) {
            return 28L + l;
        }
        if (object instanceof AbstractEnumerator) {
            AbstractEnumerator abstractEnumerator = (AbstractEnumerator)object;
            long l3 = ObjectSizer.getSize(abstractEnumerator.getName());
            long l4 = ObjectSizer.getSize(abstractEnumerator.getLiteral());
            return l3 + l4 + 4L + 8L + l;
        }
        if (object instanceof Date) {
            return 28L + l;
        }
        if (object instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)object;
            long l5 = ObjectSizer.getSize(bigDecimal.toString());
            return l5 + 8L + l;
        }
        if (object instanceof ObjectSizer$Sizeable) {
            ObjectSizer$Sizeable objectSizer$Sizeable = (ObjectSizer$Sizeable)object;
            long l6 = objectSizer$Sizeable.getObjectSize(this);
            return l6 + l;
        }
        String string = object.getClass().getName();
        if ("com.ibm.team.repository.client.internal.TeamRepository".equals(string)) {
            return 0L;
        }
        List list = unsizeableObjectList;
        synchronized (list) {
            block28: {
                if (!unsizeableObjectList.contains(string)) break block28;
                return 0L;
            }
            String string2 = "Unhandled ObjectSizer Class Case : '%s'";
            logger.warn((Object)String.format(string2, string));
            unsizeableObjectList.add(string);
            return 0L;
        }
    }
}

