/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.internal.util;

import com.ibm.team.repository.common.internal.nls.Messages;
import com.ibm.team.repository.common.internal.util.InternalTeamPlatform$$Cold;
import com.ibm.team.repository.common.internal.util.StandaloneAdapterRegistry;
import com.ibm.team.repository.common.internal.util.StandaloneExtensionRegistry;
import com.ibm.team.repository.common.internal.util.StandaloneFileLocator;
import com.ibm.team.repository.common.transport.TeamServiceCallContextImpl;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.internal.runtime.AdapterManager;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.core.runtime.spi.IRegistryProvider;
import org.osgi.framework.Bundle;

public class InternalTeamPlatform {
    private static final InternalTeamPlatform singleton = new InternalTeamPlatform();
    private static final Log logger = LogFactory.getLog(singleton.getClass());
    private static final URL[] EMPTY_URLS = new URL[0];
    private static final String URI = "uri";
    private static final String CLASS = "class";
    private static final String ECORE = "org.eclipse.emf.ecore";
    private static final String PACKAGE = "package";
    private static final String GEN_PACKAGE = "generated_package";
    private static final String EINSTANCE = "eINSTANCE";
    private static final String BUNDLE = "bundle";
    private static final String PATH = "path";
    private StandaloneExtensionRegistry standaloneRegistry;
    private StandaloneFileLocator standaloneFileLocator;
    private StandaloneAdapterRegistry standaloneAdapterRegistry;
    private boolean started = false;
    private boolean asBundle = false;
    private boolean stopped = false;

    private InternalTeamPlatform() {
    }

    public static InternalTeamPlatform getDefault() {
        return singleton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(boolean bl) {
        InternalTeamPlatform internalTeamPlatform = this;
        synchronized (internalTeamPlatform) {
            if (this.started && bl != this.asBundle) {
                throw (Throwable)new IllegalStateException("Already started from a different context. Current context = " + (bl ? BUNDLE : "plain java"));
            }
            if (this.started) {
                return;
            }
            this.started = true;
            this.asBundle = bl;
            this.initializeDebugOptions();
            if (!bl) {
                this.initializeRegistry();
                this.initializeGeneratedPackages();
                this.initializeFileLocator();
                this.initializeAdapterRegistry();
            }
        }
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean asBundle() {
        return this.asBundle;
    }

    private void initializeDebugOptions() {
        String string = null;
        string = this.asBundle ? Platform.getDebugOption((String)"com.ibm.team.repository.client/traceNoCancelableServerCall") : System.getProperty("com.ibm.team.repository.client.traceNoCancelableServerCall");
        boolean bl = string != null && string.equalsIgnoreCase("true");
        TeamServiceCallContextImpl.setLogNonCancelableServiceCalls(bl);
    }

    private void initializeFileLocator() {
        this.standaloneFileLocator = new StandaloneFileLocator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        InternalTeamPlatform internalTeamPlatform = this;
        synchronized (internalTeamPlatform) {
            if (this.stopped) {
                throw (Throwable)new IllegalStateException("Already stopped");
            }
            if (!this.asBundle) {
                try {
                    RegistryFactory.setDefaultRegistryProvider(null);
                }
                catch (CoreException coreException) {}
            }
            this.started = false;
            this.asBundle = false;
            this.stopped = true;
        }
    }

    public IExtensionRegistry getRegistry() {
        if (this.asBundle) {
            return RegistryFactory.getRegistry();
        }
        return this.standaloneRegistry.getRegistry();
    }

    public URL find(String string, IPath iPath, Map map) {
        if (this.asBundle) {
            Bundle bundle = Platform.getBundle((String)string);
            if (bundle == null) {
                String string2 = Messages.getServerString("InternalTeamPlatform.ErrorLocatingBundle");
                InternalTeamPlatform.logWarning(string2, string, iPath);
                return null;
            }
            URL uRL = FileLocator.find((Bundle)bundle, (IPath)iPath, (Map)map);
            if (uRL != null) {
                return uRL;
            }
            String string3 = Messages.getServerString("InternalTeamPlatform.ErrorLocatingPath");
            InternalTeamPlatform.logWarning(string3, string, iPath);
            return uRL;
        }
        return this.standaloneFileLocator.find(string, iPath, map, null);
    }

    public URL[] findAll(String string, IPath iPath, Map map) {
        if (this.asBundle) {
            Bundle bundle = Platform.getBundle((String)string);
            if (bundle == null) {
                String string2 = Messages.getServerString("InternalTeamPlatform.ErrorLocatingBundle");
                InternalTeamPlatform.logWarning(string2, string, iPath);
                return EMPTY_URLS;
            }
            return FileLocator.findEntries((Bundle)bundle, (IPath)iPath, (Map)map);
        }
        ArrayList arrayList = new ArrayList();
        this.standaloneFileLocator.find(string, iPath, map, arrayList);
        return arrayList.toArray(new URL[arrayList.size()]);
    }

    private static void logWarning(String string, String string2, IPath iPath) {
        if (!logger.isDebugEnabled()) {
            return;
        }
        String string3 = InternalTeamPlatform.messageForFind(string, string2, iPath);
        IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string3);
        logger.debug((Object)((Exception)illegalArgumentException).getMessage(), (Throwable)illegalArgumentException);
    }

    private static String messageForFind(String string, String string2, IPath iPath) throws  {
        return InternalTeamPlatform$$Cold.messageForFind(string, string2, iPath);
    }

    public IAdapterManager getAdapterManager() {
        if (this.asBundle) {
            return Platform.getAdapterManager();
        }
        return (IAdapterManager)AdapterManager.getDefault();
    }

    private void initializeRegistry() {
        this.standaloneRegistry = new StandaloneExtensionRegistry();
        try {
            RegistryFactory.setDefaultRegistryProvider((IRegistryProvider)this.standaloneRegistry);
        }
        catch (CoreException coreException) {}
    }

    private void initializeAdapterRegistry() {
        this.standaloneAdapterRegistry = new StandaloneAdapterRegistry();
        this.standaloneAdapterRegistry.start();
    }

    private void initializeGeneratedPackages() throws  {
        InternalTeamPlatform$$Cold.initializeGeneratedPackages(this);
    }
}

