/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.internal.querypath;

import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.internal.queryast.ComparisonOp;
import com.ibm.team.repository.common.internal.queryast.FeaturePath;
import com.ibm.team.repository.common.internal.queryast.FilterElement;
import com.ibm.team.repository.common.internal.queryast.InList;
import com.ibm.team.repository.common.internal.queryast.IsEmpty;
import com.ibm.team.repository.common.internal.queryast.IsMemberOf;
import com.ibm.team.repository.common.internal.queryast.IsMissing;
import com.ibm.team.repository.common.internal.queryast.IsNull;
import com.ibm.team.repository.common.internal.queryast.IsTypeOf;
import com.ibm.team.repository.common.internal.queryast.ItemTypePseudoVariable;
import com.ibm.team.repository.common.internal.queryast.QueryastFactory;
import com.ibm.team.repository.common.internal.queryast.impl.FeaturePathImpl;
import com.ibm.team.repository.common.internal.querypath.AbstractQueryPathModel$Implementation;
import com.ibm.team.repository.common.internal.querypath.IInternalQueryModel;
import com.ibm.team.repository.common.internal.querypath.IQueryPath;
import com.ibm.team.repository.common.internal.util.ItemUtil;
import com.ibm.team.repository.common.model.RepositoryPackage;
import com.ibm.team.repository.common.model.query.BaseAuditableQueryModel;
import com.ibm.team.repository.common.model.query.BaseItemHandleQueryModel;
import com.ibm.team.repository.common.model.query.BaseItemQueryModel;
import com.ibm.team.repository.common.model.query.BaseSimpleItemQueryModel;
import com.ibm.team.repository.common.model.query.impl.AuditableQueryModelImpl;
import com.ibm.team.repository.common.model.query.impl.ItemHandleQueryModelImpl;
import com.ibm.team.repository.common.model.query.impl.ItemQueryModelImpl;
import com.ibm.team.repository.common.model.query.impl.SimpleItemQueryModelImpl;
import com.ibm.team.repository.common.query.ast.IItemHandleInputArg;
import com.ibm.team.repository.common.query.ast.IItemQueryModel;
import com.ibm.team.repository.common.query.ast.IItemTypeInputArg;
import com.ibm.team.repository.common.query.ast.IManyItemQueryModel;
import com.ibm.team.repository.common.query.ast.IPredicate;
import com.ibm.team.repository.common.query.ast.IPseudoVariable;
import com.ibm.team.repository.common.query.ast.IQueryModel;
import com.ibm.team.repository.common.query.ast.ISingleItemQueryModel;
import com.ibm.team.repository.common.query.ast.ISingleQueryModel;
import com.ibm.team.repository.common.util.NLS;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;

public abstract class AbstractQueryPathModel
implements ISingleItemQueryModel,
IManyItemQueryModel,
IInternalQueryModel {
    private static String ITEM_QM = ItemQueryModelImpl.class.getName();
    private static String SIMPLE_ITEM_QM = SimpleItemQueryModelImpl.class.getName();
    private static String ITEM_HANDLE_QM = ItemHandleQueryModelImpl.class.getName();
    private static String AUDITABLE_QM = AuditableQueryModelImpl.class.getName();
    private static final String OPERATION_ONLY_ALLOWED_ON_SINGLE_VALUED_REFERENCES = "Operation only allowed on single valued references";
    private static final String OPERATION_ONLY_ALLOWED_ON_MANY_VALUED_REFERENCES = "Operation only allowed on many valued references";
    protected AbstractQueryPathModel$Implementation _implementation;

    public static AbstractQueryPathModel$Implementation getImplementation(IQueryModel iQueryModel) {
        return ((IInternalQueryModel)((Object)iQueryModel))._getImplementation();
    }

    public AbstractQueryPathModel(IQueryPath iQueryPath, String string) {
        this._implementation = new AbstractQueryPathModel$Implementation(this, iQueryPath, string, null);
        this.initProperties(AbstractQueryPathModel$Implementation.access$1(this._implementation), AbstractQueryPathModel$Implementation.access$2(this._implementation), AbstractQueryPathModel$Implementation.access$3(this._implementation));
    }

    protected void initProperties(List list, List list2, Map map) {
    }

    public AbstractQueryPathModel() {
        this(null, null);
    }

    public IPredicate _isEmpty() {
        if (!this._implementation.isManyValuedRef()) {
            throw (Throwable)new UnsupportedOperationException(OPERATION_ONLY_ALLOWED_ON_MANY_VALUED_REFERENCES);
        }
        IsEmpty isEmpty = QueryastFactory.eINSTANCE.createIsEmpty();
        isEmpty.setFeature(QueryastFactory.eINSTANCE.createFeaturePath(this._implementation));
        isEmpty.setNot(false);
        return isEmpty;
    }

    public IPredicate _in(IItemHandleInputArg[] iItemHandleInputArgArray) {
        if (!this._implementation.isSingleValueRef()) {
            throw (Throwable)new UnsupportedOperationException(OPERATION_ONLY_ALLOWED_ON_SINGLE_VALUED_REFERENCES);
        }
        InList inList = QueryastFactory.eINSTANCE.createInList();
        FeaturePath featurePath = QueryastFactory.eINSTANCE.createFeaturePath(this._implementation.getIdField());
        ((FeaturePathImpl)featurePath).setExtended(true);
        inList.setField(featurePath);
        IItemHandleInputArg[] iItemHandleInputArgArray2 = iItemHandleInputArgArray;
        int n = iItemHandleInputArgArray.length;
        int n2 = 0;
        while (n2 < n) {
            IItemHandleInputArg iItemHandleInputArg = iItemHandleInputArgArray2[n2];
            inList.getValues().add((Object)iItemHandleInputArg);
            ++n2;
        }
        return inList;
    }

    public IPredicate _contains(ISingleQueryModel iSingleQueryModel) {
        if (!this._implementation.isManyValuedRef()) {
            throw (Throwable)new UnsupportedOperationException(OPERATION_ONLY_ALLOWED_ON_MANY_VALUED_REFERENCES);
        }
        AbstractQueryPathModel$Implementation abstractQueryPathModel$Implementation = AbstractQueryPathModel.getImplementation(iSingleQueryModel);
        if (abstractQueryPathModel$Implementation.getRoot() != this._implementation.getRoot()) {
            throw (Throwable)new IllegalArgumentException("A _contains query cannot span two different root types");
        }
        IsMemberOf isMemberOf = QueryastFactory.eINSTANCE.createIsMemberOf();
        isMemberOf.setCollectionPath(QueryastFactory.eINSTANCE.createFeaturePath(this._implementation));
        isMemberOf.setElementPath(QueryastFactory.eINSTANCE.createFeaturePath(abstractQueryPathModel$Implementation));
        isMemberOf.setNot(false);
        return isMemberOf;
    }

    public IPredicate _contains(IItemHandle iItemHandle) {
        if (!this._implementation.isManyValuedRef()) {
            throw (Throwable)new UnsupportedOperationException(OPERATION_ONLY_ALLOWED_ON_MANY_VALUED_REFERENCES);
        }
        IsMemberOf isMemberOf = QueryastFactory.eINSTANCE.createIsMemberOf();
        isMemberOf.setCollectionPath(QueryastFactory.eINSTANCE.createFeaturePath(this._implementation));
        isMemberOf.setElementPath(QueryastFactory.eINSTANCE.createUUIDLiteral(iItemHandle.getItemId()));
        isMemberOf.setNot(false);
        return isMemberOf;
    }

    public IPredicate _contains(IItemHandleInputArg iItemHandleInputArg) {
        if (!this._implementation.isManyValuedRef()) {
            throw (Throwable)new UnsupportedOperationException(OPERATION_ONLY_ALLOWED_ON_MANY_VALUED_REFERENCES);
        }
        FilterElement filterElement = QueryastFactory.eINSTANCE.createFilterElement(iItemHandleInputArg);
        IsMemberOf isMemberOf = QueryastFactory.eINSTANCE.createIsMemberOf();
        isMemberOf.setCollectionPath(QueryastFactory.eINSTANCE.createFeaturePath(this._implementation));
        isMemberOf.setElementPath(filterElement);
        isMemberOf.setNot(false);
        return isMemberOf;
    }

    public IPredicate _eq(IItemHandle iItemHandle) {
        if (!this._implementation.isSingleValueRef()) {
            throw (Throwable)new UnsupportedOperationException(OPERATION_ONLY_ALLOWED_ON_SINGLE_VALUED_REFERENCES);
        }
        FilterElement filterElement = QueryastFactory.eINSTANCE.createFilterElement(this._implementation.getIdField());
        ((FeaturePathImpl)filterElement).setExtended(true);
        return QueryastFactory.eINSTANCE.createBasicComparison(ComparisonOp.EQUALS_LITERAL, filterElement, iItemHandle.getItemId());
    }

    public IPredicate _eq(IItemHandleInputArg iItemHandleInputArg) {
        if (!this._implementation.isSingleValueRef()) {
            throw (Throwable)new UnsupportedOperationException(OPERATION_ONLY_ALLOWED_ON_SINGLE_VALUED_REFERENCES);
        }
        FilterElement filterElement = QueryastFactory.eINSTANCE.createFilterElement(this._implementation.getIdField());
        ((FeaturePathImpl)filterElement).setExtended(true);
        return QueryastFactory.eINSTANCE.createBasicComparison(ComparisonOp.EQUALS_LITERAL, filterElement, iItemHandleInputArg);
    }

    public IPredicate _isNull() {
        if (!this._implementation.isSingleValueRef()) {
            throw (Throwable)new UnsupportedOperationException(OPERATION_ONLY_ALLOWED_ON_SINGLE_VALUED_REFERENCES);
        }
        IsNull isNull = QueryastFactory.eINSTANCE.createIsNull();
        isNull.setNot(false);
        FeaturePath featurePath = QueryastFactory.eINSTANCE.createFeaturePath(this._implementation.getIdField());
        ((FeaturePathImpl)featurePath).setExtended(true);
        isNull.setFeature(featurePath);
        return isNull;
    }

    public IPredicate _isMissing() {
        if (!this._implementation.isSingleValueRef()) {
            throw (Throwable)new UnsupportedOperationException(OPERATION_ONLY_ALLOWED_ON_SINGLE_VALUED_REFERENCES);
        }
        IsMissing isMissing = QueryastFactory.eINSTANCE.createIsMissing();
        isMissing.setNot(false);
        isMissing.setFeature(QueryastFactory.eINSTANCE.createFeaturePath(this._implementation));
        return isMissing;
    }

    public IPredicate _isTypeOf(IItemType iItemType) {
        IsTypeOf isTypeOf = QueryastFactory.eINSTANCE.createIsTypeOf();
        isTypeOf.setNot(false);
        isTypeOf.setFeature(QueryastFactory.eINSTANCE.createFeaturePath(this._implementation));
        isTypeOf.setType(QueryastFactory.eINSTANCE.createItemTypeLiteral(iItemType));
        return isTypeOf;
    }

    public IPredicate _isTypeOf(IItemTypeInputArg iItemTypeInputArg) {
        IsTypeOf isTypeOf = QueryastFactory.eINSTANCE.createIsTypeOf();
        isTypeOf.setNot(false);
        isTypeOf.setFeature(QueryastFactory.eINSTANCE.createFeaturePath(this._implementation));
        FilterElement filterElement = QueryastFactory.eINSTANCE.createFilterElement(iItemTypeInputArg);
        isTypeOf.setType(filterElement);
        return isTypeOf;
    }

    public IPseudoVariable _itemType() {
        ItemTypePseudoVariable itemTypePseudoVariable = QueryastFactory.eINSTANCE.createItemTypePseudoVariable();
        itemTypePseudoVariable.setFeature(QueryastFactory.eINSTANCE.createFeaturePath(this._implementation));
        return itemTypePseudoVariable;
    }

    protected AbstractQueryPathModel getReference(String string) {
        return null;
    }

    public AbstractQueryPathModel$Implementation _getImplementation() {
        return this._implementation;
    }

    protected abstract boolean isItem();

    private boolean isGeneric(AbstractQueryPathModel abstractQueryPathModel) {
        String string = abstractQueryPathModel.getClass().getName();
        return string.equals(ITEM_HANDLE_QM) || string.equals(ITEM_QM) || string.equals(AUDITABLE_QM) || string.equals(SIMPLE_ITEM_QM);
    }

    private EClass getEClassFrom(AbstractQueryPathModel abstractQueryPathModel) {
        if (abstractQueryPathModel instanceof BaseItemQueryModel.ItemQueryModel || abstractQueryPathModel instanceof BaseItemHandleQueryModel.ItemHandleQueryModel) {
            return RepositoryPackage.eINSTANCE.getItem();
        }
        if (abstractQueryPathModel instanceof BaseAuditableQueryModel.AuditableQueryModel) {
            return RepositoryPackage.eINSTANCE.getAuditable();
        }
        if (abstractQueryPathModel instanceof BaseSimpleItemQueryModel.SimpleItemQueryModel) {
            return RepositoryPackage.eINSTANCE.getSimpleItem();
        }
        String string = NLS.bind("unknown generic query path model: {0}", abstractQueryPathModel.getClass().getName());
        throw (Throwable)new IllegalStateException(string);
    }

    private EClass getEClassFrom(IItemType iItemType) {
        EClass eClass = ItemUtil.getEClass(iItemType.getName(), iItemType.getNamespaceURI());
        if (ItemUtil.isHandle(eClass)) {
            return ItemUtil.getItemEClass(eClass);
        }
        return eClass;
    }

    private void checkRetargetValidity(IItemQueryModel iItemQueryModel) {
        if (iItemQueryModel == null) {
            throw (Throwable)new UnsupportedOperationException("cannot target null!");
        }
        if (!this._implementation.isSingleValueRef()) {
            throw (Throwable)new UnsupportedOperationException("cannot re-target many valued references!");
        }
        if (this._implementation.isRetargeted()) {
            throw (Throwable)new UnsupportedOperationException("illegal target operation!");
        }
        if (!this.isGeneric(this)) {
            throw (Throwable)new UnsupportedOperationException("must be of generic type: ItemHandle, Item, Auditable, SimpleItem!");
        }
        try {
            iItemQueryModel.getClass().getField("ROOT");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw (Throwable)new UnsupportedOperationException("can only target concrete item types!");
        }
        if (AbstractQueryPathModel$Implementation.access$4(((AbstractQueryPathModel)iItemQueryModel)._implementation) == null) {
            throw (Throwable)new UnsupportedOperationException("can only target concrete item types!");
        }
        IItemType iItemType = ((AbstractQueryPathModel)iItemQueryModel)._implementation.getItemType();
        if (!ItemUtil.isSubclass(this.getEClassFrom(this), this.getEClassFrom(iItemType))) {
            throw (Throwable)new UnsupportedOperationException("can only target items in the same hierarchy!");
        }
    }

    public IItemQueryModel _target(IItemQueryModel iItemQueryModel) {
        IItemQueryModel iItemQueryModel2;
        this.checkRetargetValidity(iItemQueryModel);
        StringBuffer stringBuffer = new StringBuffer();
        IItemType iItemType = ((AbstractQueryPathModel)iItemQueryModel)._implementation.getItemType();
        stringBuffer.append('(').append(iItemType.getNamespaceURI()).append('#').append(iItemType.getName()).append(')').append(AbstractQueryPathModel$Implementation.access$5(this._implementation));
        try {
            iItemQueryModel2 = (IItemQueryModel)iItemQueryModel.getClass().getConstructor(IQueryPath.class, String.class).newInstance(AbstractQueryPathModel$Implementation.access$6(this._implementation), stringBuffer.toString());
        }
        catch (Exception exception) {
            String string = NLS.bind("Could not create new query model in _target: {0}", iItemQueryModel.getClass().getSimpleName());
            throw (Throwable)new IllegalStateException(string);
        }
        return (IItemQueryModel)iItemQueryModel.getClass().cast(iItemQueryModel2);
    }
}

