/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.internal.queryast.impl;

import com.ibm.team.repository.common.internal.queryast.OrderBy;
import com.ibm.team.repository.common.internal.queryast.SelectionElement;
import com.ibm.team.repository.common.internal.queryast.impl.AstQueryImpl;
import com.ibm.team.repository.common.internal.queryast.impl.FeaturePathImpl;
import com.ibm.team.repository.common.internal.queryast.impl.IQueryStringTransform;
import java.util.Iterator;

public class AstQueryStringTransform
implements IQueryStringTransform {
    static final String ERROR_OCCURRED_CREATING_PRINT_STRING = "<error occurred here>";
    private AstQueryImpl fAstQuery;

    public AstQueryStringTransform(AstQueryImpl astQueryImpl) {
        this.query(astQueryImpl);
    }

    private void query(AstQueryImpl astQueryImpl) {
        this.fAstQuery = astQueryImpl;
    }

    private AstQueryImpl query() {
        return this.fAstQuery;
    }

    public String toJavaString() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            this.addCreateRoot(stringBuffer);
            this.addCreateQuery(stringBuffer);
            if (this.query().isDistinct()) {
                stringBuffer.append("\nq.distinct();");
            }
            this.addCreateSelectList(stringBuffer);
            this.addCreateFilter(stringBuffer);
            this.addCreateOrderBys(stringBuffer);
            this.addCreateGroupBys(stringBuffer);
        }
        catch (Exception exception) {
            stringBuffer.append(ERROR_OCCURRED_CREATING_PRINT_STRING);
        }
        return stringBuffer.toString();
    }

    public String toDynamicJavaString() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            this.addCreateDynamicRoot(stringBuffer);
            this.addCreateDynamicQuery(stringBuffer);
            if (this.query().isDistinct()) {
                stringBuffer.append("\nq.distinct();");
            }
            this.addCreateDynamicSelectList(stringBuffer);
            this.addCreateDynamicFilter(stringBuffer);
            this.addCreateDynamicOrderBys(stringBuffer);
            this.addCreateDynamicGroupBys(stringBuffer);
        }
        catch (Exception exception) {
            stringBuffer.append(ERROR_OCCURRED_CREATING_PRINT_STRING);
        }
        return stringBuffer.toString();
    }

    private void addCreateOrderBys(StringBuffer stringBuffer) {
        for (OrderBy orderBy : this.query().getOrderBys()) {
            if (orderBy.isUsingLocale()) {
                if (orderBy.isAsc()) {
                    stringBuffer.append("\nq.orderByAscUsingLocale(");
                } else {
                    stringBuffer.append("\nq.orderByDscUsingLocale(");
                }
            } else if (orderBy.isAsc()) {
                stringBuffer.append("\nq.orderByAsc(");
            } else {
                stringBuffer.append("\nq.orderByDsc(");
            }
            orderBy.getField().toJavaStringOn(stringBuffer);
            stringBuffer.append(");");
        }
    }

    private void addCreateDynamicOrderBys(StringBuffer stringBuffer) {
        for (OrderBy orderBy : this.query().getOrderBys()) {
            if (orderBy.isUsingLocale()) {
                if (orderBy.isAsc()) {
                    stringBuffer.append("\nq.orderByAscUsingLocale(");
                } else {
                    stringBuffer.append("\nq.orderByDscUsingLocale(");
                }
            } else if (orderBy.isAsc()) {
                stringBuffer.append("\nq.orderByAsc(");
            } else {
                stringBuffer.append("\nq.orderByDsc(");
            }
            orderBy.getField().toDynamicJavaStringOn(stringBuffer);
            stringBuffer.append(");");
        }
    }

    private void addCreateGroupBys(StringBuffer stringBuffer) {
        Iterator iterator = this.query().getGroupBys().iterator();
        while (iterator.hasNext()) {
            stringBuffer.append("\nq.groupBy(");
            ((SelectionElement)iterator.next()).toJavaStringOn(stringBuffer);
            stringBuffer.append(");");
        }
        if (this.query().getHaving() != null) {
            stringBuffer.append("\nq.having(");
            this.query().getHaving().toJavaStringOn(stringBuffer);
            stringBuffer.append(");");
        }
    }

    private void addCreateDynamicGroupBys(StringBuffer stringBuffer) {
        Iterator iterator = this.query().getGroupBys().iterator();
        while (iterator.hasNext()) {
            stringBuffer.append("\nq.groupBy(");
            ((SelectionElement)iterator.next()).toDynamicJavaStringOn(stringBuffer);
            stringBuffer.append(");");
        }
        if (this.query().getHaving() != null) {
            stringBuffer.append("\nq.having(");
            this.query().getHaving().toDynamicJavaStringOn(stringBuffer);
            stringBuffer.append(");");
        }
    }

    private void addCreateSelectList(StringBuffer stringBuffer) {
        Iterator iterator = this.query().getSelectList().iterator();
        while (iterator.hasNext()) {
            stringBuffer.append("\nq.select(");
            ((SelectionElement)iterator.next()).toJavaStringOn(stringBuffer);
            stringBuffer.append(");");
        }
    }

    private void addCreateDynamicSelectList(StringBuffer stringBuffer) {
        Iterator iterator = this.query().getSelectList().iterator();
        while (iterator.hasNext()) {
            stringBuffer.append("\nq.select(");
            ((SelectionElement)iterator.next()).toDynamicJavaStringOn(stringBuffer);
            stringBuffer.append(");");
        }
    }

    private void addCreateFilter(StringBuffer stringBuffer) {
        if (this.query().getFilter() == null) {
            return;
        }
        stringBuffer.append("\nq.filter(");
        this.query().getFilter().toJavaStringOn(stringBuffer);
        stringBuffer.append(");");
    }

    private void addCreateDynamicFilter(StringBuffer stringBuffer) {
        if (this.query().getFilter() == null) {
            return;
        }
        stringBuffer.append("\nq.filter(");
        this.query().getFilter().toDynamicJavaStringOn(stringBuffer);
        stringBuffer.append(");");
    }

    private void addCreateQuery(StringBuffer stringBuffer) {
        stringBuffer.append("\nAstQuery q = (AstQuery) ");
        if (this.query().getSelectList().isEmpty()) {
            stringBuffer.append("IItem");
        } else {
            stringBuffer.append("IData");
        }
        stringBuffer.append("Query.FACTORY.newInstance(r");
        if (this.query().getTargetPath() != null) {
            stringBuffer.append(".");
            ((FeaturePathImpl)this.query().getTargetPath()).toJavaString(stringBuffer, null);
        }
        stringBuffer.append(");");
    }

    private void addCreateDynamicQuery(StringBuffer stringBuffer) {
        if (this.query().getSelectList().isEmpty()) {
            stringBuffer.append("\nIItemQuery q = IItemQuery");
        } else {
            stringBuffer.append("\nIDataQuery q = IDataQuery");
        }
        stringBuffer.append(".FACTORY.newInstance(");
        if (this.query().getSelectList().isEmpty()) {
            stringBuffer.append("(IDynamicItemQueryModel) ");
        }
        stringBuffer.append("d");
        if (this.query().getTargetPath() != null) {
            stringBuffer.append(".");
            ((FeaturePathImpl)this.query().getTargetPath()).toDynamicJavaStringOn(stringBuffer, null);
        }
        stringBuffer.append(");");
    }

    private void addCreateRoot(StringBuffer stringBuffer) {
        String string = "QueryModel";
        String string2 = this.query().getRootItemType().getName();
        stringBuffer.append("\n").append(string2).append(string).append(" r = ").append(string2).append(string).append(".ROOT").append(";");
    }

    private void addCreateDynamicRoot(StringBuffer stringBuffer) {
        stringBuffer.append("IDynamicQueryModel d = ItemUtil.itemTypeFor(").append("\"").append(this.query().getRootItemType().getName()).append("\"").append(", ").append("\"").append(this.query().getRootNsURI()).append("\"").append(").getQueryModel();");
    }
}

