/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.internal.content.util.tar;

import com.ibm.team.repository.common.internal.content.util.tar.TarEntry;
import com.ibm.team.repository.common.internal.nls.Messages;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.repository.common.utils.UnsynchronizedBufferedInputStream;
import com.ibm.team.repository.common.utils.UnsynchronizedBufferedOutputStream;
import com.ibm.team.repository.common.utils.UnsynchronizedByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TarOutputStream
extends FilterOutputStream {
    public static final OutputFilterProvider gzipFilter = new OutputFilterProvider(){

        public OutputStream getOutputFilter(OutputStream out) throws IOException {
            return new GZIPOutputStream(out, 8192);
        }
    };
    public static final OutputFilterProvider nullFilter = new OutputFilterProvider(){

        public OutputStream getOutputFilter(OutputStream out) throws IOException {
            return out;
        }
    };
    private static final byte[] emptyBuffer = new byte[1024];
    private static final long MAX_OCTAL_8 = 262143L;
    private static final long MAX_OCTAL_12 = 0x1FFFFFFFFL;
    private RandomAccessFile file;
    private RandomAccessFileOutputStream raOut;
    private NonClosingOutputStream bufOut;
    private File tempFile;
    private OutputStream tempOut;
    private TarEntry nextEntryToWrite;
    private long bytesWritten;
    private long contentLength;
    private boolean finished;
    private final boolean usePosix;
    private final byte[] header = new byte[512];

    public TarOutputStream(String fileName) throws IOException {
        this(fileName, false);
    }

    public TarOutputStream(String fileName, boolean usePosix) throws IOException {
        this(new File(fileName), usePosix);
    }

    public TarOutputStream(File file) throws IOException {
        this(file, false);
    }

    public TarOutputStream(File file, boolean usePosix) throws IOException {
        this(new RandomAccessFileOutputStream(new RandomAccessFile(file, "rw")), usePosix);
    }

    private TarOutputStream(RandomAccessFileOutputStream out, boolean usePosix) throws IOException {
        this(new NonClosingOutputStream(out), usePosix);
        this.raOut = out;
        this.file = out.getFile();
        this.bufOut = (NonClosingOutputStream)this.out;
        this.file.setLength(0L);
        this.file.seek(0L);
    }

    public TarOutputStream(OutputStream out) {
        this(out, false);
    }

    public TarOutputStream(OutputStream out, boolean usePosix) {
        super(out);
        this.usePosix = usePosix;
    }

    public void putNextEntry(TarEntry entry, InputStream in, OutputFilterProvider provider) throws IOException {
        if (this.finished) {
            throw new IllegalStateException("The archive has been closed");
        }
        if (this.file == null) {
            this.putNextEntryTmp(entry, in, provider);
        } else {
            this.putNextEntryDirect(entry, in, provider);
        }
    }

    private void putNextEntryDirect(TarEntry entry, InputStream in, OutputFilterProvider provider) throws IOException {
        block28: {
            try {
                entry.setSize(0L);
                this.flush();
                long origOffset = this.file.getFilePointer();
                OutputStream out = null;
                boolean success = false;
                try {
                    int bytesRead;
                    this.closeEntry();
                    if (this.usePosix) {
                        this.writeOptionalPaxHeader(entry);
                    } else {
                        this.writeOptionalGnuHeader(entry);
                    }
                    this.flush();
                    long headerOffset = this.file.getFilePointer();
                    this.file.seek(headerOffset + 512L);
                    this.raOut.setSkipClose(true);
                    this.bufOut.setSkipClose(true);
                    out = provider.getOutputFilter(this.out);
                    byte[] buf = new byte[8192];
                    while ((bytesRead = in.read(buf)) != -1) {
                        out.write(buf, 0, bytesRead);
                    }
                    out.close();
                    out = null;
                    this.flush();
                    long newOffset = this.file.getFilePointer();
                    this.file.seek(headerOffset);
                    entry.setSize(newOffset - headerOffset - 512L);
                    if (this.usePosix) {
                        this.writePosixHeader(entry);
                    } else {
                        this.writeGnuHeader(entry);
                    }
                    this.flush();
                    this.file.seek(newOffset);
                    this.bytesWritten = this.contentLength = entry.getSize();
                    this.closeEntry();
                    success = true;
                }
                catch (Throwable throwable) {
                    block27: {
                        try {
                            if (success) break block27;
                            if (out != null) {
                                try {
                                    out.close();
                                }
                                catch (IOException iOException) {}
                            }
                            try {
                                this.flush();
                                this.file.seek(origOffset);
                                this.file.setLength(origOffset);
                            }
                            catch (IOException iOException) {}
                        }
                        finally {
                            this.raOut.setSkipClose(false);
                            this.bufOut.setSkipClose(false);
                        }
                    }
                    throw throwable;
                }
                try {
                    if (success) break block28;
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException iOException) {}
                    }
                    try {
                        this.flush();
                        this.file.seek(origOffset);
                        this.file.setLength(origOffset);
                    }
                    catch (IOException iOException) {}
                }
                finally {
                    this.raOut.setSkipClose(false);
                    this.bufOut.setSkipClose(false);
                }
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
    }

    private void putNextEntryTmp(TarEntry entry, InputStream inStream, OutputFilterProvider provider) throws IOException {
        InputStream in = inStream;
        File tmp = null;
        OutputStream out = null;
        try {
            int bytesRead;
            tmp = File.createTempFile("content", null);
            tmp.deleteOnExit();
            out = provider.getOutputFilter(new FileOutputStream(tmp));
            byte[] buf = new byte[8192];
            while ((bytesRead = in.read(buf)) != -1) {
                out.write(buf, 0, bytesRead);
            }
            out.close();
            out = null;
            in.close();
            in = null;
            entry.setSize(tmp.length());
            this.putNextEntry(entry);
            in = new FileInputStream(tmp);
            while ((bytesRead = in.read(buf)) != -1) {
                this.write(buf, 0, bytesRead);
            }
            this.closeEntry();
        }
        catch (Throwable throwable) {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            if (tmp != null) {
                tmp.delete();
            }
            throw throwable;
        }
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        if (tmp != null) {
            tmp.delete();
        }
    }

    public void putNextEntry(TarEntry entry) throws IOException {
        if (this.finished) {
            throw new IllegalStateException("The archive has been closed");
        }
        this.closeEntry();
        if (this.usePosix) {
            this.writeOptionalPaxHeader(entry);
            this.writePosixHeader(entry);
        } else {
            this.writeOptionalGnuHeader(entry);
            this.writeGnuHeader(entry);
        }
    }

    public void putNextEntryUnknownSize(TarEntry entry) throws IOException {
        if (this.finished) {
            throw new IllegalStateException("The archive has been closed");
        }
        this.closeEntry();
        if (this.file == null) {
            this.putNextEntryUnknownSizeTmp(entry);
        } else {
            this.putNextEntryUnknownSizeDirect(entry);
        }
    }

    private void putNextEntryUnknownSizeTmp(TarEntry entry) throws IOException {
        this.tempFile = File.createTempFile("content", null);
        boolean success = false;
        try {
            this.tempOut = new UnsynchronizedBufferedOutputStream(new FileOutputStream(this.tempFile));
            success = true;
        }
        finally {
            if (!success) {
                this.tempFile.delete();
            }
        }
        this.nextEntryToWrite = entry;
    }

    private void putNextEntryUnknownSizeDirect(TarEntry entry) throws IOException {
        entry.setSize(0L);
        if (this.usePosix) {
            this.writeOptionalPaxHeader(entry);
        } else {
            this.writeOptionalGnuHeader(entry);
        }
        this.flush();
        entry.setOffset(this.file.getFilePointer());
        this.file.seek(entry.getOffset() + 512L);
        this.nextEntryToWrite = entry;
    }

    private void writeOptionalGnuHeader(TarEntry entry) throws IOException {
        if (entry.getLinkName().getBytes().length > 99) {
            this.writeGnuLongLink(entry.getLinkName());
        }
        if (entry.getName().getBytes().length > 99) {
            this.writeGnuLongName(entry.getName());
        }
    }

    private void writeGnuLongLink(String linkName) throws IOException {
        this.writeGnuLongEntry(linkName, (byte)75);
    }

    private void writeGnuLongName(String linkName) throws IOException {
        this.writeGnuLongEntry(linkName, (byte)76);
    }

    private void writeGnuHeader(TarEntry entry) throws IOException {
        this.writeV7Header(entry, true);
        this.writeGnuMagicVersion();
        this.writeStringV7(entry.getUserName(), 265, 32);
        this.writeStringV7(entry.getGroupName(), 297, 32);
        this.writeLongNull(entry.getDevMajor(), 329, 8);
        this.writeLongNull(entry.getDevMinor(), 337, 8);
        this.writeLongNull(entry.getAtime(), 345, 12);
        this.writeLongNull(entry.getCtime(), 357, 12);
        this.writeSize(entry.getSize(), 483);
        this.writeCheckSum();
        this.out.write(this.header);
        this.bytesWritten = 0L;
        this.contentLength = entry.getSize();
    }

    private void writeGnuLongEntry(String content, byte type) throws IOException {
        byte[] contentBytes = content.getBytes();
        TarEntry entry = new TarEntry("././@LongLink", 0L, 0L, 0L, contentBytes.length, 0L, type, "", "", "", 0L, 0L, 0L, 0L);
        this.writeGnuHeader(entry);
        this.write(contentBytes);
        this.closeEntry();
    }

    private void writeGnuMagicVersion() {
        this.header[257] = 117;
        this.header[258] = 115;
        this.header[259] = 116;
        this.header[260] = 97;
        this.header[261] = 114;
        this.header[262] = 32;
        this.header[263] = 32;
        this.header[264] = 0;
    }

    private void writeOptionalPaxHeader(TarEntry entry) throws IOException {
        List<String> entries = this.getPaxEntries(entry);
        if (!entries.isEmpty()) {
            byte[] data = this.entriesToBytes(entries);
            TarEntry paxEntry = new TarEntry("././@PaxHeader", 0L, 0L, 0L, data.length, 0L, 120, "", "", "", 0L, 0L, 0L, 0L);
            this.writePosixHeader(paxEntry);
            this.write(data);
            this.closeEntry();
        }
    }

    private byte[] entriesToBytes(List<String> headers) throws IOException {
        UnsynchronizedByteArrayOutputStream out = new UnsynchronizedByteArrayOutputStream();
        for (String line : headers) {
            long newLength;
            byte[] bytes = line.getBytes("UTF-8");
            long lineLen = bytes.length + 2;
            if ((lineLen += this.lengthOf(lineLen)) != (newLength = this.lengthOf(lineLen)) + (long)bytes.length + 2L && ++lineLen != newLength + (long)bytes.length + 2L) {
                throw new IllegalStateException();
            }
            byte[] length = new byte[(int)newLength];
            do {
                length[(int)(--newLength)] = (byte)(48L + lineLen % 10L);
                lineLen /= 10L;
            } while (newLength != 0L);
            out.write(length);
            out.write(32);
            out.write(bytes);
            out.write(10);
        }
        return out.toByteArray();
    }

    private long lengthOf(long length) {
        long value = length;
        if (value < 0L) {
            throw new IllegalArgumentException();
        }
        long len = 0L;
        do {
            ++len;
        } while ((value /= 10L) != 0L);
        return len;
    }

    private List<String> getPaxEntries(TarEntry entry) {
        ArrayList<String> headers = new ArrayList<String>();
        if (entry.getName().getBytes().length > 99) {
            headers.add("path=" + entry.getName());
        }
        if (entry.getLinkName().getBytes().length > 99) {
            headers.add("linkpath=" + entry.getLinkName());
        }
        if (entry.getAtime() != 0L) {
            headers.add("atime=" + entry.getAtime());
        }
        if (entry.getCtime() != 0L) {
            headers.add("ctime=" + entry.getCtime());
        }
        if (entry.getMtime() < 0L || entry.getMtime() > 0x1FFFFFFFFL) {
            headers.add("mtime=" + entry.getMtime());
        }
        if (entry.getUserName().getBytes().length > 32) {
            headers.add("uname=" + entry.getUserName());
        }
        if (entry.getUid() > 262143L) {
            headers.add("uid=" + entry.getUid());
        }
        if (entry.getGroupName().getBytes().length > 32) {
            headers.add("gname=" + entry.getGroupName());
        }
        if (entry.getGid() > 262143L) {
            headers.add("gid=" + entry.getGid());
        }
        if (entry.getSize() > 0x1FFFFFFFFL) {
            headers.add("size=" + entry.getSize());
        }
        return headers;
    }

    private void writePosixHeader(TarEntry entry) throws IOException {
        this.writeV7Header(entry, false);
        this.writePosixName(entry.getName(), entry.getTypeFlag() == 53 || entry.getTypeFlag() == 68);
        this.writePosixMagicVersion();
        this.writeStringV7(entry.getUserName(), 265, 32);
        this.writeStringV7(entry.getGroupName(), 297, 32);
        this.writeLongNull(entry.getDevMajor(), 329, 8);
        this.writeLongNull(entry.getDevMinor(), 337, 8);
        this.writeCheckSum();
        this.out.write(this.header);
        this.bytesWritten = 0L;
        this.contentLength = entry.getSize();
    }

    private void writeV7Header(TarEntry entry, boolean writeName) {
        if (writeName) {
            String name = entry.getName();
            if (!(entry.getTypeFlag() != 53 && entry.getTypeFlag() != 68 || name.endsWith("/"))) {
                name = String.valueOf(name) + "/";
            }
            this.writeStringSuffixV7(name, 0, 100);
        }
        this.writeLongSpaceNull(entry.getMode(), 100, 8);
        this.writeLongSpaceNull(entry.getUid(), 108, 8);
        this.writeLongSpaceNull(entry.getGid(), 116, 8);
        this.writeSize(entry.getSize(), 124);
        this.writeLongSpace(entry.getMtime(), 136, 12);
        this.header[156] = entry.getTypeFlag();
        this.writeStringSuffixV7(entry.getLinkName(), 157, 100);
    }

    private void writeCheckSum() {
        long checkSum = 256L;
        int i = 0;
        while (i < 148) {
            checkSum += (long)(this.header[i] & 0xFF);
            ++i;
        }
        i = 156;
        while (i < this.header.length) {
            checkSum += (long)(this.header[i] & 0xFF);
            ++i;
        }
        this.writeLongNullSpace(checkSum, 148, 8);
    }

    private void writePosixMagicVersion() {
        this.header[257] = 117;
        this.header[258] = 115;
        this.header[259] = 116;
        this.header[260] = 97;
        this.header[261] = 114;
        this.header[262] = 0;
        this.header[263] = 48;
        this.header[264] = 48;
    }

    private void writeSize(long size, int offset) {
        if (size > 0x1FFFFFFFFL) {
            this.writeBase256(size, offset, 12);
        } else {
            this.writeLongSpace(size, offset, 12);
        }
    }

    private void writePosixName(String posixName, boolean isDirectory) {
        String name = posixName;
        byte[] bytes = name.getBytes();
        if (bytes.length <= 99) {
            this.writeStringV7(bytes, 0, 100);
            this.writeStringPosix("", 345, 155);
        } else {
            String prefix;
            int maxLength;
            boolean addSlash;
            if (name.charAt(name.length() - 1) == '/') {
                addSlash = true;
                name = name.substring(0, name.length() - 1);
                maxLength = 98;
            } else {
                maxLength = isDirectory ? 98 : 99;
                addSlash = isDirectory;
            }
            String suffix = this.getSuffix(name, maxLength);
            int firstIndex = name.length() - suffix.length() - 1;
            int dirSep = name.indexOf(47, firstIndex);
            if (dirSep == -1) {
                dirSep = name.lastIndexOf(47);
            }
            if (dirSep == -1) {
                suffix = this.getPrefix(name, maxLength);
                prefix = "";
            } else {
                suffix = name.substring(dirSep + 1);
                prefix = this.getSuffix(name.substring(0, dirSep), 155);
            }
            if (addSlash) {
                suffix = String.valueOf(suffix) + "/";
            }
            this.writeStringV7(suffix, 0, 100);
            this.writeStringPosix(prefix, 345, 155);
        }
    }

    private void writeStringV7(String s, int offset, int maxLength) {
        this.writeStringV7(this.getPrefix(s, maxLength - 1).getBytes(), offset, maxLength);
    }

    private void writeStringSuffixV7(String s, int offset, int maxLength) {
        this.writeStringV7(this.getSuffix(s, maxLength - 1).getBytes(), offset, maxLength);
    }

    private void writeStringPosix(String s, int offset, int maxLength) {
        this.writeStringPosix(this.getPrefix(s, maxLength).getBytes(), offset, maxLength);
    }

    private void writeStringV7(byte[] data, int offset, int maxLength) {
        if (data.length < maxLength - 1) {
            System.arraycopy(data, 0, this.header, offset, data.length);
            System.arraycopy(emptyBuffer, 0, this.header, offset + data.length, maxLength - data.length);
        } else {
            System.arraycopy(data, 0, this.header, offset, maxLength - 1);
            this.header[offset + maxLength - 1] = 0;
        }
    }

    private void writeStringPosix(byte[] data, int offset, int maxLength) {
        if (data.length < maxLength) {
            System.arraycopy(data, 0, this.header, offset, data.length);
            System.arraycopy(emptyBuffer, 0, this.header, offset + data.length, maxLength - data.length);
        } else {
            System.arraycopy(data, 0, this.header, offset, maxLength);
        }
    }

    private String getPrefix(String s, int length) {
        if (length < 0) {
            throw new IllegalArgumentException();
        }
        int sLength = Math.min(length, s.length());
        int byteLength = s.substring(0, sLength).getBytes().length;
        if (byteLength > length) {
            while (s.substring(0, --sLength).getBytes().length > length) {
            }
        } else if (byteLength < length && sLength < s.length()) {
            while ((byteLength = s.substring(0, ++sLength).getBytes().length) < length && sLength < s.length()) {
            }
            if (byteLength > length) {
                --sLength;
            }
        }
        return s.substring(0, sLength);
    }

    private String getSuffix(String s, int length) {
        if (length < 0) {
            throw new IllegalArgumentException();
        }
        int start = Math.max(0, s.length() - length);
        int byteLength = s.substring(start).getBytes().length;
        if (byteLength > length) {
            while (s.substring(++start).getBytes().length > length) {
            }
        } else if (byteLength < length && start > 0) {
            while ((byteLength = s.substring(--start).getBytes().length) < length && start > 0) {
            }
            if (byteLength > length) {
                ++start;
            }
        }
        return s.substring(start);
    }

    private void writeLongSpaceNull(long value, int offset, int maxLength) {
        this.header[offset + maxLength - 2] = 32;
        this.header[offset + maxLength - 1] = 0;
        this.writeLong(value, offset, maxLength - 2);
    }

    private void writeLongSpace(long value, int offset, int maxLength) {
        this.header[offset + maxLength - 1] = 32;
        this.writeLong(value, offset, maxLength - 1);
    }

    private void writeLongNullSpace(long value, int offset, int maxLength) {
        this.header[offset + maxLength - 2] = 0;
        this.header[offset + maxLength - 1] = 32;
        this.writeLong(value, offset, maxLength - 2);
    }

    private void writeLongNull(long value, int offset, int maxLength) {
        this.header[offset + maxLength - 1] = 0;
        this.writeLong(value, offset, maxLength - 1);
    }

    private void writeLong(long longValue, int offset, int maxLength) {
        long value = longValue;
        int i = offset + maxLength - 1;
        while (i >= offset) {
            this.header[i] = (byte)(48L + (value & 7L));
            value >>= 3;
            --i;
        }
    }

    private void writeBase256(long baseValue, int offset, int maxLength) {
        long value = baseValue;
        int i = offset + maxLength - 1;
        while (i > offset) {
            this.header[i] = (byte)(value & 0xFFL);
            value >>= 8;
            --i;
        }
        if (maxLength > 0) {
            this.header[offset] = (byte)(0x80L | value & 0xFFL);
        }
    }

    public void closeEntry() throws IOException {
        if (this.nextEntryToWrite != null) {
            if (this.file == null) {
                this.writeDelayedEntryTmp();
            } else {
                this.writeDelayedEntryDirect();
            }
        }
        if (this.bytesWritten != this.contentLength) {
            String msg = NLS.bind(Messages.getServerString("TarOutputStream.BytesWrittenMismatch"), this.contentLength, this.bytesWritten);
            throw new IOException(msg);
        }
        if (this.contentLength % 512L != 0L) {
            this.out.write(emptyBuffer, 0, (int)(512L - this.contentLength % 512L));
        }
        this.contentLength = 0L;
        this.bytesWritten = 0L;
        this.nextEntryToWrite = null;
    }

    private void writeDelayedEntryTmp() throws IOException {
        TarEntry entry = this.nextEntryToWrite;
        this.nextEntryToWrite = null;
        entry.setSize(this.bytesWritten);
        this.bytesWritten = 0L;
        this.tempOut.close();
        this.tempOut = null;
        this.putNextEntry(entry);
        UnsynchronizedBufferedInputStream in = new UnsynchronizedBufferedInputStream(new FileInputStream(this.tempFile));
        try {
            int bytesRead;
            byte[] buf = new byte[8192];
            while ((bytesRead = ((InputStream)in).read(buf)) != -1) {
                this.write(buf, 0, bytesRead);
            }
        }
        finally {
            ((InputStream)in).close();
        }
        if (!this.tempFile.delete()) {
            throw new IOException(NLS.bind(Messages.getServerString("TarOutputStream.FailedToDelete"), this.tempFile));
        }
        this.tempFile = null;
    }

    private void writeDelayedEntryDirect() throws IOException {
        TarEntry entry = this.nextEntryToWrite;
        this.nextEntryToWrite = null;
        entry.setSize(this.bytesWritten);
        this.flush();
        this.file.seek(entry.getOffset());
        if (this.usePosix) {
            this.writePosixHeader(entry);
        } else {
            this.writeGnuHeader(entry);
        }
        this.flush();
        this.file.seek(entry.getOffset() + entry.getSize() + 512L);
        this.contentLength = this.bytesWritten = entry.getSize();
    }

    public void finish() throws IOException {
        if (!this.finished) {
            this.closeEntry();
            this.out.write(emptyBuffer);
            this.finished = true;
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.nextEntryToWrite != null) {
            if (this.file == null) {
                this.tempOut.write(b, off, len);
            } else {
                this.out.write(b, off, len);
            }
            this.bytesWritten += (long)len;
            return;
        }
        if (this.contentLength == 0L) {
            throw new IOException(Messages.getServerString("TarOutputStream.ErrorNoEntryContext"));
        }
        if (this.bytesWritten + (long)len > this.contentLength) {
            throw new IOException(Messages.getServerString("TarOutputStream.ErrorWriteExceedsSpecification"));
        }
        try {
            this.out.write(b, off, len);
        }
        catch (InterruptedIOException e) {
            this.bytesWritten += (long)e.bytesTransferred;
            throw e;
        }
        this.bytesWritten += (long)len;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.nextEntryToWrite != null) {
            if (this.file == null) {
                this.tempOut.write(b);
            } else {
                super.write(b);
            }
            ++this.bytesWritten;
            return;
        }
        if (this.contentLength == 0L) {
            throw new IOException(Messages.getServerString("TarOutputStream.ErrorNoEntryContext"));
        }
        if (this.bytesWritten + 1L > this.contentLength) {
            throw new IOException(Messages.getServerString("TarOutputStream.ErrorWriteExceedsSpecification"));
        }
        try {
            super.write(b);
        }
        catch (InterruptedIOException e) {
            this.bytesWritten += (long)e.bytesTransferred;
            throw e;
        }
        ++this.bytesWritten;
    }

    @Override
    public void close() throws IOException {
        try {
            this.finish();
        }
        catch (Throwable throwable) {
            block41: {
                try {
                    this.out.close();
                }
                catch (Throwable throwable2) {
                    block39: {
                        try {
                            try {
                                if (this.tempOut != null) {
                                    this.tempOut.close();
                                    this.tempOut = null;
                                }
                            }
                            catch (IOException iOException) {
                                if (this.tempFile != null && this.tempFile.delete()) {
                                    this.tempFile = null;
                                }
                                break block39;
                            }
                        }
                        catch (Throwable throwable3) {
                            if (this.tempFile != null && this.tempFile.delete()) {
                                this.tempFile = null;
                            }
                            throw throwable3;
                        }
                        if (this.tempFile != null && this.tempFile.delete()) {
                            this.tempFile = null;
                        }
                    }
                    throw throwable2;
                }
                try {
                    try {
                        if (this.tempOut != null) {
                            this.tempOut.close();
                            this.tempOut = null;
                        }
                    }
                    catch (IOException iOException) {
                        if (this.tempFile != null && this.tempFile.delete()) {
                            this.tempFile = null;
                        }
                        break block41;
                    }
                }
                catch (Throwable throwable4) {
                    if (this.tempFile != null && this.tempFile.delete()) {
                        this.tempFile = null;
                    }
                    throw throwable4;
                }
                if (this.tempFile != null && this.tempFile.delete()) {
                    this.tempFile = null;
                }
            }
            throw throwable;
        }
        try {
            this.out.close();
        }
        catch (Throwable throwable) {
            block43: {
                try {
                    try {
                        if (this.tempOut != null) {
                            this.tempOut.close();
                            this.tempOut = null;
                        }
                    }
                    catch (IOException iOException) {
                        if (this.tempFile != null && this.tempFile.delete()) {
                            this.tempFile = null;
                        }
                        break block43;
                    }
                }
                catch (Throwable throwable5) {
                    if (this.tempFile != null && this.tempFile.delete()) {
                        this.tempFile = null;
                    }
                    throw throwable5;
                }
                if (this.tempFile != null && this.tempFile.delete()) {
                    this.tempFile = null;
                }
            }
            throw throwable;
        }
        try {
            try {
                if (this.tempOut != null) {
                    this.tempOut.close();
                    this.tempOut = null;
                }
            }
            catch (IOException iOException) {
                if (this.tempFile != null && this.tempFile.delete()) {
                    this.tempFile = null;
                }
            }
        }
        finally {
            if (this.tempFile != null && this.tempFile.delete()) {
                this.tempFile = null;
            }
        }
    }

    private static class NonClosingOutputStream
    extends UnsynchronizedBufferedOutputStream {
        private boolean skipClose;

        public NonClosingOutputStream(OutputStream out) {
            super(out);
        }

        public void setSkipClose(boolean skipClose) {
            this.skipClose = skipClose;
        }

        public void close() throws IOException {
            if (!this.skipClose) {
                super.close();
            }
        }
    }

    public static interface OutputFilterProvider {
        public OutputStream getOutputFilter(OutputStream var1) throws IOException;
    }

    private static class RandomAccessFileOutputStream
    extends OutputStream {
        private final RandomAccessFile file;
        boolean skipClose;

        public RandomAccessFileOutputStream(RandomAccessFile file) {
            this.file = file;
        }

        public void write(int b) throws IOException {
            this.file.write(b);
        }

        public void close() throws IOException {
            if (!this.skipClose) {
                this.file.close();
            }
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.file.write(b, off, len);
        }

        public RandomAccessFile getFile() {
            return this.file;
        }

        public void setSkipClose(boolean skipClose) {
            this.skipClose = skipClose;
        }
    }
}

