/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.internal.content.util;

import com.ibm.team.repository.common.internal.content.util.FileChannelUtil;
import com.ibm.team.repository.common.internal.content.util.RAFWrapper;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.repository.common.utils.UnsynchronizedByteArrayInputStream;
import com.ibm.team.repository.common.utils.UnsynchronizedByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class NextFitHeap {
    private static final String INVALID_LOCATION_PASSED_TO_FREE = "Invalid location passed to free(): {0}";
    private static final String THE_HEAP_IS_CORRUPT = "The heap is corrupt";
    protected static final int BLOCK_HEADER_SIZE = 16;
    protected static final int NEXT_FREE_BLOCK_OFFSET = 8;
    protected static final int MIN_BLOCK_SIZE = 32;
    protected RAFWrapper raf;
    protected long firstFreeBlock;
    protected long nextSearchBlock;
    protected long predNextSearchBlock;
    protected long workingAreaSize;
    protected long walkLengths;
    private final UnsynchronizedByteArrayOutputStream headerOut = new UnsynchronizedByteArrayOutputStream(16);
    private final DataOutputStream headerDataOut = new DataOutputStream(this.headerOut);
    private final byte[] headerBuf = new byte[16];
    private final UnsynchronizedByteArrayInputStream headerIn = new UnsynchronizedByteArrayInputStream(this.headerBuf);
    private final DataInputStream headerDataIn = new DataInputStream(this.headerIn);

    protected NextFitHeap() {
        this.clear();
    }

    public void clear() {
        this.firstFreeBlock = -1L;
        this.nextSearchBlock = -1L;
        this.predNextSearchBlock = -1L;
        this.workingAreaSize = 0L;
    }

    public long allocate(long paramSize) throws IOException {
        long loc;
        long size = paramSize;
        if (size < 0L) {
            throw new IllegalArgumentException("Invalid size: " + size);
        }
        if (size < 32L) {
            size = 32L;
        }
        if ((loc = this.firstFreeBlock == -1L ? this.allocateAtEnd(size) : this.nextFit(size)) + size > this.workingAreaSize) {
            this.workingAreaSize = loc + size;
        }
        return loc;
    }

    protected long allocateAtEnd(long size) throws IOException {
        long offset = this.workingAreaSize;
        this.writeLongAt(offset, size);
        return offset + 16L;
    }

    protected long nextFit(long size) throws IOException {
        if (this.nextSearchBlock == -1L) {
            this.nextSearchBlock = this.firstFreeBlock;
            this.predNextSearchBlock = -1L;
        }
        long currentPos = this.nextSearchBlock;
        long prevPos = this.predNextSearchBlock;
        do {
            BlockHeader header;
            if ((header = this.readBlockHeader(currentPos)).getBlockSize() + currentPos + 16L > this.workingAreaSize) {
                throw new IllegalStateException(THE_HEAP_IS_CORRUPT);
            }
            if (header.getNextFreeBlock() != -1L && currentPos + 16L + header.getBlockSize() >= header.getNextFreeBlock()) {
                throw new IllegalStateException(THE_HEAP_IS_CORRUPT);
            }
            long blockSize = header.getBlockSize();
            if (header.getBlockSize() + currentPos + 16L == this.workingAreaSize) {
                blockSize = Long.MAX_VALUE;
            }
            if (blockSize >= size) {
                long allocatedAt = this.allocateAt(currentPos, prevPos, header.getNextFreeBlock(), blockSize, size);
                this.nextSearchBlock = header.getNextFreeBlock();
                this.predNextSearchBlock = allocatedAt != currentPos + 16L ? currentPos : prevPos;
                return allocatedAt;
            }
            prevPos = currentPos;
            currentPos = header.getNextFreeBlock();
            if (currentPos != -1L) continue;
            currentPos = this.firstFreeBlock;
            prevPos = -1L;
        } while (currentPos != this.nextSearchBlock);
        return this.allocateAtEnd(size);
    }

    protected long allocateAt(long position, long freePredecessor, long freeSuccessor, long paramBlockSize, long size) throws IOException {
        long blockSize = paramBlockSize;
        if (blockSize == Long.MAX_VALUE) {
            blockSize = size;
            this.writeLongAt(position, blockSize);
        } else if (size + 16L + 32L <= blockSize) {
            long newSize = blockSize - size - 16L;
            this.writeLongAt(position, newSize);
            this.writeLongAt(position + 16L + newSize, size);
            return position + 16L + newSize + 16L;
        }
        if (freePredecessor == -1L) {
            this.firstFreeBlock = freeSuccessor;
        } else {
            this.writeLongAt(freePredecessor + 8L, freeSuccessor);
        }
        return position + 16L;
    }

    protected void writeLongAt(long position, long value) throws IOException {
        this.headerDataOut.writeLong(value);
        this.headerDataOut.flush();
        this.writeFully(this.headerOut.toByteArray(), position);
        this.headerOut.reset();
    }

    protected long readLongAt(long position) throws IOException {
        this.readFully(this.headerBuf, 0, 8, position);
        long value = this.headerDataIn.readLong();
        this.headerDataIn.reset();
        return value;
    }

    protected void writeFreeBlock(long position, long size, long nextFree) throws IOException {
        this.headerDataOut.writeLong(size);
        this.headerDataOut.writeLong(nextFree);
        this.headerDataOut.flush();
        this.writeFully(this.headerOut.toByteArray(), position);
        this.headerOut.reset();
    }

    protected BlockHeader readBlockHeader(long position) throws IOException {
        this.readFully(this.headerBuf, position);
        long blockSize = this.headerDataIn.readLong();
        long nextFree = this.headerDataIn.readLong();
        this.headerDataIn.reset();
        return new BlockHeader(blockSize, nextFree);
    }

    protected void readFully(byte[] buf, long position) throws IOException {
        this.readFully(buf, 0, buf.length, position);
    }

    protected void readFully(byte[] buf, int off, int len, long position) throws IOException {
        FileChannelUtil.readFully(buf, off, len, position, this.raf, false);
    }

    protected void writeFully(byte[] buf, long position) throws IOException {
        this.writeFully(buf, 0, buf.length, position);
    }

    protected void writeFully(byte[] buf, int off, int len, long position) throws IOException {
        FileChannelUtil.writeFully(buf, off, len, position, this.raf, false);
    }

    protected void finalize() throws Throwable {
        if (this.raf != null) {
            try {
                this.raf.getFile().close();
            }
            catch (IOException iOException) {}
        }
        super.finalize();
    }

    public void free(long paramOffset) throws IOException {
        boolean coalescedWithSucc;
        long nextFreeBlock;
        boolean coalescedWithPred;
        long blockSize;
        long offset = paramOffset;
        if (offset < 16L || offset - 16L < 16L && offset != 16L) {
            throw new IllegalArgumentException(NLS.bind(INVALID_LOCATION_PASSED_TO_FREE, offset));
        }
        if ((offset -= 16L) + (blockSize = this.readLongAt(offset)) + 16L > this.workingAreaSize) {
            throw new IllegalArgumentException(NLS.bind(INVALID_LOCATION_PASSED_TO_FREE, offset));
        }
        long prePredecessor = -1L;
        long predecessor = -1L;
        long predecessorSize = -1L;
        long successor = this.firstFreeBlock;
        while (successor != -1L && successor < offset) {
            ++this.walkLengths;
            BlockHeader header = this.readBlockHeader(successor);
            if (successor + header.getBlockSize() + 16L > this.workingAreaSize) {
                throw new IllegalStateException(THE_HEAP_IS_CORRUPT);
            }
            if (header.getNextFreeBlock() != -1L && header.getNextFreeBlock() <= successor + 16L + header.getBlockSize()) {
                throw new IllegalStateException(THE_HEAP_IS_CORRUPT);
            }
            prePredecessor = predecessor;
            predecessor = successor;
            predecessorSize = header.getBlockSize();
            successor = header.getNextFreeBlock();
        }
        if (predecessor != -1L && predecessor + predecessorSize + 16L > offset) {
            throw new IllegalStateException(THE_HEAP_IS_CORRUPT);
        }
        if (successor != -1L && successor < offset + 16L + blockSize) {
            throw new IllegalStateException("Error: Likely double free() attempt?");
        }
        if (predecessor + predecessorSize + 16L == offset) {
            offset = predecessor;
            blockSize += predecessorSize + 16L;
            coalescedWithPred = true;
        } else {
            coalescedWithPred = false;
        }
        if (successor == offset + blockSize + 16L) {
            BlockHeader header = this.readBlockHeader(successor);
            if (successor + header.getBlockSize() + 16L > this.workingAreaSize) {
                throw new IllegalStateException(THE_HEAP_IS_CORRUPT);
            }
            if (header.getNextFreeBlock() != -1L && header.getNextFreeBlock() <= successor + header.getBlockSize() + 16L) {
                throw new IllegalStateException(THE_HEAP_IS_CORRUPT);
            }
            blockSize += header.getBlockSize() + 16L;
            nextFreeBlock = header.getNextFreeBlock();
            coalescedWithSucc = true;
        } else {
            nextFreeBlock = successor;
            coalescedWithSucc = false;
        }
        if (offset + blockSize + 16L == this.workingAreaSize) {
            if (coalescedWithPred) {
                if (prePredecessor == -1L) {
                    this.firstFreeBlock = -1L;
                } else {
                    this.writeLongAt(prePredecessor + 8L, -1L);
                }
            } else if (coalescedWithSucc) {
                if (predecessor == -1L) {
                    this.firstFreeBlock = -1L;
                } else {
                    this.writeLongAt(predecessor + 8L, -1L);
                }
            }
            this.workingAreaSize = offset;
            if (this.nextSearchBlock >= offset) {
                this.nextSearchBlock = -1L;
            }
        } else {
            if (coalescedWithPred) {
                if (!coalescedWithSucc) {
                    this.writeLongAt(offset, blockSize);
                } else {
                    this.writeFreeBlock(offset, blockSize, nextFreeBlock);
                }
            } else if (coalescedWithSucc) {
                this.writeFreeBlock(offset, blockSize, nextFreeBlock);
            } else {
                this.writeLongAt(offset + 8L, nextFreeBlock);
            }
            if (!coalescedWithPred) {
                if (predecessor == -1L) {
                    this.firstFreeBlock = offset;
                } else {
                    this.writeLongAt(predecessor + 8L, offset);
                }
            }
            if (this.nextSearchBlock >= offset && this.nextSearchBlock < offset + 16L + blockSize) {
                this.nextSearchBlock = offset;
                if (this.predNextSearchBlock == offset) {
                    this.predNextSearchBlock = prePredecessor;
                }
            } else if (this.predNextSearchBlock >= offset && this.predNextSearchBlock < offset + 16L + blockSize) {
                this.predNextSearchBlock = offset;
            }
        }
    }

    public InputStream getInputStream(long offset) {
        return new FileHeapInputStream(offset);
    }

    public OutputStream getOutputStream(long offset) {
        return new FileHeapOutputStream(offset);
    }

    protected static class BlockHeader {
        private final long blockSize;
        private final long nextFreeBlock;

        public BlockHeader(long blockSize, long nextFree) {
            this.blockSize = blockSize;
            this.nextFreeBlock = nextFree;
        }

        public long getBlockSize() {
            return this.blockSize;
        }

        public long getNextFreeBlock() {
            return this.nextFreeBlock;
        }
    }

    protected class FileHeapInputStream
    extends InputStream {
        protected ByteBuffer ONE_BYTE_BUF;
        protected long readOffset;

        public FileHeapInputStream(long offset) {
            this.readOffset = offset;
        }

        public int read() throws IOException {
            int bytesRead;
            if (this.ONE_BYTE_BUF == null) {
                this.ONE_BYTE_BUF = ByteBuffer.allocate(1);
            } else {
                this.ONE_BYTE_BUF.rewind();
            }
            try {
                while ((bytesRead = FileChannelUtil.readUninterrupted(this.ONE_BYTE_BUF, this.readOffset, NextFitHeap.this.raf)) == 0) {
                }
            }
            finally {
                this.readOffset += (long)this.ONE_BYTE_BUF.position();
            }
            if (bytesRead == -1) {
                return -1;
            }
            return this.ONE_BYTE_BUF.get(0) & 0xFF;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || len < 0 || off + len > b.length) {
                throw new ArrayIndexOutOfBoundsException();
            }
            ByteBuffer buf = ByteBuffer.wrap(b, off, len);
            try {
                int n = FileChannelUtil.readUninterrupted(buf, this.readOffset, NextFitHeap.this.raf);
                return n;
            }
            finally {
                this.readOffset += (long)(buf.position() - off);
            }
        }

        public long skip(long n) throws IOException {
            n = Math.min(n, FileChannelUtil.getLengthUninterrupted(NextFitHeap.this.raf) - this.readOffset);
            this.readOffset += n;
            return n;
        }
    }

    protected class FileHeapOutputStream
    extends OutputStream {
        protected final byte[] ONE_BYTE_BUF = new byte[1];
        protected long writeOffset;

        public FileHeapOutputStream(long offset) {
            this.writeOffset = offset;
        }

        public void write(int b) throws IOException {
            this.ONE_BYTE_BUF[0] = (byte)b;
            try {
                NextFitHeap.this.writeFully(this.ONE_BYTE_BUF, this.writeOffset);
                ++this.writeOffset;
            }
            catch (InterruptedIOException e) {
                this.writeOffset += (long)e.bytesTransferred;
                throw e;
            }
        }

        public void write(byte[] b, int off, int len) throws IOException {
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || len < 0 || off + len > b.length) {
                throw new ArrayIndexOutOfBoundsException();
            }
            try {
                NextFitHeap.this.writeFully(b, off, len, this.writeOffset);
                this.writeOffset += (long)len;
            }
            catch (InterruptedIOException e) {
                this.writeOffset += (long)e.bytesTransferred;
                throw e;
            }
        }
    }
}

