/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.links.common.internal.registry;

import com.ibm.team.links.common.internal.registry.EndPointDescriptor;
import com.ibm.team.links.common.internal.registry.LinkTypeEntry;
import com.ibm.team.links.common.registry.ILinkType;
import com.ibm.team.links.common.registry.ILinkTypeRegistry;
import com.ibm.team.repository.common.FileLocator;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.IItemType$IRegistry;
import com.ibm.team.repository.common.LogFactory;
import com.ibm.team.repository.common.util.NLS;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.RegistryFactory;

public class LinkTypeRegistry
implements ILinkTypeRegistry {
    public static final LinkTypeRegistry INSTANCE = new LinkTypeRegistry();

    private static ILinkTypeRegistry getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public Collection allEntries() {
        Collection result = LinkTypeRegistry.getInstance().allEntries();
        return result;
    }

    public ILinkType getLinkType(String linkTypeId) throws IllegalArgumentException {
        ILinkType result = LinkTypeRegistry.getInstance().getLinkType(linkTypeId);
        return result;
    }

    public boolean isRegistered(String linkTypeId) {
        boolean result = LinkTypeRegistry.getInstance().isRegistered(linkTypeId);
        return result;
    }

    private static class Impl
    implements ILinkTypeRegistry {
        private static final String INVALID_ICON_URL = "Invalid icon URL: \"{0}\"";
        private static final String PLATFORM_PLUGIN_URL_PREFIX = "platform:/plugin/";
        private static final String TARGET = "target";
        private static final String SOURCE = "source";
        private static final String UNREGISTERED_LINK_TYPE = "Unregistered link type: \"{0}\"";
        private static final String BUNDLE_ID = "com.ibm.team.repository.common";
        private static final String EXTENSIONPOINT_ID = "linkTypes";
        private static final String LINK_TYPE_ID_ATTR = "id";
        private static final String LINK_TYPE_COMPONENT_ID_ATTR = "componentId";
        private static final String LINK_TYPE_CONSTRAINED_ATTR = "constrained";
        private static final String LINK_TYPE_INTERNAL_ATTR = "internal";
        private static final String ENDPOINT_ELEM = "endpoint";
        private static final String ID_ATTR = "id";
        private static final String ICON_ATTR = "icon";
        private static final String MULTIPLICITY_ATTR = "multiplicity";
        private static final String ITEM_REFERENCE_TYPE_ELEM = "itemReferenceType";
        private static final String ITEM_TYPE_NAME_ATTR = "itemTypeName";
        private static final String PACKAGE_URI_ATTR = "packageURI";
        private static Log log;
        private Map entryMap = new HashMap();

        private Impl() {
            this.readRegistry();
        }

        public boolean isRegistered(String linkTypeId) {
            return this.entryMap.containsKey(linkTypeId);
        }

        public ILinkType getLinkType(String linkTypeId) throws IllegalArgumentException {
            ILinkType result = (ILinkType)this.entryMap.get(linkTypeId);
            if (result == null) {
                throw new IllegalArgumentException(NLS.bind(UNREGISTERED_LINK_TYPE, linkTypeId));
            }
            return result;
        }

        public Collection allEntries() {
            if (this.entryMap == null) {
                return Collections.EMPTY_LIST;
            }
            return this.entryMap.values();
        }

        private void readRegistry() {
            IExtensionRegistry useRegistry = RegistryFactory.getRegistry();
            if (useRegistry == null) {
                return;
            }
            IExtensionPoint point = useRegistry.getExtensionPoint(BUNDLE_ID, EXTENSIONPOINT_ID);
            if (point == null) {
                return;
            }
            IConfigurationElement[] elements = point.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                this.readElement(elements[i]);
                ++i;
            }
        }

        private void readElement(IConfigurationElement element) {
            String linkTypeId = element.getAttribute("id");
            String componentId = element.getAttribute(LINK_TYPE_COMPONENT_ID_ATTR);
            if (componentId != null && (componentId = componentId.trim()).length() == 0) {
                componentId = null;
            }
            String constrainedAttr = element.getAttribute(LINK_TYPE_CONSTRAINED_ATTR);
            boolean constrained = !Boolean.FALSE.toString().equals(constrainedAttr);
            String internalAttr = element.getAttribute(LINK_TYPE_INTERNAL_ATTR);
            boolean internal = Boolean.TRUE.toString().equals(internalAttr);
            boolean sourceSide = true;
            EndPointDescriptor sourceEndPoint = this.createEndPointDescriptor(element, linkTypeId, sourceSide);
            EndPointDescriptor targetEndPoint = this.createEndPointDescriptor(element, linkTypeId, !sourceSide);
            if (sourceEndPoint == null && targetEndPoint == null) {
                sourceEndPoint = this.defaultEndPointDescriptor(linkTypeId, sourceSide);
                targetEndPoint = this.defaultEndPointDescriptor(linkTypeId, !sourceSide);
            } else if (sourceEndPoint == null) {
                sourceEndPoint = targetEndPoint.createOtherEndPointDescriptor();
            } else if (targetEndPoint == null) {
                targetEndPoint = sourceEndPoint.createOtherEndPointDescriptor();
            }
            if (!this.isReferenceTypeValid(sourceEndPoint, linkTypeId)) {
                this.logInvalidSourceEndpoint(linkTypeId, sourceEndPoint);
                return;
            }
            if (!this.isReferenceTypeValid(targetEndPoint, linkTypeId)) {
                this.logInvalidTargetEndpoint(linkTypeId, sourceEndPoint);
                return;
            }
            LinkTypeEntry linkType = new LinkTypeEntry(linkTypeId, componentId, constrained, internal, sourceEndPoint, targetEndPoint);
            try {
                this.register(linkType);
            }
            catch (IllegalArgumentException e) {
                Impl.getLogger().error((Object)e.getMessage());
            }
        }

        private void logInvalidTargetEndpoint(String linkTypeId, EndPointDescriptor sourceEndPoint) {
            String msg = String.valueOf(linkTypeId) + " has an invalid item type in target endpoint " + sourceEndPoint.getDisplayName() + "; link will not be registered";
            Impl.getLogger().error((Object)msg);
        }

        private void logInvalidSourceEndpoint(String linkTypeId, EndPointDescriptor sourceEndPoint) {
            String msg = String.valueOf(linkTypeId) + " has an invalid item type in source endpoint " + sourceEndPoint.getDisplayName() + "; link will not be registered";
            Impl.getLogger().error((Object)msg);
        }

        private boolean isReferenceTypeValid(EndPointDescriptor endPoint, String linkTypeId) {
            return !endPoint.isItemReference() || endPoint.getReferencedItemType() != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void register(LinkTypeEntry linkType) {
            if (linkType == null) {
                return;
            }
            String key = linkType.getLinkTypeId();
            Map map = this.entryMap;
            synchronized (map) {
                LinkTypeEntry existing = (LinkTypeEntry)this.entryMap.get(key);
                if (existing == null) {
                    this.entryMap.put(key, linkType);
                } else {
                    String msg = "linkTypes extension-point: A link type registry entry with id " + key + " already exists: " + existing + ". Keeping the existing link type and ignoring the following link type:" + linkType;
                    Impl.getLogger().error((Object)msg);
                }
            }
        }

        private EndPointDescriptor createEndPointDescriptor(IConfigurationElement element, String linkTypeId, boolean isSource) {
            IConfigurationElement endpointElement = this.readEndPoint(element, isSource ? SOURCE : TARGET);
            if (endpointElement == null) {
                return null;
            }
            String id = Impl.getAttribute("id", endpointElement);
            URL icon = this.createIconURL(endpointElement, ICON_ATTR);
            String multiplicity = endpointElement.getAttribute(MULTIPLICITY_ATTR);
            IConfigurationElement itemRefType = null;
            IConfigurationElement[] itemRefTypes = endpointElement.getChildren(ITEM_REFERENCE_TYPE_ELEM);
            if (itemRefTypes != null && itemRefTypes.length > 0) {
                itemRefType = itemRefTypes[0];
                if (itemRefTypes.length > 1) {
                    String msg = "linkTypes extension-point:  There can be only one itemReferenceType element in " + element.getDeclaringExtension().getNamespaceIdentifier() + '/' + ENDPOINT_ELEM + " in registry. Using the first one, ignoring others";
                    Impl.getLogger().error((Object)msg);
                }
            }
            boolean isItemReference = false;
            IItemType itemType = null;
            if (itemRefType != null) {
                String TypeId = itemRefType.getAttribute(ITEM_TYPE_NAME_ATTR);
                String packageURI = itemRefType.getAttribute(PACKAGE_URI_ATTR);
                itemType = IItemType$IRegistry.INSTANCE.getItemType(TypeId, packageURI);
                isItemReference = true;
            }
            EndPointDescriptor ep = new EndPointDescriptor(id, multiplicity, isSource, isItemReference, endpointElement, icon, itemType);
            return ep;
        }

        private IConfigurationElement readEndPoint(IConfigurationElement element, String sideName) {
            IConfigurationElement[] endpoints;
            IConfigurationElement[] sides = element.getChildren(sideName);
            if (sides == null || sides.length == 0) {
                return null;
            }
            IConfigurationElement side = sides[0];
            if (sides.length > 1) {
                String msg = "linkTypes extension-point:  There can be only one " + sideName + " element in " + element.getDeclaringExtension().getNamespaceIdentifier() + '/' + element.getAttribute("id") + " in registry. Using the first one, ignoring others";
                Impl.getLogger().error((Object)msg);
            }
            if ((endpoints = side.getChildren(ENDPOINT_ELEM)) == null || endpoints.length == 0) {
                return null;
            }
            IConfigurationElement endpoint = endpoints[0];
            if (endpoints.length > 1) {
                String msg = "linkTypes extension-point:  There can be only one endpoint element in " + element.getDeclaringExtension().getNamespaceIdentifier() + '/' + sideName + " in registry. Using the first one, ignoring others";
                Impl.getLogger().error((Object)msg);
            }
            return endpoint;
        }

        private EndPointDescriptor defaultEndPointDescriptor(String linkTypeId, boolean isSource) {
            String id = isSource ? SOURCE : TARGET;
            String displayName = String.valueOf(linkTypeId) + '/' + id;
            return new EndPointDescriptor(id, null, isSource, false, displayName, null, null);
        }

        private URL createPlatormURLWithFileLocator(String urlString) {
            if (!urlString.startsWith(PLATFORM_PLUGIN_URL_PREFIX)) {
                return null;
            }
            String platformStripped = urlString.substring(PLATFORM_PLUGIN_URL_PREFIX.length());
            int pluginEndIndex = platformStripped.indexOf(47);
            if (pluginEndIndex == -1) {
                return null;
            }
            String plugin = platformStripped.substring(0, pluginEndIndex);
            String file = platformStripped.substring(pluginEndIndex + 1);
            if (file.length() == 0) {
                return null;
            }
            return FileLocator.find(plugin, (IPath)new Path(file));
        }

        public URL createIconURL(IConfigurationElement element, String iconAttribute) {
            if (element == null || iconAttribute == null) {
                return null;
            }
            String icon = element.getAttribute(iconAttribute);
            if (icon == null) {
                return null;
            }
            if ((icon = icon.trim()).length() == 0) {
                return null;
            }
            if (icon.startsWith(PLATFORM_PLUGIN_URL_PREFIX)) {
                try {
                    URL url = new URL(icon);
                    return url;
                }
                catch (MalformedURLException e) {
                    URL url = this.createPlatormURLWithFileLocator(icon);
                    if (url == null) {
                        Impl.getLogger().error((Object)NLS.bind(INVALID_ICON_URL, icon), (Throwable)e);
                    }
                    return url;
                }
            }
            String bundleId = element.getDeclaringExtension().getNamespaceIdentifier();
            URL url = FileLocator.find(bundleId, (IPath)new Path(icon));
            if (url != null) {
                return url;
            }
            try {
                url = new URL(icon);
                return url;
            }
            catch (MalformedURLException e) {
                Impl.getLogger().error((Object)NLS.bind(INVALID_ICON_URL, icon), (Throwable)e);
                return null;
            }
        }

        private static String getAttribute(String name, IConfigurationElement element) {
            return element.getAttribute(name);
        }

        private static synchronized Log getLogger() {
            if (log == null) {
                log = LogFactory.getLog(BUNDLE_ID);
            }
            return log;
        }
    }

    private static class SingletonHolder {
        private static final ILinkTypeRegistry INSTANCE = new Impl();

        private SingletonHolder() {
        }
    }
}

