/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.links.common.internal.registry;

import com.ibm.team.links.common.internal.registry.LinkTypeEntry;
import com.ibm.team.links.common.registry.IEndPointDescriptor;
import com.ibm.team.links.common.registry.ILinkType;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.util.NLS;
import java.net.URL;
import org.eclipse.core.runtime.IConfigurationElement;

public class EndPointDescriptor
implements IEndPointDescriptor {
    private static final String INVALID_MULTIPLICITY = "Invalid multiplicity: \"{0}\"";
    private static final String ZERO_TO_MANY = "0..n";
    private static final String ZERO_TO_ONE = "0..1";
    private static final String DISPLAY_NAME_ATTR = "displayName";
    private LinkTypeEntry linkType;
    private String multiplicity;
    private boolean isSource;
    private boolean isItemReference;
    private IItemType referencedItemType;
    private String displayName;
    private IConfigurationElement element;
    private String id;
    private URL icon;

    EndPointDescriptor(String id, String multiplicity, boolean isSource, boolean isItemReference, IConfigurationElement element, URL icon, IItemType itemType) {
        this(id, multiplicity, isSource, isItemReference, null, element, icon, itemType);
    }

    EndPointDescriptor(String id, String multiplicity, boolean isSource, boolean isItemReference, String displayName, URL icon, IItemType itemType) {
        this(id, multiplicity, isSource, isItemReference, displayName, null, icon, itemType);
    }

    private EndPointDescriptor(String id, String multiplicity, boolean isSource, boolean isItemReference, String displayName, IConfigurationElement element, URL icon, IItemType itemType) {
        this.id = id;
        if (multiplicity == null || multiplicity.equals("")) {
            multiplicity = ZERO_TO_MANY;
        }
        if (!multiplicity.equals(ZERO_TO_MANY) && !multiplicity.equals(ZERO_TO_ONE)) {
            throw new IllegalArgumentException(NLS.bind(INVALID_MULTIPLICITY, multiplicity));
        }
        this.multiplicity = multiplicity;
        this.isSource = isSource;
        this.isItemReference = isItemReference;
        this.referencedItemType = itemType;
        this.displayName = displayName;
        this.element = element;
        this.icon = icon;
        if (this.displayName != null && this.element != null) {
            throw new IllegalArgumentException("Both displayName and element cannot be non-null");
        }
        if (this.displayName == null && this.element == null) {
            throw new IllegalArgumentException("Both displayName and element cannot be null");
        }
    }

    public EndPointDescriptor createOtherEndPointDescriptor() {
        if (this.element != null) {
            return new EndPointDescriptor(this.id, this.getMultiplicity(), !this.isSource, this.isItemReference, this.element, this.getIcon(), this.getReferencedItemType());
        }
        return new EndPointDescriptor(this.id, this.getMultiplicity(), !this.isSource, this.isItemReference, this.getDisplayName(), this.getIcon(), this.getReferencedItemType());
    }

    public EndPointDescriptor clone() {
        if (this.element != null) {
            return new EndPointDescriptor(this.id, this.getMultiplicity(), this.isSource, this.isItemReference, this.element, this.getIcon(), this.getReferencedItemType());
        }
        return new EndPointDescriptor(this.id, this.getMultiplicity(), this.isSource, this.isItemReference, this.getDisplayName(), this.getIcon(), this.getReferencedItemType());
    }

    public String getMultiplicity() {
        return this.multiplicity;
    }

    public ILinkType getLinkType() {
        return this.linkType;
    }

    public IItemType getReferencedItemType() {
        return this.referencedItemType;
    }

    public boolean isItemReference() {
        return this.isItemReference;
    }

    public boolean isMultiValued() {
        return this.multiplicity.equals(ZERO_TO_MANY);
    }

    public boolean isSingleValued() {
        return !this.isMultiValued();
    }

    public boolean isSource() {
        return this.isSource;
    }

    public boolean isTarget() {
        return !this.isSource();
    }

    public boolean checkReferencedItemType(IItemHandle item) {
        IItemType type = item.getItemType();
        try {
            if (this.getReferencedItemType().getName().equals(type.getName()) && this.getReferencedItemType().getNamespaceURI().equals(type.getNamespaceURI())) {
                return true;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    public void setLinkType(LinkTypeEntry linkType) {
        this.linkType = linkType;
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayName() {
        if (this.displayName != null) {
            return this.displayName;
        }
        String value = this.element.getAttribute(DISPLAY_NAME_ATTR);
        return value;
    }

    public URL getIcon() {
        return this.icon;
    }
}

