/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.ui.internal.util;

import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.operations.ICollision;
import com.ibm.team.filesystem.client.operations.ILoadLocation;
import com.ibm.team.filesystem.client.operations.IRemovedShare;
import com.ibm.team.filesystem.client.operations.IShareOutOfSync;
import com.ibm.team.filesystem.client.operations.IShareableToLoad;
import com.ibm.team.filesystem.client.operations.LoadDilemmaHandler;
import com.ibm.team.filesystem.rcp.ui.internal.ImagePool;
import com.ibm.team.filesystem.rcp.ui.internal.Messages;
import com.ibm.team.filesystem.rcp.ui.internal.util.CollisionListSelectionDialog;
import com.ibm.team.filesystem.rcp.ui.internal.util.DialogUtil;
import com.ibm.team.repository.rcp.ui.internal.utils.BaseLabelProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListDialog;
import org.eclipse.ui.model.IWorkbenchAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WarnLoadUser
extends LoadDilemmaHandler {
    protected Shell shell;
    protected String dialogTitle;

    public WarnLoadUser(IWorkbenchPart targetPart, String dialogTitle) {
        this(targetPart.getSite().getShell(), dialogTitle);
    }

    public WarnLoadUser(Shell shell, String dialogTitle) {
        this.shell = shell;
        this.dialogTitle = dialogTitle;
    }

    private static String toString(ILoadLocation location) {
        return NLS.bind((String)Messages.WarnLoadUser_3, (Object)location.getComponent().getName(), (Object)location.getShareName());
    }

    public int collision(Collection<ICollision> loadCollisions, Collection<IRemovedShare> sharesToRemove, Collection<IShareOutOfSync> sharesOutOfSync) {
        int result = 0;
        HashMap<IPath, IShareOutOfSync> sharesNeedingReload = new HashMap<IPath, IShareOutOfSync>();
        for (IShareOutOfSync shareOutOfSync : sharesOutOfSync) {
            sharesNeedingReload.put(shareOutOfSync.getShare().getPath(), shareOutOfSync);
        }
        if (loadCollisions.size() > 0) {
            result = this.promptForOverwrite(loadCollisions, this.collisionsToSelect(loadCollisions, sharesNeedingReload));
        }
        if (result == 0 && !sharesToRemove.isEmpty()) {
            result = this.promptForDeletion(sharesToRemove);
        }
        return result;
    }

    private List<ICollision> collisionsToSelect(Collection<ICollision> collisions, HashMap<IPath, IShareOutOfSync> sharesNeedingReload) {
        if (sharesNeedingReload == null || sharesNeedingReload.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ICollision> toSelect = new ArrayList<ICollision>(collisions.size());
        for (ICollision collision : collisions) {
            IShare share = collision.getShareable().getShare();
            if (share == null || !sharesNeedingReload.containsKey(share.getPath())) continue;
            toSelect.add(collision);
        }
        return toSelect;
    }

    public int newItemsToLoad(final Collection<IShareableToLoad> sharesToLoad) {
        final int[] result = new int[]{1};
        Display display = PlatformUI.getWorkbench().getDisplay();
        display.syncExec(new Runnable(){

            public void run() {
                Object[] toLoad = sharesToLoad.toArray(new IShareableToLoad[sharesToLoad.size()]);
                int i = 0;
                while (i < toLoad.length) {
                    toLoad[i].setWillLoad(false);
                    ++i;
                }
                Arrays.sort(toLoad, new Comparator(){

                    public int compare(Object o1, Object o2) {
                        String msg1 = ((IShareableToLoad)o1).getShareableLocalPath();
                        String msg2 = ((IShareableToLoad)o2).getShareableLocalPath();
                        return msg1.compareToIgnoreCase(msg2);
                    }
                });
                String msg = Messages.WarnLoadUser_4;
                CollisionListSelectionDialog dialog = new CollisionListSelectionDialog(DialogUtil.checkShell(WarnLoadUser.this.shell), toLoad, (IStructuredContentProvider)new ArrayContentProvider(), (ILabelProvider)new ShareableToLoadLabelProvider(), msg, false);
                dialog.setTitle(WarnLoadUser.this.dialogTitle);
                dialog.setInitialSelections(toLoad);
                if (dialog.open() == 0) {
                    Object[] toBeLoaded = dialog.getResult();
                    int i2 = 0;
                    while (i2 < toBeLoaded.length) {
                        IShareableToLoad shareableToLoad = (IShareableToLoad)toBeLoaded[i2];
                        shareableToLoad.setWillLoad(true);
                        ++i2;
                    }
                    result[0] = 0;
                }
            }
        });
        return result[0];
    }

    private int promptForOverwrite(final Collection<ICollision> loadCollisions, final List<ICollision> collisionsToSelect) {
        final int[] result = new int[]{1};
        Display display = PlatformUI.getWorkbench().getDisplay();
        display.syncExec(new Runnable(){

            public void run() {
                ICollision[] collisions = loadCollisions.toArray(new ICollision[loadCollisions.size()]);
                int i = 0;
                while (i < collisions.length) {
                    collisions[i].setLoadLocation(null);
                    ++i;
                }
                Arrays.sort(collisions, new Comparator(){

                    public int compare(Object o1, Object o2) {
                        String msg1 = ((ICollision)o1).getStatus().getMessage();
                        String msg2 = ((ICollision)o2).getStatus().getMessage();
                        return msg1.compareToIgnoreCase(msg2);
                    }
                });
                String msg = Messages.WarnLoadUser_5;
                CollisionListSelectionDialog dialog = new CollisionListSelectionDialog(DialogUtil.checkShell(WarnLoadUser.this.shell), collisions, (IStructuredContentProvider)new ArrayContentProvider(), (ILabelProvider)new CollisionLabelProvider(), msg, true);
                dialog.setTitle(WarnLoadUser.this.dialogTitle);
                dialog.setInitialElementSelections(collisionsToSelect);
                if (dialog.open() == 0) {
                    Object[] overwrite = dialog.getResult();
                    int i2 = 0;
                    while (i2 < overwrite.length) {
                        ICollision collision = (ICollision)overwrite[i2];
                        Object[] locations = collision.getLocations().toArray();
                        if (locations.length == 1) {
                            collision.setLoadLocation((ILoadLocation)locations[0]);
                        } else {
                            Object[] result2;
                            String itemName;
                            if (collision.getShareable() != null) {
                                IPath path = collision.getShareable().getLocalFullPath();
                                if (path != null) {
                                    path = path.makeRelative();
                                }
                                itemName = String.valueOf(path);
                            } else {
                                itemName = collision.getStatus().getMessage();
                            }
                            String msg2 = NLS.bind((String)Messages.WarnLoadUser_6, (Object)itemName);
                            Arrays.sort(locations, new Comparator(){

                                public int compare(Object o1, Object o2) {
                                    String str1 = WarnLoadUser.toString((ILoadLocation)o1);
                                    String str2 = WarnLoadUser.toString((ILoadLocation)o2);
                                    return str1.compareToIgnoreCase(str2);
                                }
                            });
                            ListDialog locationDialog = new ListDialog(DialogUtil.checkShell(WarnLoadUser.this.shell));
                            locationDialog.setTitle(WarnLoadUser.this.dialogTitle);
                            locationDialog.setMessage(msg2);
                            locationDialog.setAddCancelButton(true);
                            locationDialog.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
                            locationDialog.setLabelProvider((ILabelProvider)new LocationLabelProvider());
                            locationDialog.setInitialElementSelections(Collections.singletonList(locations[0]));
                            locationDialog.setInput((Object)locations);
                            if (locationDialog.open() == 0 && (result2 = locationDialog.getResult()).length > 0) {
                                collision.setLoadLocation((ILoadLocation)result2[0]);
                            }
                        }
                        ++i2;
                    }
                    result[0] = 0;
                }
            }
        });
        return result[0];
    }

    private int promptForDeletion(final Collection<IRemovedShare> sharesToRemove) {
        final int[] result = new int[]{1};
        Display display = PlatformUI.getWorkbench().getDisplay();
        display.syncExec(new Runnable(){

            public void run() {
                IRemovedShare[] toRemove = sharesToRemove.toArray(new IRemovedShare[sharesToRemove.size()]);
                int i = 0;
                while (i < toRemove.length) {
                    toRemove[i].isToBeDeleted(false);
                    ++i;
                }
                Arrays.sort(toRemove, new Comparator(){

                    public int compare(Object o1, Object o2) {
                        String msg1 = ((IRemovedShare)o1).getShareableLocalPath();
                        String msg2 = ((IRemovedShare)o2).getShareableLocalPath();
                        return msg1.compareToIgnoreCase(msg2);
                    }
                });
                String msg = Messages.WarnLoadUser_7;
                CollisionListSelectionDialog dialog = new CollisionListSelectionDialog(DialogUtil.checkShell(WarnLoadUser.this.shell), toRemove, (IStructuredContentProvider)new ArrayContentProvider(), (ILabelProvider)new RemoveShareLabelProvider(), msg, false);
                dialog.setTitle(WarnLoadUser.this.dialogTitle);
                if (dialog.open() == 0) {
                    Object[] toDelete = dialog.getResult();
                    int i2 = 0;
                    while (i2 < toDelete.length) {
                        IRemovedShare removedShare = (IRemovedShare)toDelete[i2];
                        removedShare.isToBeDeleted(true);
                        ++i2;
                    }
                    result[0] = 0;
                }
            }
        });
        return result[0];
    }

    private class CollisionLabelProvider
    extends BaseLabelProvider {
        private CollisionLabelProvider() {
        }

        public void updateLabel(ViewerLabel label, Object element) {
            if (element instanceof ICollision) {
                ICollision collision = (ICollision)element;
                label.setText(collision.getStatus().getMessage());
                ImageDescriptor desc = this.getImageDescriptor(collision);
                label.setImage(desc == null ? null : this.getResources().createImageWithDefault(desc));
            }
        }

        private ImageDescriptor getImageDescriptor(ICollision collision) {
            IWorkbenchAdapter wbAdapter;
            IResource resource = (IResource)collision.getShareable().getAdapter(IResource.class);
            if (resource != null && (wbAdapter = (IWorkbenchAdapter)resource.getAdapter(IWorkbenchAdapter.class)) != null) {
                return wbAdapter.getImageDescriptor((Object)resource);
            }
            return null;
        }
    }

    private class LocationLabelProvider
    extends BaseLabelProvider {
        private LocationLabelProvider() {
        }

        public void updateLabel(ViewerLabel label, Object element) {
            if (element instanceof ILoadLocation) {
                ILoadLocation location = (ILoadLocation)element;
                label.setText(WarnLoadUser.toString(location));
            }
        }
    }

    private class RemoveShareLabelProvider
    extends BaseLabelProvider {
        private RemoveShareLabelProvider() {
        }

        public void updateLabel(ViewerLabel label, Object element) {
            if (element instanceof IRemovedShare) {
                IRemovedShare removedShare = (IRemovedShare)element;
                String name = removedShare.getShareable().getLocalFullPath().makeRelative().toString();
                IShare share = removedShare.getShareable().getShare();
                if (share != null) {
                    ISharingDescriptor descriptor = share.getSharingDescriptor();
                    if (share != null) {
                        name = NLS.bind((String)Messages.WarnLoadUser_1, (Object[])new String[]{name, descriptor.getConnectionName(), descriptor.getComponentName()});
                    }
                }
                if (removedShare.getUncommittedChangeCount() > 0) {
                    name = NLS.bind((String)Messages.WarnLoadUser_2, (Object)name, (Object)removedShare.getUncommittedChangeCount());
                }
                label.setText(name);
                ImageDescriptor desc = this.getImageDescriptor(removedShare);
                label.setImage(desc == null ? null : this.getResources().createImageWithDefault(desc));
            }
        }

        private ImageDescriptor getImageDescriptor(IRemovedShare removedShare) {
            IWorkbenchAdapter wbAdapter;
            IResource resource = (IResource)removedShare.getShareable().getAdapter(IResource.class);
            if (resource != null && (wbAdapter = (IWorkbenchAdapter)resource.getAdapter(IWorkbenchAdapter.class)) != null) {
                return wbAdapter.getImageDescriptor((Object)resource);
            }
            return null;
        }
    }

    private class ShareableToLoadLabelProvider
    extends BaseLabelProvider {
        private Image projectImage;

        private ShareableToLoadLabelProvider() {
        }

        public void updateLabel(ViewerLabel label, Object element) {
            if (element instanceof IShareableToLoad) {
                IShareableToLoad shareableToLoad = (IShareableToLoad)element;
                String name = shareableToLoad.getShareable().getLocalFullPath().makeRelative().toString();
                ILoadLocation loadLocation = shareableToLoad.getLoadLocation();
                if (loadLocation != null) {
                    name = NLS.bind((String)Messages.WarnLoadUser_0, (Object)name, (Object)loadLocation.getComponent().getName());
                }
                label.setText(name);
                if (this.projectImage == null) {
                    this.projectImage = ImagePool.PROJECT.createImage();
                }
                label.setImage(this.projectImage);
            }
        }

        public void dispose() {
            super.dispose();
            if (this.projectImage != null) {
                this.projectImage.dispose();
            }
        }
    }
}

