/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.ui.internal.util;

import com.ibm.team.filesystem.common.ILogicalChange;
import com.ibm.team.filesystem.rcp.ui.internal.util.IConflictDialogFactory;
import com.ibm.team.scm.common.IFolderHandle;
import java.util.Collection;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DialogUtil {
    public static IConflictDialogFactory conflictDialogFactory = new IConflictDialogFactory(){

        @Override
        public ListDialog createConflictDialog(Shell shell, Collection<ILogicalChange> conflictItems, String title, String message) {
            ListDialog dialog = new ListDialog(shell);
            dialog.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
            dialog.setLabelProvider((ILabelProvider)new LogicalChangeLabelProvider());
            dialog.setInput(conflictItems);
            dialog.setBlockOnOpen(true);
            dialog.setMessage(message);
            dialog.setTitle(title);
            return dialog;
        }
    };

    public static Shell checkShell(Shell shell) {
        if (shell != null && !shell.isDisposed()) {
            return shell;
        }
        return null;
    }

    public static ListDialog createConflictDialog(Shell shell, Collection<ILogicalChange> conflictItems, String title, String message) {
        return conflictDialogFactory.createConflictDialog(shell, conflictItems, title, message);
    }

    private static class LogicalChangeLabelProvider
    extends LabelProvider {
        private LocalResourceManager resources = new LocalResourceManager(JFaceResources.getResources((Display)Display.getDefault()));

        public void dispose() {
            super.dispose();
            this.resources.dispose();
        }

        public String getText(Object element) {
            if (element instanceof ILogicalChange) {
                ILogicalChange change = (ILogicalChange)element;
                String[] path = change.getPathHint();
                if (path.length > 0) {
                    return path[path.length - 1];
                }
                return ILogicalChange.UNKNOWN_PATH;
            }
            return super.getText(element);
        }

        public Image getImage(Object element) {
            if (element instanceof ILogicalChange) {
                ILogicalChange change = (ILogicalChange)element;
                String simpleName = null;
                if (change.item() instanceof IFolderHandle) {
                    String[] path = change.getPathHint();
                    simpleName = path.length > 0 ? path[path.length - 1] : ILogicalChange.UNKNOWN_PATH;
                }
                ImageDescriptor desc = this.getFileSystemImageDescriptor(simpleName);
                return this.resources.createImage(desc);
            }
            return super.getImage(element);
        }

        public ImageDescriptor getFileSystemImageDescriptor(String filename) {
            if (filename == null) {
                return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FOLDER");
            }
            return PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(filename);
        }
    }
}

