/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.ui.internal.compare;

import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.common.changemodel.FileState;
import com.ibm.team.filesystem.rcp.ui.internal.Messages;
import com.ibm.team.filesystem.rcp.ui.internal.compare.CompareFilePropertiesState;
import com.ibm.team.filesystem.rcp.ui.internal.compare.CompareFilePropertiesViewerPane;
import com.ibm.team.filesystem.rcp.ui.internal.compare.FileChangeEditorInput;
import com.ibm.team.filesystem.rcp.ui.internal.compare.SimpleConflictCompareEditorInput;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.utils.DisposableInputStreamProvider;
import com.ibm.team.repository.rcp.common.IRemoteFunction;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.viewers.ConstantFunction;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.IContentChangeListener;
import org.eclipse.compare.IContentChangeNotifier;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.internal.BufferedResourceNode;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.Differencer;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalFileCompareEditorInput
extends CompareEditorInput {
    private IFile file;
    private CompareFilePropertiesState fileProperties;
    private boolean fileStreamChanges;
    private boolean isSaving = false;
    private boolean isCreateOrDelete = false;
    private BufferedResourceNode left;
    private IRemoteFunction<FileState> right;
    private IRemoteFunction<FileState> ancestor;
    private String rightLabelOverride = null;
    private CompareFilePropertiesViewerPane compareFilePropertiesViewerPane;

    public LocalFileCompareEditorInput(IFile left, FileState right) {
        this(left, null, right);
    }

    public LocalFileCompareEditorInput(IFile left, FileState ancestor, FileState right) {
        this(left, (IRemoteFunction<FileState>)(ancestor == null ? null : new ConstantFunction((Object)ancestor)), (IRemoteFunction<FileState>)new ConstantFunction((Object)right));
    }

    public LocalFileCompareEditorInput(IFile left, IRemoteFunction<FileState> right) {
        this(left, null, right);
    }

    public LocalFileCompareEditorInput(IFile left, IRemoteFunction<FileState> ancestor, IRemoteFunction<FileState> right) {
        super(new CompareConfiguration());
        this.file = left;
        this.right = right;
        this.ancestor = ancestor;
    }

    public String getTitle() {
        return this.file.getName();
    }

    public Object prepareInput(IProgressMonitor pm) throws InvocationTargetException {
        this.isCreateOrDelete = false;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)pm, (int)100);
        try {
            ITypedElement l;
            FileState rightState;
            CompareConfiguration cc = this.getCompareConfiguration();
            ITypedElement ancestorElement = null;
            if (this.ancestor != null) {
                FileState ancestorState = (FileState)this.ancestor.compute((IProgressMonitor)progress.newChild(50));
                ancestorElement = FileChangeEditorInput.getTypedElement(ancestorState, (IProgressMonitor)progress.newChild(50));
                progress.setWorkRemaining(100);
            }
            if ((rightState = (FileState)this.right.compute((IProgressMonitor)progress.newChild(50))).isDeleted()) {
                this.isCreateOrDelete = true;
            }
            ITypedElement right = FileChangeEditorInput.getTypedElement(rightState, (IProgressMonitor)progress.newChild(50));
            if (this.file == null || !this.file.exists()) {
                this.isCreateOrDelete = true;
            }
            if (this.file == null || !this.file.exists()) {
                l = FileChangeEditorInput.getTypedElement(FileState.getDeletedState(), (IProgressMonitor)progress.newChild(10));
                progress.setWorkRemaining(100);
            } else {
                final String localEncoding = SimpleConflictCompareEditorInput.getEncoding(this.file);
                this.left = new BufferedResourceNode((IResource)this.file){

                    public String getCharset() {
                        return localEncoding;
                    }
                };
                this.left.addContentChangeListener(new IContentChangeListener(){

                    public void contentChanged(IContentChangeNotifier source) {
                        try {
                            if (!LocalFileCompareEditorInput.this.isSaving) {
                                LocalFileCompareEditorInput.this.saveChanges((IProgressMonitor)new NullProgressMonitor());
                            }
                        }
                        catch (CoreException e) {
                            LoggingHelper.error((String)"com.ibm.team.filesystem.rcp.ui", (String)e.getMessage(), (Throwable)e);
                        }
                    }
                });
                l = this.left;
                IShareable shareable = (IShareable)this.file.getAdapter(IShareable.class);
                if (shareable != null) {
                    this.fileProperties = new CompareFilePropertiesState(shareable, rightState);
                }
            }
            if (this.fileProperties == null) {
                this.fileProperties = new CompareFilePropertiesState();
            }
            cc.setLeftLabel(NLS.bind((String)Messages.LocalFileCompareEditorInput_0, (Object)l.getName()));
            if (this.rightLabelOverride != null) {
                cc.setRightLabel(this.rightLabelOverride);
            } else if (rightState.isDeleted()) {
                cc.setRightLabel(Messages.LocalFileCompareEditorInput_1);
            } else {
                cc.setRightLabel(NLS.bind((String)Messages.LocalFileCompareEditorInput_2, (Object)right.getName()));
            }
            Object diff = new Differencer().findDifferences(ancestorElement != null, pm, null, (Object)ancestorElement, (Object)l, (Object)right);
            boolean bl = this.fileStreamChanges = diff != null;
            if (diff == null && this.fileProperties.isShareableChanges()) {
                return new DiffNode(7, ancestorElement, l, right);
            }
            return diff;
        }
        catch (IOException e) {
            throw new InvocationTargetException(e);
        }
        catch (TeamRepositoryException e) {
            throw new InvocationTargetException(e);
        }
        catch (RuntimeException e) {
            StatusUtil.log((Object)((Object)this), (Throwable)e);
            throw e;
        }
        catch (CoreException e) {
            throw new InvocationTargetException(e);
        }
    }

    public boolean isSaveNeeded() {
        if (this.compareFilePropertiesViewerPane != null) {
            return this.compareFilePropertiesViewerPane.isDirty() || super.isSaveNeeded();
        }
        return super.isSaveNeeded();
    }

    public void saveChanges(IProgressMonitor pm) throws CoreException {
        try {
            this.isSaving = true;
            if (this.compareFilePropertiesViewerPane != null) {
                this.compareFilePropertiesViewerPane.flush(pm);
            }
            super.saveChanges(pm);
            if (this.left != null) {
                this.left.commit(pm);
            }
        }
        finally {
            this.setDirty(false);
            this.isSaving = false;
        }
    }

    public Control createContents(Composite parent) {
        if (this.isCreateOrDelete || !this.fileProperties.isShareableChanges()) {
            return super.createContents(parent);
        }
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().applyTo(composite);
        this.compareFilePropertiesViewerPane = new CompareFilePropertiesViewerPane(composite, this.getCompareConfiguration(), this.fileProperties, this.getWorkbenchPart().getSite()){

            protected void firePropertyChange(PropertyChangeEvent event) {
                LocalFileCompareEditorInput.this.firePropertyChange(event);
            }
        };
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.compareFilePropertiesViewerPane);
        if (this.fileStreamChanges) {
            Control c = super.createContents(composite);
            GridDataFactory.fillDefaults().grab(true, true).applyTo(c);
        } else {
            Composite c = CompareFilePropertiesViewerPane.createNoStreamChangesLabel(composite);
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)c);
        }
        return composite;
    }

    public void setRightLabel(String remoteName) {
        this.rightLabelOverride = remoteName;
    }

    protected void handleDispose() {
        super.handleDispose();
        Object compareResult = this.getCompareResult();
        if (compareResult instanceof ICompareInput) {
            ICompareInput ci = (ICompareInput)compareResult;
            this.dispose(ci.getLeft());
            this.dispose(ci.getRight());
            this.dispose(ci.getAncestor());
        }
    }

    private void dispose(ITypedElement element) {
        Object adapter;
        if (element instanceof IAdaptable && (adapter = ((IAdaptable)element).getAdapter(DisposableInputStreamProvider.class)) instanceof DisposableInputStreamProvider) {
            DisposableInputStreamProvider disp = (DisposableInputStreamProvider)adapter;
            try {
                disp.dispose();
            }
            catch (IOException iOException) {}
        }
    }
}

