/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.ui.internal.compare;

import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.changemodel.FileState;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.LineDelimiter;
import com.ibm.team.repository.rcp.common.NullUtil;

public class CompareFilePropertiesState {
    private IShareable shareable;
    private String selectedContentType;
    private LineDelimiter selectedLineDelimiter;
    private String leftContentType;
    private LineDelimiter leftLineDelimiter;
    private boolean leftExecutable;
    private boolean hasRight = true;
    private String rightContentType;
    private LineDelimiter rightLineDelimiter;
    private boolean rightExecutable;
    private boolean hasAncestor = false;
    private String ancestorContentType;
    private LineDelimiter ancestorLineDelimiter;
    private boolean ancestorExecutable;

    public CompareFilePropertiesState() {
    }

    public CompareFilePropertiesState(IShareable shareable, IFileItem right, IFileItem ancestor) {
        this.shareable = shareable;
        if (shareable != null) {
            this.leftExecutable = shareable.isExecutable();
            this.leftContentType = shareable.getContentType();
            this.leftLineDelimiter = shareable.getLineDelimiter();
            this.selectedContentType = this.leftContentType;
            this.selectedLineDelimiter = this.leftLineDelimiter;
        }
        if (right != null) {
            IContent rightContent = right.getContent();
            this.rightExecutable = right.isExecutable();
            this.rightContentType = rightContent.getContentType();
            this.rightLineDelimiter = rightContent.getLineDelimiter();
        } else {
            this.hasRight = false;
        }
        if (ancestor != null) {
            this.hasAncestor = true;
            IContent ancestorContent = ancestor.getContent();
            this.ancestorExecutable = ancestor.isExecutable();
            this.ancestorContentType = ancestorContent.getContentType();
            this.ancestorLineDelimiter = ancestorContent.getLineDelimiter();
        }
    }

    public CompareFilePropertiesState(IShareable shareable, FileState right) {
        this.shareable = shareable;
        this.leftExecutable = shareable.isExecutable();
        this.leftContentType = shareable.getContentType();
        this.leftLineDelimiter = shareable.getLineDelimiter();
        this.selectedContentType = this.leftContentType;
        this.selectedLineDelimiter = this.leftLineDelimiter;
        this.rightExecutable = right.isExectuable();
        this.rightContentType = right.getContentType();
        this.rightLineDelimiter = right.getLineDelimiter();
    }

    public CompareFilePropertiesState(FileState left, FileState right) {
        this.leftExecutable = left.isExectuable();
        this.leftContentType = left.getContentType();
        this.leftLineDelimiter = left.getLineDelimiter();
        this.rightExecutable = right.isExectuable();
        this.rightContentType = right.getContentType();
        this.rightLineDelimiter = right.getLineDelimiter();
    }

    public boolean isShareableChanges() {
        if (this.shareable == null) {
            return false;
        }
        if (this.shareable.getContentType() == null && this.shareable.getLineDelimiter() == null) {
            return false;
        }
        if (!NullUtil.equals((Object)this.shareable.getLineDelimiter(), (Object)this.shareable.getOriginalLineDelimiter()) || !NullUtil.equals((Object)this.shareable.getContentType(), (Object)this.shareable.getOriginalContentType())) {
            return true;
        }
        if (!NullUtil.equals((Object)this.rightContentType, (Object)this.shareable.getContentType()) || !NullUtil.equals((Object)this.rightLineDelimiter, (Object)this.shareable.getLineDelimiter()) || this.rightExecutable != this.shareable.isExecutable()) {
            return true;
        }
        return this.isPropertiesDirty();
    }

    public boolean isPropertiesDirty() {
        return !NullUtil.equals((Object)this.selectedContentType, (Object)this.shareable.getContentType()) || !NullUtil.equals((Object)this.selectedLineDelimiter, (Object)this.shareable.getLineDelimiter());
    }

    public boolean isLeftSameAsAncestorExectuable() {
        return this.leftExecutable == this.ancestorExecutable;
    }

    public boolean isLeftSameAsAncestorContentType() {
        return NullUtil.equals((Object)this.leftContentType, (Object)this.ancestorContentType);
    }

    public boolean isLeftSameAsAncestorLineDelimiter() {
        return NullUtil.equals((Object)this.leftLineDelimiter, (Object)this.ancestorLineDelimiter);
    }

    public boolean isLeftSameAsRightExecutable() {
        return this.leftExecutable == this.rightExecutable;
    }

    public boolean isLeftSameAsRightContentType() {
        return NullUtil.equals((Object)this.leftContentType, (Object)this.rightContentType);
    }

    public boolean isLeftSameAsRightLineDelimiter() {
        return NullUtil.equals((Object)this.leftLineDelimiter, (Object)this.rightLineDelimiter);
    }

    public boolean isLeftSameAsRight() {
        return this.isLeftSameAsRightContentType() && this.isLeftSameAsRightLineDelimiter() && this.isLeftSameAsRightExecutable();
    }

    public boolean isRightSameAsAncestorExecutable() {
        return this.rightExecutable == this.ancestorExecutable;
    }

    public boolean isRightSameAsAncestorContentType() {
        return NullUtil.equals((Object)this.rightContentType, (Object)this.ancestorContentType);
    }

    public boolean isRightSameAsAncestorLineDelimiter() {
        return NullUtil.equals((Object)this.rightLineDelimiter, (Object)this.ancestorLineDelimiter);
    }

    public IShareable getShareable() {
        return this.shareable;
    }

    public boolean isLeftExecutable() {
        return this.leftExecutable;
    }

    public boolean isRightExecutable() {
        return this.rightExecutable;
    }

    public boolean isAncestorExecutable() {
        return this.ancestorExecutable;
    }

    public String getSelectedContentType() {
        return this.selectedContentType;
    }

    public LineDelimiter getSelectedLineDelimiter() {
        return this.selectedLineDelimiter;
    }

    public String getLeftContentType() {
        return this.leftContentType;
    }

    public LineDelimiter getLeftLineDelimiter() {
        return this.leftLineDelimiter;
    }

    public String getRightContentType() {
        return this.rightContentType;
    }

    public LineDelimiter getRightLineDelimiter() {
        return this.rightLineDelimiter;
    }

    public String getAncestorContentType() {
        return this.ancestorContentType;
    }

    public LineDelimiter getAncestorLineDelimiter() {
        return this.ancestorLineDelimiter;
    }

    public void setSelectedContentType(String selectedContentType) {
        this.selectedContentType = selectedContentType;
    }

    public void setSelectedLineDelimiter(LineDelimiter selectedLineDelimiter) {
        this.selectedLineDelimiter = selectedLineDelimiter;
    }

    public boolean hasAncestor() {
        return this.hasAncestor;
    }

    public boolean hasRight() {
        return this.hasRight;
    }
}

