/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.client.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ThreadCheck {
    public static final String LONG_OPS_PROPERTY = "disallow.long.ops.on.ui.thread";
    public static final String LONG_OPS_LOGGED_PROPERTY = "log.long.ops.on.ui.thread";
    private static volatile boolean exceptionOnLongOp = System.getProperty("disallow.long.ops.on.ui.thread", "false").equals("true");
    private static boolean logLongOps = System.getProperty("log.long.ops.on.ui.thread", "true").equals("true");
    private static Log log = LogFactory.getLog(ThreadCheck.class);
    private static ThreadLocal longOpsProhibited = new ThreadLocal(){

        protected Object initialValue() {
            return Boolean.FALSE;
        }
    };

    private ThreadCheck() {
    }

    public static boolean longOpsProhibited() {
        return (Boolean)longOpsProhibited.get();
    }

    public static void checkLongOpsAllowed() throws IllegalStateException {
        if (ThreadCheck.longOpsProhibited()) {
            IllegalStateException e = new IllegalStateException("Long-running operations prohibited on this thread");
            if (exceptionOnLongOp) {
                throw e;
            }
            if (logLongOps) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void prohibitLongOps() {
        longOpsProhibited.set(Boolean.TRUE);
    }

    public static void runProhibitingLongOps(Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException();
        }
        Boolean savedLongOpsProhibited = (Boolean)longOpsProhibited.get();
        try {
            longOpsProhibited.set(Boolean.TRUE);
            runnable.run();
        }
        finally {
            longOpsProhibited.set(savedLongOpsProhibited);
        }
    }

    public static void throwExceptionOnLongOp(boolean value) {
        exceptionOnLongOp = value;
    }
}

