/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.client.util;

import com.ibm.team.repository.client.util.Event;
import com.ibm.team.repository.client.util.IEventSource;
import com.ibm.team.repository.client.util.IPropertyChangeEvent;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class PropertyChangeEvent
extends Event
implements IPropertyChangeEvent {
    private static final long serialVersionUID = 1L;
    private static final Set EVENT_TYPES = new HashSet(Arrays.asList("com.ibm.team.repository.PropertySet", "com.ibm.team.repository.PropertyUnset", "com.ibm.team.repository.PropertyAdd", "com.ibm.team.repository.PropertyRemove", "com.ibm.team.repository.PropertyAddMany", "com.ibm.team.repository.PropertyRemoveMany", "com.ibm.team.repository.PropertyMove"));
    private final Object object;
    private final Object property;
    private final Object oldValue;
    private final Object newValue;
    private final int position;
    private final Object data;

    public PropertyChangeEvent(IEventSource eventSource, String eventType, Object object, Object property, Object oldValue, Object newValue, int position, Object data) {
        super(eventSource, eventType);
        if (!EVENT_TYPES.contains(eventType)) {
            throw new IllegalArgumentException();
        }
        if (object == null) {
            throw new IllegalArgumentException();
        }
        if (property == null) {
            throw new IllegalArgumentException();
        }
        this.object = object;
        this.property = property;
        this.oldValue = oldValue;
        this.newValue = newValue;
        this.position = position;
        this.data = data;
    }

    public PropertyChangeEvent(IEventSource eventSource, String eventType, Object object, Object property, Object oldValue, Object newValue, int position) {
        this(eventSource, eventType, object, property, oldValue, newValue, position, null);
    }

    public PropertyChangeEvent(IEventSource eventSource, String eventType, Object object, Object property, Object oldValue, Object newValue) {
        this(eventSource, eventType, object, property, oldValue, newValue, -1);
    }

    public PropertyChangeEvent(IEventSource eventSource, String eventType, Object object, Object property) {
        this(eventSource, eventType, object, property, null, null);
    }

    public final Object getObject() {
        return this.object;
    }

    public final Object getProperty() {
        return this.property;
    }

    public final Object getOldValue() {
        return this.oldValue;
    }

    public final Object getNewValue() {
        return this.newValue;
    }

    public final int getPosition() {
        return this.position;
    }

    public final Object getData() {
        return this.data;
    }

    protected void addCategories(List categories) {
        super.addCategories(categories);
        if (this.object != null) {
            categories.add(this.object);
        }
        if (this.property != null) {
            categories.add(this.property);
        }
        if (this.data != null) {
            categories.add(this.data);
        }
    }
}

