/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.client.util;

import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.client.internal.TeamRepository;
import com.ibm.team.repository.client.internal.nls.Messages;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.util.NLS;
import java.io.IOException;
import java.net.CookieHandler;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class FormBasedAuth {
    private static final String GET_METHOD = "GET";
    private static final String POST_METHOD = "POST";
    private static final String FORM_URL_ENCODED_CONTENT_TYPE = "application/x-www-form-urlencoded";
    private static final String LOCATION_HEADER = "Location";
    private static final String CONTENT_TYPE_HEADER = "Content-Type";
    private static final String COOKIE = "Cookie";
    private static final String SET_COOKIE_HEADER = "Set-Cookie";
    private static final String SET_COOKIE_HEADER2 = "Set-Cookie2";
    private static final String CONNECTION_HEADER = "Connection";
    private static final String CLOSE_CONNECTION = "close";
    private static final String COOKIE_EXPIRES = "Expires";
    private static final String COOKIE_PATH = "Path";
    private static final String FORM_AUTH_HEADER = "X-com-ibm-team-repository-web-auth-msg";
    private static final String FORM_AUTH_REQUIRED_MSG = "authrequired";
    private static final String FORM_AUTH_FAILED_MSG = "authfailed";
    private static final String FORM_AUTH_URI = "/j_security_check";
    private static final String FORM_AUTH_FAILED_URI = "/auth/authfailed";

    public static URLConnection handleFormBasedAuthentication(URLConnection urlCon, String requestUrl) throws IOException {
        String formAuthMsg;
        if (CookieHandler.getDefault() == null) {
            JazzSessionCookieHandler cookieHandler = new JazzSessionCookieHandler();
            CookieHandler.setDefault(cookieHandler);
        }
        if (!FORM_AUTH_REQUIRED_MSG.equals(formAuthMsg = urlCon.getHeaderField(FORM_AUTH_HEADER))) {
            return null;
        }
        FormBasedAuth.formBasedAuthenticate(requestUrl);
        URL urlObj = new URL(requestUrl);
        urlCon = urlObj.openConnection();
        urlCon.addRequestProperty(CONNECTION_HEADER, CLOSE_CONNECTION);
        return urlCon;
    }

    private static TeamRepository getTeamRepository(String uri) {
        if (uri == null) {
            return null;
        }
        Location loc = null;
        try {
            loc = Location.location((URI)new URI(uri));
        }
        catch (Exception exception) {
            return null;
        }
        String repoUri = loc.getRepoUri();
        if (repoUri.length() == 0) {
            return null;
        }
        TeamRepository repo = (TeamRepository)TeamPlatform.getTeamRepositoryService().getTeamRepository(repoUri, 4);
        return repo;
    }

    private static String trimTrailingSlash(String uri) {
        if (uri == null) {
            return uri;
        }
        if (uri.endsWith("/") || uri.endsWith("\\")) {
            int len = uri.length();
            if (len > 1) {
                return uri.substring(0, len - 1);
            }
            return new String();
        }
        return uri;
    }

    private static void formBasedAuthenticate(String uri) throws IOException {
        int status;
        URL authURL;
        TeamRepository repo = FormBasedAuth.getTeamRepository(uri);
        if (repo == null) {
            return;
        }
        String repoUri = FormBasedAuth.trimTrailingSlash(repo.getRepositoryURI());
        String authURLString = String.valueOf(repoUri) + FORM_AUTH_URI;
        try {
            authURL = new URL(authURLString);
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(NLS.bind((String)Messages.getServerString("FormBasedAuth.UnexpectedAuthUri"), (Object[])new Object[]{authURLString}));
        }
        HttpURLConnection authConnection = (HttpURLConnection)authURL.openConnection();
        if (authConnection instanceof HttpsURLConnection) {
            FormBasedAuth.setupLazySSLSupport(authConnection);
        }
        authConnection.setRequestMethod(POST_METHOD);
        authConnection.addRequestProperty(CONTENT_TYPE_HEADER, FORM_URL_ENCODED_CONTENT_TYPE);
        authConnection.addRequestProperty(CONNECTION_HEADER, CLOSE_CONNECTION);
        authConnection.setDoOutput(true);
        authConnection.setInstanceFollowRedirects(false);
        repo.formBasedAuthenticate(authConnection);
        try {
            status = authConnection.getResponseCode();
        }
        catch (Throwable t) {
            throw new RuntimeException(NLS.bind((String)Messages.getServerString("FormBasedAuth.LoginError"), (Object[])new Object[]{t.getMessage()}), t);
        }
        String authResponse = authConnection.getHeaderField(FORM_AUTH_HEADER);
        if (authResponse != null) {
            if (authResponse.equals(FORM_AUTH_REQUIRED_MSG)) {
                throw new RuntimeException(NLS.bind((String)Messages.getServerString("FormBasedAuth.ProtectedResourceError"), (Object[])new Object[]{FORM_AUTH_URI}));
            }
            if (authResponse.equals(FORM_AUTH_FAILED_MSG)) {
                throw new RuntimeException(Messages.getServerString("FormBasedAuth.InvalidCreds"));
            }
            throw new RuntimeException(NLS.bind((String)Messages.getServerString("FormBasedAuth.UnexpectedServletResponse"), (Object[])new Object[]{FORM_AUTH_REQUIRED_MSG, FORM_AUTH_FAILED_MSG, authResponse}));
        }
        if (status == 302) {
            String location = authConnection.getHeaderField(LOCATION_HEADER);
            if (location != null && location.indexOf(FORM_AUTH_FAILED_URI) != -1) {
                throw new RuntimeException(Messages.getServerString("FormBasedAuth.InvalidCreds"));
            }
            authConnection = (HttpURLConnection)authURL.openConnection();
            if (authConnection instanceof HttpsURLConnection) {
                FormBasedAuth.setupLazySSLSupport(authConnection);
            }
            authConnection.setRequestMethod(GET_METHOD);
            authConnection.addRequestProperty(CONNECTION_HEADER, CLOSE_CONNECTION);
            authConnection.setDoInput(true);
            authConnection.setInstanceFollowRedirects(false);
            authConnection.connect();
            status = authConnection.getResponseCode();
            authConnection.getInputStream().close();
            authConnection.disconnect();
            return;
        }
        throw new RuntimeException(NLS.bind((String)Messages.getServerString("FormBasedAuth.UnexpectedUriResponse"), (Object[])new Object[]{authURLString, 302, status}));
    }

    public static void setupLazySSLSupport(URLConnection urlConnection) {
        if (!(urlConnection instanceof HttpsURLConnection)) {
            return;
        }
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }

            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        }};
        HostnameVerifier hv = new HostnameVerifier(){

            public boolean verify(String urlHostname, SSLSession sslSession) {
                return true;
            }
        };
        SSLContext sc = null;
        try {
            sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (KeyManagementException keyManagementException) {}
        if (sc != null) {
            ((HttpsURLConnection)urlConnection).setSSLSocketFactory(sc.getSocketFactory());
        }
        ((HttpsURLConnection)urlConnection).setHostnameVerifier(hv);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class JazzSessionCookieHandler
    extends CookieHandler {
        private final Map<String, Set<CookieStruct>> fCookieMap = new HashMap<String, Set<CookieStruct>>();

        @Override
        public Map<String, List<String>> get(URI uri, Map<String, List<String>> requestHeaders) throws IOException {
            if (uri == null) {
                throw new IllegalArgumentException("uri must not be null");
            }
            if (requestHeaders == null) {
                throw new IllegalArgumentException("requestHeaders must not be null");
            }
            Set<CookieStruct> cookies = this.fCookieMap.get(JazzSessionCookieHandler.getDomain(uri));
            if (cookies == null || cookies.size() == 0) {
                return new HashMap<String, List<String>>();
            }
            String uriPath = uri.getPath();
            ArrayList<CookieStruct> foundCookies = new ArrayList<CookieStruct>();
            for (CookieStruct cookie : cookies) {
                if (!this.pathMatches(uriPath, cookie.path)) continue;
                foundCookies.add(cookie);
            }
            List<String> cookiePaths = this.sortAndFormat(foundCookies);
            HashMap<String, List<String>> map = new HashMap<String, List<String>>();
            map.put(FormBasedAuth.COOKIE, cookiePaths);
            return map;
        }

        @Override
        public void put(URI uri, Map<String, List<String>> responseHeaders) throws IOException {
            for (Map.Entry<String, List<String>> entry : responseHeaders.entrySet()) {
                List<String> cookieStrings;
                String key = entry.getKey();
                if (key == null || !key.equalsIgnoreCase(FormBasedAuth.SET_COOKIE_HEADER) && !key.equalsIgnoreCase(FormBasedAuth.SET_COOKIE_HEADER2) || (cookieStrings = entry.getValue()) == null) continue;
                this.updateCookieMap(uri, cookieStrings);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateCookieMap(URI uri, List<String> cookies) {
            String domain = JazzSessionCookieHandler.getDomain(uri);
            for (String cookieString : cookies) {
                CookieStruct cookie = this.extractCookie(cookieString);
                Map<String, Set<CookieStruct>> map = this.fCookieMap;
                synchronized (map) {
                    Set<CookieStruct> loginCookies = this.fCookieMap.get(domain);
                    if (loginCookies == null) {
                        loginCookies = new HashSet<CookieStruct>();
                        this.fCookieMap.put(domain, loginCookies);
                    }
                    if (loginCookies.contains(cookie)) {
                        loginCookies.remove(cookie);
                    }
                    loginCookies.add(cookie);
                }
            }
        }

        private CookieStruct extractCookie(String cookieString) {
            CookieStruct cookie = new CookieStruct();
            StringTokenizer tokenizer = new StringTokenizer(cookieString, ";");
            if (!tokenizer.hasMoreTokens()) {
                return cookie;
            }
            String token = tokenizer.nextToken();
            int ndx = token.indexOf(61);
            if (ndx == -1) {
                return cookie;
            }
            cookie.name = token.substring(0, ndx).trim();
            cookie.value = ndx == token.length() - 1 ? new String() : token.substring(ndx + 1).trim();
            while (tokenizer.hasMoreTokens()) {
                token = tokenizer.nextToken();
                ndx = token.indexOf(61);
                if (ndx == -1) {
                    return cookie;
                }
                String name = token.substring(0, ndx).trim();
                String value = null;
                if (ndx != token.length() - 1) {
                    value = token.substring(ndx + 1).trim();
                }
                if (name.equalsIgnoreCase(FormBasedAuth.COOKIE_EXPIRES)) {
                    cookie.expires = value;
                    continue;
                }
                if (!name.equalsIgnoreCase(FormBasedAuth.COOKIE_PATH)) continue;
                cookie.path = value;
            }
            return cookie;
        }

        private boolean pathMatches(String basePath, String pathMatch) {
            if (basePath == pathMatch) {
                return true;
            }
            if (basePath == null || pathMatch == null) {
                return false;
            }
            return basePath.startsWith(pathMatch);
        }

        private List<String> sortAndFormat(List<CookieStruct> cookies) {
            Collections.sort(cookies, new CookiePathComparator());
            ArrayList<String> cookieHeader = new ArrayList<String>();
            for (CookieStruct cookie : cookies) {
                if (cookie.name.length() == 0) continue;
                String cookieString = String.format("%s=%s", cookie.name, cookie.value);
                cookieHeader.add(cookieString);
            }
            return cookieHeader;
        }

        private static String getDomain(URI uri) {
            return uri.getHost().toLowerCase();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class CookiePathComparator
        implements Comparator<CookieStruct> {
            private CookiePathComparator() {
            }

            @Override
            public int compare(CookieStruct c1, CookieStruct c2) {
                if (c1 == c2) {
                    return 0;
                }
                if (!c1.name.equals(c2.name)) {
                    return 0;
                }
                if (c1.path.startsWith(c2.path)) {
                    return -1;
                }
                if (c2.path.startsWith(c1.path)) {
                    return 1;
                }
                return 0;
            }
        }

        private static class CookieStruct {
            public String name = new String();
            public String value = new String();
            public String expires = new String();
            public String path = new String();

            private CookieStruct() {
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null) {
                    return false;
                }
                if (!(o instanceof CookieStruct)) {
                    return false;
                }
                CookieStruct that = (CookieStruct)o;
                return this.path.equals(that.path) && this.name.equals(that.name);
            }

            public int hashCode() {
                return (String.valueOf(this.path) + this.name).hashCode();
            }
        }
    }
}

