/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.client.internal;

import com.ibm.team.repository.client.ILicenseClient;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.EventSource;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.ILicenseService;
import com.ibm.team.repository.common.LicenseNotGrantedException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LicenseClient
extends EventSource
implements ILicenseClient {
    public static final Log logger = LogFactory.getLog(LicenseClient.class);
    private final IClientLibraryContext context;
    private final ILicenseService licenseService;
    private final Map<String, String> cachedLicenseChecks = new HashMap<String, String>();
    private final ITeamRepository.ILoginParticipant cacheFlusher = new ITeamRepository.ILoginParticipant(){

        public void handleLogout(ITeamRepository repository) {
            LicenseClient.this.flushCache();
        }

        public void handleLogin(ITeamRepository repository) {
            LicenseClient.this.flushCache();
        }
    };

    public LicenseClient(IClientLibraryContext context) {
        this.context = context;
        this.licenseService = (ILicenseService)context.getServiceInterface(ILicenseService.class);
        context.teamRepository().addLoginParticipant(this.cacheFlusher);
    }

    public void assertLicense(String operationId) throws LicenseNotGrantedException, TeamRepositoryException {
        this.assertLicense(operationId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String[] checkLicenses(final List<String> operationIds, IProgressMonitor monitor) throws TeamRepositoryException {
        if (operationIds == null) {
            throw new IllegalArgumentException("The operationIds must not be null");
        }
        Map<String, String> map = this.cachedLicenseChecks;
        synchronized (map) {
            String[] stringArray;
            String[] results = new String[operationIds.size()];
            boolean allCached = true;
            int i = 0;
            while (i < operationIds.size()) {
                String operationId = operationIds.get(i);
                if (operationId == null) {
                    throw new IllegalArgumentException(NLS.bind((String)"Each operationId must be non-null, but element {0} was null", (Object[])new Object[]{i}));
                }
                if (!this.cachedLicenseChecks.containsKey(operationId)) {
                    allCached = false;
                    break;
                }
                results[i] = this.cachedLicenseChecks.get(operationId);
                ++i;
            }
            if (!allCached) return this.context.callCancelableService(new IClientLibraryContext.IServiceRunnable<String[]>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public String[] run(IProgressMonitor monitor) throws TeamRepositoryException {
                    String[] checkLicenses = LicenseClient.this.licenseService.checkLicenses(operationIds.toArray(new String[operationIds.size()]));
                    Map map = LicenseClient.this.cachedLicenseChecks;
                    synchronized (map) {
                        int i = 0;
                        while (i < operationIds.size()) {
                            LicenseClient.this.cachedLicenseChecks.put((String)operationIds.get(i), checkLicenses[i]);
                            ++i;
                        }
                    }
                    return checkLicenses;
                }
            }, monitor);
            if (monitor != null) {
                monitor.beginTask(null, -1);
            }
            try {
                stringArray = results;
                if (monitor == null) return stringArray;
            }
            catch (Throwable throwable) {
                if (monitor == null) throw throwable;
                monitor.done();
                throw throwable;
            }
            monitor.done();
            return stringArray;
        }
    }

    @Override
    public void assertLicenseForContributor(final String operationId, final IContributorHandle contributor, IProgressMonitor monitor) throws LicenseNotGrantedException, TeamRepositoryException {
        if (operationId == null) {
            throw new IllegalArgumentException("The operationId must not be null");
        }
        if (contributor == null) {
            throw new IllegalArgumentException("The contributor must not be null");
        }
        this.context.callCancelableService(new IClientLibraryContext.IServiceRunnable<Object>(){

            @Override
            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                LicenseClient.this.licenseService.assertLicenseForContributor(operationId, contributor);
                return null;
            }
        }, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void assertLicense(final String operationId, IProgressMonitor monitor) throws LicenseNotGrantedException, TeamRepositoryException {
        if (operationId == null) {
            throw new IllegalArgumentException("The operationId must not be null");
        }
        Map<String, String> map = this.cachedLicenseChecks;
        synchronized (map) {
            if (this.cachedLicenseChecks.containsKey(operationId)) {
                if (monitor != null) {
                    monitor.beginTask(null, -1);
                }
                try {
                    String message = this.cachedLicenseChecks.get(operationId);
                    if (message != null) {
                        throw new LicenseNotGrantedException(message);
                    }
                    return;
                }
                finally {
                    if (monitor != null) {
                        monitor.done();
                    }
                }
            }
        }
        try {
            this.context.callCancelableService(new IClientLibraryContext.IServiceRunnable<Object>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                    LicenseClient.this.licenseService.assertLicense(operationId);
                    Map map = LicenseClient.this.cachedLicenseChecks;
                    synchronized (map) {
                        LicenseClient.this.cachedLicenseChecks.put(operationId, null);
                    }
                    return null;
                }
            }, monitor);
        }
        catch (LicenseNotGrantedException exp) {
            Map<String, String> map2 = this.cachedLicenseChecks;
            synchronized (map2) {
                this.cachedLicenseChecks.put(operationId, exp.getMessage());
            }
            throw exp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flushCache() {
        Map<String, String> map = this.cachedLicenseChecks;
        synchronized (map) {
            this.cachedLicenseChecks.clear();
        }
    }
}

