/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.client.internal;

import com.ibm.team.repository.client.internal.TeamRepository;
import com.ibm.team.repository.common.LoginFailureException;
import com.ibm.team.repository.common.transport.ServiceNotAvailableException;
import com.ibm.team.repository.common.transport.TeamServiceException;
import com.ibm.team.repository.transport.client.AuthenticationException;
import java.io.IOException;

public class ConnectionUtil {
    public static boolean setConnectionError(Exception e, TeamRepository repository) {
        boolean connectionError = false;
        if (ConnectionUtil.isMinorConnectionError(e)) {
            connectionError = true;
        } else {
            int nextState = 0;
            if (e instanceof AuthenticationException || e instanceof LoginFailureException) {
                nextState = 2;
                repository.logout();
            } else if (e.getCause() instanceof IOException) {
                nextState = 1;
                connectionError = true;
            } else if (e instanceof TeamServiceException) {
                nextState = 1;
                connectionError = true;
            }
            if (nextState != 0) {
                repository.setErrorState(nextState, e);
            }
        }
        return connectionError;
    }

    private static boolean isMinorConnectionError(Exception e) {
        String message = e.getMessage();
        if (message == null) {
            return false;
        }
        if (e instanceof ServiceNotAvailableException) {
            return true;
        }
        if (message.equals("Read timed out")) {
            return true;
        }
        return message.contains("Connection reset");
    }
}

