/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.client;

import com.ibm.team.repository.client.IContentManager;
import com.ibm.team.repository.client.IContributorManager;
import com.ibm.team.repository.client.IExternalUserRegistryManager;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.IStatistics;
import com.ibm.team.repository.client.util.IEventSource;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IRepositoryRoot;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;

public interface ITeamRepository
extends IEventSource {
    public static final String STATE = "state";
    public static final String ERROR_STATE = "error_state";
    public static final String URI = "uri";
    public static final String NAME = "name";
    public static final String ID = "id";
    public static final String ALIAS_REPOSITORY_URIS = "aliasRepositoryURIs";
    public static final String SAVE_PASSWORD = "savePassword";
    public static final String AUTO_LOGIN = "autoLogin";
    public static final String USERID = "userId";
    public static final int STATE_LOGGING_IN = 0;
    public static final int STATE_LOGGED_IN = 1;
    public static final int STATE_LOGGING_OUT = 2;
    public static final int STATE_LOGGED_OUT = 3;
    public static final int ERROR_STATE_NONE = 0;
    public static final int ERROR_STATE_IO = 1;
    public static final int ERROR_STATE_AUTH = 2;
    public static final int DEBUG_NONE = 0;
    public static final int DEBUG_BLOCKING_SERVICEMETHODS = 1;

    public IRepositoryRoot root();

    public String publicUriRoot();

    public IContentManager contentManager();

    public IItemManager itemManager();

    public IContributorManager contributorManager();

    public IExternalUserRegistryManager externalUserRegistryManager();

    public Object getClientLibrary(Class var1);

    public void registerLoginHandler(ILoginHandler var1);

    public void addLoginParticipant(ILoginParticipant var1);

    public void removeLoginParticipant(ILoginParticipant var1);

    public void login(IProgressMonitor var1) throws TeamRepositoryException;

    public void logout();

    @Deprecated
    public void logout(IProgressMonitor var1) throws TeamRepositoryException;

    public boolean loggedIn();

    public IContributor loggedInContributor();

    public String getRepositoryURI();

    public int getState();

    public int getErrorState();

    public Throwable getLastError();

    public void setSavePassword(boolean var1);

    public boolean getSavePassword();

    public void setAutoLogin(boolean var1);

    public boolean getAutoLogin();

    public void setName(String var1);

    public String getName();

    public void setId(UUID var1);

    public UUID getId();

    public Collection getAliasRepositoryURIs();

    public void addAliasRepositoryURI(String var1);

    public void removeAliasRepositoryURI(String var1);

    public void setUserId(String var1);

    public String getUserId();

    public void setConnectionTimeout(int var1);

    public int getConnectionTimeout();

    public IStatistics statistics();

    public void setDebugMode(int var1);

    public void setProxy(String var1, int var2, String var3, String var4);

    public static interface ILoginHandler {
        public ILoginInfo challenge(ITeamRepository var1);

        public static interface ILoginInfo {
            public String getUserId();

            public String getPassword();
        }
    }

    public static interface ILoginParticipant {
        public void handleLogin(ITeamRepository var1);

        public void handleLogout(ITeamRepository var1);
    }
}

