/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.client.wiki;

import com.ibm.team.apt.internal.common.wiki.transformer.Token;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemType;
import org.eclipse.core.runtime.Assert;

public class WikiLinks {
    private static final char WHITESPACE_CHAR = ' ';
    private static final char LEFT_PAREN = '(';
    private static final char RIGHT_PAREN = ')';
    private static final char DASH = '-';

    public static String staticLink(IWorkItem item, IWorkItemType type) {
        Assert.isTrue((boolean)item.isPropertySet(IWorkItem.TYPE_PROPERTY));
        Assert.isTrue((boolean)item.isPropertySet(IWorkItem.ID_PROPERTY));
        Assert.isTrue((boolean)item.isPropertySet(IWorkItem.SUMMARY_PROPERTY));
        StringBuilder text = new StringBuilder();
        text.append(Token.LINK_START.wiki);
        text.append(WikiLinks.getDisplayName(item, type));
        text.append(' ');
        text.append(item.getId());
        text.append(' ');
        text.append(Token.SEPARATOR.wiki);
        text.append(item.getHTMLSummary().getXMLText());
        text.append(' ');
        text.append('(');
        text.append(item.getId());
        text.append(')');
        text.append(Token.LINK_END.wiki);
        return WikiLinks.returnString(text);
    }

    public static String link(IWorkItem item, IWorkItemType type) {
        Assert.isTrue((boolean)item.isPropertySet(IWorkItem.TYPE_PROPERTY));
        Assert.isTrue((boolean)item.isPropertySet(IWorkItem.ID_PROPERTY));
        StringBuilder text = new StringBuilder();
        text.append(Token.LINK_START.wiki);
        text.append(WikiLinks.getDisplayName(item, type));
        text.append(' ');
        text.append(item.getId());
        text.append(' ');
        text.append(Token.SEPARATOR.wiki);
        text.append(Token.VAR_START.wiki);
        text.append("summary");
        text.append(Token.VAR_END.wiki);
        text.append(' ');
        text.append('(');
        text.append(item.getId());
        text.append(')');
        text.append(Token.LINK_END.wiki);
        return WikiLinks.returnString(text);
    }

    public static String link(Object reference, Object label) {
        StringBuilder text = new StringBuilder();
        text.append(Token.LINK_START.wiki);
        text.append(reference);
        text.append(' ');
        text.append(Token.SEPARATOR.wiki);
        text.append(WikiLinks.escapeString(label));
        text.append(Token.LINK_END.wiki);
        return WikiLinks.returnString(text);
    }

    private static String getDisplayName(IWorkItem workItem, IWorkItemType type) {
        String displayName = workItem.getWorkItemType();
        if (type != null && type.getDisplayName() != null) {
            displayName = type.getDisplayName();
        }
        return displayName;
    }

    private static String returnString(StringBuilder text) {
        return text.toString();
    }

    private static String escapeString(Object label) {
        String text = label instanceof String ? (String)label : String.valueOf(label);
        int len = text.length();
        StringBuilder result = new StringBuilder((int)((float)len * 1.1f));
        int i = 0;
        while (i < len) {
            char c = text.charAt(i);
            if (Token.LINK_START.wiki.indexOf(c) == 0 || Token.LINK_END.wiki.indexOf(c) == 0) {
                result.append('~');
            }
            result.append(c);
            ++i;
        }
        return WikiLinks.returnString(result);
    }
}

