/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.client.util;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LRUElementCache<K, V>
extends LinkedHashMap<K, V> {
    private static final long serialVersionUID = 1L;
    private int fCurrentSize;
    private final int fMaxSize;

    public LRUElementCache(int maximum, int size) {
        super(size);
        Assert.isLegal((maximum > 0 ? 1 : 0) != 0, (String)"Size must be positive");
        this.fMaxSize = maximum;
        this.fCurrentSize = maximum;
    }

    public int getSize() {
        return this.fCurrentSize;
    }

    public int increaseSize(int size) {
        Assert.isLegal((size > 0 ? 1 : 0) != 0, (String)"Size must be positive");
        int temp = this.fCurrentSize;
        this.fCurrentSize += size;
        return temp;
    }

    public V internalPut(K key, V value) {
        return super.put(key, value);
    }

    @Override
    public V put(K key, V value) {
        Object object = this.remove(key);
        super.put(key, value);
        return object;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> entry) {
        return this.size() > this.fCurrentSize;
    }

    public void trimSize() {
        int diff = this.fCurrentSize - this.fMaxSize;
        if (diff > 0) {
            this.fCurrentSize = this.fMaxSize;
            ArrayList keys = new ArrayList(diff);
            for (Map.Entry entry : this.entrySet()) {
                if (keys.size() >= diff) break;
                keys.add(entry.getKey());
            }
            for (Object key : keys) {
                this.remove(key);
            }
        }
    }
}

