/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.client.teamload;

import com.ibm.team.apt.common.resource.IContributorAbsence;
import com.ibm.team.apt.common.resource.IWorkResourceDetails;
import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.client.resource.IContributorInfo;
import com.ibm.team.apt.internal.client.resource.ResourcePlanningManager;
import com.ibm.team.apt.internal.client.teamload.ILoadItemCreator;
import com.ibm.team.apt.internal.client.teamload.LoadInformation;
import com.ibm.team.apt.internal.client.teamload.LoadItem;
import com.ibm.team.apt.internal.common.GenericOutOfOfficeTimeSpan;
import com.ibm.team.apt.internal.common.IBookedTime;
import com.ibm.team.apt.internal.common.Timespan;
import com.ibm.team.apt.internal.common.WorktimeScheduler;
import com.ibm.team.apt.internal.common.rcp.dto.DTO_ContributorLoad;
import com.ibm.team.apt.internal.common.rcp.dto.DTO_TeamLoad;
import com.ibm.team.apt.internal.common.util.ItemArrayList;
import com.ibm.team.apt.internal.common.util.ItemCollection;
import com.ibm.team.apt.internal.common.util.ItemCollections;
import com.ibm.team.apt.internal.common.util.ItemHashMap;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.workitem.client.IWorkItemWorkingCopyManager;
import com.ibm.team.workitem.common.model.ICategory;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TeamLoadInformation
extends LoadInformation {
    private ILoadItemCreator fItemCreator = new ILoadItemCreator(){

        @Override
        public List<LoadItem> createItems(IProgressMonitor monitor) throws TeamRepositoryException {
            ArrayList<LoadItem> result = new ArrayList<LoadItem>(TeamLoadInformation.this.fDto.getContributorLoads().size());
            List contributorLoads = TeamLoadInformation.this.fDto.getContributorLoads();
            ItemArrayList contributors = new ItemArrayList();
            for (DTO_ContributorLoad load : contributorLoads) {
                IContributorHandle contributor = load.getContributor();
                if (contributors.contains((Object)contributor)) continue;
                contributors.add((Object)contributor);
            }
            ItemHashMap fetchedContributors = new ItemHashMap(contributors.size());
            IItemManager itemManager = PlanningClientPlugin.getTeamRepository((IItemHandle)TeamLoadInformation.this.fIteration).itemManager();
            List items = itemManager.fetchPartialItems(contributors.toList(), 0, (Collection)Collections.singleton(IContributor.NAME_PROPERTY), monitor);
            for (IItem item : items) {
                if (!(item instanceof IContributor)) continue;
                IContributor contributor = (IContributor)item;
                fetchedContributors.put((IItemHandle)((IContributorHandle)contributor.getItemHandle()), (Object)contributor);
            }
            ResourcePlanningManager manager = PlanningClientPlugin.getResourcePlanningManager((IItemHandle)TeamLoadInformation.this.fIteration);
            Timestamp start = new Timestamp(0L);
            Timestamp end = null;
            if (TeamLoadInformation.this.fIteration.getStartDate() != null) {
                start = new Timestamp(TeamLoadInformation.this.fIteration.getStartDate().getTime());
            }
            if (TeamLoadInformation.this.fIteration.getEndDate() != null) {
                end = new Timestamp(TeamLoadInformation.this.fIteration.getEndDate().getTime());
            }
            IContributorInfo info = manager.getContributorInfo((ItemCollection<IContributorHandle>)contributors, start, end, false, false, monitor);
            for (DTO_ContributorLoad load : contributorLoads) {
                IContributor contributor = (IContributor)fetchedContributors.get((IItemHandle)load.getContributor());
                if (contributor == null) continue;
                long workTimeLeft = 0L;
                if (TeamLoadInformation.this.fIteration.getStartDate() != null && TeamLoadInformation.this.fIteration.getEndDate() != null) {
                    WorktimeScheduler scheduler = new WorktimeScheduler(info.getWorkLocation((IContributorHandle)contributor));
                    ItemCollection<IContributorAbsence> absences = info.getAbsences((IContributorHandle)contributor);
                    for (IContributorAbsence absence : absences) {
                        scheduler.addBookedTime((IBookedTime)new GenericOutOfOfficeTimeSpan(absence.getStartDate(), absence.getEndDate()));
                    }
                    Timestamp now = new Timestamp(System.currentTimeMillis());
                    if (now.after(start)) {
                        start = now;
                    }
                    workTimeLeft = !end.before(now) ? scheduler.calcutateWorkingTime(new Timespan((Date)start, (Date)end)) : -1L;
                }
                int assignment = 0;
                boolean defaultAssignment = true;
                ItemCollection<IWorkResourceDetails> details = info.getWorkDetails((IContributorHandle)contributor);
                for (IWorkResourceDetails detail : details) {
                    if (!detail.getOwner().sameItemId((IItemHandle)TeamLoadInformation.this.fTeamArea) || !detail.getDevelopmentLine().sameItemId((IItemHandle)TeamLoadInformation.this.fIteration.getDevelopmentLine())) continue;
                    assignment = detail.getAssignment();
                    defaultAssignment = !detail.isCustomized();
                    break;
                }
                boolean defaultLocation = !info.getWorkLocation((IContributorHandle)contributor).isCustomized();
                LoadItem item = new LoadItem(TeamLoadInformation.this, contributor, info.getAbsences((IContributorHandle)contributor), workTimeLeft, assignment, defaultAssignment, defaultLocation, load.getSumOfEstimates(), new HashSet<UUID>(load.getOpenWorkItems()), new HashSet<UUID>(load.getEstimatedWorkItems()), new HashSet<UUID>(load.getClosedWorkItems()));
                result.add(item);
            }
            return result;
        }
    };
    private ITeamArea fTeamArea;
    private final DTO_TeamLoad fDto;
    private final IIteration fIteration;

    public TeamLoadInformation(DTO_TeamLoad dto, ITeamArea teamArea, ItemArrayList<ICategory> categories, IIteration iteration) {
        super((ItemCollection<? extends IIteration>)ItemCollections.singleton((Object)iteration), (ItemCollection<? extends ICategory>)categories);
        Assert.isNotNull((Object)dto);
        this.fDto = dto;
        this.fIteration = iteration;
        this.fTeamArea = teamArea;
        this.setMode(iteration.getEndDate() != null && iteration.getEndDate().after(new Date()) ? LoadInformation.Mode.TIME : LoadInformation.Mode.COUNT);
    }

    public IIteration getIteration() {
        return this.fIteration;
    }

    public ITeamArea getTeamArea() {
        return this.fTeamArea;
    }

    @Override
    public ILoadItemCreator getItemCreator() {
        return this.fItemCreator;
    }

    @Override
    public IProjectAreaHandle getProjectArea() {
        return this.fTeamArea.getProjectArea();
    }

    @Override
    public IItemManager getItemManager() {
        return PlanningClientPlugin.getTeamRepository((IItemHandle)this.fTeamArea).itemManager();
    }

    @Override
    public IWorkItemWorkingCopyManager getWorkItemWorkingCopyManager() {
        return PlanningClientPlugin.getWorkItemClient((IItemHandle)this.fTeamArea).getWorkItemWorkingCopyManager();
    }
}

