/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.client.teamload;

import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.client.teamload.ITeamLoadClient;
import com.ibm.team.apt.internal.client.teamload.LoadItem;
import com.ibm.team.apt.internal.client.teamload.Messages;
import com.ibm.team.apt.internal.client.teamload.TeamLoadDelta;
import com.ibm.team.apt.internal.client.teamload.TeamLoadInformation;
import com.ibm.team.apt.internal.common.rcp.dto.DTO_TeamLoad;
import com.ibm.team.apt.internal.common.teamload.ITeamLoadService;
import com.ibm.team.apt.internal.common.util.ItemArrayList;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IIterationHandle;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.IWorkItemWorkingCopyManager;
import com.ibm.team.workitem.client.WorkItemChangeEvent;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.common.internal.model.WorkItem;
import com.ibm.team.workitem.common.model.ChangeDetails;
import com.ibm.team.workitem.common.model.ICategory;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.common.workflow.IWorkflowInfo;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TeamLoadClient
implements ITeamLoadClient {
    private static final ItemProfile<IWorkItem> EMPTY_PROFILE = ItemProfile.createProfile((IItemType)IWorkItem.ITEM_TYPE, (String[])new String[0]);
    private IClientLibraryContext fContext;

    public TeamLoadClient(IClientLibraryContext context) {
        this.fContext = context;
    }

    @Override
    public TeamLoadInformation refreshTeamLoadInformation(TeamLoadInformation teamLoad, IProgressMonitor monitor) throws TeamRepositoryException {
        Assert.isNotNull((Object)teamLoad);
        monitor.beginTask(Messages.TeamLoadClient_MONITOR_UPDATING_INFORMATION, 4);
        List<TeamLoadDelta> deltas = teamLoad.getDeltas();
        ITeamArea teamArea = teamLoad.getTeamArea();
        IIteration iteration = teamLoad.getIteration();
        TeamLoadInformation result = this.internalTeamLoadFetch((ITeamAreaHandle)teamArea, (IIterationHandle)iteration, monitor);
        result.applyDeltas(deltas);
        monitor.done();
        return result;
    }

    @Override
    public TeamLoadInformation fetchTeamLoadInformation(ITeamAreaHandle teamAreaHandle, IIterationHandle iterationHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        Assert.isNotNull((Object)teamAreaHandle);
        Assert.isNotNull((Object)iterationHandle);
        monitor.beginTask(Messages.TeamLoadClient_MONITOR_LOADING_INFORMATION, 4);
        TeamLoadInformation result = this.internalTeamLoadFetch(teamAreaHandle, iterationHandle, monitor);
        result = this.internalTeamLoadUpdate(result, monitor);
        monitor.done();
        return result;
    }

    private TeamLoadInformation internalTeamLoadFetch(ITeamAreaHandle teamAreaHandle, IIterationHandle iterationHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        IWorkItemClient workItemClient = PlanningClientPlugin.getWorkItemClient((IItemHandle)teamAreaHandle);
        IItemManager manager = PlanningClientPlugin.getTeamRepository((IItemHandle)teamAreaHandle).itemManager();
        ITeamLoadService service = (ITeamLoadService)this.fContext.getServiceInterface(ITeamLoadService.class);
        IIteration iteration = (IIteration)manager.fetchCompleteItem((IItemHandle)iterationHandle, 0, monitor);
        List<ICategory> categories = this.findCategoriesWithoutUnassigned(teamAreaHandle, monitor, workItemClient);
        ITeamArea teamArea = (ITeamArea)manager.fetchCompleteItem((IItemHandle)teamAreaHandle, 0, monitor);
        DTO_TeamLoad teamLoadInformation = service.fetchTeamLoadInformation(teamAreaHandle, iterationHandle);
        TeamLoadInformation result = new TeamLoadInformation(teamLoadInformation, teamArea, (ItemArrayList<ICategory>)new ItemArrayList(categories), iteration);
        result.connect(monitor);
        return result;
    }

    private List<ICategory> findCategoriesWithoutUnassigned(ITeamAreaHandle teamAreaHandle, IProgressMonitor monitor, IWorkItemClient workItemClient) throws TeamRepositoryException {
        List categories = workItemClient.findCategoriesOfTeamArea2(teamAreaHandle, ICategory.DEFAULT_PROFILE, monitor);
        Iterator iter = categories.iterator();
        while (iter.hasNext()) {
            if (!((ICategory)iter.next()).isUnassigned()) continue;
            iter.remove();
        }
        return categories;
    }

    private TeamLoadInformation internalTeamLoadUpdate(TeamLoadInformation teamLoad, IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamRepository repository = PlanningClientPlugin.getTeamRepository((IItemHandle)teamLoad.getTeamArea());
        IWorkItemWorkingCopyManager workingCopyManager = PlanningClientPlugin.getWorkItemClient((IItemHandle)teamLoad.getTeamArea()).getWorkItemWorkingCopyManager();
        List<LoadItem> teamLoadItems = teamLoad.getLoadItems();
        ItemProfile profile = ItemProfile.createProfile((IItemType)IWorkItem.ITEM_TYPE, teamLoad.getRequiredProperties());
        for (LoadItem loadItem : teamLoadItems) {
            ArrayList<WorkItemChangeEvent> changes = new ArrayList<WorkItemChangeEvent>();
            for (UUID uuid : loadItem.getOpenItems()) {
                IWorkItemHandle handle = (IWorkItemHandle)IWorkItem.ITEM_TYPE.createItemHandle((Object)repository, uuid, null);
                boolean connected = workingCopyManager.connectLocal(handle, EMPTY_PROFILE);
                if (!connected) continue;
                WorkItemWorkingCopy workingCopy = workingCopyManager.getWorkingCopy(handle);
                boolean dirty = workingCopy.isDirty();
                workingCopyManager.disconnect(handle);
                if (!dirty) continue;
                workingCopyManager.connectCurrent(handle, profile, monitor);
                try {
                    ChangeDetails details;
                    IWorkItem modified = workingCopyManager.getWorkingCopy(handle).getWorkItem();
                    IWorkItem original = (IWorkItem)repository.itemManager().fetchPartialItem((IItemHandle)handle, 0, profile.getProperties(), monitor);
                    String[] dependents = new String[]{};
                    WorkItemChangeEvent event = new WorkItemChangeEvent(modified);
                    if (original.getOwner() != null && !original.getOwner().sameItemId((IItemHandle)modified.getOwner())) {
                        details = new ChangeDetails((Object)original.getOwner(), (Object)modified.getOwner());
                        event.addAttributeDetails(IWorkItem.OWNER_PROPERTY, dependents, (IAdaptable)details, 1);
                    } else if (original.getCategory() != null && !original.getCategory().sameItemId((IItemHandle)modified.getCategory())) {
                        details = new ChangeDetails((Object)original.getCategory(), (Object)modified.getCategory());
                        event.addAttributeDetails(IWorkItem.CATEGORY_PROPERTY, dependents, (IAdaptable)details, 1);
                    } else if (original.getTarget() != null && !original.getTarget().sameItemId((IItemHandle)modified.getTarget())) {
                        details = new ChangeDetails((Object)original.getTarget(), (Object)modified.getTarget());
                        event.addAttributeDetails(IWorkItem.TARGET_PROPERTY, dependents, (IAdaptable)details, 1);
                    } else if (original.getState2() != null && !original.getState2().equals((Object)modified.getState2())) {
                        details = new ChangeDetails((Object)original.getState2(), (Object)modified.getState2());
                        event.addAttributeDetails(IWorkItem.STATE_PROPERTY, dependents, (IAdaptable)details, 1);
                    } else if (original.getDuration() != modified.getDuration()) {
                        details = new ChangeDetails((Object)original.getDuration(), (Object)modified.getDuration());
                        event.addAttributeDetails(IWorkItem.DURATION_PROPERTY, dependents, (IAdaptable)details, 1);
                    } else if (((WorkItem)original).getTimeSpent() != ((WorkItem)modified).getTimeSpent()) {
                        details = new ChangeDetails((Object)((WorkItem)original).getTimeSpent(), (Object)((WorkItem)modified).getTimeSpent());
                        event.addAttributeDetails(WorkItem.TIME_SPENT_PROPERTY, dependents, (IAdaptable)details, 1);
                    } else if (((WorkItem)original).getCorrectedEstimate() != ((WorkItem)modified).getCorrectedEstimate()) {
                        details = new ChangeDetails((Object)((WorkItem)original).getCorrectedEstimate(), (Object)((WorkItem)modified).getCorrectedEstimate());
                        event.addAttributeDetails(WorkItem.CORRECTED_ESTIMATE_PROPERTY, dependents, (IAdaptable)details, 1);
                    }
                    changes.add(event);
                }
                finally {
                    workingCopyManager.disconnect(handle);
                }
            }
            for (WorkItemChangeEvent event : changes) {
                WorkItem workItem = (WorkItem)event.getWorkItem();
                IWorkflowInfo info = PlanningClientPlugin.getWorkItemClient((IItemHandle)workItem).findWorkflowInfo((IWorkItem)workItem, monitor);
                List<String> itemTypes = PlanningClientPlugin.getIterationPlanClient((IItemHandle)workItem).fetchTopLevelWorkItemTypes((IProcessAreaHandle)workItem.getProjectArea(), monitor);
                teamLoad.handleWorkItemEvent((IWorkItem)workItem, info, itemTypes, event);
            }
        }
        return teamLoad;
    }
}

