/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.client.teamload;

import com.ibm.team.apt.internal.client.teamload.LoadItem;
import com.ibm.team.apt.internal.client.teamload.Messages;
import com.ibm.team.apt.internal.common.Message;
import com.ibm.team.apt.internal.common.duration.TimeUnit;
import com.ibm.team.repository.common.util.NLS;

public class LoadItems {
    public static final Message MSG_NO_ESTIMATES = new Message(Messages.LoadItems_MESSAGE_NO_WORK_ESTIMATED, Message.Severity.Warning);
    public static final Message MSG_DEFAULT_WORK_ASSIGNMENT = new Message(Messages.LoadItems_MESSAGE_USING_DEFAULT_WORK_ASSIGNMENT, Message.Severity.Information);
    public static final Message MSG_NO_WORK_TIME = new Message(Messages.LoadItems_MESSAGE_NO_WORK_TIME_LEFT, Message.Severity.Information);
    private static final String STR_999_PLUS = Messages.LoadItems_999_PLUS;

    public static Message getMessage(LoadItem item) {
        if (item.getWorkTimeLeft() <= 0L) {
            return MSG_NO_WORK_TIME;
        }
        if (LoadItems.getQualityOfPlanning(item) == 0) {
            return MSG_NO_ESTIMATES;
        }
        return null;
    }

    public static boolean isOverbooked(LoadItem item) {
        return item.getWorkTimeLeft() < item.getSumOfEstimates();
    }

    public static int getHoursOverbooked(LoadItem item) {
        return Math.round((float)(item.getSumOfEstimates() - item.getWorkTimeLeft()) / (float)TimeUnit.HOURS.getDivisor());
    }

    public static int getQualityOfPlanning(LoadItem item) {
        if (item.getOpenItems().size() < item.getEstimatedItems().size()) {
            return 100;
        }
        if (item.getOpenItems().isEmpty()) {
            return 100;
        }
        return Math.round(100.0f * ((float)item.getEstimatedItems().size() / (float)item.getOpenItems().size()));
    }

    public static String getTextQualityOfPlanning(LoadItem item) {
        int value = LoadItems.getQualityOfPlanning(item);
        if (value < 33) {
            return Messages.LoadItems_QUALITY_POOR;
        }
        if (value >= 33 && value < 66) {
            return Messages.LoadItems_QUALITY_FAIR;
        }
        if (value >= 66 && value < 95) {
            return Messages.LoadItems_QUALITY_GOOD;
        }
        if (value >= 95) {
            return Messages.LoadItems_QUALITY_EXCELLENT;
        }
        return Messages.LoadItems_QUALITY_UNKNOWN;
    }

    public static String getTextWorkTimeLeft(LoadItem item) {
        long value = Math.round((double)item.getWorkTimeLeft() / TimeUnit.HOURS.getDivisor());
        return String.valueOf(value);
    }

    public static String getTextSumOfEstimates(LoadItem item) {
        long value = Math.round((double)item.getSumOfEstimates() / TimeUnit.HOURS.getDivisor());
        return String.valueOf(value);
    }

    public static String getTextEstimate(LoadItem item) {
        return NLS.bind((String)Messages.LoadItems_WORK_ESTIMATED, (Object[])new Object[]{LoadItems.getQualityOfPlanning(item)});
    }

    public static String getMaxTextEstimate() {
        return NLS.bind((String)Messages.LoadItems_WORK_ESTIMATED, (Object[])new Object[]{100});
    }

    public static String getTextAssignment(LoadItem item) {
        return NLS.bind((String)Messages.LoadItems_WORK_ASSIGNMENT, (Object[])new Object[]{item.getAssignment()});
    }

    public static String getTextHours(LoadItem item) {
        StringBuilder text = new StringBuilder();
        int hoursOverbooked = Math.round((float)(item.getWorkTimeLeft() - item.getSumOfEstimates()) / (float)TimeUnit.HOURS.getDivisor());
        if (Math.abs(hoursOverbooked) > 999) {
            text.append(STR_999_PLUS);
        } else {
            if (hoursOverbooked > 0) {
                text.append('+');
            }
            text.append(hoursOverbooked);
        }
        return NLS.bind((String)Messages.LoadItems_WORK_HOURS, (Object[])new Object[]{LoadItems.formatHours(item.getSumOfEstimates()), LoadItems.formatHours(item.getWorkTimeLeft()), text});
    }

    private static String formatHours(long value) {
        StringBuilder text = new StringBuilder();
        long hour = Math.round((double)value / TimeUnit.HOURS.getDivisor());
        if (hour == 0L) {
            if (value > 0L) {
                text.append('<');
                text.append(1);
            } else {
                text.append(0);
            }
        } else if (hour > 999L) {
            text.append(STR_999_PLUS);
        } else {
            text.append(hour);
        }
        return text.toString();
    }

    public static String getMaxTextHours() {
        return NLS.bind((String)Messages.LoadItems_WORK_HOURS, (Object[])new Object[]{STR_999_PLUS, STR_999_PLUS, STR_999_PLUS});
    }

    public static String getTextOpenClose(LoadItem item) {
        int closeCount = item.getClosedItems().size();
        int openCount = item.getOpenItems().size();
        return NLS.bind((String)Messages.LoadItems_OPEN_CLOSED_COUNT, (Object[])new Object[]{closeCount > 999 ? STR_999_PLUS : Integer.valueOf(closeCount), openCount > 999 ? STR_999_PLUS : Integer.valueOf(openCount)});
    }
}

