/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.client.teamload;

import com.ibm.team.apt.internal.client.IIterationPlanClient;
import com.ibm.team.apt.internal.client.ILoadListener;
import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.client.resource.IContributorInfo;
import com.ibm.team.apt.internal.client.resource.IResourcePlanningListener;
import com.ibm.team.apt.internal.client.resource.ResourcePlanningEvent;
import com.ibm.team.apt.internal.client.resource.ResourcePlanningManager;
import com.ibm.team.apt.internal.client.teamload.ILoadItemCreator;
import com.ibm.team.apt.internal.client.teamload.LoadItem;
import com.ibm.team.apt.internal.client.teamload.Messages;
import com.ibm.team.apt.internal.client.teamload.ResourceDelta;
import com.ibm.team.apt.internal.client.teamload.TeamLoadDelta;
import com.ibm.team.apt.internal.client.util.WorkItems;
import com.ibm.team.apt.internal.common.util.CMode;
import com.ibm.team.apt.internal.common.util.ItemArrayList;
import com.ibm.team.apt.internal.common.util.ItemCollection;
import com.ibm.team.apt.internal.common.util.ItemHashMap;
import com.ibm.team.apt.internal.common.util.ItemList;
import com.ibm.team.apt.internal.common.util.ItemMap;
import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.IWorkItemListener;
import com.ibm.team.workitem.client.IWorkItemWorkingCopyManager;
import com.ibm.team.workitem.client.IWorkingCopyListener;
import com.ibm.team.workitem.client.WorkItemChangeEvent;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.client.WorkingCopyEvent;
import com.ibm.team.workitem.common.internal.model.WorkItem;
import com.ibm.team.workitem.common.model.ChangeDetails;
import com.ibm.team.workitem.common.model.ICategory;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.common.workflow.IWorkflowInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LoadInformation {
    public static final Collection<String> DEFAULT_PROPERTIES = Arrays.asList(IWorkItem.PROJECT_AREA_PROPERTY, IWorkItem.TARGET_PROPERTY, IWorkItem.OWNER_PROPERTY, IWorkItem.CATEGORY_PROPERTY, IWorkItem.STATE_PROPERTY, IWorkItem.TYPE_PROPERTY, WorkItem.TIME_SPENT_PROPERTY, WorkItem.CORRECTED_ESTIMATE_PROPERTY);
    private AttributeChangeHandler fAttributeChangeHandler = new AttributeChangeHandler();
    private InternalResourcePlanningListener fResourcePlanningListener = new InternalResourcePlanningListener();
    private State fState;
    private Mode fMode;
    private InternalListener fChangeListener = new InternalListener();
    private ListenerList fListener = new ListenerList();
    private ItemMap<IContributor, LoadItem> fLoadItems = new ItemHashMap();
    private List<TeamLoadDelta> fUndoableDeltas = new LinkedList<TeamLoadDelta>();
    private ItemList<IIteration> fIterations;
    private ItemList<ICategory> fCategories;

    public LoadInformation(ItemCollection<? extends IIteration> iterations, ItemCollection<? extends ICategory> categories) {
        Assert.isTrue((!iterations.isEmpty() ? 1 : 0) != 0);
        this.fCategories = new ItemArrayList(categories, CMode.CURRENT_HANDLEONLY);
        this.fIterations = new ItemArrayList(iterations, CMode.CURRENT_HANDLEONLY);
        IItemHandle itemHandle = (IItemHandle)this.fIterations.get(0);
        IWorkItemWorkingCopyManager workItemManager = PlanningClientPlugin.getWorkItemClient(itemHandle).getWorkItemWorkingCopyManager();
        workItemManager.addWorkingCopyListener((IWorkingCopyListener)this.fChangeListener);
        workItemManager.addWorkItemListener((IWorkItemListener)this.fChangeListener);
        ResourcePlanningManager resourcePlanningManager = PlanningClientPlugin.getResourcePlanningManager(itemHandle);
        resourcePlanningManager.addResourceListener(this.fResourcePlanningListener);
    }

    public void connect(IProgressMonitor monitor) throws TeamRepositoryException {
        ILoadItemCreator creator = this.getItemCreator();
        Assert.isNotNull((Object)creator);
        ArrayList<LoadItem> list = new ArrayList<LoadItem>();
        if (this.safeCreateItems(monitor, list)) {
            for (LoadItem item : list) {
                this.fLoadItems.put((IItemHandle)item.getContributor(), (Object)item);
            }
            this.fState = State.CONNECTED;
        }
    }

    private boolean safeCreateItems(final IProgressMonitor monitor, final List<LoadItem> loadItems) {
        final boolean[] success = new boolean[1];
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void run() throws Exception {
                loadItems.addAll(LoadInformation.this.getItemCreator().createItems(monitor));
                success[0] = true;
            }

            public void handleException(Throwable exception) {
                PlanningClientPlugin.log(exception);
                LoadInformation.this.disconnect();
                success[0] = false;
            }
        });
        return success[0];
    }

    public void disconnect() {
        this.fLoadItems.clear();
        this.fState = State.DISCONNECTED;
    }

    public void dispose() {
        IWorkItemWorkingCopyManager workItemManager = this.getWorkItemWorkingCopyManager();
        workItemManager.removeWorkItemListener((IWorkItemListener)this.fChangeListener);
        workItemManager.removeWorkingCopyListener((IWorkingCopyListener)this.fChangeListener);
        IItemHandle itemHandle = (IItemHandle)this.fIterations.get(0);
        ResourcePlanningManager resourcePlanningManager = PlanningClientPlugin.getResourcePlanningManager(itemHandle);
        resourcePlanningManager.removeResourceListener(this.fResourcePlanningListener);
        this.fListener.clear();
    }

    public abstract ILoadItemCreator getItemCreator();

    public abstract IProjectAreaHandle getProjectArea();

    public abstract IItemManager getItemManager();

    public abstract IWorkItemWorkingCopyManager getWorkItemWorkingCopyManager();

    public void setMode(Mode mode) {
        this.fMode = mode;
    }

    public Mode getMode() {
        return this.fMode;
    }

    public List<ICategory> getCategories() {
        return this.fCategories.toList();
    }

    public List<IIteration> getIterations() {
        return this.fIterations.toList();
    }

    public LoadItem getLoadItem(IContributorHandle handle) {
        return (LoadItem)this.fLoadItems.get((IItemHandle)handle);
    }

    public List<LoadItem> getLoadItems() {
        return Collections.unmodifiableList(new ArrayList(this.fLoadItems.values().toCollection()));
    }

    public void addTeamLoadListener(ILoadListener listener) {
        this.fListener.add((Object)listener);
    }

    public void removeTeamLoadListener(ILoadListener listener) {
        this.fListener.remove((Object)listener);
    }

    protected void fireTeamLoadEvent(LoadItem item) {
        Object[] listeners;
        Object[] objectArray = listeners = this.fListener.getListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((ILoadListener)listener).loadItemChanged(item);
            ++n2;
        }
    }

    List<TeamLoadDelta> getDeltas() {
        return Collections.unmodifiableList(this.fUndoableDeltas);
    }

    void applyDeltas(List<TeamLoadDelta> updates) {
        for (TeamLoadDelta delta : updates) {
            LoadItem item = (LoadItem)this.fLoadItems.get((IItemHandle)delta.getItem().getContributor());
            if (item == null) continue;
            delta = delta.adopt(item);
            delta.apply();
            this.fUndoableDeltas.add(delta);
        }
    }

    void handleWorkItemEvent(IWorkItem workItem, IWorkflowInfo info, List<String> topLevelWorkItemTypes, WorkItemChangeEvent event) {
        ArrayList<TeamLoadDelta> deltas = new ArrayList<TeamLoadDelta>(3);
        LoadItem item = this.known(workItem);
        if (item != null) {
            if (event.affects(IWorkItem.TYPE_PROPERTY) || event.affects(IWorkItem.DURATION_PROPERTY) || event.affects(WorkItem.TIME_SPENT_PROPERTY) || event.affects(WorkItem.CORRECTED_ESTIMATE_PROPERTY)) {
                Long newEstimate;
                Long oldEstimate = ((WorkItem)workItem).getCorrectedEstimate();
                if (oldEstimate < 0L) {
                    oldEstimate = workItem.getDuration();
                }
                if ((newEstimate = Long.valueOf(((WorkItem)workItem).getCorrectedEstimate())) < 0L) {
                    newEstimate = workItem.getDuration();
                }
                Long oldTimeSpent = ((WorkItem)workItem).getTimeSpent();
                Long newTimeSpent = ((WorkItem)workItem).getTimeSpent();
                if (!topLevelWorkItemTypes.contains(workItem.getWorkItemType())) {
                    if (event.affects(IWorkItem.DURATION_PROPERTY) && ((WorkItem)workItem).getCorrectedEstimate() < 0L) {
                        oldEstimate = (Long)this.oldValue(event, IWorkItem.DURATION_PROPERTY);
                        newEstimate = (Long)this.newValue(event, IWorkItem.DURATION_PROPERTY);
                    }
                    if (event.affects(WorkItem.CORRECTED_ESTIMATE_PROPERTY)) {
                        oldEstimate = (Long)this.oldValue(event, WorkItem.CORRECTED_ESTIMATE_PROPERTY);
                        if (oldEstimate < 0L) {
                            oldEstimate = workItem.getDuration();
                        }
                        if ((newEstimate = (Long)this.newValue(event, WorkItem.CORRECTED_ESTIMATE_PROPERTY)) < 0L) {
                            newEstimate = workItem.getDuration();
                        }
                    }
                    if (event.affects(WorkItem.TIME_SPENT_PROPERTY)) {
                        oldTimeSpent = (Long)this.oldValue(event, WorkItem.TIME_SPENT_PROPERTY);
                        newTimeSpent = (Long)this.newValue(event, WorkItem.TIME_SPENT_PROPERTY);
                    }
                }
                if (event.affects(IWorkItem.TYPE_PROPERTY)) {
                    String oldType = (String)this.oldValue(event, IWorkItem.TYPE_PROPERTY);
                    String newType = (String)this.newValue(event, IWorkItem.TYPE_PROPERTY);
                    if (topLevelWorkItemTypes.contains(oldType) ^ topLevelWorkItemTypes.contains(newType)) {
                        if (topLevelWorkItemTypes.contains(oldType)) {
                            oldEstimate = 0L;
                        } else {
                            newEstimate = 0L;
                        }
                    }
                }
                deltas.add(TeamLoadDelta.updateSumOfEstimates(item, workItem, oldEstimate, newEstimate, oldTimeSpent, newTimeSpent));
            }
            if (this.matches(workItem, info)) {
                if (event.affects(IWorkItem.OWNER_PROPERTY)) {
                    IContributorHandle newValue;
                    IContributorHandle oldValue = (IContributorHandle)this.oldValue(event, IWorkItem.OWNER_PROPERTY);
                    if (oldValue != null && this.fLoadItems.containsKey((IItemHandle)oldValue)) {
                        deltas.add(TeamLoadDelta.remove((LoadItem)this.fLoadItems.get((IItemHandle)oldValue), workItem, info));
                    }
                    if ((newValue = (IContributorHandle)this.newValue(event, IWorkItem.OWNER_PROPERTY)) != null && this.fLoadItems.containsKey((IItemHandle)newValue)) {
                        deltas.add(TeamLoadDelta.add((LoadItem)this.fLoadItems.get((IItemHandle)newValue), workItem));
                    }
                }
            } else {
                deltas.add(TeamLoadDelta.remove(item, workItem, info));
            }
        } else if (this.matches(workItem, info)) {
            item = (LoadItem)this.fLoadItems.get((IItemHandle)workItem.getOwner());
            deltas.add(TeamLoadDelta.add(item, workItem));
        }
        this.fireChangeEvents(deltas);
    }

    private void fireChangeEvents(List<TeamLoadDelta> deltas) {
        for (TeamLoadDelta delta : deltas) {
            delta.apply();
            this.fUndoableDeltas.add(delta);
            this.fireTeamLoadEvent(delta.getItem());
        }
    }

    public Collection<String> getRequiredProperties() {
        return DEFAULT_PROPERTIES;
    }

    protected LoadItem known(IWorkItem workItem) {
        ItemCollection items = this.fLoadItems.values();
        for (LoadItem item : items) {
            if (!item.getOpenItems().contains(workItem.getItemId())) continue;
            return item;
        }
        return null;
    }

    protected boolean matches(IWorkItem workItem, IWorkflowInfo info) {
        return this.inTeam(workItem) && this.isTarget(workItem) && this.inCategory(workItem) && !WorkItems.isResolved(workItem, info);
    }

    protected boolean inTeam(IWorkItem workItem) {
        return workItem.getOwner() != null && this.fLoadItems.containsKey((IItemHandle)workItem.getOwner());
    }

    protected boolean isTarget(IWorkItem workItem) {
        return workItem.getTarget() != null && this.fIterations.contains((Object)workItem.getTarget());
    }

    protected boolean inCategory(IWorkItem workItem) {
        return this.fCategories.isEmpty() || workItem.getCategory() != null && this.fCategories.contains((Object)workItem.getCategory());
    }

    private <T> T oldValue(WorkItemChangeEvent event, String attribute) {
        ChangeDetails change = (ChangeDetails)event.getAttributeChangeDetails(attribute, ChangeDetails.class);
        if (change == null) {
            return null;
        }
        return (T)change.getOldValue();
    }

    private <T> T newValue(WorkItemChangeEvent event, String attribute) {
        ChangeDetails change = (ChangeDetails)event.getAttributeChangeDetails(attribute, ChangeDetails.class);
        if (change == null) {
            return null;
        }
        return (T)change.getNewValue();
    }

    private final class AttributeChangeHandler
    extends FoundationJob {
        private final ISchedulingRule RULE;
        private static final int TIME_OUT = 1500;
        private LinkedBlockingQueue<WorkItemChangeEvent> fQueue;

        private AttributeChangeHandler() {
            super(Messages.LoadInformation_JOB_TITLE_ATTRIBUTE_CHANGE_HANDLE);
            this.RULE = new ExclusiveRule();
            this.fQueue = new LinkedBlockingQueue();
            this.setSystem(true);
            this.setRule(this.RULE);
        }

        public void post(WorkItemChangeEvent event) {
            this.fQueue.add(event);
            this.schedule();
        }

        public boolean shouldRun() {
            return !this.fQueue.isEmpty();
        }

        protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
            Assert.isTrue((!this.fQueue.isEmpty() ? 1 : 0) != 0);
            while (!this.fQueue.isEmpty()) {
                WorkItemChangeEvent event = this.fQueue.poll(1500L, TimeUnit.MILLISECONDS);
                if (event == null) continue;
                IWorkItem workItem = event.getWorkItem();
                IIterationPlanClient iterationPlanClient = PlanningClientPlugin.getIterationPlanClient((IItemHandle)workItem);
                IWorkItemClient workItemClient = PlanningClientPlugin.getWorkItemClient((IItemHandle)workItem);
                IWorkItemWorkingCopyManager manager = workItemClient.getWorkItemWorkingCopyManager();
                IWorkflowInfo info = workItemClient.findWorkflowInfo(workItem, monitor);
                ItemProfile profile = ItemProfile.createProfile((IItemType)IWorkItem.ITEM_TYPE, LoadInformation.this.getRequiredProperties());
                try {
                    manager.connect((IWorkItemHandle)workItem, profile, monitor);
                    try {
                        List<String> topLevelWorkItemTypes = iterationPlanClient.fetchTopLevelWorkItemTypes((IProcessAreaHandle)workItem.getProjectArea(), monitor);
                        WorkItemWorkingCopy workingCopy = manager.getWorkingCopy((IWorkItemHandle)workItem);
                        LoadInformation.this.handleWorkItemEvent(workingCopy.getWorkItem(), info, topLevelWorkItemTypes, event);
                    }
                    finally {
                        manager.disconnect((IWorkItemHandle)workItem);
                    }
                }
                catch (ItemNotFoundException itemNotFoundException) {}
            }
            return Status.OK_STATUS;
        }
    }

    private final class ExclusiveRule
    implements ISchedulingRule {
        private ExclusiveRule() {
        }

        public boolean contains(ISchedulingRule rule) {
            return rule instanceof ExclusiveRule;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return rule instanceof ExclusiveRule;
        }
    }

    private class InternalListener
    implements IWorkItemListener,
    IWorkingCopyListener {
        private InternalListener() {
        }

        public void workingCopyEvent(WorkingCopyEvent event) {
            WorkItemWorkingCopy workingCopy = event.getSource();
            IWorkItem workItem = workingCopy.getWorkItem();
            ArrayList deltas = new ArrayList(LoadInformation.this.fUndoableDeltas);
            if (workingCopy.isDirty() && "aboutToBeDisposed".equals(event.getType())) {
                Collections.reverse(deltas);
                Iterator iter = deltas.iterator();
                while (iter.hasNext()) {
                    TeamLoadDelta delta = (TeamLoadDelta)iter.next();
                    if (workItem.sameItemId((IItemHandle)delta.getWorkItem())) {
                        delta.undo();
                        LoadInformation.this.fireTeamLoadEvent(delta.getItem());
                        continue;
                    }
                    iter.remove();
                }
                LoadInformation.this.fUndoableDeltas.removeAll(deltas);
            } else if ("saved".equals(event.getType())) {
                Iterator iter = deltas.iterator();
                while (iter.hasNext()) {
                    TeamLoadDelta delta = (TeamLoadDelta)iter.next();
                    if (workItem.sameItemId((IItemHandle)delta.getWorkItem())) continue;
                    iter.remove();
                }
                LoadInformation.this.fUndoableDeltas.removeAll(deltas);
            }
        }

        public void workItemAttributeChanged(WorkItemChangeEvent event) {
            LoadInformation.this.fAttributeChangeHandler.post(event);
        }

        public void workItemAttributeDependencyChanged(WorkItemChangeEvent event) {
        }
    }

    private class InternalResourcePlanningListener
    implements IResourcePlanningListener {
        private InternalResourcePlanningListener() {
        }

        public void resourceNotification(ResourcePlanningEvent event) {
            if (LoadInformation.this.fState != State.CONNECTED) {
                return;
            }
            if (event.getType() != 2) {
                return;
            }
            if (!(event.getInfo() instanceof IContributorInfo)) {
                return;
            }
            IContributorInfo info = (IContributorInfo)event.getInfo();
            ItemArrayList contributors = new ItemArrayList(CMode.CURRENT_HANDLEONLY);
            contributors.addAll(info.getContributors());
            contributors.retainAll((ItemCollection)LoadInformation.this.fLoadItems.keySet());
            if (contributors.isEmpty()) {
                return;
            }
            FoundationJob job = new FoundationJob(Messages.LoadInformation_JOB_TITLE_UPDATING){

                protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                    if (LoadInformation.this.fState != State.CONNECTED) {
                        return Status.CANCEL_STATUS;
                    }
                    ArrayList loadItems = new ArrayList();
                    boolean success = LoadInformation.this.safeCreateItems(monitor, loadItems);
                    if (!success) {
                        return Status.CANCEL_STATUS;
                    }
                    for (LoadItem newLoadItem : loadItems) {
                        IContributor contributor = newLoadItem.getContributor();
                        LoadItem loadItem = (LoadItem)LoadInformation.this.fLoadItems.get((IItemHandle)contributor);
                        ResourceDelta delta = ResourceDelta.newResourceInformation(newLoadItem);
                        loadItem.deltaApply(delta);
                        LoadInformation.this.fireTeamLoadEvent(loadItem);
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.setRule((ISchedulingRule)new ExclusiveRule());
            job.schedule();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        TIME,
        COUNT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        CONNECTED,
        DISCONNECTED;

    }
}

