/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.client.teamload;

import com.ibm.team.apt.common.resource.IContributorAbsence;
import com.ibm.team.apt.internal.client.teamload.LoadItem;
import com.ibm.team.apt.internal.common.util.ItemArrayList;
import com.ibm.team.apt.internal.common.util.ItemCollection;
import com.ibm.team.repository.common.UUID;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeLoadItem
extends LoadItem {
    private List<LoadItem> fLoadItems;

    public CompositeLoadItem(LoadItem first, LoadItem ... rest) {
        super(first.getLoadInformation(), first.getContributor(), (ItemCollection<IContributorAbsence>)new ItemArrayList(first.getAbsences()), first.getWorkTimeLeft(), CompositeLoadItem.assignment(first, rest), CompositeLoadItem.defaultAssignment(first, rest), first.usesDefaultWorkLocation(), -1L, null, null, null);
        this.fLoadItems = new ArrayList<LoadItem>(1 + rest.length);
        this.fLoadItems.add(first);
        this.fLoadItems.addAll((Collection<LoadItem>)Arrays.asList(rest));
    }

    private static int assignment(LoadItem first, LoadItem ... rest) {
        int result = first.getAssignment();
        LoadItem[] loadItemArray = rest;
        int n = rest.length;
        int n2 = 0;
        while (n2 < n) {
            LoadItem item = loadItemArray[n2];
            result += item.getAssignment();
            ++n2;
        }
        return Math.min(100, result);
    }

    private static boolean defaultAssignment(LoadItem first, LoadItem ... rest) {
        boolean result = first.usesDefaultWorkAssignment();
        LoadItem[] loadItemArray = rest;
        int n = rest.length;
        int n2 = 0;
        while (n2 < n) {
            LoadItem item = loadItemArray[n2];
            result &= item.usesDefaultWorkAssignment();
            ++n2;
        }
        return result;
    }

    @Override
    public Set<UUID> getOpenItems() {
        HashSet<UUID> result = new HashSet<UUID>();
        for (LoadItem loadItem : this.fLoadItems) {
            result.addAll(loadItem.getOpenItems());
        }
        return result;
    }

    @Override
    public Set<UUID> getEstimatedItems() {
        HashSet<UUID> result = new HashSet<UUID>();
        for (LoadItem loadItem : this.fLoadItems) {
            result.addAll(loadItem.getEstimatedItems());
        }
        return result;
    }

    @Override
    public Set<UUID> getClosedItems() {
        HashSet<UUID> result = new HashSet<UUID>();
        for (LoadItem loadItem : this.fLoadItems) {
            result.addAll(loadItem.getClosedItems());
        }
        return result;
    }

    @Override
    public long getSumOfEstimates() {
        long result = 0L;
        for (LoadItem loadItem : this.fLoadItems) {
            result += loadItem.getSumOfEstimates();
        }
        return result;
    }

    @Override
    public long getWorkTimeLeft() {
        long result = -1L;
        for (LoadItem loadItem : this.fLoadItems) {
            long workTimeLeft = loadItem.getWorkTimeLeft();
            if (workTimeLeft <= 0L || result != -1L && workTimeLeft >= result) continue;
            result = workTimeLeft;
        }
        return Math.max(0L, result);
    }
}

