/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.client.resource;

import com.ibm.team.apt.common.resource.IContributorAbsence;
import com.ibm.team.apt.common.resource.IContributorAbsenceHandle;
import com.ibm.team.apt.common.resource.IContributorResourceDetails;
import com.ibm.team.apt.common.resource.IResourcePlanningService;
import com.ibm.team.apt.common.resource.IWorkLocationDefinition;
import com.ibm.team.apt.common.resource.IWorkResourceDetails;
import com.ibm.team.apt.common.resource.IWorkResourceDetailsHandle;
import com.ibm.team.apt.common.resource.ResourcePlanningUtils;
import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.client.resource.IResourcePlanningClient;
import com.ibm.team.apt.internal.client.resource.OperationStatus;
import com.ibm.team.apt.internal.client.resource.ResourcePlanningManager;
import com.ibm.team.apt.internal.common.resource.dto.DTO_ContributorInfo;
import com.ibm.team.apt.internal.common.resource.dto.DTO_TeamInfo;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.process.common.advice.TeamOperationCanceledException;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Locale;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ResourcePlanningClient
implements IResourcePlanningClient {
    private final IClientLibraryContext fContext;
    private ResourcePlanningManager fManager;

    ResourcePlanningClient(IClientLibraryContext context) {
        Assert.isNotNull((Object)context);
        this.fContext = context;
    }

    @Override
    public boolean checkWritePermissions(final IContributorHandle contributor, IProgressMonitor monitor) {
        Assert.isNotNull((Object)contributor);
        try {
            return (Boolean)this.fContext.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<Boolean>(){

                public Boolean run(IProgressMonitor progress) throws TeamRepositoryException {
                    IResourcePlanningService service = (IResourcePlanningService)ResourcePlanningClient.this.fContext.getServiceInterface(IResourcePlanningService.class);
                    return service.checkWritePermissions(contributor);
                }
            }, monitor);
        }
        catch (TeamRepositoryException exception) {
            PlanningClientPlugin.log(exception);
            return false;
        }
    }

    @Override
    public OperationStatus<IContributorAbsenceHandle> deleteAbsences(final IContributorAbsenceHandle[] absences, IProgressMonitor monitor) throws TeamRepositoryException {
        Assert.isNotNull((Object)absences);
        return (OperationStatus)this.fContext.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<OperationStatus<IContributorAbsenceHandle>>(){

            public OperationStatus<IContributorAbsenceHandle> run(IProgressMonitor progress) throws TeamRepositoryException {
                IResourcePlanningService service = (IResourcePlanningService)ResourcePlanningClient.this.fContext.getServiceInterface(IResourcePlanningService.class);
                try {
                    IContributorAbsenceHandle[] deleted = service.deleteAbsences(absences);
                    ResourcePlanningClient.this.fContext.teamRepository().itemManager().applyItemDeletes(Arrays.asList(deleted));
                    return new OperationStatus<IContributorAbsenceHandle>(deleted);
                }
                catch (TeamOperationCanceledException exception) {
                    return new OperationStatus<IContributorAbsenceHandle>((IStatus)new Status(4, PlanningClientPlugin.getPluginId(), exception.getLocalizedMessage(), (Throwable)exception), null, absences);
                }
            }
        }, monitor);
    }

    @Override
    public OperationStatus<IWorkResourceDetailsHandle> deleteWorkDetails(final IWorkResourceDetailsHandle[] details, IProgressMonitor monitor) throws TeamRepositoryException {
        Assert.isNotNull((Object)details);
        return (OperationStatus)this.fContext.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<OperationStatus<IWorkResourceDetailsHandle>>(){

            public OperationStatus<IWorkResourceDetailsHandle> run(IProgressMonitor progress) throws TeamRepositoryException {
                IResourcePlanningService service = (IResourcePlanningService)ResourcePlanningClient.this.fContext.getServiceInterface(IResourcePlanningService.class);
                try {
                    IWorkResourceDetailsHandle[] deleted = service.deleteWorkDetails(details);
                    ResourcePlanningClient.this.fContext.teamRepository().itemManager().applyItemDeletes(Arrays.asList(deleted));
                    return new OperationStatus<IWorkResourceDetailsHandle>(deleted);
                }
                catch (TeamOperationCanceledException exception) {
                    return new OperationStatus<IWorkResourceDetailsHandle>((IStatus)new Status(4, PlanningClientPlugin.getPluginId(), exception.getLocalizedMessage(), (Throwable)exception), null, details);
                }
            }
        }, monitor);
    }

    DTO_ContributorInfo[] fetchContributorInfo(final IContributorHandle[] contributors, final Timestamp start, final Timestamp end, final boolean synchronize, IProgressMonitor monitor) throws TeamRepositoryException {
        Assert.isNotNull((Object)contributors);
        return (DTO_ContributorInfo[])this.fContext.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<DTO_ContributorInfo[]>(){

            public DTO_ContributorInfo[] run(IProgressMonitor progress) throws TeamRepositoryException {
                IResourcePlanningService service = (IResourcePlanningService)ResourcePlanningClient.this.fContext.getServiceInterface(IResourcePlanningService.class);
                DTO_ContributorInfo[] infos = service.fetchContributorInfo(contributors, start, end, synchronize);
                Timestamp stamp = new Timestamp(System.currentTimeMillis());
                DTO_ContributorInfo[] dTO_ContributorInfoArray = infos;
                int n = infos.length;
                int n2 = 0;
                while (n2 < n) {
                    DTO_ContributorInfo info = dTO_ContributorInfoArray[n2];
                    info.setTimeStamp(stamp);
                    ++n2;
                }
                return infos;
            }
        }, monitor);
    }

    DTO_TeamInfo[] fetchTeamInfo(final ITeamAreaHandle[] areas, final Timestamp start, final Timestamp end, final boolean synchronize, IProgressMonitor monitor) throws TeamRepositoryException {
        Assert.isNotNull((Object)areas);
        return (DTO_TeamInfo[])this.fContext.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<DTO_TeamInfo[]>(){

            public DTO_TeamInfo[] run(IProgressMonitor progress) throws TeamRepositoryException {
                IResourcePlanningService service = (IResourcePlanningService)ResourcePlanningClient.this.fContext.getServiceInterface(IResourcePlanningService.class);
                DTO_TeamInfo[] infos = service.fetchTeamInfo(areas, start, end, synchronize);
                Timestamp stamp = new Timestamp(System.currentTimeMillis());
                DTO_TeamInfo[] dTO_TeamInfoArray = infos;
                int n = infos.length;
                int n2 = 0;
                while (n2 < n) {
                    DTO_TeamInfo info = dTO_TeamInfoArray[n2];
                    for (DTO_ContributorInfo contributor : info.getContributorInfos()) {
                        contributor.setTimeStamp(stamp);
                    }
                    ++n2;
                }
                return infos;
            }
        }, monitor);
    }

    @Override
    public synchronized ResourcePlanningManager getResourcePlanningManager() {
        if (this.fManager == null) {
            this.fManager = new ResourcePlanningManager(this);
        }
        return this.fManager;
    }

    ITeamRepository getTeamRepository() {
        return this.fContext.teamRepository();
    }

    @Override
    public IWorkLocationDefinition getWorkLocation(final IProcessAreaHandle area, IProgressMonitor monitor) throws TeamRepositoryException {
        Assert.isNotNull((Object)area);
        return (IWorkLocationDefinition)this.fContext.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<IWorkLocationDefinition>(){

            public IWorkLocationDefinition run(IProgressMonitor progress) throws TeamRepositoryException {
                IResourcePlanningService service = (IResourcePlanningService)ResourcePlanningClient.this.fContext.getServiceInterface(IResourcePlanningService.class);
                IWorkLocationDefinition definition = service.findWorkLocation(area);
                if (definition == null) {
                    definition = ResourcePlanningUtils.createWorkLocation((int)5, (int)8, (Locale)Locale.getDefault());
                }
                return definition;
            }
        }, monitor);
    }

    @Override
    public OperationStatus<IContributorAbsence> saveAbsences(final IContributorAbsence[] workingCopies, IProgressMonitor monitor) throws TeamRepositoryException {
        Assert.isNotNull((Object)workingCopies);
        return (OperationStatus)this.fContext.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<OperationStatus<IContributorAbsence>>(){

            public OperationStatus<IContributorAbsence> run(IProgressMonitor progress) throws TeamRepositoryException {
                IResourcePlanningService service = (IResourcePlanningService)ResourcePlanningClient.this.fContext.getServiceInterface(IResourcePlanningService.class);
                try {
                    IContributorAbsence[] saved = service.saveAbsences(workingCopies);
                    ResourcePlanningClient.this.fContext.teamRepository().itemManager().applyItemUpdates(Arrays.asList(saved));
                    return new OperationStatus<IContributorAbsence>(saved);
                }
                catch (TeamOperationCanceledException exception) {
                    return new OperationStatus<IContributorAbsence>((IStatus)new Status(4, PlanningClientPlugin.getPluginId(), exception.getLocalizedMessage(), (Throwable)exception), null, workingCopies);
                }
            }
        }, monitor);
    }

    @Override
    public OperationStatus<IContributorResourceDetails> saveContributorDetails(final IContributorResourceDetails workingCopy, IProgressMonitor monitor) throws TeamRepositoryException {
        Assert.isNotNull((Object)workingCopy);
        return (OperationStatus)this.fContext.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<OperationStatus<IContributorResourceDetails>>(){

            public OperationStatus<IContributorResourceDetails> run(IProgressMonitor progress) throws TeamRepositoryException {
                IResourcePlanningService service = (IResourcePlanningService)ResourcePlanningClient.this.fContext.getServiceInterface(IResourcePlanningService.class);
                try {
                    IContributorResourceDetails saved = service.saveResourceDetails(workingCopy);
                    ResourcePlanningClient.this.fContext.teamRepository().itemManager().applyItemUpdates(Arrays.asList(saved));
                    return new OperationStatus<IContributorResourceDetails>(saved);
                }
                catch (TeamOperationCanceledException exception) {
                    return new OperationStatus<IContributorResourceDetails>((IStatus)new Status(4, PlanningClientPlugin.getPluginId(), exception.getLocalizedMessage(), (Throwable)exception), null, workingCopy);
                }
            }
        }, monitor);
    }

    @Override
    public OperationStatus<IWorkResourceDetails> saveWorkDetails(final IWorkResourceDetails[] workingCopies, IProgressMonitor monitor) throws TeamRepositoryException {
        Assert.isNotNull((Object)workingCopies);
        return (OperationStatus)this.fContext.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<OperationStatus<IWorkResourceDetails>>(){

            public OperationStatus<IWorkResourceDetails> run(IProgressMonitor progress) throws TeamRepositoryException {
                IResourcePlanningService service = (IResourcePlanningService)ResourcePlanningClient.this.fContext.getServiceInterface(IResourcePlanningService.class);
                try {
                    IWorkResourceDetails[] saved = service.saveWorkDetails(workingCopies);
                    ResourcePlanningClient.this.fContext.teamRepository().itemManager().applyItemUpdates(Arrays.asList(saved));
                    return new OperationStatus<IWorkResourceDetails>(saved);
                }
                catch (TeamOperationCanceledException exception) {
                    return new OperationStatus<IWorkResourceDetails>((IStatus)new Status(4, PlanningClientPlugin.getPluginId(), exception.getLocalizedMessage(), (Throwable)exception), null, workingCopies);
                }
            }
        }, monitor);
    }
}

