/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.client.problems;

import com.ibm.team.apt.internal.client.IPlanAttributeDelta;
import com.ibm.team.apt.internal.client.IPlanElementChangeEvent;
import com.ibm.team.apt.internal.client.IPlanElementDelta;
import com.ibm.team.apt.internal.client.IPlanElementDeltaVisitor;
import com.ibm.team.apt.internal.client.IPlanElementListener;
import com.ibm.team.apt.internal.client.PlanElement;
import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.client.ResolvedPlan;
import com.ibm.team.apt.internal.client.problems.HierarchicalPlanElementCheck;
import com.ibm.team.apt.internal.client.problems.IProblemReportAcceptor;
import com.ibm.team.apt.internal.client.problems.InvalidEstimateCheck;
import com.ibm.team.apt.internal.client.problems.Messages;
import com.ibm.team.apt.internal.client.problems.PlanItemCheck;
import com.ibm.team.apt.internal.client.problems.PlanItemProblemReport;
import com.ibm.team.apt.internal.client.problems.PlanProblemReport;
import com.ibm.team.apt.internal.client.problems.RequiredAttributeCheck;
import com.ibm.team.apt.internal.client.problems.SchedulingCheck;
import com.ibm.team.apt.internal.common.util.IEventCondition;
import com.ibm.team.apt.internal.common.util.SimpleEventCondition;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.ProgressMonitorWrapper;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProblemChecker {
    private ResolvedPlan fPlan;
    private IPlanElementListener fListener;
    private IProblemReportAcceptor fAcceptor;
    private ProblemDetectionQueue fQueue;
    private volatile boolean fCancelled;

    public ProblemChecker(ResolvedPlan plan, IProblemReportAcceptor acceptor) {
        this.fPlan = plan;
        this.fAcceptor = acceptor;
        this.fListener = new IPlanElementListener(){

            public void planElementChanged(IPlanElementChangeEvent event) {
                if (ProblemChecker.this.fCancelled) {
                    return;
                }
                IPlanElementDelta delta = event.getDelta();
                if (ProblemChecker.this.isRelevantForProblemChecker(delta)) {
                    ProblemChecker.this.run(delta);
                }
            }
        };
        this.fPlan.addListener(this.fListener);
    }

    public void dispose() {
        this.fPlan.removeListener(this.fListener);
        this.fPlan = null;
        this.fListener = null;
        this.fAcceptor = null;
    }

    private void acceptProblemReport(PlanProblemReport report) {
        this.fAcceptor.accept(report);
    }

    public synchronized void run(IPlanElementDelta delta) {
        this.run(new DeltaCheckRun(delta));
    }

    public synchronized void run(Collection<? extends PlanItem> items) {
        this.run(new ItemCheckRun(items));
    }

    public synchronized void run(List<? extends HierarchicalPlanElementCheck> checks) {
        this.run(new PlanCheckCheckRun(checks));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void run(CheckRun run) {
        if (this.fQueue == null) {
            this.scheduleJob(run);
        } else {
            ProblemDetectionQueue problemDetectionQueue = this.fQueue;
            synchronized (problemDetectionQueue) {
                if (this.fQueue.isActive()) {
                    this.fQueue.add(run);
                } else {
                    this.scheduleJob(run);
                }
            }
        }
    }

    public synchronized void cancel() {
        this.fCancelled = true;
        if (this.fQueue != null) {
            this.fQueue.cancel();
        }
    }

    public synchronized boolean isActive() {
        return this.fQueue != null;
    }

    public void join(IProgressMonitor monitor) throws InterruptedException {
        Job.getJobManager().join((Object)this.fPlan, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized IEventCondition getProblemCheckerExecutedCondition() {
        final SimpleEventCondition result = new SimpleEventCondition();
        if (this.fQueue != null) {
            ProblemDetectionQueue problemDetectionQueue = this.fQueue;
            synchronized (problemDetectionQueue) {
                if (this.fQueue.isActive()) {
                    this.fQueue.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                        public void done(IJobChangeEvent event) {
                            result.setEventTriggered();
                        }
                    });
                } else {
                    result.setEventTriggered();
                }
            }
        } else {
            result.setEventTriggered();
        }
        return result;
    }

    private void scheduleJob(CheckRun run) {
        this.fQueue = new ProblemDetectionQueue();
        this.fQueue.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                ProblemChecker.this.resetQueue(event.getJob());
            }
        });
        this.fQueue.add(run);
        this.fQueue.schedule();
    }

    private synchronized void resetQueue(Job queue) {
        if (this.fQueue == queue) {
            this.fQueue = null;
        }
    }

    private static PlanItemCheck[] createChecks() {
        return new PlanItemCheck[]{new RequiredAttributeCheck(), new SchedulingCheck(), new InvalidEstimateCheck()};
    }

    private void checkCanceled(IProgressMonitor monitor) {
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    private boolean isRelevantForProblemChecker(IPlanElementDelta delta) {
        final boolean[] result = new boolean[1];
        delta.accept(new IPlanElementDeltaVisitor(){

            public boolean visit(IPlanElementDelta delta) {
                if (delta.isContentChange() || delta.isStructuralChange()) {
                    result[0] = true;
                    return false;
                }
                IPlanAttributeDelta[] deltas = delta.getAttributeDeltas();
                if (deltas.length >= 1 && deltas[0].getAttribute() != PlanElement.PROBLEM_REPORT) {
                    result[0] = true;
                    return false;
                }
                return true;
            }
        });
        return result[0];
    }

    private class CancelAwareProgressMonitor
    extends ProgressMonitorWrapper {
        protected CancelAwareProgressMonitor(IProgressMonitor monitor) {
            super(monitor);
        }

        public boolean isCanceled() {
            return ProblemChecker.this.fCancelled || super.isCanceled();
        }
    }

    private static abstract class CheckRun {
        private CheckRun() {
        }

        public abstract PlanProblemReport execute(IProgressMonitor var1) throws TeamRepositoryException;
    }

    private class DeltaCheckRun
    extends CheckRun {
        private IPlanElementDelta fDelta;

        public DeltaCheckRun(IPlanElementDelta delta) {
            this.fDelta = delta;
        }

        public PlanProblemReport execute(IProgressMonitor monitor) throws TeamRepositoryException {
            PlanProblemReport result;
            final PlanItemCheck[] checks = ProblemChecker.createChecks();
            final IdentityHashMap itemsToCheck = new IdentityHashMap();
            PlanItemCheck[] planItemCheckArray = checks;
            int n = checks.length;
            int n2 = 0;
            while (n2 < n) {
                PlanItemCheck check = planItemCheckArray[n2];
                itemsToCheck.put(check, new HashSet());
                ++n2;
            }
            this.fDelta.accept(new IPlanElementDeltaVisitor(){

                public boolean visit(IPlanElementDelta delta) {
                    PlanElement element = delta.getPlanElement();
                    if (element instanceof PlanItem) {
                        PlanItemCheck[] planItemCheckArray = checks;
                        int n = checks.length;
                        int n2 = 0;
                        while (n2 < n) {
                            PlanItemCheck check = planItemCheckArray[n2];
                            ((Set)itemsToCheck.get(check)).addAll(check.computeItemsToCheck((PlanItem)element, delta));
                            ++n2;
                        }
                    }
                    return true;
                }
            });
            PlanProblemReport currentReport = ProblemChecker.this.fPlan.getProblemReport();
            PlanProblemReport planProblemReport = result = currentReport != null ? new PlanProblemReport(currentReport) : new PlanProblemReport(ProblemChecker.this.fPlan);
            if (!itemsToCheck.isEmpty()) {
                PlanItemCheck check;
                monitor.beginTask("", checks.length);
                HashSet toClear = new HashSet();
                HashSet checkers = new HashSet(checks.length);
                PlanItemCheck[] planItemCheckArray2 = checks;
                int n3 = checks.length;
                int n4 = 0;
                while (n4 < n3) {
                    check = planItemCheckArray2[n4];
                    toClear.addAll((Collection)itemsToCheck.get(check));
                    checkers.add(check.getClass());
                    ++n4;
                }
                for (PlanItem planItem : toClear) {
                    PlanItemProblemReport report = result.getReport(planItem);
                    if (report == null) continue;
                    report.clearProblems(checkers.iterator());
                }
                planItemCheckArray2 = checks;
                n3 = checks.length;
                int n5 = 0;
                while (n5 < n3) {
                    check = planItemCheckArray2[n5];
                    ProblemChecker.this.checkCanceled(monitor);
                    check.run(result, (Collection)itemsToCheck.get(check), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    ++n5;
                }
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ItemCheckRun
    extends CheckRun {
        private Collection<? extends PlanItem> fItems;

        public ItemCheckRun(Collection<? extends PlanItem> items) {
            this.fItems = items;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public PlanProblemReport execute(IProgressMonitor monitor) throws TeamRepositoryException {
            void var6_14;
            PlanItemCheck[] checks = ProblemChecker.createChecks();
            PlanProblemReport currentReport = ProblemChecker.this.fPlan.getProblemReport();
            PlanProblemReport result = currentReport != null ? new PlanProblemReport(currentReport) : new PlanProblemReport(ProblemChecker.this.fPlan);
            HashSet checkers = new HashSet(checks.length);
            PlanItemCheck[] planItemCheckArray = checks;
            int n = checks.length;
            int n2 = 0;
            while (n2 < n) {
                PlanItemCheck planItemCheck = planItemCheckArray[n2];
                checkers.add(planItemCheck.getClass());
                ++n2;
            }
            for (PlanItem planItem : this.fItems) {
                result.createReport(planItem).clearProblems(checkers.iterator());
            }
            monitor.beginTask("", checks.length);
            boolean bl = false;
            while (var6_14 < checks.length) {
                ProblemChecker.this.checkCanceled(monitor);
                checks[var6_14].run(result, this.fItems, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                ++var6_14;
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PlanCheckCheckRun
    extends CheckRun {
        private List<? extends HierarchicalPlanElementCheck> fChecks;

        public PlanCheckCheckRun(List<? extends HierarchicalPlanElementCheck> checks) {
            this.fChecks = checks;
        }

        @Override
        public PlanProblemReport execute(IProgressMonitor monitor) throws TeamRepositoryException {
            PlanItemProblemReport[] planItemProblemReportArray;
            PlanProblemReport currentReport = ProblemChecker.this.fPlan.getProblemReport();
            PlanProblemReport result = currentReport != null ? new PlanProblemReport(currentReport) : new PlanProblemReport(ProblemChecker.this.fPlan);
            HashSet checkers = new HashSet(this.fChecks.size());
            for (HierarchicalPlanElementCheck hierarchicalPlanElementCheck : this.fChecks) {
                checkers.add(hierarchicalPlanElementCheck.getClass());
            }
            PlanItemProblemReport[] planItemProblemReportArray2 = planItemProblemReportArray = result.getPlanItemProblemReports();
            int n = planItemProblemReportArray.length;
            int n2 = 0;
            while (n2 < n) {
                PlanItemProblemReport planItemProblemReport = planItemProblemReportArray2[n2];
                planItemProblemReport.clearProblems(checkers.iterator());
                ++n2;
            }
            monitor.beginTask("", this.fChecks.size());
            for (HierarchicalPlanElementCheck hierarchicalPlanElementCheck : this.fChecks) {
                hierarchicalPlanElementCheck.run(result, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            return result;
        }
    }

    private class ProblemDetectionQueue
    extends Job {
        private List fChecks;

        public ProblemDetectionQueue() {
            super(Messages.ProblemChecker_NAME);
            this.fChecks = new ArrayList();
        }

        public boolean belongsTo(Object family) {
            return family == ProblemChecker.this.fPlan;
        }

        public synchronized boolean isActive() {
            return this.fChecks != null;
        }

        public synchronized boolean add(CheckRun run) {
            if (this.fChecks == null) {
                return false;
            }
            this.fChecks.add(run);
            return true;
        }

        protected IStatus run(IProgressMonitor monitor) {
            monitor = new CancelAwareProgressMonitor((IProgressMonitor)monitor);
            CheckRun run = null;
            IStatus result = null;
            while ((run = this.getNextCheckRun()) != null) {
                try {
                    ProblemChecker.this.checkCanceled(monitor);
                    ProblemChecker.this.acceptProblemReport(run.execute((IProgressMonitor)monitor));
                }
                catch (TeamRepositoryException e) {
                    PlanningClientPlugin.log(e);
                }
            }
            if (result == null) {
                return Status.OK_STATUS;
            }
            return result;
        }

        private synchronized CheckRun getNextCheckRun() {
            if (this.fChecks.size() > 0) {
                return (CheckRun)this.fChecks.remove(0);
            }
            this.fChecks = null;
            return null;
        }
    }
}

