/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.client.problems;

import com.ibm.team.apt.internal.client.PlanElement;
import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.client.ResolvedPlan;
import com.ibm.team.apt.internal.client.problems.PlanItemProblemReport;
import com.ibm.team.apt.internal.client.problems.Problem;
import com.ibm.team.apt.internal.client.problems.ProblemReport;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class PlanProblemReport
extends ProblemReport {
    private ResolvedPlan fPlan;
    private Map<PlanItem, PlanItemProblemReport> fProblemReports;

    public PlanProblemReport(ResolvedPlan plan) {
        this.fPlan = plan;
        this.fProblemReports = new HashMap<PlanItem, PlanItemProblemReport>();
    }

    public PlanProblemReport(PlanProblemReport report) {
        this.fPlan = report.fPlan;
        this.fProblemReports = new HashMap<PlanItem, PlanItemProblemReport>();
        for (PlanItemProblemReport planItemReport : report.fProblemReports.values()) {
            this.fProblemReports.put(planItemReport.getPlanItem(), new PlanItemProblemReport(planItemReport));
        }
    }

    public PlanElement getPlanElement() {
        return this.fPlan;
    }

    public ResolvedPlan getPlan() {
        return this.fPlan;
    }

    public PlanItemProblemReport getReport(PlanItem planItem) {
        return this.fProblemReports.get(planItem);
    }

    public PlanItemProblemReport removeReport(PlanItem planItem) {
        return this.fProblemReports.remove(planItem);
    }

    public PlanItemProblemReport createReport(PlanItem planItem) {
        PlanItemProblemReport result = this.fProblemReports.get(planItem);
        if (result != null) {
            return result;
        }
        result = new PlanItemProblemReport(planItem);
        this.fProblemReports.put(planItem, result);
        return result;
    }

    public PlanItemProblemReport[] getPlanItemProblemReports() {
        Collection<PlanItemProblemReport> values = this.fProblemReports.values();
        return values.toArray(new PlanItemProblemReport[values.size()]);
    }

    public void merge(PlanProblemReport other) {
        PlanItemProblemReport[] others = other.getPlanItemProblemReports();
        int i = 0;
        while (i < others.length) {
            PlanItemProblemReport report = others[i];
            if (!this.fProblemReports.containsKey(report.getPlanItem())) {
                this.fProblemReports.put(report.getPlanItem(), report);
            }
            ++i;
        }
    }

    public boolean isSeverity(Problem.Severity severirty) {
        for (PlanItemProblemReport report : this.fProblemReports.values()) {
            if (!report.isSeverity(severirty)) continue;
            return true;
        }
        return false;
    }

    public void removeEmptyReports() {
        Iterator<Map.Entry<PlanItem, PlanItemProblemReport>> iterator = this.fProblemReports.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<PlanItem, PlanItemProblemReport> entry = iterator.next();
            if (entry.getValue().hasProblems()) continue;
            iterator.remove();
        }
    }
}

