/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.client.problems;

import com.ibm.team.apt.internal.client.IterationPlanItem;
import com.ibm.team.apt.internal.client.PlanElement;
import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.client.ResolvedIterationPlan;
import com.ibm.team.apt.internal.client.problems.AttributeProblem;
import com.ibm.team.apt.internal.client.problems.Messages;
import com.ibm.team.apt.internal.client.problems.OpenCloseCheck;
import com.ibm.team.apt.internal.client.problems.PlanCheck;
import com.ibm.team.apt.internal.client.problems.PlanItemProblemReport;
import com.ibm.team.apt.internal.client.problems.PlanProblemReport;
import com.ibm.team.apt.internal.client.problems.Problem;
import com.ibm.team.repository.common.TeamRepositoryException;
import org.eclipse.core.runtime.IProgressMonitor;

public class FullOpenCloseCheck
extends OpenCloseCheck {
    private ResolvedIterationPlan fRoot;

    public FullOpenCloseCheck(ResolvedIterationPlan root) {
        this.fRoot = root;
    }

    public void run(PlanProblemReport report, IProgressMonitor monitor) throws TeamRepositoryException {
        this.traverse(report, this.fRoot);
    }

    private CleanupInfo traverse(PlanProblemReport report, PlanElement element) {
        PlanElement[] children = element.getChildren();
        CleanupInfo result = new CleanupInfo();
        PlanElement[] planElementArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            PlanElement child = planElementArray[n2];
            result.merge(this.traverse(report, child));
            ++n2;
        }
        if (element instanceof IterationPlanItem) {
            IterationPlanItem item = (IterationPlanItem)element;
            if (!result.changed && item.isGroupItem()) {
                PlanItemProblemReport itemReport = report.createReport(item);
                itemReport.clearProblems((Class<? extends PlanCheck>)OpenCloseCheck.class);
                if (result.open == 0 && (item.isOpen() || item.isInProgress()) && !item.isAuxiliaryPlanItem() && !item.getEstimate().isSpecified()) {
                    itemReport.addProblem(new AttributeProblem(Problem.Severity.INFO, 50, Messages.OpenCloseCheck_OPEN_BUT_CHILDREN_CLOSED, item, PlanItem.STATE, OpenCloseCheck.class));
                    result.changed = true;
                } else if (result.open > 0 && item.isResolved() && !item.isAuxiliaryPlanItem()) {
                    itemReport.addProblem(new AttributeProblem(Problem.Severity.WARNING, 50, Messages.OpenCloseCheck_CLOSED_BUT_ONE_CHILD_OPEN, item, PlanItem.STATE, OpenCloseCheck.class));
                    result.changed = true;
                }
            }
            if (item.isOpen() || item.isInProgress()) {
                ++result.open;
            } else if (item.isResolved()) {
                ++result.resovled;
            }
        }
        return result;
    }

    private static class CleanupInfo {
        public int open;
        public int resovled;
        public boolean changed;

        private CleanupInfo() {
        }

        public void merge(CleanupInfo other) {
            this.open += other.open;
            this.resovled += other.resovled;
            this.changed |= other.changed;
        }
    }
}

