/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.client.problems;

import com.ibm.team.apt.internal.client.IterationPlanItem;
import com.ibm.team.apt.internal.client.PlanElement;
import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.client.problems.AttributeProblem;
import com.ibm.team.apt.internal.client.problems.FullOpenCloseCheck;
import com.ibm.team.apt.internal.client.problems.Messages;
import com.ibm.team.apt.internal.client.problems.OpenCloseCheck;
import com.ibm.team.apt.internal.client.problems.PlanCheck;
import com.ibm.team.apt.internal.client.problems.PlanItemProblemReport;
import com.ibm.team.apt.internal.client.problems.PlanProblemReport;
import com.ibm.team.apt.internal.client.problems.Problem;
import com.ibm.team.repository.common.TeamRepositoryException;
import org.eclipse.core.runtime.IProgressMonitor;

public class DeltaOpenCloseCheck
extends OpenCloseCheck {
    private PlanElement fElement;

    public DeltaOpenCloseCheck(PlanElement element) {
        this.fElement = element;
    }

    public void run(PlanProblemReport report, IProgressMonitor monitor) throws TeamRepositoryException {
        this.checkElement(report, this.fElement);
    }

    private void checkElement(PlanProblemReport report, PlanElement element) {
        if (element.hasChildren() && element instanceof IterationPlanItem) {
            PlanElement[] children = element.getChildren();
            int open = 0;
            int closed = 0;
            PlanElement[] planElementArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                PlanElement child = planElementArray[n2];
                if (child instanceof PlanItem) {
                    PlanItem item = (PlanItem)child;
                    if (item.isOpen() || item.isInProgress()) {
                        ++open;
                    } else if (item.isResolved()) {
                        ++closed;
                    }
                }
                ++n2;
            }
            IterationPlanItem item = (IterationPlanItem)element;
            if (item.isGroupItem()) {
                PlanItemProblemReport itemReport = report.createReport(item);
                itemReport.clearProblems((Class<? extends PlanCheck>)OpenCloseCheck.class);
                if (open == 0 && (item.isOpen() || item.isInProgress()) && !item.isAuxiliaryPlanItem() && !item.getEstimate().isSpecified()) {
                    itemReport.addProblem(new AttributeProblem(Problem.Severity.INFO, 50, Messages.OpenCloseCheck_OPEN_BUT_CHILDREN_CLOSED, item, PlanItem.STATE, FullOpenCloseCheck.class));
                } else if (open > 0 && item.isResolved() && !item.isAuxiliaryPlanItem()) {
                    itemReport.addProblem(new AttributeProblem(Problem.Severity.WARNING, 50, Messages.OpenCloseCheck_CLOSED_BUT_ONE_CHILD_OPEN, item, PlanItem.STATE, FullOpenCloseCheck.class));
                }
            }
        }
        if (element.getParent() != null) {
            this.checkElement(report, element.getParent());
        }
    }
}

