/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.client;

import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.workitem.common.internal.model.WorkItem;
import com.ibm.team.workitem.common.model.IWorkItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequenceValue
implements Comparable<SequenceValue> {
    private static final String SEQUENCE_VALUE_SEPARATOR = " ";
    private static final Double SEQUENCE_VALUE_NEWITEM = null;
    private static final Double SEQUENCE_VALUE_ACCEPTED = Double.NaN;
    public static final SequenceValue NEW = new SequenceValue(SEQUENCE_VALUE_NEWITEM);
    public static final SequenceValue ACCEPTED = new SequenceValue(SEQUENCE_VALUE_ACCEPTED);
    private final Double fSequenceValue;

    SequenceValue(Double sequenceValue) {
        this.fSequenceValue = sequenceValue;
    }

    public static final SequenceValue parse(IWorkItem workItem) {
        return SequenceValue.parse(((WorkItem)workItem).getInternalSequenceValue(), workItem.getOwner());
    }

    static final SequenceValue parse(String sequenceValue, IContributorHandle planItemOwner) {
        try {
            String[] parts;
            if (sequenceValue != null && sequenceValue.length() > 0 && (parts = sequenceValue.split(SEQUENCE_VALUE_SEPARATOR)).length == 2 && UUID.valueOf((String)parts[0]).equals((Object)planItemOwner.getItemId())) {
                Double parsedValue = Double.longBitsToDouble(Long.parseLong(parts[1]));
                return SEQUENCE_VALUE_ACCEPTED.equals(parsedValue) ? ACCEPTED : new SequenceValue(parsedValue);
            }
        }
        catch (IllegalArgumentException e) {
            PlanningClientPlugin.log("Unable to parse sequence value", e);
        }
        return NEW;
    }

    boolean isNew() {
        return this.fSequenceValue == SEQUENCE_VALUE_NEWITEM;
    }

    boolean isScheduled() {
        return this.fSequenceValue != SEQUENCE_VALUE_NEWITEM && !this.fSequenceValue.equals(SEQUENCE_VALUE_ACCEPTED);
    }

    Double getValue() {
        return this.fSequenceValue != null && !this.fSequenceValue.isNaN() ? this.fSequenceValue : null;
    }

    String serializeSequenceValue(IContributorHandle planItemOwner) {
        return this.isNew() ? null : String.valueOf(planItemOwner.getItemId().getUuidValue()) + SEQUENCE_VALUE_SEPARATOR + Long.toString(Double.doubleToLongBits(this.fSequenceValue));
    }

    @Override
    public int compareTo(SequenceValue o) {
        if (this.fSequenceValue == null || o.fSequenceValue == null) {
            return (this.fSequenceValue == null ? 1 : 0) - (o.fSequenceValue == null ? 1 : 0);
        }
        return this.fSequenceValue.compareTo(o.fSequenceValue);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SequenceValue)) {
            return false;
        }
        return this.compareTo((SequenceValue)obj) == 0;
    }
}

