/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.client;

import com.ibm.team.apt.internal.client.IPlanAttributeDelta;
import com.ibm.team.apt.internal.client.IPlanElementChangeEvent;
import com.ibm.team.apt.internal.client.IPlanElementDelta;
import com.ibm.team.apt.internal.client.IPlanElementDeltaVisitor;
import com.ibm.team.apt.internal.client.IPlanElementListener;
import com.ibm.team.apt.internal.client.IterationPlanData;
import com.ibm.team.apt.internal.client.IterationPlanDataListener;
import com.ibm.team.apt.internal.client.PlanElement;
import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.client.ResolvedIterationPlan;
import com.ibm.team.apt.internal.common.ProgressInformation;
import com.ibm.team.apt.internal.common.duration.PlanDuration;
import com.ibm.team.workitem.common.model.Identifier;
import com.ibm.team.workitem.common.workflow.IWorkflowInfo;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ListenerList;

public class ProgressInformationUpdater {
    private IPlanElementDeltaVisitor fPlanDeltaVisitor = new IPlanElementDeltaVisitor(){

        public boolean visit(IPlanElementDelta delta) {
            PlanElement element = delta.getPlanElement();
            if (!(element instanceof PlanItem)) {
                return true;
            }
            PlanItem item = (PlanItem)element;
            boolean wasDraftItem = delta.getAttributeDelta(PlanItem.DRAFT_ITEM) != null;
            IPlanAttributeDelta auxiliaryDelta = delta.getAttributeDelta(PlanItem.AUXILIARY_ITEM);
            if (auxiliaryDelta != null) {
                if (!((Boolean)auxiliaryDelta.getNewValue()).booleanValue()) {
                    if (item.countAsOpen()) {
                        ProgressInformationUpdater.this.fProgressInformation.deltaOpenCount(1);
                        ProgressInformationUpdater.this.fProgressInformation.deltaWorkHoursLeft(item.getDuration().getDuration());
                        if (item.getDuration().isSpecified()) {
                            ProgressInformationUpdater.this.fProgressInformation.deltaEstimateCount(1);
                        }
                    } else if (item.isResolved()) {
                        ProgressInformationUpdater.this.fProgressInformation.deltaCloseCount(1);
                        ProgressInformationUpdater.this.fProgressInformation.deltaWorkHoursDone(item.getDuration().getDuration());
                    }
                } else if (item.isOpen() || item.isInProgress()) {
                    ProgressInformationUpdater.this.fProgressInformation.deltaOpenCount(-1);
                    ProgressInformationUpdater.this.fProgressInformation.deltaWorkHoursLeft(-item.getDuration().getDuration());
                    if (item.getDuration().isSpecified()) {
                        ProgressInformationUpdater.this.fProgressInformation.deltaEstimateCount(-1);
                    }
                } else if (item.isResolved()) {
                    ProgressInformationUpdater.this.fProgressInformation.deltaCloseCount(-1);
                    ProgressInformationUpdater.this.fProgressInformation.deltaWorkHoursDone(-item.getDuration().getDuration());
                }
            } else if (delta.isAdded() && !delta.isMoveChange()) {
                if (item.countAsOpen()) {
                    ProgressInformationUpdater.this.fProgressInformation.deltaOpenCount(1);
                    ProgressInformationUpdater.this.fProgressInformation.deltaWorkHoursLeft(item.getDuration().getDuration());
                    if (item.getDuration().isSpecified()) {
                        ProgressInformationUpdater.this.fProgressInformation.deltaEstimateCount(1);
                    }
                } else if (item.countAsResolved()) {
                    ProgressInformationUpdater.this.fProgressInformation.deltaCloseCount(1);
                    ProgressInformationUpdater.this.fProgressInformation.deltaWorkHoursDone(item.getDuration().getDuration());
                }
            } else if (delta.isRemoved() && !delta.isMoveChange()) {
                if (item.countAsOpen()) {
                    ProgressInformationUpdater.this.fProgressInformation.deltaOpenCount(-1);
                    ProgressInformationUpdater.this.fProgressInformation.deltaWorkHoursLeft(-item.getDuration().getDuration());
                    if (item.getDuration().isSpecified()) {
                        ProgressInformationUpdater.this.fProgressInformation.deltaEstimateCount(-1);
                    }
                } else if (item.countAsResolved()) {
                    ProgressInformationUpdater.this.fProgressInformation.deltaCloseCount(-1);
                    ProgressInformationUpdater.this.fProgressInformation.setWorkHoursDone(-item.getDuration().getDuration());
                }
            } else if (delta.isChanged()) {
                IPlanAttributeDelta estimateDelta;
                IPlanAttributeDelta attributeDelta = delta.getAttributeDelta(PlanItem.STATE);
                if (attributeDelta != null && !wasDraftItem) {
                    int newStateGroup;
                    IWorkflowInfo workflowInfo = item.getWorkflowInfo();
                    int oldStateGroup = workflowInfo.getStateGroup((Identifier)attributeDelta.getOldValue());
                    if ((oldStateGroup == 1 || oldStateGroup == 4) ^ ((newStateGroup = workflowInfo.getStateGroup((Identifier)attributeDelta.getNewValue())) == 1 || oldStateGroup == 4)) {
                        if (newStateGroup == 1 || newStateGroup == 4) {
                            ProgressInformationUpdater.this.fProgressInformation.deltaOpenCount(1);
                            ProgressInformationUpdater.this.fProgressInformation.deltaWorkHoursLeft(item.getDuration().getDuration());
                            if (item.getDuration().isSpecified()) {
                                ProgressInformationUpdater.this.fProgressInformation.deltaEstimateCount(1);
                            }
                        } else {
                            ProgressInformationUpdater.this.fProgressInformation.deltaOpenCount(-1);
                            ProgressInformationUpdater.this.fProgressInformation.deltaWorkHoursLeft(-item.getDuration().getDuration());
                        }
                    }
                    if (oldStateGroup == 2 ^ newStateGroup == 2) {
                        if (newStateGroup == 2) {
                            ProgressInformationUpdater.this.fProgressInformation.deltaCloseCount(1);
                            ProgressInformationUpdater.this.fProgressInformation.deltaWorkHoursDone(item.getDuration().getDuration());
                            if (item.getDuration().isSpecified()) {
                                ProgressInformationUpdater.this.fProgressInformation.deltaEstimateCount(-1);
                            }
                        } else {
                            ProgressInformationUpdater.this.fProgressInformation.deltaCloseCount(-1);
                            ProgressInformationUpdater.this.fProgressInformation.deltaWorkHoursDone(-item.getDuration().getDuration());
                        }
                    }
                }
                if ((estimateDelta = delta.getAttributeDelta(PlanItem.DURATION)) != null) {
                    PlanDuration oldDuration = (PlanDuration)estimateDelta.getOldValue();
                    PlanDuration newDuration = (PlanDuration)estimateDelta.getNewValue();
                    if (item.countAsOpen()) {
                        ProgressInformationUpdater.this.fProgressInformation.deltaWorkHoursLeft(-oldDuration.getDuration());
                        ProgressInformationUpdater.this.fProgressInformation.deltaWorkHoursLeft(newDuration.getDuration());
                        if (!newDuration.isSpecified() ^ !oldDuration.isSpecified()) {
                            if (!newDuration.isSpecified()) {
                                ProgressInformationUpdater.this.fProgressInformation.deltaEstimateCount(-1);
                            } else {
                                ProgressInformationUpdater.this.fProgressInformation.deltaEstimateCount(1);
                            }
                        }
                    } else if (item.countAsResolved()) {
                        ProgressInformationUpdater.this.fProgressInformation.deltaWorkHoursDone(-oldDuration.getDuration());
                        ProgressInformationUpdater.this.fProgressInformation.deltaWorkHoursDone(newDuration.getDuration());
                    }
                }
            }
            return true;
        }
    };
    private IPlanElementListener fPlanElementListener = new IPlanElementListener(){

        public void planElementChanged(IPlanElementChangeEvent event) {
            ProgressInformationUpdater.this.handlePlanItemChange(event);
        }
    };
    private IterationPlanDataListener fPlanDataListener = new IterationPlanDataListener(){

        public void iterationPlanResolved(ResolvedIterationPlan plan) {
            plan.addListener(ProgressInformationUpdater.this.fPlanElementListener);
        }
    };
    private static final Object mutex = new Object();
    private ListenerList fListener = new ListenerList(1);
    private ProgressInformation fProgressInformation;
    private IterationPlanData fIterationPlanData;

    public ProgressInformationUpdater(IterationPlanData data) {
        Assert.isNotNull((Object)data);
        this.fProgressInformation = data.getProgress();
        this.fIterationPlanData = data;
        if (data.getIterationPlan() != null) {
            data.getIterationPlan().addListener(this.fPlanElementListener);
        } else {
            data.addListener(this.fPlanDataListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handlePlanItemChange(IPlanElementChangeEvent event) {
        Object object = mutex;
        synchronized (object) {
            event.getDelta().accept(this.fPlanDeltaVisitor);
            this.fireProgressInformationChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProgressInformation(ProgressInformation progressInformation) {
        Object object = mutex;
        synchronized (object) {
            this.fProgressInformation = progressInformation;
        }
    }

    public void dispose() {
        this.fIterationPlanData.removeListener(this.fPlanDataListener);
        if (this.fIterationPlanData.getIterationPlan() != null) {
            this.fIterationPlanData.getIterationPlan().removeListener(this.fPlanElementListener);
        }
        this.fPlanElementListener = null;
        this.fIterationPlanData = null;
        this.fProgressInformation = null;
    }

    public IterationPlanData getIterationPlanData() {
        return this.fIterationPlanData;
    }

    public void addProgressInformationListener(IProgressInformationListener listener) {
        this.fListener.add((Object)listener);
    }

    public void removeProgressInformationListener(IProgressInformationListener listener) {
        this.fListener.remove((Object)listener);
    }

    protected void fireProgressInformationChanged() {
        Object[] listeners;
        Object[] objectArray = listeners = this.fListener.getListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            ((IProgressInformationListener)object).progressInformationChanged(this.fProgressInformation);
            ++n2;
        }
    }

    public static interface IProgressInformationListener {
        public void progressInformationChanged(ProgressInformation var1);
    }
}

