/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.client;

import com.ibm.team.apt.internal.client.Attribute;
import com.ibm.team.apt.internal.client.IPlanElementChangeEvent;
import com.ibm.team.apt.internal.client.PlanAttributeDelta;
import com.ibm.team.apt.internal.client.PlanElement;
import com.ibm.team.apt.internal.client.PlanElementChangeEvent;
import com.ibm.team.apt.internal.client.PlanElementDelta;
import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.client.ResolvedPlan;
import com.ibm.team.apt.internal.client.problems.PlanItemProblemReport;
import com.ibm.team.apt.internal.client.problems.PlanProblemReport;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;

public class PlanDeltaBuilder {
    private ResolvedPlan fPlanRoot;
    private PlanElementDelta fDeltaRoot;
    private PlanElement fOldParent;
    private PlanElement fNewParent;
    private List<Runnable> fPostRunnables;

    public PlanDeltaBuilder(ResolvedPlan root) {
        this.fPlanRoot = root;
        this.fDeltaRoot = new PlanElementDelta(null, this.fPlanRoot);
        this.fPostRunnables = new ArrayList<Runnable>();
    }

    public synchronized boolean isEmpty() {
        return this.fDeltaRoot.isNoChange() && !this.fDeltaRoot.hasChildren();
    }

    public synchronized IPlanElementChangeEvent getEvent() {
        return new PlanElementChangeEvent(this.fDeltaRoot);
    }

    public void sendPostNotifications() {
        for (Runnable runnable : this.fPostRunnables) {
            runnable.run();
        }
    }

    public synchronized void addPostNotification(Runnable runnable) {
        Assert.isNotNull((Object)runnable);
        this.fPostRunnables.add(runnable);
    }

    public synchronized boolean isInMove() {
        return this.fOldParent != null && this.fNewParent != null;
    }

    public synchronized void aboutToMove(PlanElement oldParent, PlanElement newParent) {
        Assert.isNotNull((Object)((Object)oldParent));
        Assert.isNotNull((Object)((Object)newParent));
        this.fOldParent = oldParent;
        this.fNewParent = newParent;
        if (this.fNewParent != null) {
            int childrenCount = this.fNewParent.getChildrenCount();
            this.changed(this.fNewParent, PlanElement.CHILDREN_COUNT, childrenCount, childrenCount + 1);
            if (childrenCount == 0) {
                this.changed(this.fNewParent, PlanElement.CHILDREN, Boolean.FALSE, Boolean.TRUE);
            }
        }
    }

    public synchronized void moved() {
        if (this.fOldParent != null) {
            int childrenCount = this.fOldParent.getChildrenCount();
            this.changed(this.fOldParent, PlanElement.CHILDREN_COUNT, childrenCount + 1, childrenCount);
            if (childrenCount == 0) {
                this.changed(this.fOldParent, PlanElement.CHILDREN, Boolean.TRUE, Boolean.FALSE);
            }
        }
        this.fOldParent = null;
        this.fNewParent = null;
    }

    public synchronized void changed(PlanElement element, Attribute attribute, Object oldValue, Object newValue) {
        PlanElementDelta delta = this.getDelta(element);
        if (delta.isNoChange()) {
            delta.setChanged();
        }
        delta.setContentChange();
        delta.addAttribute(new PlanAttributeDelta(attribute, oldValue, newValue));
    }

    public synchronized void problemsChanged(PlanProblemReport oldReport, PlanProblemReport newReport) {
        Assert.isTrue((boolean)(oldReport != null ? this.fPlanRoot == oldReport.getPlanElement() : this.fPlanRoot == newReport.getPlanElement()));
        this.fDeltaRoot.addAttribute(new PlanAttributeDelta(PlanElement.PROBLEM_REPORT, oldReport, newReport));
        PlanItemProblemReport[] reports = newReport.getPlanItemProblemReports();
        int i = 0;
        while (i < reports.length) {
            PlanItemProblemReport oldItemReport;
            PlanItemProblemReport newItemReport = reports[i];
            PlanItem planItem = newItemReport.getPlanItem();
            PlanItemProblemReport planItemProblemReport = oldItemReport = oldReport != null ? oldReport.getReport(planItem) : null;
            if (oldItemReport == null && newItemReport.hasProblems() || oldItemReport != null && !oldItemReport.equals(newItemReport)) {
                PlanElementDelta delta = this.getDelta(planItem);
                delta.setChanged();
                delta.addAttribute(new PlanAttributeDelta(PlanElement.PROBLEM_REPORT, oldItemReport, newItemReport));
            }
            ++i;
        }
    }

    public synchronized void added(PlanElement element) {
        PlanElement parent = element.getParent();
        Assert.isNotNull((Object)((Object)parent));
        PlanElementDelta parentDelta = this.getDelta(parent);
        if (parentDelta.isNoChange()) {
            parentDelta.setChanged();
        }
        parentDelta.setStructuralChange();
        PlanElementDelta delta = this.getDelta(element);
        delta.setAdded();
        if (this.fOldParent != null) {
            delta.setMoveParent(this.fOldParent);
            delta.setOtherMoveDelta(this.getDelta(this.getPath(this.fOldParent, element)));
        }
    }

    public synchronized void removed(PlanElement element) {
        PlanElement parent = element.getParent();
        Assert.isNotNull((Object)((Object)parent));
        PlanElementDelta parentDelta = this.getDelta(parent);
        if (parentDelta.isNoChange()) {
            parentDelta.setChanged();
        }
        parentDelta.setStructuralChange();
        PlanElementDelta delta = this.getDelta(element);
        delta.setRemoved();
        if (this.fNewParent != null) {
            delta.setMoveParent(this.fNewParent);
            delta.setOtherMoveDelta(this.getDelta(this.getPath(this.fNewParent, element)));
        } else {
            PlanElement[] children = element.getChildren();
            int i = 0;
            while (i < children.length) {
                this.removed(children[i]);
                ++i;
            }
        }
    }

    private PlanElementDelta getDelta(PlanElement element) {
        Assert.isTrue((this.fPlanRoot == element.getPlan() ? 1 : 0) != 0);
        return this.getDelta(this.getPath(element, null));
    }

    private PlanElementDelta getDelta(PlanElement[] path) {
        if (path.length == 1) {
            return this.fDeltaRoot;
        }
        PlanElementDelta current = this.fDeltaRoot;
        int i = path.length - 2;
        while (i >= 0) {
            PlanElementDelta child = current.getChild(path[i]);
            if (child == null) {
                child = new PlanElementDelta(current, path[i]);
                current.addChild(child);
            }
            current = child;
            --i;
        }
        return current;
    }

    private PlanElement[] getPath(PlanElement element, PlanElement child) {
        ArrayList<PlanElement> result = new ArrayList<PlanElement>();
        if (child != null) {
            result.add(child);
        }
        result.add(element);
        PlanElement parent = element.getParent();
        while (parent != null) {
            result.add(parent);
            parent = parent.getParent();
        }
        return result.toArray(new PlanElement[result.size()]);
    }
}

