/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.client;

import com.ibm.team.apt.common.IIterationPlanRecordHandle;
import com.ibm.team.process.common.IDevelopmentLineHandle;
import com.ibm.team.process.common.IIterationHandle;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IterationPlanWizardContext {
    private String fName;
    private IProjectAreaHandle fSelectedProjectArea;
    private List<IProjectAreaHandle> fProjectAreas = new LinkedList<IProjectAreaHandle>();
    private IDevelopmentLineHandle fDevelopmentLineHandle;
    private IIterationHandle fIteration;
    private ITeamAreaHandle fTeamArea;
    private ITeamRepository fTeamRepository;
    private IIterationPlanRecordHandle fIterationPlanHandle;

    public IterationPlanWizardContext(List<IProjectAreaHandle> projectAreas) {
        this.setProjectAreas(projectAreas);
        if (projectAreas.size() > 0) {
            this.setSelectedProjectArea(this.fProjectAreas.get(0));
        }
    }

    public boolean isValid() {
        return this.fSelectedProjectArea != null;
    }

    public void clear() {
        this.fName = null;
        this.fIteration = null;
        this.fTeamArea = null;
        this.fSelectedProjectArea = null;
        this.fTeamRepository = null;
        this.fIterationPlanHandle = null;
    }

    public void setProjectAreas(List<IProjectAreaHandle> projectAreas) {
        this.fProjectAreas = projectAreas;
    }

    public void setName(String name) {
        this.fName = name;
    }

    public void setSelectedProjectArea(IProjectAreaHandle selectedProjectArea) {
        this.fSelectedProjectArea = selectedProjectArea;
        this.updateTeamRepository((IItemHandle)selectedProjectArea);
    }

    public void setIteration(IIterationHandle iteration) {
        this.fIteration = iteration;
        this.updateTeamRepository((IItemHandle)iteration);
    }

    public void setTeamArea(ITeamAreaHandle teamArea) {
        this.fTeamArea = teamArea;
        this.updateTeamRepository((IItemHandle)teamArea);
    }

    public void setIterationPlanHandle(IIterationPlanRecordHandle iterationPlanHandle) {
        this.fIterationPlanHandle = iterationPlanHandle;
        this.updateTeamRepository((IItemHandle)iterationPlanHandle);
    }

    public void setDevelopmentLineHandle(IDevelopmentLineHandle developmentLineHandle) {
        this.fDevelopmentLineHandle = developmentLineHandle;
        this.updateTeamRepository((IItemHandle)developmentLineHandle);
    }

    public void setTeamRepository(ITeamRepository teamRepository) {
        this.fTeamRepository = teamRepository;
    }

    private void updateTeamRepository(IItemHandle handle) {
        if (handle != null) {
            this.setTeamRepository((ITeamRepository)handle.getOrigin());
        }
    }

    public String getName() {
        return this.fName;
    }

    public List<IProjectAreaHandle> getProjectAreas() {
        return this.fProjectAreas;
    }

    public IProjectAreaHandle getSelectedProjectArea() {
        return this.fSelectedProjectArea;
    }

    public IIterationHandle getIteration() {
        return this.fIteration;
    }

    public ITeamAreaHandle getTeamArea() {
        return this.fTeamArea;
    }

    public IIterationPlanRecordHandle getIterationPlanHandle() {
        return this.fIterationPlanHandle;
    }

    public IDevelopmentLineHandle getDevelopmentLineHandle() {
        return this.fDevelopmentLineHandle;
    }

    public ITeamRepository getTeamRepository() {
        return this.fTeamRepository;
    }
}

