/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.client;

import com.ibm.team.apt.common.resource.IWorkResourceDetails;
import com.ibm.team.apt.internal.client.IPlanElementVisitor;
import com.ibm.team.apt.internal.client.PlanElement;
import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.client.PlanLoadInformation;
import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.client.ResolvedIterationPlan;
import com.ibm.team.apt.internal.client.resource.IContributorInfo;
import com.ibm.team.apt.internal.client.resource.ResourcePlanningManager;
import com.ibm.team.apt.internal.client.teamload.ILoadItemCreator;
import com.ibm.team.apt.internal.client.teamload.LoadItem;
import com.ibm.team.apt.internal.common.util.ItemCollection;
import com.ibm.team.apt.internal.common.util.ItemCollections;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.workitem.common.model.ICategory;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IterationPlanLoadInformation
extends PlanLoadInformation<ResolvedIterationPlan> {
    private ILoadItemCreator fItemCreator = new ILoadItemCreator(){

        @Override
        public List<LoadItem> createItems(IProgressMonitor monitor) throws TeamRepositoryException {
            ItemCollection<IContributor> owners = ((ResolvedIterationPlan)IterationPlanLoadInformation.this.fPlan).getTeamMembers();
            ArrayList<LoadItem> result = new ArrayList<LoadItem>();
            for (IContributor owner : owners) {
                result.add(this.createItem(owner, monitor));
            }
            return result;
        }

        private LoadItem createItem(final IContributor contributor, IProgressMonitor monitor) throws TeamRepositoryException {
            ResourcePlanningManager manager = PlanningClientPlugin.getResourcePlanningClient(((ResolvedIterationPlan)IterationPlanLoadInformation.this.fPlan).getTeamRepository()).getResourcePlanningManager();
            Timestamp start = new Timestamp(0L);
            Timestamp end = null;
            if (IterationPlanLoadInformation.this.fIteration.getStartDate() != null) {
                start = new Timestamp(IterationPlanLoadInformation.this.fIteration.getStartDate().getTime());
            }
            if (IterationPlanLoadInformation.this.fIteration.getEndDate() != null) {
                end = new Timestamp(IterationPlanLoadInformation.this.fIteration.getEndDate().getTime());
            }
            IContributorInfo info = manager.getContributorInfo((IContributorHandle)contributor, start, end, monitor);
            long workTimeLeft = ((ResolvedIterationPlan)IterationPlanLoadInformation.this.fPlan).getItemSequenceManager((IContributorHandle)contributor).calculateRemainingWorkTime(IterationPlanLoadInformation.this.fIteration.getEndDate());
            int assignment = 0;
            boolean defaultAssignment = true;
            ItemCollection<IWorkResourceDetails> details = info.getWorkDetails((IContributorHandle)contributor);
            for (IWorkResourceDetails detail : details) {
                if (!detail.getOwner().sameItemId((IItemHandle)((ResolvedIterationPlan)IterationPlanLoadInformation.this.fPlan).getTeamArea()) || !detail.getDevelopmentLine().sameItemId((IItemHandle)IterationPlanLoadInformation.this.fIteration.getDevelopmentLine())) continue;
                assignment = detail.getAssignment();
                defaultAssignment = !detail.isCustomized();
                break;
            }
            boolean defaultLocation = !info.getWorkLocation((IContributorHandle)contributor).isCustomized();
            final HashSet<UUID> open = new HashSet<UUID>();
            final HashSet<UUID> estimated = new HashSet<UUID>();
            final HashSet<UUID> closed = new HashSet<UUID>();
            final long[] sumOfEstimate = new long[1];
            ((ResolvedIterationPlan)IterationPlanLoadInformation.this.fPlan).accept(new IPlanElementVisitor(){

                public boolean visit(PlanElement element) {
                    PlanItem planItem;
                    if (element instanceof PlanItem && (planItem = (PlanItem)element).getOwner().sameItemId((IItemHandle)contributor) && IterationPlanLoadInformation.this.fIteration.sameItemId((IItemHandle)planItem.getTarget())) {
                        UUID workItemId = planItem.getWorkItemId();
                        if (planItem.isResolved()) {
                            closed.add(workItemId);
                        } else {
                            open.add(workItemId);
                            if (planItem.isTopLevelPlanItem()) {
                                estimated.add(workItemId);
                            } else if (planItem.getDuration().isSpecified()) {
                                estimated.add(workItemId);
                                sumOfEstimate[0] = sumOfEstimate[0] + planItem.getDuration().getDuration();
                            }
                        }
                    }
                    return true;
                }
            });
            return new LoadItem(IterationPlanLoadInformation.this, contributor, info.getAbsences((IContributorHandle)contributor), workTimeLeft, assignment, defaultAssignment, defaultLocation, sumOfEstimate[0], open, estimated, closed);
        }
    };
    private final IIteration fIteration;

    public IterationPlanLoadInformation(ResolvedIterationPlan plan, IIteration iteration, ItemCollection<? extends ICategory> categories) {
        super(plan, (ItemCollection<? extends IIteration>)ItemCollections.singleton((Object)iteration), categories);
        this.fIteration = iteration;
    }

    @Override
    public ILoadItemCreator getItemCreator() {
        return this.fItemCreator;
    }
}

