/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.client;

import com.ibm.team.apt.internal.client.EstimateMode;
import com.ibm.team.apt.internal.client.IterationPlanClient;
import com.ibm.team.apt.internal.client.Messages;
import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.common.duration.PlanDuration;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IWorkItemWorkingCopyManager;
import com.ibm.team.workitem.common.internal.model.WorkItem;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class DurationSupport {
    public static final DurationSupportFactory FACTORY = new DurationSupportFactory();
    public static final IStatus TIME_REMAINING_EXCEEDS_ESTIMATE = new Status(4, PlanningClientPlugin.getPluginId(), Messages.DurationAdjuster_TIME_REMAINING_EXCEEDS_ESTIMATE);
    private final EstimateMode fEstimateMode;

    private DurationSupport(EstimateMode estimateMode) {
        this.fEstimateMode = estimateMode;
    }

    public EstimateMode getEstimateMode() {
        return this.fEstimateMode;
    }

    public IStatus setCurrentDuration(IWorkItem item, boolean isResolved, long value) {
        WorkItem workItem = (WorkItem)item;
        PlanDuration duration = new PlanDuration(workItem.getDuration(), workItem.getCorrectedEstimate(), workItem.getTimeSpent(), isResolved);
        IWorkItemWorkingCopyManager manager = PlanningClientPlugin.getWorkItemClient((IItemHandle)workItem).getWorkItemWorkingCopyManager();
        manager.beginCompoundWorkItemChange((IWorkItemHandle)workItem);
        try {
            if (this.isMode(EstimateMode.TimeSpent)) {
                workItem.setTimeSpent(value);
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            if (value < 0L) {
                workItem.setTimeSpent(value);
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            if (!duration.hasEstimate()) {
                if (duration.isOriginalEstimateFixed()) {
                    workItem.setCorrectedEstimate(value);
                } else {
                    workItem.setDuration(value);
                }
                workItem.setTimeSpent(0L);
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            if (duration.getCurrentEstimate() < value) {
                value = PlanDuration.encodeTimeRemaining2TimeSpent((long)value);
                workItem.setTimeSpent(value);
                IStatus iStatus = TIME_REMAINING_EXCEEDS_ESTIMATE;
                return iStatus;
            }
            value = duration.getCurrentEstimate() - value;
            workItem.setTimeSpent(value);
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        finally {
            manager.endCompoundWorkItemChange((IWorkItemHandle)workItem);
        }
    }

    public IStatus setCurrentEstimate(IWorkItem item, boolean editingCorrectedEstimate, boolean isResolved, long value) {
        WorkItem workItem = (WorkItem)item;
        PlanDuration duration = new PlanDuration(workItem.getDuration(), workItem.getCorrectedEstimate(), workItem.getTimeSpent(), isResolved);
        IWorkItemWorkingCopyManager manager = PlanningClientPlugin.getWorkItemClient((IItemHandle)workItem).getWorkItemWorkingCopyManager();
        manager.beginCompoundWorkItemChange((IWorkItemHandle)workItem);
        try {
            if (duration.hasCorrectedEstimate() || editingCorrectedEstimate) {
                workItem.setCorrectedEstimate(value);
                if (value < 0L) {
                    value = duration.getOriginalEstimate();
                }
            } else {
                workItem.setDuration(value);
            }
            if (this.isMode(EstimateMode.TimeRemaining)) {
                long timeSpent = duration.getTimeSpent();
                if (PlanDuration.isEncodedTimeRemaining((long)timeSpent)) {
                    long timeRemaining = PlanDuration.decodeTimeSpent2TimeRemaining((long)timeSpent);
                    if (value < timeRemaining) {
                        IStatus iStatus = TIME_REMAINING_EXCEEDS_ESTIMATE;
                        return iStatus;
                    }
                    workItem.setTimeSpent(value - timeRemaining);
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                long timeRemaining = duration.getTimeRemaining();
                if (value < timeRemaining) {
                    timeSpent = PlanDuration.encodeTimeRemaining2TimeSpent((long)timeRemaining);
                    workItem.setTimeSpent(timeSpent);
                    IStatus iStatus = TIME_REMAINING_EXCEEDS_ESTIMATE;
                    return iStatus;
                }
                if (timeRemaining < -1L && timeSpent > -1L) {
                    timeSpent = PlanDuration.encodeTimeRemaining2TimeSpent((long)timeSpent);
                    workItem.setTimeSpent(timeSpent);
                    IStatus iStatus = TIME_REMAINING_EXCEEDS_ESTIMATE;
                    return iStatus;
                }
                if (timeRemaining >= 0L) {
                    workItem.setTimeSpent(value - timeRemaining);
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
            }
        }
        finally {
            manager.endCompoundWorkItemChange((IWorkItemHandle)workItem);
        }
        return Status.OK_STATUS;
    }

    private boolean isMode(EstimateMode mode) {
        return this.fEstimateMode == mode;
    }

    /* synthetic */ DurationSupport(EstimateMode estimateMode, DurationSupport durationSupport) {
        this(estimateMode);
    }

    public static class DurationSupportFactory {
        private DurationSupportFactory() {
        }

        public DurationSupport getInstance(IProcessAreaHandle handle, IProgressMonitor monitor) throws TeamRepositoryException {
            IterationPlanClient client = (IterationPlanClient)PlanningClientPlugin.getIterationPlanClient((IItemHandle)handle);
            DurationSupport support = this.getInstance(handle);
            if (support != null) {
                return support;
            }
            EstimateMode mode = client.fetchEstimationMode(handle, monitor);
            return new DurationSupport(mode, null);
        }

        public DurationSupport getInstance(IProcessAreaHandle handle) {
            IterationPlanClient client = (IterationPlanClient)PlanningClientPlugin.getIterationPlanClient((IItemHandle)handle);
            EstimateMode mode = client.findCachedEstimationMode(handle);
            if (mode != null) {
                return new DurationSupport(mode, null);
            }
            return null;
        }
    }
}

