/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.client;

import com.ibm.team.apt.internal.client.GetterKind;
import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.client.SetterKind;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.core.runtime.Assert;

public abstract class Attribute {
    private String fName;
    private Class fReceiverType;
    private GetterKind fGetterKind;
    private Method fGetter;
    private SetterKind fSetterKind;
    private Method fSetter;

    public Attribute(String name, Class receiverType) {
        this(name, receiverType, GetterKind.GET, SetterKind.SET);
    }

    public Attribute(String name, Class receiverType, GetterKind getter, SetterKind setter) {
        this.fName = name;
        this.fReceiverType = receiverType;
        this.fGetterKind = getter;
        this.fSetterKind = setter;
    }

    public String getName() {
        return this.fName;
    }

    protected abstract Class getAttributeType();

    protected Class getAttributeReflectionType() {
        return this.getAttributeType();
    }

    public Object getValue(Object receiver) {
        Method getter = this.getGetter();
        if (getter == null) {
            throw new UnsupportedOperationException();
        }
        Assert.isTrue((boolean)this.fReceiverType.isInstance(receiver));
        try {
            Object result = getter.invoke(receiver, new Object[0]);
            Assert.isTrue((result == null || this.getAttributeReflectionType().isInstance(result) ? 1 : 0) != 0);
            return result;
        }
        catch (IllegalArgumentException e) {
            PlanningClientPlugin.log(e);
        }
        catch (IllegalAccessException e) {
            PlanningClientPlugin.log(e);
        }
        catch (InvocationTargetException e) {
            PlanningClientPlugin.log(e);
        }
        Assert.isTrue((boolean)false, (String)"Should never happen");
        return null;
    }

    public void setValue(Object receiver, Object value) {
        Method setter = this.getSetter();
        if (setter == null) {
            throw new UnsupportedOperationException();
        }
        Assert.isTrue((boolean)this.fReceiverType.isInstance(receiver));
        Assert.isTrue((boolean)this.getAttributeReflectionType().isInstance(value));
        try {
            setter.invoke(receiver, value);
            return;
        }
        catch (IllegalArgumentException e) {
            PlanningClientPlugin.log(e);
        }
        catch (IllegalAccessException e) {
            PlanningClientPlugin.log(e);
        }
        catch (InvocationTargetException e) {
            PlanningClientPlugin.log(e);
        }
        Assert.isTrue((boolean)false, (String)"Should never happen");
    }

    public String toString() {
        return this.fName;
    }

    private Method getGetter() {
        if (this.fGetter != null) {
            return this.fGetter;
        }
        if (this.fGetterKind == GetterKind.NONE) {
            return null;
        }
        this.fGetter = this.resolveGetter(this.fReceiverType, this.fName);
        return this.fGetter;
    }

    private Method getSetter() {
        if (this.fSetter != null) {
            return this.fSetter;
        }
        if (this.fSetterKind == SetterKind.NONE) {
            return null;
        }
        this.fSetter = this.resolveSetter(this.fReceiverType, this.fName, this.getAttributeType());
        return this.fSetter;
    }

    protected Method resolveGetter(Class type, String name) {
        try {
            return type.getMethod(this.fGetterKind.getMethodName(name), new Class[0]);
        }
        catch (SecurityException e) {
            PlanningClientPlugin.log(e);
        }
        catch (NoSuchMethodException e) {
            PlanningClientPlugin.log(e);
        }
        Assert.isTrue((boolean)false, (String)"Should never happen");
        return null;
    }

    protected Method resolveSetter(Class type, String name, Class paramType) {
        try {
            return type.getMethod(this.fSetterKind.getMethodName(name), paramType);
        }
        catch (SecurityException e) {
            PlanningClientPlugin.log(e);
        }
        catch (NoSuchMethodException e) {
            PlanningClientPlugin.log(e);
        }
        Assert.isTrue((boolean)false, (String)"Should never happen");
        return null;
    }
}

