/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.connector.scm.client;

import com.ibm.rational.wvcm.interop.InteropStream;
import com.ibm.rational.wvcm.ri.impl.PropValue;
import com.ibm.rational.wvcm.ri.impl.WorkspaceImpl;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import com.ibm.rational.wvcm.ri.srvc.SrvcResource;
import com.ibm.team.connector.scm.client.JzLocation;
import com.ibm.team.connector.scm.client.JzProvider;
import com.ibm.team.connector.scm.client.JzRepoBaselineControlledFolder;
import com.ibm.team.connector.scm.client.JzRepoChangeSet;
import com.ibm.team.connector.scm.client.JzRepoComponent;
import com.ibm.team.connector.scm.client.JzRepoConfiguration;
import com.ibm.team.connector.scm.client.JzRepoControllableFolder;
import com.ibm.team.connector.scm.client.JzRepoException;
import com.ibm.team.connector.scm.client.JzRepoFolderItem;
import com.ibm.team.connector.scm.client.JzRepoResource;
import com.ibm.team.connector.scm.client.JzRepoStream;
import com.ibm.team.connector.scm.client.JzRepoVersion;
import com.ibm.team.connector.scm.client.JzRepoVersionHistory;
import com.ibm.team.connector.scm.client.Messages;
import com.ibm.team.repository.client.IContributorManager;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.internal.util.ItemUtil;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IFlowNodeConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.ComponentNotInWorkspaceException;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFlowEntry;
import com.ibm.team.scm.common.IFlowNodeHandle;
import com.ibm.team.scm.common.IFlowTable;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.WorkspaceComparisonFlags;
import com.ibm.team.scm.common.dto.IChangeHistorySyncReport;
import com.ibm.team.scm.common.dto.IItemConflictReport;
import com.ibm.team.scm.common.dto.IUpdateReport;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.wvcm.ControllableFolder;
import javax.wvcm.ControllableResource;
import javax.wvcm.Folder;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList;
import javax.wvcm.Resource;
import javax.wvcm.Workspace;
import javax.wvcm.WvcmException;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JzRepoWorkspace
extends JzRepoControllableFolder {
    public JzRepoWorkspace(JzProvider provider, JzLocation loc) {
        super(provider, loc);
    }

    @Override
    public Class<?> get_proxyClass() {
        return WorkspaceImpl.class;
    }

    @Override
    protected Object getThisProperty(PropertyNameList.PropertyName<?> propertyName, SrvcResource configuration, SrvcFeedback feedback) throws WvcmException {
        if (propertyName.equals((Object)Resource.RESOURCE_IDENTIFIER)) {
            return this.getLocation().string();
        }
        if (propertyName.equals((Object)Workspace.BASELINE_CONTROLLED_FOLDER_LIST)) {
            return this.computeBcfList();
        }
        if (propertyName.equals((Object)Workspace.CONTROLLABLE_RESOURCE_HOME)) {
            return this.lookupCRH();
        }
        if (propertyName.equals((Object)Workspace.CONFIGURATION_ROOT_FOLDER_HOME)) {
            return this;
        }
        if (propertyName.equals((Object)ControllableResource.IS_VERSION_CONTROLLED)) {
            return false;
        }
        if (propertyName.equals((Object)ControllableFolder.ROOT_FOLDER_OF)) {
            return null;
        }
        if (propertyName.equals((Object)Folder.CHILD_MAP)) {
            return this.childMap(true);
        }
        if (propertyName.equals((Object)Workspace.CURRENT_ACTIVITY)) {
            return this.getCurrentActivity(feedback);
        }
        if (propertyName.equals((Object)Workspace.STREAM)) {
            return this.getWorkspaceStream(feedback);
        }
        if (propertyName.equals((Object)Workspace.TARGET)) {
            return this.getTarget();
        }
        if (propertyName.equals((Object)Workspace.SOURCE_LIST)) {
            return this.getSourceList();
        }
        return super.getThisProperty(propertyName, configuration, feedback);
    }

    private void setSourceList(List<JzRepoResource> newSources) throws WvcmException {
        IWorkspaceConnection wsConn = this.getConnection();
        IFlowTable flowTable = wsConn.getFlowTable().getWorkingCopy();
        IFlowEntry currentFlowEntry = flowTable.getCurrentAcceptFlow();
        IFlowNodeHandle currentHandle = currentFlowEntry == null ? null : currentFlowEntry.getFlowNode();
        ArrayList currentSources = new ArrayList(flowTable.acceptSources());
        for (IFlowEntry flowEntry : currentSources) {
            IFlowNodeHandle flowHandle = flowEntry.getFlowNode();
            if (currentHandle == null || ItemUtil.equivItemRef((IItemHandle)flowHandle, (IItemHandle)currentHandle)) continue;
            flowTable.removeAcceptFlow(flowHandle);
        }
        List<IWorkspaceHandle> sourceHandles = this.resolveSources(newSources);
        this.addFlowSources(wsConn, flowTable, sourceHandles);
    }

    private List<JzRepoResource> getSourceList() throws WvcmException {
        List<IWorkspaceHandle> sources = this.getSources();
        ArrayList<JzRepoResource> result = new ArrayList<JzRepoResource>(sources.size());
        for (IWorkspaceHandle source : sources) {
            result.add(this.createJRR(source));
        }
        return result;
    }

    private List<IWorkspaceHandle> getSources() throws WvcmException {
        IFlowTable flowTable = this.getConnection().getFlowTable();
        ArrayList flowEntries = new ArrayList(flowTable.acceptSources());
        flowEntries.addAll(flowTable.deliverTargets());
        ArrayList<IWorkspaceHandle> flowHandles = new ArrayList<IWorkspaceHandle>(flowEntries.size());
        for (IFlowEntry flowEntry : flowEntries) {
            flowHandles.add((IWorkspaceHandle)flowEntry.getFlowNode());
        }
        IWorkspaceHandle deliverFlow = this.getTargetHandle();
        ArrayList<IWorkspaceHandle> sources = deliverFlow == null ? flowHandles : (List)ItemUtil.removeAll(flowHandles, (Collection)Collections.singletonList(deliverFlow));
        return sources;
    }

    private JzRepoResource getTarget() throws WvcmException {
        IWorkspaceHandle targetHandle = this.getTargetHandle();
        JzRepoResource result = targetHandle == null ? null : this.createJRR(targetHandle);
        return result;
    }

    private IWorkspaceHandle getTargetHandle() throws WvcmException {
        IFlowEntry currentDeliverFlow = this.getConnection().getFlowTable().getCurrentDeliverFlow();
        IWorkspaceHandle targetHandle = currentDeliverFlow == null ? null : (IWorkspaceHandle)currentDeliverFlow.getFlowNode();
        return targetHandle;
    }

    private JzRepoResource createJRR(IWorkspaceHandle targetHandle) throws JzRepoException {
        JzProvider provider = this.getProvider();
        try {
            IWorkspaceManager workspaceManager = this.getWorkspaceManager();
            JzRepoResource result = workspaceManager.getWorkspaceConnection(targetHandle, provider.getMonitor()).isStream() ? JzRepoStream.create(provider, (IItemHandle)targetHandle) : JzRepoWorkspace.create(provider, targetHandle);
            return result;
        }
        catch (TeamRepositoryException e) {
            throw this.wrapException("get Workspace's target flow", (Exception)((Object)e));
        }
    }

    private JzRepoChangeSet getCurrentActivity(SrvcFeedback feedback) throws WvcmException {
        JzRepoChangeSet result = null;
        JzProvider provider = this.getProvider();
        IWorkspaceConnection wsConn = this.getConnection();
        List<IComponentHandle> knownComponents = JzRepoWorkspace.getComponentHandles(provider, (IFlowNodeConnection)this.getConnection());
        for (IComponentHandle componentHandle : knownComponents) {
            List sets = wsConn.activeChangeSets(componentHandle);
            int count = sets.size();
            if (count <= 0) continue;
            String displayName = JzRepoWorkspace.getCurrentStateDisplayName((IItemHandle)((IChangeSetHandle)sets.get(0)));
            JzLocation csLoc = JzLocation.createChangeSetLocation(displayName);
            result = (JzRepoChangeSet)provider.lookup(csLoc, feedback);
            break;
        }
        return result;
    }

    private JzRepoStream getWorkspaceStream(SrvcFeedback feedback) throws WvcmException {
        JzRepoStream result = null;
        JzLocation wsLoc = JzLocation.createWorkspaceStreamLoc(this.getLocation());
        result = (JzRepoStream)this.getProvider().lookup(wsLoc, feedback);
        return result;
    }

    public IWorkspaceConnection getConnection() throws WvcmException {
        return JzRepoWorkspace.getConnection(this.getProvider(), (IWorkspaceHandle)this.getItemHandle());
    }

    public static JzRepoWorkspace doCreateGeneratedWorkspace(JzProvider provider, JzLocation locationHint, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        PropValue commentValue = updates != null ? updates.get(Resource.COMMENT) : null;
        String comment = commentValue != null ? (String)commentValue.get_value() : JzProvider.EMPTY_STRING;
        PropValue targetValue = null;
        if (updates != null && (targetValue = updates.get(Workspace.TARGET)) == null) {
            targetValue = updates.get(Workspace.ISOLATED_TARGET);
        }
        Location targetLoc = targetValue != null ? (Location)targetValue.get_value() : null;
        JzRepoStream targetStream = targetLoc == null ? null : JzRepoStream.lookup(provider, JzLocation.create(targetLoc));
        IWorkspaceHandle targetHandle = targetStream == null ? null : (IWorkspaceHandle)targetStream.getItemHandle();
        PropValue ownerUserIdValue = updates != null ? updates.get(InteropStream.PN_RESERVE_FOR_INTEROP) : null;
        IContributor owner = ownerUserIdValue == null ? null : JzRepoWorkspace.getSyncUser(provider);
        JzRepoWorkspace result = JzRepoWorkspace.doCreateGeneratedWorkspace(provider, locationHint, updates, comment, targetHandle, owner);
        return result;
    }

    private static IContributor getSyncUser(JzProvider provider) throws WvcmException {
        String ownerUserIdString = provider.getSyncUserId();
        try {
            IContributorManager s = provider.getRepo().contributorManager();
            IContributor result = s.fetchContributorByUserId(ownerUserIdString, provider.getMonitor());
            return result;
        }
        catch (TeamRepositoryException e) {
            throw new WvcmException(NLS.bind((String)Messages.JzRepoWorkspace_ERROR_CREATE_WS_FAILED_WITH_USERID, (Object[])new Object[]{ownerUserIdString}), null, WvcmException.ReasonCode.CONFLICT, (Throwable)e);
        }
    }

    public static JzRepoWorkspace doCreateGeneratedWorkspace(JzProvider provider, JzLocation locationHint, Map<PropertyNameList.PropertyName<?>, PropValue> updates, String comment, IWorkspaceHandle sourceHandle, IContributor requestedOwner) throws WvcmException {
        IProgressMonitor monitor = provider.getMonitor();
        String randomizer = JzProvider.timeFormatter.format(new Date());
        String basename = locationHint.name();
        boolean workspaceWithBasenameExists = JzRepoWorkspace.findAllStreamsOrWorkspacesByName(provider, basename, false).size() > 0;
        String workspaceName = workspaceWithBasenameExists ? String.valueOf(basename) + JzProvider.UNDERSCORE + randomizer : basename;
        ITeamRepository repo = provider.getRepo();
        IContributor owner = requestedOwner != null ? requestedOwner : repo.loggedInContributor();
        try {
            PropValue additionalSourceStreamsValue;
            IWorkspaceConnection wsConn = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).createWorkspace((IContributorHandle)owner, workspaceName, comment, sourceHandle, sourceHandle, monitor);
            IWorkspace resolvedWorkspace = wsConn.getResolvedWorkspace();
            JzRepoWorkspace result = JzRepoWorkspace.create(provider, (IWorkspaceHandle)resolvedWorkspace);
            result.logInfo("created Workspace with name: " + workspaceName + " owned by: " + owner.getUserId() + " at: " + JzLocation.createWorkspaceLoc(JzRepoWorkspace.getCurrentStateDisplayName((IItemHandle)resolvedWorkspace)).toString());
            PropValue propValue = additionalSourceStreamsValue = updates != null ? updates.get(Workspace.SOURCE_LIST) : null;
            if (additionalSourceStreamsValue != null) {
                List additionalSourceStreamLocs = (List)additionalSourceStreamsValue.get_value();
                ArrayList<JzRepoResource> streams = new ArrayList<JzRepoResource>(additionalSourceStreamLocs.size());
                for (JzLocation streamLoc : additionalSourceStreamLocs) {
                    streams.add(JzRepoStream.lookup(provider, streamLoc));
                }
                List<IWorkspaceHandle> sourceHandles = result.resolveSources(streams);
                result.addFlowSources(sourceHandles);
            }
            return result;
        }
        catch (TeamRepositoryException e) {
            throw new WvcmException(NLS.bind((String)Messages.JzRepoWorkspace_ERR_COULD_NOT_CREATE_WS_WITH_NAME, (Object[])new Object[]{workspaceName}), null, JzRepoException.exceptionToReasonCode((Exception)((Object)e)), (Throwable)e);
        }
    }

    private List<IWorkspaceHandle> resolveSources(List<JzRepoResource> sources) throws WvcmException {
        ArrayList<IWorkspaceHandle> results = new ArrayList<IWorkspaceHandle>(sources.size());
        for (JzRepoResource sourceStream : sources) {
            results.add((IWorkspaceHandle)sourceStream.getItemHandle());
        }
        return results;
    }

    private static JzRepoWorkspace create(JzProvider provider, IWorkspaceHandle workspaceHandle) {
        String displayName = JzRepoWorkspace.getCurrentStateDisplayName((IItemHandle)workspaceHandle);
        JzLocation myLoc = JzLocation.createWorkspaceLoc(displayName);
        JzRepoWorkspace result = new JzRepoWorkspace(provider, myLoc);
        return result;
    }

    private void addFlowSources(List<IWorkspaceHandle> sources) throws WvcmException {
        IWorkspaceConnection wsConn = this.getConnection();
        IFlowTable flowTable = wsConn.getFlowTable().getWorkingCopy();
        this.addFlowSources(wsConn, flowTable, sources);
    }

    private void addFlowSources(IWorkspaceConnection wsConn, IFlowTable flowTable, List<IWorkspaceHandle> sources) throws JzRepoException {
        for (IWorkspaceHandle source : sources) {
            flowTable.addAcceptFlow((IFlowNodeHandle)source);
        }
        try {
            wsConn.setFlowTable(flowTable, this.getProvider().getMonitor());
        }
        catch (TeamRepositoryException e) {
            throw this.wrapException("add Stream Source to newly created workspace failed", (Exception)((Object)e));
        }
    }

    public Map<String, SrvcResource> childMap(boolean ignored) throws WvcmException {
        JzProvider provider = this.getProvider();
        JzLocation myLoc = this.getLocation();
        try {
            List knownComponents = this.getConnection().getComponents();
            HashMap<String, SrvcResource> results = new HashMap<String, SrvcResource>(knownComponents.size());
            for (IComponentHandle componentHandle : knownComponents) {
                JzLocation actualCompLoc = JzRepoComponent.createComponentLocation(componentHandle);
                JzLocation bcfLoc = JzLocation.createBCFLoc(myLoc, actualCompLoc);
                JzRepoBaselineControlledFolder bcf = new JzRepoBaselineControlledFolder(provider, bcfLoc);
                results.put(JzRepoWorkspace.getCurrentStateDisplayName((IItemHandle)componentHandle), bcf);
            }
            return results;
        }
        catch (TeamRepositoryException e) {
            throw new JzRepoException("childMap", (JzRepoResource)this, (Exception)((Object)e));
        }
    }

    public IWorkspaceConnection lookupConnection() {
        IWorkspaceConnection conn = null;
        JzProvider provider = this.getProvider();
        IWorkspaceHandle wh = (IWorkspaceHandle)this.lookupItemHandle();
        if (wh != null) {
            try {
                conn = this.getWorkspaceManager().getWorkspaceConnection(wh, provider.getMonitor());
            }
            catch (TeamRepositoryException e) {
                this.logIgnoredException("lookupConnection", (Exception)((Object)e));
            }
        }
        return conn;
    }

    public static IWorkspaceConnection getConnection(JzProvider provider, IWorkspaceHandle connectableHandle) throws WvcmException {
        ITeamRepository repo = provider.getRepo();
        try {
            IWorkspaceConnection conn = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).getWorkspaceConnection(connectableHandle, provider.getMonitor());
            return conn;
        }
        catch (TeamRepositoryException e) {
            throw new JzRepoException("get connection for location", new JzLocation(JzRepoWorkspace.getCurrentStateDisplayName((IItemHandle)connectableHandle)), (Exception)((Object)e));
        }
    }

    public static JzRepoWorkspace lookupByPathname(JzProvider provider, String name) {
        JzRepoWorkspace result = null;
        UUID uuid = UUID.valueOf((String)name);
        IWorkspaceHandle myItemHandle = (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(uuid, null);
        if (myItemHandle != null) {
            result = JzRepoWorkspace.create(provider, myItemHandle);
            result.setItemHandle((IItemHandle)myItemHandle);
        }
        return result;
    }

    public static JzRepoWorkspace lookup(JzProvider provider, JzLocation loc) {
        JzRepoWorkspace result = null;
        IItemHandle myItemHandle = JzRepoWorkspace.lookupItemHandle(provider, loc);
        if (myItemHandle != null) {
            result = new JzRepoWorkspace(provider, loc);
            result.setItemHandle(myItemHandle);
        }
        return result;
    }

    private JzRepoComponent lookupComponentByNameInLocation(JzLocation compLoc) {
        JzRepoComponent result = null;
        String compName = JzRepoComponent.lookupComponentNameStringLoc(compLoc);
        if (compName == null) {
            return null;
        }
        try {
            JzProvider provider = this.getProvider();
            IProgressMonitor monitor = provider.getMonitor();
            IItemManager itemManager = provider.getRepo().itemManager();
            for (IComponentHandle cH : JzRepoWorkspace.getComponentHandles(provider, (IFlowNodeConnection)this.getConnection())) {
                IComponent c = (IComponent)itemManager.fetchCompleteItem((IItemHandle)cH, 0, monitor);
                if (!c.getName().equals(compName)) continue;
                if (result != null) {
                    throw new WvcmException(NLS.bind((String)Messages.JzRepoWorkspace_ERROR_AMBIG_COMP_NAME_WITH_NAME, (Object[])new Object[]{compName}), WvcmException.ReasonCode.FORBIDDEN);
                }
                result = JzRepoComponent.create(cH, provider);
            }
        }
        catch (TeamRepositoryException e) {
            this.logIgnoredException("lookupComponentByName", (Exception)((Object)e));
        }
        catch (WvcmException e) {
            this.logIgnoredException("lookupComponentByName", (Exception)((Object)e));
        }
        return result;
    }

    private JzRepoBaselineControlledFolder lookupCRH() throws WvcmException {
        List<IComponentHandle> knownComponents = JzRepoWorkspace.getComponentHandles(this.getProvider(), (IFlowNodeConnection)this.getConnection());
        JzRepoBaselineControlledFolder result = knownComponents.size() < 1 ? null : this.computeBcf(knownComponents.get(0));
        return result;
    }

    private static List<IComponentHandle> getComponentHandles(JzProvider provider, IFlowNodeConnection conn) throws WvcmException {
        try {
            List knownComponents = conn.getComponents();
            return knownComponents;
        }
        catch (TeamRepositoryException e) {
            throw new WvcmException("getComponents", null, WvcmException.ReasonCode.FORBIDDEN, (Throwable)e);
        }
    }

    public JzRepoBaselineControlledFolder computeBcf(IComponentHandle compH) throws WvcmException {
        JzLocation bcfLoc = this.computeBcfLoc(compH);
        JzRepoBaselineControlledFolder result = new JzRepoBaselineControlledFolder(this.getProvider(), bcfLoc);
        return result;
    }

    public JzRepoConfiguration computeConfig(JzRepoComponent comp) throws WvcmException {
        return this.computeConfig(comp.getLocation());
    }

    private JzRepoConfiguration computeConfig(JzLocation compLoc) throws WvcmException {
        JzLocation configLoc = JzLocation.createConfigurationLoc(this.getLocation(), compLoc);
        return JzRepoConfiguration.lookup(this.getProvider(), configLoc);
    }

    public JzRepoConfiguration computeConfig(IComponentHandle compHandle) throws WvcmException {
        return this.computeConfig(JzRepoComponent.createComponentLocation(compHandle));
    }

    public JzLocation computeBcfLoc(JzRepoComponent comp) {
        JzLocation bcfLoc = JzLocation.createBCFLoc(this.getLocation(), comp.getLocation());
        return bcfLoc;
    }

    public JzLocation computeBcfLoc(IComponentHandle compH) throws WvcmException {
        JzLocation compLoc = JzRepoComponent.createComponentLocation(compH);
        JzLocation bcfLoc = JzLocation.createBCFLoc(this.getLocation(), compLoc);
        return bcfLoc;
    }

    public List<JzRepoBaselineControlledFolder> computeBcfList() throws WvcmException {
        try {
            IWorkspaceConnection wsConn = this.getConnection();
            List knownComponents = wsConn.getComponents();
            ArrayList<JzRepoBaselineControlledFolder> result = new ArrayList<JzRepoBaselineControlledFolder>(knownComponents.size());
            for (IComponentHandle c : knownComponents) {
                JzRepoBaselineControlledFolder bcf = this.computeBcf(c);
                result.add(bcf);
            }
            return result;
        }
        catch (TeamRepositoryException e) {
            throw this.wrapException("get Bcf List", (Exception)((Object)e));
        }
    }

    public <T extends SrvcResource> void doCheckin(List<T> resources, String comment, ControllableResource.CheckinFlag[] flags, SrvcFeedback feedback) throws WvcmException {
        this.getProvider().applyDeferredContentCommits();
    }

    public void doCheckinAll(String comment, ControllableResource.CheckinFlag[] flags, SrvcFeedback feedback) throws WvcmException {
        this.getProvider().applyDeferredContentCommits();
    }

    @Override
    public void setPropertyFromClient(PropertyNameList.PropertyName<?> propertyName, Object value, boolean initialize, SrvcFeedback feedback) throws WvcmException {
        if (propertyName.equals((Object)Workspace.SOURCE_LIST)) {
            this.setSourceList((List)value);
        } else if (propertyName.equals((Object)Workspace.CURRENT_ACTIVITY)) {
            if (value != null) {
                throw new JzRepoException("setPropertyFromClient", (JzRepoResource)this, "NYI");
            }
            this.closeAllCurrentActivities();
        } else {
            super.setPropertyFromClient(propertyName, value, initialize, feedback);
        }
    }

    public void closeAllCurrentActivities() throws WvcmException {
        List<IComponentHandle> componentHandles = JzRepoWorkspace.getComponentHandles(this.getProvider(), (IFlowNodeConnection)this.getConnection());
        for (IComponentHandle compHandle : componentHandles) {
            JzRepoConfiguration config = this.computeConfig(compHandle);
            config.closeCurrentActivity();
        }
    }

    public IBaselineHandle createBaselineIfNeeded(IComponent comp, String name, IBaselineHandle baselineHandle) throws WvcmException {
        JzRepoConfiguration config = this.computeConfig((IComponentHandle)comp);
        config.closeCurrentActivity();
        try {
            boolean needToCreateBaseline;
            IWorkspaceConnection wsConn = this.getConnection();
            boolean bl = needToCreateBaseline = baselineHandle == null;
            if (!needToCreateBaseline) {
                IChangeHistorySyncReport changes = wsConn.compareToBaseline(baselineHandle, this.getProvider().getMonitor());
                needToCreateBaseline = changes.outgoingChangeSets((IComponentHandle)comp).size() != 0;
            }
            IBaselineHandle result = needToCreateBaseline ? wsConn.createBaseline((IComponentHandle)comp, name, null, this.getProvider().getMonitor()).getBaseline() : null;
            return result;
        }
        catch (TeamRepositoryException e) {
            throw new JzRepoException("createBaseline", (JzRepoResource)this, (Exception)((Object)e));
        }
    }

    @Override
    public String getDisplayName() throws WvcmException {
        String result = this.getConnection().getName();
        return result;
    }

    @Override
    public JzLocation getPathnameLocation(SrvcFeedback feedback) throws WvcmException {
        String uuidString = this.getConnection().getResolvedWorkspace().getItemId().getUuidValue();
        JzLocation result = JzLocation.root().child("workspace").child(uuidString);
        return result;
    }

    public void doVersionControl(List<Location> locations, SrvcFeedback feedback) throws WvcmException {
        this.getProvider().applyDeferredContentCommits();
    }

    public <T extends SrvcResource> void doMerge(List<T> sourceList, Workspace.MergeFlag[] flags, SrvcFeedback feedback) throws WvcmException {
        for (SrvcResource resource : sourceList) {
            if (resource instanceof JzRepoStream) {
                this.doMerge((JzRepoStream)resource, flags, feedback);
                continue;
            }
            throw new JzRepoException("doMerge", (JzRepoResource)this, "unsupported source:" + resource.toString());
        }
    }

    public <T extends SrvcResource> void doUpdate(List<T> sourceList, SrvcFeedback feedback) throws WvcmException {
        for (SrvcResource resource : sourceList) {
            if (resource instanceof JzRepoStream) {
                this.doUpdate((JzRepoStream)resource, feedback);
                continue;
            }
            throw new JzRepoException("doUpdate", (JzRepoResource)this, "unsupported source:" + resource.toString());
        }
    }

    private void doUpdate(JzRepoStream sourceStream, SrvcFeedback feedback) throws WvcmException {
        JzProvider provider = this.getProvider();
        JzLocation myLoc = this.getLocation();
        IWorkspaceConnection wsConn = this.getConnection();
        try {
            wsConn.refresh(provider.getMonitor());
        }
        catch (TeamRepositoryException e) {
            provider.logIgnoredException("doUpdate", (Exception)((Object)e));
        }
        IWorkspaceConnection sourceConnection = sourceStream.getConnection();
        List sourceActivities = sourceConnection.activeChangeSets();
        int sourceCount = sourceActivities.size();
        if (sourceCount > 0 && feedback != null) {
            String name = wsConn.getName();
            feedback.notifyWarning(NLS.bind((String)Messages.JzRepoWorkspace_WARNING_CLOSING_ACTIVE_CS, (Object[])new Object[]{sourceCount, name}));
            sourceStream.getStreamWorkspace(feedback).closeAllCurrentActivities();
        }
        this.logDebug("updating ws: " + myLoc.string() + " from stream: " + sourceStream.getLocation().string());
        List targetActivities = wsConn.activeChangeSets();
        int targetCount = targetActivities.size();
        if (targetCount > 0) {
            String name = wsConn.getName();
            throw new IllegalStateException(String.format("Workspace: %s has %d active changes sets.  It should have 0.", name, targetCount));
        }
        JzRepoWorkspace.doUpdate(provider, myLoc, (IFlowNodeConnection)wsConn, (IFlowNodeConnection)sourceConnection, true);
    }

    public static void doUpdate(JzProvider provider, JzLocation targetLocationForException, IFlowNodeConnection targetConnection, IFlowNodeConnection sourceConnection, boolean replaceComponents) throws WvcmException {
        if (ItemUtil.equivItemRef((IItemHandle)sourceConnection.getResolvedWorkspace(), (IItemHandle)targetConnection.getResolvedWorkspace())) {
            provider.logDebug("not updating : " + targetConnection.getName() + " (" + targetLocationForException.string() + ") since its source is the same: " + sourceConnection.getName());
            return;
        }
        provider.logDebug("updating : " + targetConnection.getName() + " (" + targetLocationForException.string() + ") from : " + sourceConnection.getName());
        IProgressMonitor monitor = provider.getMonitor();
        try {
            List targetComponents = targetConnection.getComponents();
            List sourceComponents = sourceConnection.getComponents();
            for (IComponentHandle componentHandle : sourceComponents) {
                if (ItemUtil.itemInCollection((IItemHandle)componentHandle, (Collection)targetComponents)) {
                    if (!replaceComponents) continue;
                    targetConnection.replaceComponent(componentHandle, (IConnection)sourceConnection, false, monitor);
                    continue;
                }
                targetConnection.addComponent(componentHandle, sourceConnection, false, monitor);
                provider.logDebug("added component: " + componentHandle.getItemId().toString() + " to: " + targetConnection.getName());
            }
        }
        catch (TeamRepositoryException e) {
            throw new JzRepoException("doUpdate", targetLocationForException, (Exception)((Object)e));
        }
    }

    private void doMerge(JzRepoStream sourceStream, Workspace.MergeFlag[] flags, SrvcFeedback feedback) throws WvcmException {
        JzProvider p = this.getProvider();
        JzLocation targetLocation = this.getLocation();
        IProgressMonitor monitor = p.getMonitor();
        JzLocation sourceStreamLoc = sourceStream.getLocation();
        IWorkspaceConnection wsConn = this.getConnection();
        IWorkspaceConnection sourceStreamConnection = sourceStream.getConnection();
        if (ItemUtil.equivItemRef((IItemHandle)sourceStreamConnection.getResolvedWorkspace(), (IItemHandle)wsConn.getResolvedWorkspace())) {
            p.logDebug("not merging into : " + wsConn.getName() + " (" + targetLocation.string() + ") since its source is the same: " + sourceStreamConnection.getName());
            return;
        }
        this.logDebug("merging to ws: " + targetLocation.string() + " from stream: " + sourceStreamLoc.string());
        int baseLinesAndChangeSets = WorkspaceComparisonFlags.CHANGE_SET_COMPARISON_ONLY | WorkspaceComparisonFlags.INCLUDE_BASELINE_INFO | WorkspaceComparisonFlags.INCLUDE_EMPTY_BASELINES;
        IItemManager itemManager = this.getProvider().getRepo().itemManager();
        try {
            IUpdateReport acceptReport;
            int actualConflictCount;
            IChangeHistorySyncReport changes = wsConn.compareTo((IFlowNodeConnection)sourceStreamConnection, baseLinesAndChangeSets, Collections.EMPTY_LIST, monitor);
            List incomingBaselines = changes.incomingBaselines();
            ArrayList<IBaselineHandle> latestIncomingBaselines = new ArrayList<IBaselineHandle>(incomingBaselines.size());
            HashSet<UUID> componentIds = new HashSet<UUID>();
            for (IBaselineHandle blH : incomingBaselines) {
                IBaseline baseline = (IBaseline)itemManager.fetchCompleteItem((IItemHandle)blH, 0, monitor);
                IComponentHandle component = baseline.getComponent();
                if (componentIds.contains(component.getItemId())) continue;
                componentIds.add(component.getItemId());
                latestIncomingBaselines.add((IBaselineHandle)changes.incomingBaselines(component).get(0));
            }
            List incomingChangeSets = changes.incomingChangeSets();
            IUpdateReport preflightReport = wsConn.accept(1, changes, latestIncomingBaselines, incomingChangeSets, monitor);
            int preflightConflictCount = preflightReport.conflicts().size();
            if (preflightConflictCount > 0) {
                List<Object> flagList = flags != null ? Arrays.asList(flags) : Collections.emptyList();
                if (!p.allowModModMerge() || flagList.contains(Workspace.MergeFlag.NO_AUTO_MERGE) || flagList.contains(Workspace.MergeFlag.NO_CHECKOUT)) {
                    throw new WvcmException("unexpected conflicting changes found during \"preflight\". conflict count: " + Integer.toString(preflightConflictCount), WvcmException.ReasonCode.CANNOT_MERGE_CHECKOUT_NOT_ALLOWED);
                }
            }
            if (!((actualConflictCount = (acceptReport = wsConn.accept(0, changes, latestIncomingBaselines, incomingChangeSets, monitor)).conflicts().size()) <= 0 || p.allowModModMerge() && actualConflictCount == 1)) {
                wsConn.discardChangeSets(false, (Collection)incomingChangeSets, monitor);
                throw new WvcmException("unexpected conflicting changes count: " + Integer.toString(actualConflictCount), WvcmException.ReasonCode.CANNOT_MERGE_CHECKOUT_NOT_ALLOWED);
            }
            if (actualConflictCount == 1) {
                IItemConflictReport c = (IItemConflictReport)acceptReport.conflicts().iterator().next();
                IVersionableHandle ver = c.item();
                this.closeAllCurrentActivities();
                IChangeSetHandle cH = (IChangeSetHandle)incomingChangeSets.get(0);
                IChangeSet changeSet = (IChangeSet)itemManager.fetchCompleteItem((IItemHandle)cH, 0, monitor);
                wsConn.commit(wsConn.createChangeSet(changeSet.getComponent(), monitor), (Collection)Arrays.asList(wsConn.configurationOpFactory().markAsMerged(ver, c.getSelectedContributorState(), c.getProposedContributorState())), null);
            }
            JzRepoWorkspace.doUpdate(p, targetLocation, (IFlowNodeConnection)wsConn, (IFlowNodeConnection)sourceStreamConnection, false);
            if (flags != null && Arrays.asList(flags).contains(Workspace.MergeFlag.UPDATE_STREAM)) {
                sourceStream.doUpdate((Object)this, feedback);
            }
        }
        catch (TeamRepositoryException e) {
            throw new JzRepoException("doMerge", (JzRepoResource)this, (Exception)((Object)e));
        }
    }

    public JzLocation doCreateComponent(JzLocation compLoc, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        String compName = JzRepoComponent.lookupComponentNameStringLoc(compLoc);
        if (compName == null) {
            throw new JzRepoException("doCreateComponent", compLoc, "could not find component name in location");
        }
        JzProvider provider = this.getProvider();
        IWorkspaceManager workspaceManager = this.getWorkspaceManager();
        IContributor owner = provider.getRepo().loggedInContributor();
        IProgressMonitor monitor = provider.getMonitor();
        try {
            IComponent component = workspaceManager.createComponent(compName, (IAuditableHandle)owner, monitor);
            this.getConnection().addComponent((IComponentHandle)component, false, monitor);
            JzLocation actualCompLoc = JzRepoComponent.createComponentLocation((IComponentHandle)component);
            provider.logCreation("Component", compLoc, actualCompLoc.string(), "rootFolder ItemId: " + component.getRootFolder().getItemId().toString());
            return actualCompLoc;
        }
        catch (TeamRepositoryException e) {
            String msg = NLS.bind((String)Messages.JzRepoWorkspace_ERROR_CREATE_COMP_FAILED_WITH_USER_AND_CONTRIBID, (Object[])new Object[]{owner.getName(), owner.getItemId().toString()});
            throw new JzRepoException(msg, (JzRepoResource)this, (Exception)((Object)e));
        }
    }

    public JzRepoComponent lookupJzRepoComponent(JzLocation componentLocation, SrvcFeedback feedback) {
        JzLocation compLoc;
        JzProvider p = this.getProvider();
        JzRepoComponent result = (JzRepoComponent)p.lookup(compLoc = componentLocation.lookupContextLocation(JzLocation.Kind.Component), feedback);
        if (result == null) {
            result = this.lookupComponentByNameInLocation(compLoc);
        }
        return result;
    }

    public JzRepoComponent getJzRepoComponent(JzLocation loc, SrvcFeedback feedback) throws WvcmException {
        JzRepoComponent result = this.lookupJzRepoComponent(loc, feedback);
        if (result == null) {
            throw new WvcmException(NLS.bind((String)Messages.JzRepoWorkspace_ERROR_COMP_NOT_FOUND_WITH_LOCSTRING, (Object[])new Object[]{loc.string()}), null, WvcmException.ReasonCode.NOT_FOUND);
        }
        return result;
    }

    public IComponent lookupComponent(JzLocation componentLocation, SrvcFeedback feedback) {
        IComponent result = null;
        JzRepoComponent comp = this.lookupJzRepoComponent(componentLocation, feedback);
        if (comp != null) {
            result = comp.lookupComponentItem();
        }
        return result;
    }

    public IComponent getComponent(JzLocation componentLocation, SrvcFeedback feedback) throws WvcmException {
        IComponent result = this.lookupComponent(componentLocation, feedback);
        if (result == null) {
            throw new WvcmException("getComponent failed", null, WvcmException.ReasonCode.NOT_FOUND);
        }
        return result;
    }

    public IComponentHandle lookupComponentHandle(JzLocation componentLocation, SrvcFeedback feedback) throws WvcmException {
        JzRepoComponent comp = this.lookupJzRepoComponent(componentLocation, feedback);
        IComponentHandle result = comp == null ? null : comp.getComponentItemHandle();
        return result;
    }

    public static JzRepoVersion locateByHistory(JzProvider provider, IWorkspaceConnection connection, JzRepoVersionHistory vh) throws WvcmException {
        JzRepoVersion result = null;
        IComponentHandle compH = JzRepoComponent.getComponentItemHandle(provider, vh.getLocation().getComponentLocation());
        try {
            IConfiguration configuration = connection.configuration(compH);
            if (configuration != null) {
                result = vh.lookupVersion(configuration);
            }
        }
        catch (ItemNotFoundException e) {
            provider.logIgnoredException("locateByHistory", (Exception)((Object)e));
        }
        catch (ComponentNotInWorkspaceException e) {
            provider.logIgnoredException("locateByHistory", (Exception)((Object)e));
        }
        return result;
    }

    protected SrvcResource locateByHistory(SrvcResource genericVersionHistory) throws WvcmException {
        return JzRepoWorkspace.locateByHistory(this.getProvider(), this.getConnection(), (JzRepoVersionHistory)genericVersionHistory);
    }

    public Map<String, SrvcResource> getFolderVersionChildMap(SrvcResource genericFolderVersion) throws WvcmException {
        JzRepoFolderItem folderVersion = (JzRepoFolderItem)genericFolderVersion;
        IComponentHandle compH = JzRepoComponent.getComponentItemHandle(this.getProvider(), folderVersion.getLocation().getComponentLocation());
        try {
            IConfiguration configuration = this.getConnection().configuration(compH);
            return folderVersion.childMap(true, configuration);
        }
        catch (TeamRepositoryException e) {
            throw new JzRepoException("getFolderVersionChildMap", (JzRepoResource)this, (Exception)((Object)e));
        }
    }

    public List<SrvcResource> getFolderVersionChildList(SrvcResource folderVersion) throws WvcmException {
        return new ArrayList<SrvcResource>(this.getFolderVersionChildMap(folderVersion).values());
    }

    public void doUnbindAll(SrvcFeedback feedback) throws WvcmException {
        IWorkspaceManager workspaceManager = this.getWorkspaceManager();
        try {
            workspaceManager.deleteWorkspace((IWorkspaceHandle)this.getItemHandle(), this.getProvider().getMonitor());
            this.setItemHandle(null);
        }
        catch (TeamRepositoryException e) {
            throw new JzRepoException("doUnbindAll", (JzRepoResource)this, (Exception)((Object)e));
        }
    }

    public IVersionableHandle lookupVersionableHandle(JzLocation componentLocation, URI versionHistoryUri, SrvcFeedback feedback) {
        IVersionable result = null;
        IComponent comp = this.lookupComponent(componentLocation, feedback);
        if (comp != null) {
            JzProvider provider = this.getProvider();
            IVersionableHandle versionableHandle = (IVersionableHandle)JzRepoWorkspace.lookupItemHandle(provider, versionHistoryUri);
            try {
                IWorkspaceConnection wsConn = this.getConnection();
                result = wsConn.configuration((IComponentHandle)comp).fetchPartialItem(versionableHandle, null, provider.getMonitor());
            }
            catch (TeamRepositoryException e) {
                this.logIgnoredException("lookupVersionableHandle", (Exception)((Object)e));
            }
            catch (WvcmException e) {
                this.logIgnoredException("lookupVersionableHandle", (Exception)((Object)e));
            }
        }
        return result;
    }

    public JzLocation getUriComponentLocation(JzLocation componentLocation, SrvcFeedback feedback) throws WvcmException {
        JzRepoComponent comp = this.lookupJzRepoComponent(componentLocation, feedback);
        if (comp != null) {
            return comp.getLocation();
        }
        throw new WvcmException(NLS.bind((String)"component not found: {0}", (Object[])new Object[]{componentLocation}), null, WvcmException.ReasonCode.NOT_FOUND);
    }

    public static IChangeSetHandle doCreateGeneratedChangeSet(JzProvider provider, JzLocation locationHint, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        JzRepoWorkspace ws = JzRepoWorkspace.lookup(provider, locationHint.getWorkspaceLocation());
        return ws.createGeneratedChangeSet(provider, locationHint, updates, updated, feedback);
    }

    private IChangeSetHandle createGeneratedChangeSet(JzProvider provider, JzLocation locationHint, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        JzLocation compLoc = locationHint.getComponentLocation();
        JzRepoComponent comp = this.getJzRepoComponent(compLoc, feedback);
        JzRepoConfiguration config = this.computeConfig(comp);
        return config.createChangeSet();
    }

    public IComponentHandle lookupComponentHandleInWorkspace(JzLocation componentLocation) throws WvcmException {
        IComponent cHByLocation = this.lookupComponent(componentLocation, null);
        boolean found = false;
        for (IComponentHandle cHInWs : JzRepoWorkspace.getComponentHandles(this.getProvider(), (IFlowNodeConnection)this.getConnection())) {
            if (!cHByLocation.sameItemId((IItemHandle)cHInWs) || !cHByLocation.sameStateId((IItemHandle)cHInWs)) continue;
            found = true;
            break;
        }
        return found ? cHByLocation : null;
    }

    public IConfiguration lookupConfiguration(JzLocation loc) throws WvcmException {
        IComponentHandle componentHandle;
        IConfiguration config = null;
        JzProvider provider = this.getProvider();
        JzLocation compLoc = loc.lookupContextLocation(JzLocation.Kind.Component);
        if (compLoc != null && (componentHandle = this.lookupComponentHandle(compLoc, null)) != null) {
            try {
                config = this.getConnection().configuration(componentHandle);
            }
            catch (ItemNotFoundException e) {
                provider.logIgnoredException("lookupConfiguration", (Exception)((Object)e));
            }
            catch (ComponentNotInWorkspaceException e) {
                provider.logIgnoredException("lookupConfiguration", (Exception)((Object)e));
            }
            catch (WvcmException e) {
                provider.logIgnoredException("lookupConfiguration", (Exception)((Object)e));
            }
        }
        return config;
    }

    public IConfiguration ensureComponentInConfiguration(JzRepoComponent comp) throws WvcmException {
        IWorkspaceConnection wsConn = this.getConnection();
        IComponentHandle componentHandle = comp.getComponentItemHandle();
        IConfiguration result = null;
        try {
            result = wsConn.configuration(componentHandle);
        }
        catch (ItemNotFoundException e1) {
            throw this.wrapException("addComponent", (Exception)((Object)e1));
        }
        catch (ComponentNotInWorkspaceException componentNotInWorkspaceException) {
            try {
                wsConn.addComponent(componentHandle, false, this.getProvider().getMonitor());
                this.logDebug("added component to workspace: " + comp.getLocation().string());
                result = wsConn.configuration(componentHandle);
            }
            catch (TeamRepositoryException e) {
                throw this.wrapException("addComponent", (Exception)((Object)e));
            }
        }
        return result;
    }
}

