/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.connector.scm.client;

import com.ibm.rational.wvcm.interop.InteropStream;
import com.ibm.rational.wvcm.ri.impl.PropValue;
import com.ibm.rational.wvcm.ri.impl.ResourceImpl;
import com.ibm.rational.wvcm.ri.impl.TaskImpl;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import com.ibm.rational.wvcm.ri.srvc.SrvcResource;
import com.ibm.team.connector.scm.client.JzLocation;
import com.ibm.team.connector.scm.client.JzProvider;
import com.ibm.team.connector.scm.client.JzRepoChangeSet;
import com.ibm.team.connector.scm.client.JzRepoResource;
import com.ibm.team.connector.scm.client.Messages;
import com.ibm.team.connector.scm.common.CcConnectorUtils;
import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.links.client.ILinkManager;
import com.ibm.team.links.common.IItemReference;
import com.ibm.team.links.common.ILink;
import com.ibm.team.links.common.IReference;
import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.internal.util.ItemUtil;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.IDetailedStatus;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.IWorkItemWorkingCopyManager;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.internal.util.ItemQueryIterator;
import com.ibm.team.workitem.common.internal.util.WorkItemQueries;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.ICategory;
import com.ibm.team.workitem.common.model.ICategoryHandle;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.IWorkItemType;
import com.ibm.team.workitem.common.model.Identifier;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList;
import javax.wvcm.PropertyRequestItem;
import javax.wvcm.Resource;
import javax.wvcm.Task;
import javax.wvcm.WvcmException;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JzRepoWorkItem
extends JzRepoResource {
    public JzRepoWorkItem(JzProvider provider, Location loc) {
        super(provider, loc);
    }

    @Override
    public Class<?> get_proxyClass() {
        return TaskImpl.class;
    }

    @Override
    protected Object getThisProperty(PropertyNameList.PropertyName<?> propertyName, SrvcResource configuration, SrvcFeedback feedback) throws WvcmException {
        if (propertyName.equals(JzProvider.PN_TASK_ID)) {
            return this.getTaskId();
        }
        if (propertyName.equals((Object)Resource.DISPLAY_NAME)) {
            return this.getDisplayName();
        }
        if (propertyName.equals((Object)Resource.COMMENT)) {
            return this.getComment();
        }
        if (propertyName.equals((Object)Task.ACTIVITY_LIST)) {
            return this.getActivityList(feedback);
        }
        return super.getThisProperty(propertyName, configuration, feedback);
    }

    private String getTaskId() throws WvcmException {
        return Integer.toString(this.getWorkItem().getId());
    }

    @Override
    public String getDisplayName() throws WvcmException {
        IWorkItem workItem = this.getWorkItem();
        String result = workItem.getHTMLSummary().getPlainText();
        return result;
    }

    private String getComment() throws WvcmException {
        IWorkItem workItem = this.getWorkItem();
        String result = workItem.getHTMLDescription().getPlainText();
        return result;
    }

    private IWorkItem getWorkItem() throws WvcmException {
        JzProvider provider = this.getProvider();
        ITeamRepository repo = provider.getRepo();
        IWorkItemHandle myItemHandle = (IWorkItemHandle)this.getItemHandle();
        IAuditableClient auditableClient = (IAuditableClient)repo.getClientLibrary(IAuditableClient.class);
        try {
            IWorkItem workItem = (IWorkItem)auditableClient.fetchCurrentAuditable((IAuditableHandle)myItemHandle, IWorkItem.FULL_PROFILE, provider.getMonitor());
            return workItem;
        }
        catch (ItemNotFoundException itemNotFoundException) {
            throw new WvcmException(NLS.bind((String)Messages.JzRepoWorkItem_ERROR_ITEM_NOT_FOUND_WITH_LOCSTRING, (Object[])new Object[]{this.getLocation().string()}), null, WvcmException.ReasonCode.NOT_FOUND);
        }
        catch (TeamRepositoryException e) {
            throw this.wrapException("get work item from repository", (Exception)((Object)e));
        }
    }

    private static IWorkItem createWorkItem(JzProvider provider, Map<PropertyNameList.PropertyName<?>, PropValue> updates, SrvcFeedback feedback) throws WvcmException {
        ITeamRepository repo = provider.getRepo();
        IProgressMonitor monitor = provider.getMonitor();
        String summary = null;
        String description = null;
        if (updates != null) {
            PropValue commentValue;
            PropValue nameValue = updates.get(Resource.DISPLAY_NAME);
            if (nameValue != null) {
                summary = (String)nameValue.get_value();
            }
            if ((commentValue = updates.get(Resource.COMMENT)) != null) {
                description = (String)commentValue.get_value();
            }
        }
        IWorkItemClient clientLib = (IWorkItemClient)repo.getClientLibrary(IWorkItemClient.class);
        try {
            ITeamArea teamArea = provider.getTeamArea();
            IWorkItem templateItem = JzRepoWorkItem.lookupTemplateItem(provider, feedback);
            IWorkItemType workItemType = JzRepoWorkItem.getWorkItemType(provider, templateItem);
            IWorkItemWorkingCopyManager mgr = clientLib.getWorkItemWorkingCopyManager();
            IWorkItemHandle handle = mgr.connectNew(workItemType, monitor);
            WorkItemWorkingCopy wc = mgr.getWorkingCopy(handle);
            IWorkItem workItem = wc.getWorkItem();
            if (templateItem != null && !provider.templateIdHasInitialValue()) {
                JzRepoWorkItem.copyPartialWorkItem(provider, workItem, templateItem, null);
            } else {
                IDevelopmentLine developmentLine = clientLib.getAuditableCommon().getDevelopmentLine((ITeamAreaHandle)teamArea, provider.getMonitor());
                if (developmentLine != null) {
                    workItem.setTarget(developmentLine.getCurrentIteration());
                }
                JzRepoWorkItem.setCategory(provider, clientLib, workItem);
            }
            workItem.setCreator((IContributorHandle)repo.loggedInContributor());
            workItem.setOwner((IContributorHandle)repo.loggedInContributor());
            if (summary != null) {
                workItem.setHTMLSummary(XMLString.createFromPlainText((String)summary));
            }
            if (description != null) {
                workItem.setHTMLDescription(XMLString.createFromPlainText((String)description));
            }
            return JzRepoWorkItem.saveWorkItem(monitor, mgr, wc, workItem);
        }
        catch (TeamRepositoryException e) {
            throw new WvcmException(NLS.bind((String)Messages.JzRepoWorkItem_ERROR_CREATE_ITEM_FAILED_WITH_DESC, (Object[])new Object[]{description}), null, WvcmException.ReasonCode.FORBIDDEN, (Throwable)e);
        }
    }

    private static void setCategory(JzProvider provider, IWorkItemClient clientLib, IWorkItem workItem) throws TeamRepositoryException, WvcmException {
        IProgressMonitor monitor = provider.getMonitor();
        List categories = clientLib.findCategoriesOfTeamArea2((ITeamAreaHandle)provider.getTeamArea(), ICategory.DEFAULT_PROFILE, monitor);
        ICategory unassigned = clientLib.findUnassignedCategory(provider.getTeamArea().getProjectArea(), ICategory.DEFAULT_PROFILE, monitor);
        ICategory category = null;
        for (ICategory c : categories) {
            if (ItemUtil.equivItemRef((IItemHandle)unassigned, (IItemHandle)c)) continue;
            category = c;
            break;
        }
        if (category != null) {
            if (provider.isDebugLogEnabled()) {
                ICategory cat = (ICategory)provider.getRepo().itemManager().fetchPartialItem((IItemHandle)category, 0, (Collection)Collections.singletonList(ICategory.NAME_PROPERTY), monitor);
                provider.logDebug("assigning category: " + cat.getName());
            }
            workItem.setCategory(category);
        }
    }

    private static IWorkItemType getWorkItemType(JzProvider provider, IWorkItem templateItem) throws TeamRepositoryException, WvcmException {
        String itemName = templateItem != null ? templateItem.getWorkItemType() : "task";
        IWorkItemClient workItemClient = (IWorkItemClient)provider.getRepo().getClientLibrary(IWorkItemClient.class);
        IWorkItemType result = workItemClient.findWorkItemType(provider.getTeamArea().getProjectArea(), itemName, provider.getMonitor());
        if (result == null) {
            throw new WvcmException("Internal error.  Could not find task workitem type", WvcmException.ReasonCode.FORBIDDEN);
        }
        return result;
    }

    private static IWorkItem lookupTemplateItem(JzProvider provider, SrvcFeedback feedback) throws WvcmException {
        JzRepoWorkItem proxy;
        IWorkItem result = null;
        String templateId = provider.getTemplateId();
        if (templateId != null && !provider.templateIdHasInitialValue() && (proxy = JzRepoWorkItem.lookupById(provider, templateId, feedback)) != null) {
            result = proxy.getWorkItem();
        }
        return result;
    }

    private static IWorkItem saveWorkItem(IProgressMonitor monitor, IWorkItemWorkingCopyManager mgr, WorkItemWorkingCopy wc, IWorkItem workItem) throws WvcmException {
        IDetailedStatus detailedStatus = wc.save(monitor);
        mgr.disconnect((IWorkItemHandle)workItem);
        int severity = detailedStatus.getSeverity();
        if (severity >= 2) {
            throw new WvcmException(NLS.bind((String)Messages.JzRepoWorkItem_ERROR_SAVE_ITEM_FAILED_WITH_DETAILS, (Object[])new Object[]{detailedStatus.getMessage()}), null, WvcmException.ReasonCode.FORBIDDEN, detailedStatus.getException());
        }
        return workItem;
    }

    public static SrvcResource doCreateGeneratedResource(JzProvider provider, JzLocation loc, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        IWorkItem wi = JzRepoWorkItem.createWorkItem(provider, updates, feedback);
        JzRepoWorkItem result = JzRepoWorkItem.create(provider, (IWorkItemHandle)wi);
        provider.logCreation("WorkItem", result.getLocation());
        return result;
    }

    public static JzRepoWorkItem create(JzProvider provider, IWorkItemHandle wiHandle) {
        JzRepoWorkItem result = new JzRepoWorkItem(provider, JzLocation.createWorkItemLoc(JzRepoWorkItem.getCurrentStateDisplayName((IItemHandle)wiHandle)));
        result.setItemHandle((IItemHandle)wiHandle);
        return result;
    }

    public static JzRepoWorkItem lookup(JzProvider provider, JzLocation loc) {
        JzRepoWorkItem result = null;
        IItemHandle myItemHandle = JzRepoWorkItem.lookupItemHandle(provider, loc);
        if (myItemHandle != null) {
            result = new JzRepoWorkItem(provider, loc);
            result.setItemHandle(myItemHandle);
        }
        return result;
    }

    public void setPropertyFromClient(PropertyNameList.PropertyName<?> propertyName, Object value, boolean initialize, SrvcFeedback feedback) throws WvcmException {
        if (propertyName.equals((Object)Resource.COMMENT) && value instanceof String) {
            this.setComment((String)value);
        } else if (propertyName.equals((Object)InteropStream.PN_CLONE)) {
            this.storeInteropCloneValue((String)value, feedback);
        } else {
            super.setPropertyFromClient(propertyName, value, initialize, feedback);
        }
    }

    private void setComment(String comment) throws WvcmException {
        JzProvider provider = this.getProvider();
        ITeamRepository repo = provider.getRepo();
        IWorkItemClient service = (IWorkItemClient)repo.getClientLibrary(IWorkItemClient.class);
        IWorkItemWorkingCopyManager workItemWorkingCopyManager = service.getWorkItemWorkingCopyManager();
        IWorkItemHandle workItemHandle = (IWorkItemHandle)this.getItemHandle();
        IProgressMonitor monitor = provider.getMonitor();
        try {
            workItemWorkingCopyManager.connectCurrent(workItemHandle, IWorkItem.FULL_PROFILE, monitor);
        }
        catch (TeamRepositoryException e) {
            throw this.wrapException("Set Task Comment", (Exception)((Object)e));
        }
        WorkItemWorkingCopy wc = workItemWorkingCopyManager.getWorkingCopy(workItemHandle);
        IWorkItem workItem = wc.getWorkItem();
        workItem.setHTMLDescription(XMLString.createFromPlainText((String)comment));
        JzRepoWorkItem.saveWorkItem(monitor, workItemWorkingCopyManager, wc, workItem);
    }

    private List<SrvcResource> getActivityList(SrvcFeedback feedback) throws WvcmException {
        JzProvider provider = this.getProvider();
        List<IChangeSetHandle> changeSetHandles = this.getChangeSetHandles(feedback);
        ArrayList<SrvcResource> results = new ArrayList<SrvcResource>(changeSetHandles.size());
        for (IChangeSetHandle changeSetHandle : changeSetHandles) {
            results.add(JzRepoChangeSet.create(provider, changeSetHandle, feedback));
        }
        return results;
    }

    private List<IChangeSetHandle> getChangeSetHandles(SrvcFeedback feedback) throws WvcmException {
        ArrayList<IChangeSetHandle> results = new ArrayList<IChangeSetHandle>();
        JzProvider provider = this.getProvider();
        IProgressMonitor monitor = provider.getMonitor();
        IWorkItemHandle myHandle = (IWorkItemHandle)this.getItemHandle();
        try {
            ILinkManager linkManager = JzRepoWorkItem.getLinkManager(provider);
            IItemReference reference = CcConnectorUtils.createReferenceToItem((IItemHandle)myHandle);
            Collection linkCollection = linkManager.findLinksByTarget("com.ibm.team.filesystem.workitems.change_set", (IReference)reference, monitor).getAllLinksFromHereOn().getLinksById("com.ibm.team.filesystem.workitems.change_set");
            for (ILink link : linkCollection) {
                IReference sourceRef = link.getSourceRef();
                if (!sourceRef.isItemReference()) continue;
                IChangeSetHandle csh = (IChangeSetHandle)((IItemReference)sourceRef).getReferencedItem();
                results.add(csh);
            }
        }
        catch (TeamRepositoryException e) {
            throw this.wrapException("getChangeSetHandles", (Exception)((Object)e));
        }
        return results;
    }

    public static JzRepoWorkItem lookupById(JzProvider provider, String requestedId, SrvcFeedback feedback) throws WvcmException {
        if (requestedId == null) {
            throw new IllegalArgumentException("requestId must not be null");
        }
        JzRepoWorkItem result = null;
        IProgressMonitor monitor = provider.getMonitor();
        int id = Integer.parseInt(requestedId);
        try {
            IAuditableClient auditableClient = (IAuditableClient)provider.getRepo().getClientLibrary(IAuditableClient.class);
            ItemQueryIterator iter = WorkItemQueries.workItemById((IAuditableCommon)auditableClient, (int)id);
            if (iter.hasNext(monitor)) {
                IWorkItemHandle workItemHandle = (IWorkItemHandle)iter.next(monitor);
                result = JzRepoWorkItem.create(provider, workItemHandle);
            }
        }
        catch (ItemNotFoundException e) {
            provider.logIgnoredException("lookupById", (Exception)((Object)e));
        }
        catch (TeamRepositoryException e) {
            throw new WvcmException("lookupById", null, WvcmException.ReasonCode.FORBIDDEN, (Throwable)e);
        }
        return result;
    }

    private static void copyPartialWorkItem(JzProvider provider, IWorkItem targetItem, IWorkItem sourceItem, Collection<String> exclusions) throws WvcmException {
        try {
            JzRepoWorkItem.copyPartialWorkItem(targetItem, sourceItem, exclusions, (IWorkItemCommon)provider.getRepo().getClientLibrary(IWorkItemCommon.class), provider.getMonitor());
        }
        catch (TeamRepositoryException e) {
            throw new WvcmException("could not copy work item", null, WvcmException.ReasonCode.FORBIDDEN, (Throwable)e);
        }
    }

    private static void copyPartialWorkItem(IWorkItem targetItem, IWorkItem sourceItem, Collection<String> exclusions, IWorkItemCommon workItemCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList includedProperties = new ArrayList(IWorkItem.FULL_PROFILE.getProperties());
        if (exclusions != null) {
            includedProperties.removeAll(exclusions);
        }
        includedProperties.remove(IWorkItem.ID_PROPERTY);
        for (String attributeId : includedProperties) {
            IAttribute attribute = workItemCommon.findAttribute(sourceItem.getProjectArea(), attributeId, monitor);
            if (attribute == null) continue;
            targetItem.setValue(attribute, sourceItem.getValue(attribute));
        }
    }

    protected void readCustomProperties(ResourceImpl resource, PropertyRequestItem.PropertyRequest propertyRequest, SrvcResource configuration, SrvcFeedback feedback) throws WvcmException {
        JzProvider provider = this.getProvider();
        IProgressMonitor monitor = provider.getMonitor();
        IWorkItem workItem = this.getWorkItem();
        IProjectAreaHandle projectArea = workItem.getProjectArea();
        String namespaceName = ((Object)((Object)this)).getClass().getName();
        IWorkItemCommon workItemCommon = (IWorkItemCommon)provider.getRepo().getClientLibrary(IWorkItemCommon.class);
        ArrayList includedProperties = new ArrayList(IWorkItem.FULL_PROFILE.getProperties());
        includedProperties.remove(IWorkItem.ID_PROPERTY);
        includedProperties.remove(IWorkItem.SUMMARY_PROPERTY);
        includedProperties.remove(IWorkItem.DESCRIPTION_PROPERTY);
        for (String attributeId : includedProperties) {
            try {
                Object value;
                IAttribute attribute = workItemCommon.findAttribute(projectArea, attributeId, monitor);
                if (attribute == null || !workItem.hasAttribute(attribute) || !workItem.isAttributeSet(attribute) || (value = workItem.getValue(attribute)) == null) continue;
                this.storeValueAsProperty(resource, namespaceName, attributeId, value);
            }
            catch (TeamRepositoryException e) {
                throw new WvcmException("workitem.findAttribute with id: " + attributeId, null, WvcmException.ReasonCode.FORBIDDEN, (Throwable)e);
            }
        }
        Map propertyRequestMap = propertyRequest.toMap();
        if (propertyRequestMap.containsKey(JzProvider.PN_TASK_ID)) {
            resource.setPropMapProperty(JzProvider.PN_TASK_ID, (Object)Integer.toString(workItem.getId()));
        }
        if (propertyRequestMap.containsKey(Resource.DISPLAY_NAME)) {
            resource.setPropMapProperty(Resource.DISPLAY_NAME, (Object)workItem.getHTMLSummary().getPlainText());
        }
        if (propertyRequestMap.containsKey(Resource.COMMENT)) {
            resource.setPropMapProperty(Resource.COMMENT, (Object)workItem.getHTMLDescription().getPlainText());
        }
    }

    private void storeValueAsProperty(ResourceImpl resource, String namespaceName, String attributeId, Object value) {
        String valueString = null;
        if (value instanceof String) {
            valueString = (String)value;
        } else if (value instanceof Number) {
            valueString = String.valueOf(value);
        } else if (value instanceof Timestamp) {
            valueString = ((Timestamp)value).toString();
        } else if (value instanceof IContributorHandle) {
            IContributorHandle contributorHandle = (IContributorHandle)value;
            valueString = contributorHandle.getItemId().getUuidValue();
        } else if (value instanceof ICategoryHandle) {
            ICategoryHandle categoryHandle = (ICategoryHandle)value;
            valueString = categoryHandle.getItemId().getUuidValue();
        } else {
            valueString = value instanceof Identifier ? ((Identifier)value).getStringIdentifier() : "non-Stringable value";
        }
        if (valueString != null) {
            PropertyNameList.PropertyName propertyName = new PropertyNameList.PropertyName(namespaceName, attributeId);
            resource.setPropMapProperty(propertyName, (Object)valueString);
        }
    }
}

