/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.connector.scm.client;

import com.ibm.rational.wvcm.interop.InteropStream;
import com.ibm.rational.wvcm.ri.impl.PropValue;
import com.ibm.rational.wvcm.ri.impl.StreamImpl;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import com.ibm.rational.wvcm.ri.srvc.SrvcResource;
import com.ibm.team.connector.scm.client.JzLocation;
import com.ibm.team.connector.scm.client.JzProvider;
import com.ibm.team.connector.scm.client.JzRepoBaseline;
import com.ibm.team.connector.scm.client.JzRepoComponent;
import com.ibm.team.connector.scm.client.JzRepoException;
import com.ibm.team.connector.scm.client.JzRepoFolderItem;
import com.ibm.team.connector.scm.client.JzRepoResource;
import com.ibm.team.connector.scm.client.JzRepoVersion;
import com.ibm.team.connector.scm.client.JzRepoVersionHistory;
import com.ibm.team.connector.scm.client.JzRepoWorkspace;
import com.ibm.team.connector.scm.client.Messages;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.internal.util.ItemUtil;
import com.ibm.team.repository.common.query.IItemQueryPage;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IFlowNodeConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.wvcm.Baseline;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList;
import javax.wvcm.PropertyRequestItem;
import javax.wvcm.Resource;
import javax.wvcm.Stream;
import javax.wvcm.WvcmException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JzRepoStream
extends JzRepoResource {
    public JzRepoStream(JzProvider provider, Location loc) {
        super(provider, loc);
    }

    @Override
    public Class<?> get_proxyClass() {
        return StreamImpl.class;
    }

    public static SrvcResource doCreateGeneratedResource(JzProvider provider, JzLocation locationHint, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        IWorkspaceConnection newStreamConnection;
        ITeamAreaHandle teamAreaHandle = provider.lookupTeamAreaHandle();
        if (teamAreaHandle == null) {
            throw new JzRepoException("doCreateGeneratedResource", locationHint, "team area specified in JzProvider initArg does not specify a team area. Could not create stream");
        }
        String randomizer = JzProvider.timeFormatter.format(new Date());
        String basename = locationHint.lastSegment();
        List<IItemHandle> existingWorkspaces = JzRepoStream.findAllStreamsOrWorkspacesByName(provider, basename, true);
        boolean streamWithBasenameExists = existingWorkspaces.size() > 0;
        String streamName = streamWithBasenameExists ? String.valueOf(basename) + JzProvider.UNDERSCORE + randomizer : basename;
        PropValue commentValue = updates != null ? updates.get(Resource.COMMENT) : null;
        String comment = commentValue != null ? (String)commentValue.get_value() : InteropStream.DOT;
        ITeamRepository repo = provider.getRepo();
        IWorkspaceManager workspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
        try {
            newStreamConnection = workspaceManager.createStream(teamAreaHandle, streamName, comment, provider.getMonitor());
        }
        catch (TeamRepositoryException e) {
            throw new WvcmException(NLS.bind((String)Messages.JzRepoStream_ERROR_COULD_NOT_CREATE_STREAM_WITH_NAME, (Object[])new Object[]{streamName}), null, JzRepoException.exceptionToReasonCode((Exception)((Object)e)), (Throwable)e);
        }
        IWorkspace resolvedStream = newStreamConnection.getResolvedWorkspace();
        JzLocation resultLoc = JzRepoStream.createStreamLocation((IItemHandle)resolvedStream);
        JzRepoStream result = new JzRepoStream(provider, resultLoc);
        result.logInfo("created stream named: " + streamName + ", in: team area @: " + resultLoc.string());
        return result;
    }

    @Override
    public Object getThisProperty(PropertyNameList.PropertyName<?> propertyName, SrvcResource configuration, SrvcFeedback feedback) throws WvcmException {
        if (propertyName.getNamespace() != null) {
            return this.getCustomProperty(propertyName, feedback);
        }
        if (propertyName.equals((Object)Stream.LATEST_VERSION_LIST)) {
            return this.doGetBaselines();
        }
        if (propertyName.equals((Object)Stream.VERSION_LIST)) {
            return this.getVersionList();
        }
        if (propertyName.equals((Object)Stream.WORKSPACE)) {
            return this.getStreamWorkspace(feedback);
        }
        return super.getThisProperty(propertyName, configuration, feedback);
    }

    private List<JzRepoVersion> getVersionList() throws WvcmException {
        ArrayList<JzRepoVersion> result = new ArrayList<JzRepoVersion>();
        JzProvider provider = this.getProvider();
        try {
            List componentHandles = this.getConnection().getComponents();
            for (IComponentHandle componentHandle : componentHandles) {
                JzRepoComponent comp = JzRepoComponent.create(componentHandle, provider);
                IConfiguration config = this.getConnection().configuration(componentHandle);
                JzRepoStream.getVersionList(provider, comp, config, result);
            }
        }
        catch (TeamRepositoryException e) {
            throw this.wrapException("getVersionList", (Exception)((Object)e));
        }
        return result;
    }

    private List<JzRepoBaseline> doGetBaselines() throws WvcmException {
        ArrayList<JzRepoBaseline> results = new ArrayList<JzRepoBaseline>();
        IWorkspaceConnection sConn = this.getConnection();
        this.logDebug("getting baselines from stream: " + sConn.getName() + " (" + this.getLocation().string() + ")");
        try {
            List knownComponents = sConn.getComponents();
            for (IComponentHandle componentHandle : knownComponents) {
                JzRepoComponent comp = JzRepoComponent.create(componentHandle, this.getProvider());
                JzRepoBaseline latestBaseline = comp.lookupLatestBaseline((IFlowNodeConnection)sConn);
                if (latestBaseline == null) continue;
                results.add(latestBaseline);
            }
            return results;
        }
        catch (TeamRepositoryException e) {
            throw new JzRepoException("doGetBaselines", (JzRepoResource)this, (Exception)((Object)e));
        }
    }

    public JzRepoWorkspace getStreamWorkspace(SrvcFeedback feedback) throws WvcmException {
        JzRepoWorkspace result = null;
        JzLocation wsLoc = JzLocation.createStreamWorkspaceLoc(this.getLocation());
        result = (JzRepoWorkspace)this.getProvider().lookup(wsLoc, feedback);
        return result;
    }

    public void setPropertyFromClient(PropertyNameList.PropertyName<?> propertyName, Object value, boolean initialize, SrvcFeedback feedback) throws WvcmException {
        if (propertyName.getNamespace() != null) {
            this.storeCustomProperty(propertyName, (String)value, initialize, feedback);
        } else {
            super.setPropertyFromClient(propertyName, value, initialize, feedback);
        }
    }

    @Override
    public Location getPathnameLocation(SrvcFeedback feedback) throws WvcmException {
        JzLocation result = JzLocation.root().child("stream").child(this.getDisplayName());
        return result;
    }

    public static JzRepoStream lookup(JzProvider provider, JzLocation loc) {
        JzRepoStream result = null;
        IItemHandle myItemHandle = JzRepoStream.lookupItemHandle(provider, loc);
        if (myItemHandle != null) {
            result = JzRepoStream.create(provider, loc, myItemHandle);
        }
        return result;
    }

    public static JzRepoStream create(Stream streamProxy) throws WvcmException {
        Location syncStreamLocation;
        JzProvider provider = (JzProvider)streamProxy.provider();
        JzRepoStream syncStream = (JzRepoStream)provider.lookup(syncStreamLocation = streamProxy.location(), null);
        if (syncStream == null) {
            throw new WvcmException(NLS.bind((String)Messages.JzRepoStream_ERROR_STREAM_NOT_FOUND_WITH_LOCSTRING, (Object[])new Object[]{syncStreamLocation.string()}), null, WvcmException.ReasonCode.NOT_FOUND);
        }
        return syncStream;
    }

    public static JzRepoStream create(JzProvider provider, JzLocation loc, IItemHandle myItemHandle) {
        JzRepoStream result = new JzRepoStream(provider, loc);
        result.setItemHandle(myItemHandle);
        return result;
    }

    public static JzRepoStream create(JzProvider provider, IItemHandle itemHandle) {
        JzLocation resultLoc = JzRepoStream.createStreamLocation(itemHandle);
        return JzRepoStream.create(provider, resultLoc, itemHandle);
    }

    public static JzLocation createStreamLocation(IItemHandle itemHandle) {
        String displayName = JzRepoResource.getCurrentStateDisplayName(itemHandle);
        JzLocation resultLoc = JzLocation.createStreamLoc(displayName);
        return resultLoc;
    }

    public IWorkspaceConnection getConnection() throws WvcmException {
        IWorkspaceConnection result = JzRepoWorkspace.getConnection(this.getProvider(), (IWorkspaceHandle)this.getItemHandle());
        return result;
    }

    @Override
    public String getDisplayName() throws WvcmException {
        String result = this.getConnection().getName();
        return result;
    }

    public <T extends SrvcResource> void doUpdate(List<T> sourceList, SrvcFeedback feedback) throws WvcmException {
        for (SrvcResource resource : sourceList) {
            JzRepoWorkspace source = null;
            if (resource instanceof JzRepoWorkspace) {
                source = (JzRepoWorkspace)resource;
            } else if (resource instanceof JzRepoStream) {
                source = ((JzRepoStream)resource).getConnection();
            } else {
                throw new JzRepoException("doUpdate", (JzRepoResource)this, "unsupported source:" + resource.toString());
            }
            this.doUpdate((Object)source, feedback);
        }
    }

    public void doUpdate(Object source, SrvcFeedback feedback) throws WvcmException {
        IFlowNodeConnection sourceConn = null;
        if (source instanceof JzRepoWorkspace) {
            JzRepoWorkspace ws = (JzRepoWorkspace)((Object)source);
            ws.closeAllCurrentActivities();
            sourceConn = ws.getConnection();
        } else {
            sourceConn = (IFlowNodeConnection)source;
        }
        JzRepoWorkspace.doUpdate(this.getProvider(), this.getLocation(), (IFlowNodeConnection)this.getConnection(), sourceConn, true);
    }

    public Map<String, SrvcResource> getFolderVersionChildMap(SrvcResource genericFolderVersion) throws WvcmException {
        JzRepoFolderItem folderVersion = (JzRepoFolderItem)genericFolderVersion;
        IComponentHandle compH = JzRepoComponent.getComponentItemHandle(this.getProvider(), folderVersion.getLocation().getComponentLocation());
        try {
            return folderVersion.childMap(true, this.getConnection().configuration(compH));
        }
        catch (TeamRepositoryException e) {
            throw this.wrapException("getChildMap", (Exception)((Object)e));
        }
    }

    public List<SrvcResource> getFolderVersionChildList(SrvcResource folderVersion) throws WvcmException {
        return new ArrayList<SrvcResource>(this.getFolderVersionChildMap(folderVersion).values());
    }

    public void doUnbindAll(SrvcFeedback feedback) throws WvcmException {
        IWorkspaceManager workspaceManager = this.getWorkspaceManager();
        try {
            workspaceManager.deleteWorkspace((IWorkspaceHandle)this.getItemHandle(), this.getProvider().getMonitor());
        }
        catch (TeamRepositoryException e) {
            throw this.wrapException("doUnbindAll", (Exception)((Object)e));
        }
    }

    public List<SrvcResource.SrvcCompareReport> doCompareReport(SrvcResource resource, Baseline.CompareFlag[] flags, SrvcFeedback feedback) throws WvcmException {
        if (!(resource instanceof JzRepoStream)) {
            throw new WvcmException("JzRepoStream.doCompareReport is not supported for resource other than JzRepoStreams", WvcmException.ReasonCode.FORBIDDEN);
        }
        try {
            IWorkspaceConnection thisConnection = this.getConnection();
            TreeSet<IComponentHandle> thisStreamComponents = new TreeSet<IComponentHandle>(ItemUtil.itemIdComparator);
            thisStreamComponents.addAll(thisConnection.getComponents());
            IWorkspaceConnection otherConnection = ((JzRepoStream)resource).getConnection();
            TreeSet<IComponentHandle> otherStreamComponents = new TreeSet<IComponentHandle>(ItemUtil.itemIdComparator);
            otherStreamComponents.addAll(otherConnection.getComponents());
            TreeSet<IComponentHandle> includedComponents = new TreeSet<IComponentHandle>(ItemUtil.itemIdComparator);
            includedComponents.addAll(thisStreamComponents);
            includedComponents.retainAll(otherStreamComponents);
            TreeSet<IComponentHandle> excludedComponents = new TreeSet<IComponentHandle>(ItemUtil.itemIdComparator);
            excludedComponents.addAll(thisStreamComponents);
            excludedComponents.addAll(otherStreamComponents);
            excludedComponents.removeAll(includedComponents);
            boolean debugLogEnabled = this.isDebugLogEnabled();
            if (debugLogEnabled) {
                this.logDebug("this components: " + this.commaSeparatedComponentNames(thisStreamComponents));
                this.logDebug("other components: " + this.commaSeparatedComponentNames(otherStreamComponents));
                this.logDebug("included components (intersection): " + this.commaSeparatedComponentNames(includedComponents));
                this.logDebug("excluded components (): " + this.commaSeparatedComponentNames(excludedComponents));
            }
            return this.computeWvcmCompareReport((IConnection)thisConnection, (IConnection)otherConnection, new ArrayList<IComponentHandle>(includedComponents), new ArrayList<IComponentHandle>(excludedComponents), flags);
        }
        catch (TeamRepositoryException e) {
            throw this.wrapException("doCompareReport", (Exception)((Object)e));
        }
    }

    protected SrvcResource locateByHistory(SrvcResource genericVersionHistory) throws WvcmException {
        return JzRepoWorkspace.locateByHistory(this.getProvider(), this.getConnection(), (JzRepoVersionHistory)genericVersionHistory);
    }

    public ITeamAreaHandle getOwner() throws WvcmException {
        return (ITeamAreaHandle)this.getConnection().getOwner();
    }

    public static Stream lookupStreamByName(JzProvider provider, String name, PropertyRequestItem.PropertyRequest propertyRequest, SrvcFeedback feedback) throws WvcmException {
        int resultSize;
        IItemQueryPage itemQueryPage;
        Stream result;
        block4: {
            result = null;
            IWorkspaceManager wm = SCMPlatform.getWorkspaceManager((ITeamRepository)provider.getRepo());
            try {
                itemQueryPage = wm.findWorkspacesByName(name, false, true, true, 2, provider.getMonitor());
                resultSize = itemQueryPage.getResultSize();
                if (resultSize != 0) break block4;
                return null;
            }
            catch (TeamRepositoryException e) {
                throw new WvcmException(NLS.bind((String)Messages.JzRepoStream_ERROR_STREAM_NOT_FOUND, (Object[])new Object[]{name}), null, JzRepoException.exceptionToReasonCode((Exception)((Object)e)), (Throwable)e);
            }
        }
        if (resultSize > 1) {
            throw new WvcmException(NLS.bind((String)Messages.JzRepoStream_ERROR_AMBIGUOUS_STREAM_NAME, (Object[])new Object[]{name, resultSize}), null, WvcmException.ReasonCode.NOT_FOUND);
        }
        JzLocation streamLoc = JzRepoStream.createStreamLocation((IItemHandle)itemQueryPage.getItemHandles().get(0));
        result = (Stream)provider.buildProxy(streamLoc, propertyRequest, feedback);
        return result;
    }
}

