/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.connector.scm.client;

import com.ibm.rational.wvcm.ri.impl.VersionImpl;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import com.ibm.rational.wvcm.ri.srvc.SrvcResource;
import com.ibm.team.connector.scm.client.JzProvider;
import com.ibm.team.connector.scm.client.JzRepoComponent;
import com.ibm.team.connector.scm.client.JzRepoVersion;
import com.ibm.team.connector.scm.client.JzRepoVersionHistory;
import com.ibm.team.connector.scm.client.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.common.IChange;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IChangeSetSearchCriteria;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import java.util.List;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList;
import javax.wvcm.Resource;
import javax.wvcm.Version;
import javax.wvcm.WvcmException;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JzRepoRootVersion
extends JzRepoVersion {
    public JzRepoRootVersion(JzProvider provider, Location loc) {
        super(provider, loc);
    }

    @Override
    public Class<?> get_proxyClass() {
        return VersionImpl.class;
    }

    @Override
    public Object getThisProperty(PropertyNameList.PropertyName<?> propertyName, SrvcResource configuration, SrvcFeedback feedback) throws WvcmException {
        if (propertyName.equals((Object)Resource.RESOURCE_IDENTIFIER)) {
            return this.getLocation().string();
        }
        if (propertyName.equals((Object)Version.VERSION_HISTORY)) {
            return this.getVersionHistory(feedback);
        }
        return super.getThisProperty(propertyName, configuration, feedback);
    }

    private JzRepoVersionHistory getVersionHistory(SrvcFeedback feedback) throws WvcmException {
        JzRepoVersionHistory result = (JzRepoVersionHistory)this.getProvider().lookup(this.getLocation().getVersionHistoryLocation(), feedback);
        return result;
    }

    @Override
    public IVersionable fetchCompleteState() throws WvcmException {
        JzRepoVersionHistory vh = this.getVersionHistory(null);
        IVersionableHandle versionableHandle = (IVersionableHandle)vh.getItemHandle();
        return JzRepoRootVersion.fetchCompleteState(versionableHandle, this.getProvider());
    }

    @Override
    protected String getBindingName() throws WvcmException {
        throw new WvcmException("getBindingName is NYI", WvcmException.ReasonCode.FORBIDDEN);
    }

    @Override
    public IFolderHandle getParentFolderHandle() throws WvcmException {
        JzRepoComponent comp = this.getJzRepoComponent();
        IFolderHandle parent = comp.getRootFolderHandle();
        return parent;
    }

    @Override
    protected JzRepoVersionHistory getParentVersionHistory() throws WvcmException {
        throw new WvcmException("getParentVersionHistory is NYI", WvcmException.ReasonCode.FORBIDDEN);
    }

    @Override
    public JzRepoComponent getJzRepoComponent() throws WvcmException {
        JzRepoComponent result = JzRepoComponent.lookup(this.getProvider(), this.getLocation().getVersionHistoryLocation().getComponentLocation());
        return result;
    }

    @Override
    public IVersionable getWorkingCopy() throws WvcmException {
        JzProvider provider = this.getProvider();
        ITeamRepository repo = provider.getRepo();
        IProgressMonitor monitor = provider.getMonitor();
        JzRepoVersionHistory vh = this.getVersionHistory(null);
        IVersionableHandle versionableHandle = (IVersionableHandle)vh.getItemHandle();
        IComponentHandle componentHandle = vh.getJzRepoComponent().getComponentItemHandle();
        try {
            IChangeSetSearchCriteria criteria = IChangeSetSearchCriteria.FACTORY.newInstance();
            criteria.setComponent(componentHandle);
            criteria.setItem(versionableHandle);
            List changeSets = this.getWorkspaceManager().findChangeSets(criteria, 1, monitor);
            for (IChangeSetHandle changeSetHandle : changeSets) {
                IChangeSet changeSet = (IChangeSet)repo.itemManager().fetchCompleteItem((IItemHandle)changeSetHandle, 1, monitor);
                List changes = changeSet.changes();
                IVersionableHandle result = null;
                for (IChange change : changes) {
                    if (!change.item().sameItemId((IItemHandle)versionableHandle) || (result = change.beforeState()) != null) continue;
                    IVersionableHandle afterStateHandle = change.afterState();
                    return (IVersionable)JzRepoRootVersion.fetchCompleteState(afterStateHandle, this.getProvider()).getWorkingCopy();
                }
                if (result == null) continue;
                return (IVersionable)JzRepoRootVersion.fetchCompleteState(result, this.getProvider()).getWorkingCopy();
            }
        }
        catch (TeamRepositoryException e) {
            throw this.wrapException("getWorkingCopy", (Exception)((Object)e));
        }
        throw new WvcmException(NLS.bind((String)Messages.JzRepoRootVersion_ERROR_FIND_ANY_STATE_OF_VERSIONABLE_FAILED_WITH_VH_LOCSTRING, (Object[])new Object[]{vh.getLocation().string()}), WvcmException.ReasonCode.FORBIDDEN);
    }
}

