/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.connector.scm.client;

import com.ibm.rational.wvcm.ri.impl.ConfigurationImpl;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import com.ibm.rational.wvcm.ri.srvc.SrvcResource;
import com.ibm.team.connector.scm.client.JzLocation;
import com.ibm.team.connector.scm.client.JzProvider;
import com.ibm.team.connector.scm.client.JzRepoChangeSet;
import com.ibm.team.connector.scm.client.JzRepoComponent;
import com.ibm.team.connector.scm.client.JzRepoControllableFolder;
import com.ibm.team.connector.scm.client.JzRepoException;
import com.ibm.team.connector.scm.client.JzRepoResource;
import com.ibm.team.connector.scm.client.JzRepoWorkspace;
import com.ibm.team.connector.scm.client.Messages;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IFlowNodeConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.wvcm.Configuration;
import javax.wvcm.ControllableResource;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList;
import javax.wvcm.WvcmException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JzRepoConfiguration
extends JzRepoResource {
    JzRepoWorkspace _myWsCache = null;
    JzRepoComponent _myCompCache = null;

    public JzRepoConfiguration(JzProvider provider, Location loc) {
        super(provider, loc);
    }

    @Override
    public Class<?> get_proxyClass() {
        return ConfigurationImpl.class;
    }

    public JzRepoWorkspace getMyWorkspace() throws WvcmException {
        if (this._myWsCache == null) {
            this._myWsCache = this.getWvcmWorkspace();
        }
        return this._myWsCache;
    }

    public JzRepoComponent getMyComponent() throws WvcmException {
        if (this._myCompCache == null) {
            this._myCompCache = this.getMyWorkspace().getJzRepoComponent(this.getLocation().getComponentLocation(), null);
        }
        return this._myCompCache;
    }

    private static JzRepoComponent getJzRepoComponent(JzProvider provider, JzLocation myLoc) throws WvcmException {
        JzRepoWorkspace ws = (JzRepoWorkspace)provider.lookup(myLoc.getWorkspaceLocation(), null);
        JzRepoComponent c = ws.getJzRepoComponent(myLoc.getComponentLocation(), null);
        return c;
    }

    public static JzRepoConfiguration lookup(JzProvider provider, JzLocation myLoc) {
        JzRepoConfiguration result = null;
        try {
            JzRepoComponent myComp = JzRepoConfiguration.getJzRepoComponent(provider, myLoc);
            if (myComp != null) {
                JzLocation configLoc = JzLocation.createConfigurationLoc(myLoc.getWorkspaceLocation(), myComp.getLocation());
                result = new JzRepoConfiguration(provider, configLoc);
            }
        }
        catch (WvcmException e) {
            provider.logIgnoredException("lookup", (Exception)((Object)e));
        }
        return result;
    }

    public void doCheckin(ControllableResource.CheckinFlag[] flags, SrvcFeedback feedback) throws WvcmException {
        JzRepoComponent c = this.getMyComponent();
        c.createBaselineIfNeeded(this.getMyWorkspace(), "Laswell", null);
    }

    public void doCheckout(ControllableResource.CheckoutFlag[] flags, SrvcFeedback feedback) throws WvcmException {
    }

    @Override
    protected Object getThisProperty(PropertyNameList.PropertyName<?> propertyName, SrvcResource configuration, SrvcFeedback feedback) throws WvcmException {
        if (propertyName.equals((Object)Configuration.CHECKED_IN)) {
            return this.getLatestBaseline(feedback);
        }
        if (propertyName.equals((Object)Configuration.VERSION_HISTORY)) {
            return this.getMyComponent();
        }
        if (propertyName.equals((Object)Configuration.ROOT_FOLDER)) {
            return this.getRootFolder(feedback);
        }
        return super.getThisProperty(propertyName, configuration, feedback);
    }

    public JzRepoResource getLatestBaseline(SrvcFeedback feedback) throws WvcmException {
        JzRepoWorkspace ws = this.getMyWorkspace();
        JzRepoComponent c = this.getMyComponent();
        this.logDebug("getting baseline in ws: " + ws.getLocation().string());
        return c.lookupLatestBaseline((IFlowNodeConnection)ws.getConnection());
    }

    public SrvcResource getRootFolder(SrvcFeedback feedback) throws WvcmException {
        JzRepoComponent myComp = this.getMyComponent();
        JzLocation parentLoc = this.getMyWorkspace().computeBcfLoc(myComp);
        JzRepoControllableFolder result = (JzRepoControllableFolder)JzRepoConfiguration.createFromVersionable(this.getProvider(), parentLoc, (IVersionableHandle)myComp.getRootFolderHandle());
        return result;
    }

    public void commit(IWorkspaceConnection.IConfigurationOp configOp, JzLocation location) throws WvcmException {
        if (configOp != null) {
            HashMap<JzLocation, IWorkspaceConnection.IConfigurationOp> op = new HashMap<JzLocation, IWorkspaceConnection.IConfigurationOp>();
            op.put(location, configOp);
            this.commit(op);
        }
    }

    IChangeSetHandle createChangeSet() throws WvcmException {
        try {
            IChangeSetHandle result = this.getMyWorkspace().getConnection().createChangeSet(this.getMyComponent().getComponentItemHandle(), this.getProvider().getMonitor());
            this.logCreation("ChangeSet", JzRepoChangeSet.create(this.getProvider(), result, null).getLocation());
            return result;
        }
        catch (TeamRepositoryException e) {
            throw this.wrapException("create Change Set", (Exception)((Object)e));
        }
    }

    public IChangeSetHandle getActiveChangeSetHandle() throws WvcmException {
        IWorkspaceConnection wsConn = this.getMyWorkspace().getConnection();
        IComponentHandle cH = this.getMyComponent().getComponentItemHandle();
        List sets = wsConn.activeChangeSets(cH);
        int count = sets.size();
        IChangeSetHandle result = null;
        if (count > 1) {
            throw new IllegalStateException("got too many active change sets: " + Integer.toString(count));
        }
        if (count == 1) {
            this.logDebug("reusing active change set");
            result = (IChangeSetHandle)sets.get(0);
        } else {
            result = this.createChangeSet();
        }
        return result;
    }

    public void commit(Map<JzLocation, IWorkspaceConnection.IConfigurationOp> opDescs) throws WvcmException {
        if (opDescs != null) {
            IWorkspaceConnection wsConn = this.getMyWorkspace().getConnection();
            IChangeSetHandle activeCS = this.getActiveChangeSetHandle();
            if (this.getProvider().isDebugLogEnabled()) {
                JzLocation[] locations = opDescs.keySet().toArray(new JzLocation[opDescs.size()]);
                this.logDebug("committing: " + this.join(JzProvider.COMMA_SPACE, locations));
            }
            try {
                wsConn.commit(activeCS, opDescs.values(), this.getProvider().getMonitor());
            }
            catch (TeamRepositoryException e) {
                throw new WvcmException(Messages.JzRepoConfiguration_ERROR_COMMIT_FAILED, null, JzRepoException.exceptionToReasonCode((Exception)((Object)e)), (Throwable)e);
            }
        }
    }

    public String join(String separator, JzLocation ... values) {
        if (values.length == 0) {
            return JzProvider.EMPTY_STRING;
        }
        StringBuilder buf = new StringBuilder(values[0].string());
        int i = 1;
        while (i < values.length) {
            buf.append(separator);
            buf.append(values[i].string());
            ++i;
        }
        return buf.toString();
    }

    public void closeCurrentActivity() throws WvcmException {
        JzProvider provider = this.getProvider();
        provider.applyDeferredContentCommits(this);
        JzRepoWorkspace ws = this.getMyWorkspace();
        IWorkspaceConnection wsConn = ws.getConnection();
        JzRepoComponent comp = this.getMyComponent();
        try {
            List activeCSs = wsConn.activeChangeSets(comp.getComponentItemHandle());
            int count = activeCSs.size();
            if (count > 0) {
                wsConn.closeChangeSets((Collection)activeCSs, provider.getMonitor());
            }
        }
        catch (TeamRepositoryException e) {
            throw this.wrapException("unset Current Activity", (Exception)((Object)e));
        }
    }
}

