/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.connector.scm.client;

import com.ibm.rational.wvcm.interop.InteropStream;
import com.ibm.rational.wvcm.ri.impl.ComponentImpl;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import com.ibm.rational.wvcm.ri.srvc.SrvcResource;
import com.ibm.team.connector.scm.client.JzLocation;
import com.ibm.team.connector.scm.client.JzProvider;
import com.ibm.team.connector.scm.client.JzRepoBaseline;
import com.ibm.team.connector.scm.client.JzRepoException;
import com.ibm.team.connector.scm.client.JzRepoResource;
import com.ibm.team.connector.scm.client.JzRepoRootBaseline;
import com.ibm.team.connector.scm.client.JzRepoWorkspace;
import com.ibm.team.connector.scm.client.Messages;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IFlowNodeConnection;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolderHandle;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList;
import javax.wvcm.Resource;
import javax.wvcm.VersionHistory;
import javax.wvcm.WvcmException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JzRepoComponent
extends JzRepoResource {
    public JzRepoComponent(JzProvider provider, Location childLoc) {
        super(provider, childLoc);
    }

    public static JzRepoComponent lookup(JzProvider provider, JzLocation compLoc) {
        IComponentHandle cH;
        JzRepoComponent result = null;
        if (compLoc.isUriLocation() && (cH = JzRepoComponent.lookupComponentItemHandle(provider, compLoc)) != null) {
            result = JzRepoComponent.create(cH, provider);
        }
        return result;
    }

    public IComponent lookupComponentItem() {
        IComponent result = null;
        JzProvider provider = this.getProvider();
        IItemHandle compH = this.lookupItemHandle();
        if (compH != null) {
            try {
                result = (IComponent)provider.getRepo().itemManager().fetchCompleteItem(compH, 0, provider.getMonitor());
            }
            catch (TeamRepositoryException e) {
                this.logIgnoredException("fetchComponent", (Exception)((Object)e));
            }
        }
        return result;
    }

    public IComponent getComponentItem() throws WvcmException {
        IComponent result = null;
        JzProvider provider = this.getProvider();
        try {
            result = (IComponent)provider.getRepo().itemManager().fetchCompleteItem(this.getItemHandle(), 0, provider.getMonitor());
        }
        catch (TeamRepositoryException e) {
            throw new JzRepoException("fetchComponent", (JzRepoResource)this, (Exception)((Object)e));
        }
        return result;
    }

    public static IComponentHandle lookupComponentItemHandle(JzProvider provider, JzLocation compLoc) {
        IComponentHandle result = (IComponentHandle)JzRepoComponent.lookupItemHandle(provider, compLoc);
        return result;
    }

    protected IComponentHandle getItemHandleByURI() throws WvcmException {
        return JzRepoComponent.getComponentItemHandle(this.getProvider(), this.getLocation());
    }

    public static IComponentHandle getComponentItemHandle(JzProvider provider, JzLocation compLoc) throws WvcmException {
        IComponentHandle result = JzRepoComponent.lookupComponentItemHandle(provider, compLoc);
        if (result == null) {
            throw new WvcmException(NLS.bind((String)Messages.JzRepoComponent_ERROR_COULD_NOT_GET_COMPONENT_GIVEN_LOC, (Object[])new Object[]{compLoc.toString()}), WvcmException.ReasonCode.NOT_FOUND);
        }
        return result;
    }

    public IFolderHandle getRootFolderHandle() throws WvcmException {
        JzProvider provider = this.getProvider();
        try {
            IComponent comp = (IComponent)provider.getRepo().itemManager().fetchPartialItem((IItemHandle)this.getComponentItemHandle(), 0, (Collection)Collections.singletonList(IComponent.ROOT_FOLDER_PROPERTY), provider.getMonitor());
            return comp.getRootFolder();
        }
        catch (TeamRepositoryException e) {
            throw new JzRepoException("getRootFolderHandle", (JzRepoResource)this, (Exception)((Object)e));
        }
    }

    @Override
    public Object getThisProperty(PropertyNameList.PropertyName<?> propertyName, SrvcResource configuration, SrvcFeedback feedback) throws WvcmException {
        if (propertyName.equals((Object)VersionHistory.ROOT_VERSION)) {
            return this.getRootVersion();
        }
        if (propertyName.equals((Object)Resource.DISPLAY_NAME)) {
            return this.getName();
        }
        return super.getThisProperty(propertyName, configuration, feedback);
    }

    public void setPropertyFromClient(PropertyNameList.PropertyName<?> propertyName, Object value, boolean initialize, SrvcFeedback feedback) throws WvcmException {
        if (propertyName.equals((Object)InteropStream.PN_CLONE)) {
            HashMap<JzRepoResource, String> sources2Values = new HashMap<JzRepoResource, String>(1);
            sources2Values.put(this, (String)value);
            JzRepoResource.storeInteropCloneValues(this.getProvider(), sources2Values, feedback);
        } else {
            super.setPropertyFromClient(propertyName, value, initialize, feedback);
        }
    }

    @Override
    public void removePropertyFromClient(PropertyNameList.PropertyName<?> propertyName, SrvcFeedback feedback) throws WvcmException {
        if (propertyName.equals((Object)InteropStream.PN_CLONE)) {
            this.removeInteropCloneValue(feedback);
        } else {
            super.removePropertyFromClient(propertyName, feedback);
        }
    }

    public JzRepoBaseline getRootVersion() throws WvcmException {
        JzLocation baselineLoc = this.getLocation().createRootBaselineLocation();
        JzRepoRootBaseline result = new JzRepoRootBaseline(this.getProvider(), baselineLoc);
        return result;
    }

    public void createBaselineIfNeeded(JzRepoWorkspace ws, String optionalName, IBaselineHandle latestBaselineHandle) throws WvcmException {
        JzLocation myLoc = this.getLocation().getComponentLocation();
        IBaselineHandle blH = ws.createBaselineIfNeeded(ws.getComponent(myLoc, null), optionalName, this.lookupLatestBaselineHandle((IFlowNodeConnection)ws.getConnection()));
        if (blH != null) {
            JzLocation blLoc = myLoc.createBaselineLoc(JzRepoComponent.getCurrentStateDisplayName((IItemHandle)blH));
            this.logCreation("Baseline", blLoc);
        }
    }

    public JzRepoBaseline lookupLatestBaseline(IFlowNodeConnection wsConn) throws WvcmException {
        JzProvider provider = this.getProvider();
        IBaselineHandle latestBaselineHandle = this.lookupLatestBaselineHandle(wsConn);
        JzRepoBaseline result = null;
        if (latestBaselineHandle != null) {
            JzLocation compLoc = this.getLocation().getComponentLocation();
            String blPath = JzRepoComponent.getCurrentStateDisplayName((IItemHandle)latestBaselineHandle);
            JzLocation blLoc = compLoc.createBaselineLoc(blPath);
            this.logDebug("latest baseline: " + blPath);
            result = new JzRepoBaseline(provider, blLoc);
        }
        return result;
    }

    private IBaselineHandle lookupLatestBaselineHandle(IFlowNodeConnection conn) throws WvcmException {
        try {
            return conn.getComponentInfo(this.getComponentItemHandle()).basis();
        }
        catch (TeamRepositoryException e) {
            throw new JzRepoException("get latest baseline handle", (JzRepoResource)this, (Exception)((Object)e));
        }
    }

    public IComponentHandle getComponentItemHandle() throws WvcmException {
        return JzRepoComponent.getComponentItemHandle(this.getProvider(), this.getLocation());
    }

    public String getName() throws WvcmException {
        IComponent myItem = this.getComponentItem();
        String result = myItem.getName();
        return result;
    }

    public static JzRepoComponent create(IComponentHandle myHandle, JzProvider provider) {
        JzLocation myLoc = JzRepoComponent.createComponentLocation(myHandle);
        JzRepoComponent result = new JzRepoComponent(provider, myLoc);
        result.setItemHandle((IItemHandle)myHandle);
        return result;
    }

    public String getResourceIdentifier() throws WvcmException {
        String result = JzRepoComponent.createComponentLocation(this.getComponentItemHandle()).string();
        return result;
    }

    public static JzLocation createComponentLocation(IComponentHandle myHandle) {
        String displayName = JzRepoComponent.getCurrentStateDisplayName((IItemHandle)myHandle);
        JzLocation myLoc = JzLocation.createComponentUriLocation(displayName);
        return myLoc;
    }

    @Override
    public Class<?> get_proxyClass() {
        return ComponentImpl.class;
    }

    public static String lookupComponentNameStringLoc(JzLocation compLoc) {
        String result = null;
        String displayName = compLoc.getDisplayName();
        if (displayName.startsWith("name:")) {
            result = displayName.substring("name:".length());
        }
        return result;
    }

    public boolean isSameObject(JzRepoComponent rhs) throws WvcmException {
        return this.getResourceIdentifier().equals(rhs.getResourceIdentifier());
    }
}

